/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.ResponseStateManagerImpl;
import com.sun.faces.renderkit.html_basic.HtmlResponseWriter;
import com.sun.faces.util.MessageUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;

public class RenderKitImpl
extends RenderKit {
    private static String HTML_CONTENT_TYPE = "text/html";
    private static String XHTML_CONTENT_TYPE = "application/xhtml+xml";
    private static String APPLICATION_XML_CONTENT_TYPE = "application/xml";
    private static String TEXT_XML_CONTENT_TYPE = "text/xml";
    private static String ALL_MEDIA = "*/*";
    private static String CHAR_ENCODING = "ISO-8859-1";
    private HashMap<String, HashMap<Object, Renderer>> rendererFamilies = new HashMap();
    private ResponseStateManager responseStateManager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRenderer(String family, String rendererType, Renderer renderer) {
        if (family == null || rendererType == null || renderer == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]);
            message = message + " family " + family + " rendererType " + rendererType + " renderer " + renderer;
            throw new NullPointerException(message);
        }
        HashMap<Object, Object> renderers = null;
        HashMap<String, HashMap<Object, Renderer>> hashMap = this.rendererFamilies;
        synchronized (hashMap) {
            renderers = this.rendererFamilies.get(family);
            if (null == renderers) {
                renderers = new HashMap();
                this.rendererFamilies.put(family, renderers);
            }
            renderers.put(rendererType, renderer);
        }
    }

    public Renderer getRenderer(String family, String rendererType) {
        if (rendererType == null || family == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]);
            message = message + " family " + family + " rendererType " + rendererType;
            throw new NullPointerException(message);
        }
        assert (this.rendererFamilies != null);
        HashMap<Object, Renderer> renderers = null;
        Renderer renderer = null;
        renderers = this.rendererFamilies.get(family);
        if (null != renderers) {
            renderer = renderers.get(rendererType);
        }
        return renderer;
    }

    public synchronized ResponseStateManager getResponseStateManager() {
        if (this.responseStateManager == null) {
            this.responseStateManager = new ResponseStateManagerImpl();
        }
        return this.responseStateManager;
    }

    public ResponseWriter createResponseWriter(Writer writer, String desiredContentTypeList, String characterEncoding) {
        if (writer == null) {
            return null;
        }
        String contentType = null;
        boolean contentTypeNullFromResponse = false;
        FacesContext context = FacesContext.getCurrentInstance();
        String[] supportedTypes = new String[]{HTML_CONTENT_TYPE, XHTML_CONTENT_TYPE, APPLICATION_XML_CONTENT_TYPE, TEXT_XML_CONTENT_TYPE};
        if (null != desiredContentTypeList) {
            contentType = this.findMatch(context, desiredContentTypeList, supportedTypes);
        }
        if (null == desiredContentTypeList && null != (desiredContentTypeList = context.getExternalContext().getResponseContentType()) && null == (contentType = this.findMatch(context, desiredContentTypeList, supportedTypes))) {
            contentTypeNullFromResponse = true;
        }
        if (null == desiredContentTypeList || contentTypeNullFromResponse) {
            String supportedTypeString;
            String[] typeArray = (String[])context.getExternalContext().getRequestHeaderValuesMap().get("Accept");
            if (typeArray.length > 0) {
                StringBuffer buff = new StringBuffer();
                buff.append(typeArray[0]);
                for (int i = 1; i < typeArray.length; ++i) {
                    buff.append(',');
                    buff.append(typeArray[i]);
                }
                desiredContentTypeList = buff.toString();
            }
            if (null != desiredContentTypeList && null != (desiredContentTypeList = RenderKitUtils.determineContentType(desiredContentTypeList, supportedTypeString = HTML_CONTENT_TYPE + ',' + XHTML_CONTENT_TYPE + ',' + APPLICATION_XML_CONTENT_TYPE + ',' + TEXT_XML_CONTENT_TYPE))) {
                contentType = this.findMatch(context, desiredContentTypeList, supportedTypes);
            }
        }
        if (null == desiredContentTypeList || desiredContentTypeList.equals(ALL_MEDIA)) {
            contentType = HTML_CONTENT_TYPE;
        }
        if (null == contentType) {
            throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.CONTENT_TYPE_ERROR", new Object[0]));
        }
        if (characterEncoding == null) {
            characterEncoding = CHAR_ENCODING;
        }
        return new HtmlResponseWriter(writer, contentType, characterEncoding);
    }

    private String[] contentTypeSplit(String contentTypeString) {
        String[] result = contentTypeString.split(",");
        for (int i = 0; i < result.length; ++i) {
            int semicolon = result[i].indexOf(";");
            if (-1 == semicolon) continue;
            result[i] = result[i].substring(0, semicolon);
        }
        return result;
    }

    private String findMatch(FacesContext context, String desiredContentTypeList, String[] supportedTypes) {
        String contentType = null;
        Map requestMap = context.getExternalContext().getRequestMap();
        String[] desiredTypes = this.contentTypeSplit(desiredContentTypeList);
        String curContentType = null;
        String curDesiredType = null;
        for (int i = 0; i < desiredTypes.length; ++i) {
            curDesiredType = desiredTypes[i];
            for (int j = 0; j < supportedTypes.length; ++j) {
                curContentType = supportedTypes[j].trim();
                if (-1 == curDesiredType.indexOf(curContentType)) continue;
                if (-1 != curContentType.indexOf(HTML_CONTENT_TYPE)) {
                    contentType = HTML_CONTENT_TYPE;
                    requestMap.put("com.sun.faces.ContentTypeIsHTML", Boolean.TRUE);
                    break;
                }
                if (-1 == curContentType.indexOf(XHTML_CONTENT_TYPE) && -1 == curContentType.indexOf(APPLICATION_XML_CONTENT_TYPE) && -1 == curContentType.indexOf(TEXT_XML_CONTENT_TYPE)) break;
                contentType = XHTML_CONTENT_TYPE;
                requestMap.put("com.sun.faces.ContentTypeIsXHTML", Boolean.TRUE);
                break;
            }
            if (null != contentType) break;
        }
        return contentType;
    }

    public ResponseStream createResponseStream(OutputStream out) {
        final OutputStream output = out;
        return new ResponseStream(){

            public void write(int b) throws IOException {
                output.write(b);
            }

            public void write(byte[] b) throws IOException {
                output.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                output.write(b, off, len);
            }

            public void flush() throws IOException {
                output.flush();
            }

            public void close() throws IOException {
                output.close();
            }
        };
    }
}

