/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.renderkit.html_basic.LinkRenderer;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;

public class CommandLinkRenderer
extends LinkRenderer {
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Begin decoding component " + component.getId());
        }
        UICommand command = (UICommand)component;
        if (Util.componentIsDisabledOrReadonly(component)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("No decoding necessary since the component " + component.getId() + " is disabled");
            }
            return;
        }
        String clientId = command.getClientId(context);
        String paramName = this.getHiddenFieldName(context, (UIComponent)command);
        if (null == paramName) {
            return;
        }
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestParameterMap.get(paramName);
        if (value == null || value.equals("") || !clientId.equals(value)) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(component);
        component.queueEvent((FacesEvent)actionEvent);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("This command resulted in form submission  ActionEvent queued " + actionEvent);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "End decoding component " + component.getId());
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        UIForm form;
        UICommand command;
        if (context == null || component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Begin encoding component " + component.getId());
        }
        if (!(command = (UICommand)component).isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End encoding component " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        boolean componentDisabled = false;
        if (command.getAttributes().get("disabled") != null && command.getAttributes().get("disabled").equals(Boolean.TRUE)) {
            componentDisabled = true;
        }
        if ((form = this.getMyForm(component)) == null && logger.isLoggable(Level.WARNING)) {
            logger.warning("component '" + component.getId() + "' must be enclosed inside a form ");
        }
        if (componentDisabled || this.getMyForm(component) == null) {
            this.renderAsDisabled(context, (UIComponent)command);
        } else {
            this.renderAsActive(context, (UIComponent)command);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Begin encoding children " + component.getId());
        }
        if (!component.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End encoding component " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        for (UIComponent kid : component.getChildren()) {
            kid.encodeBegin(context);
            if (kid.getRendersChildren()) {
                kid.encodeChildren(context);
            }
            kid.encodeEnd(context);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "End encoding children " + component.getId());
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        UICommand command = (UICommand)component;
        if (!command.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End encoding component " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String fieldName = this.getHiddenFieldName(context, component);
        if (fieldName == null) {
            writer.write(MessageUtils.getExceptionMessageString("com.sun.faces.COMMAND_LINK_NO_FORM_MESSAGE", new Object[0]));
            writer.endElement("span");
            return;
        }
        boolean componentDisabled = false;
        if (component.getAttributes().get("disabled") != null && component.getAttributes().get("disabled").equals(Boolean.TRUE)) {
            componentDisabled = true;
        }
        if (componentDisabled) {
            writer.endElement("span");
            return;
        }
        writer.endElement("a");
        this.renderHiddenFieldsAndScriptIfNecessary(context, writer, component, fieldName);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "End encoding component " + component.getId());
        }
    }

    protected void renderAsActive(FacesContext context, UIComponent command) throws IOException {
        boolean userSpecifiedOnclick;
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String clientId = command.getClientId(context);
        UIForm uiform = this.getMyForm(command);
        if (uiform == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("component " + command.getId() + " must be enclosed inside a form ");
            }
            return;
        }
        String formClientId = uiform.getClientId(context);
        HtmlBasicRenderer.Param[] paramList = this.getParamList(context, command);
        writer.startElement("a", command);
        this.writeIdAttributeIfNecessary(context, writer, command);
        writer.writeAttribute("href", (Object)"#", "href");
        RenderKitUtils.renderPassThruAttributes(context, writer, command);
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, command);
        String userOnclick = (String)command.getAttributes().get("onclick");
        StringBuffer sb = new StringBuffer(128);
        boolean bl = userSpecifiedOnclick = userOnclick != null && !"".equals(userOnclick);
        if (userSpecifiedOnclick) {
            sb.append("var a=function(){");
            userOnclick = userOnclick.trim();
            sb.append(userOnclick);
            if (userOnclick.charAt(userOnclick.length() - 1) != ';') {
                sb.append(';');
            }
            sb.append("};var b=function(){");
        }
        sb.append("clearFormHiddenParams");
        sb.append('_');
        sb.append(formClientId.replace(':', '_'));
        sb.append("('");
        sb.append(formClientId);
        sb.append("');");
        sb.append("document.forms[");
        sb.append('\'');
        sb.append(formClientId);
        sb.append('\'');
        sb.append("]['");
        sb.append(this.getHiddenFieldName(context, command));
        sb.append("'].value='");
        sb.append(clientId);
        sb.append("';");
        int len = paramList.length;
        for (int i = 0; i < len; ++i) {
            sb.append("document.forms[");
            sb.append('\'');
            sb.append(formClientId);
            sb.append('\'');
            sb.append("]['");
            sb.append(paramList[i].getName());
            sb.append("'].value='");
            sb.append(paramList[i].getValue());
            sb.append("';");
        }
        String target = (String)command.getAttributes().get("target");
        if (target != null && target.trim().length() > 0) {
            sb.append(" document.forms[");
            sb.append('\'');
            sb.append(formClientId);
            sb.append('\'');
            sb.append("].target='");
            sb.append(target);
            sb.append("';");
        }
        sb.append(" document.forms[");
        sb.append('\'');
        sb.append(formClientId);
        sb.append('\'');
        sb.append("].submit()");
        sb.append("; return false;");
        if (userSpecifiedOnclick) {
            sb.append("};return (a()==false) ? false : b();");
        }
        writer.writeAttribute("onclick", (Object)sb.toString(), "onclick");
        this.writeCommonLinkAttributes(writer, command);
        this.writeValue(command, writer);
        writer.flush();
    }

    private void writeScriptContent(FacesContext context, ResponseWriter writer, UIComponent component) throws IOException {
        Map requestMap = context.getExternalContext().getRequestMap();
        UIForm myForm = this.getMyForm(component);
        boolean isXHTML = requestMap.containsKey("com.sun.faces.ContentTypeIsXHTML");
        if (null == myForm) {
            return;
        }
        if (null != myForm.getAttributes().get("com.sun.faces.didRenderScript")) {
            return;
        }
        String formName = myForm.getClientId(context);
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", "type");
        writer.writeAttribute("language", (Object)"Javascript", "language");
        if (isXHTML) {
            writer.write("//<![CDATA[\n");
        } else {
            writer.write("<!--\n");
        }
        writer.write("\nfunction ");
        String functionName = "clearFormHiddenParams_" + formName.replace(':', '_');
        writer.write(functionName);
        writer.write("(curFormName) {");
        writer.write("\n  var curForm = document.forms[curFormName];");
        writer.write("\n curForm.elements['");
        writer.write(this.getHiddenFieldName(context, component));
        writer.write("'].value = null;");
        HtmlBasicRenderer.Param[] paramList = this.getParamList(context, component);
        for (int i = 0; i < paramList.length; ++i) {
            writer.write("\n curForm.elements['");
            writer.write(paramList[i].getName());
            writer.write("'].value = null;");
        }
        String formTarget = (String)myForm.getAttributes().get("target");
        if (formTarget != null && formTarget.length() > 0) {
            writer.write("\n  curForm.target=");
            writer.write("'");
            writer.write(formTarget);
            writer.write("';");
        }
        writer.write("\n}\n");
        if (isXHTML) {
            writer.write("//]]>\n");
        } else {
            writer.write("//-->\n");
        }
        writer.endElement("script");
        myForm.getAttributes().put("com.sun.faces.didRenderScript", "com.sun.faces.didRenderScript");
    }

    private void renderHiddenFieldsAndScriptIfNecessary(FacesContext context, ResponseWriter writer, UIComponent component, String fieldName) throws IOException {
        Map requestMap = context.getExternalContext().getRequestMap();
        if (null == fieldName) {
            return;
        }
        String keyName = "com.sun.faces." + fieldName;
        Object keyVal = requestMap.get(keyName);
        if (null == keyVal || !keyVal.equals(keyName)) {
            writer.startElement("input", component);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.writeAttribute("name", (Object)fieldName, null);
            writer.endElement("input");
            requestMap.put(keyName, keyName);
        }
        ArrayList<String> renderedFields = null;
        HtmlBasicRenderer.Param[] paramList = this.getParamList(context, component);
        if (paramList != null && paramList.length > 0) {
            renderedFields = (ArrayList<String>)requestMap.get("com.sun.faces.renderedHiddenFields");
            if (renderedFields == null) {
                renderedFields = new ArrayList<String>();
            }
            for (int i = 0; i < paramList.length; ++i) {
                fieldName = paramList[i].getName();
                keyName = "com.sun.faces." + fieldName;
                int keyLocation = renderedFields.indexOf(keyName);
                if (keyLocation != -1) continue;
                writer.startElement("input", component);
                writer.writeAttribute("type", (Object)"hidden", null);
                writer.writeAttribute("name", (Object)fieldName, null);
                writer.endElement("input");
                renderedFields.add(keyName);
            }
        }
        requestMap.put("com.sun.faces.renderedHiddenFields", renderedFields);
        this.writeScriptContent(context, writer, component);
    }

    private String getHiddenFieldName(FacesContext context, UIComponent component) {
        UIForm uiform = this.getMyForm(component);
        if (null == uiform) {
            return null;
        }
        String formClientId = uiform.getClientId(context);
        return formClientId + ':' + "_id" + "cl";
    }

    private UIForm getMyForm(UIComponent component) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        if (null == parent && logger.isLoggable(Level.WARNING)) {
            logger.warning("component " + component.getId() + " must be enclosed inside a form ");
        }
        return (UIForm)parent;
    }
}

