/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.RIConstants;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicInputRenderer;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuRenderer
extends HtmlBasicInputRenderer {
    @Override
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Begin decoding component " + component.getId());
        }
        if (Util.componentIsDisabledOrReadonly(component)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("No decoding necessary since the component " + component.getId() + " is disabled");
            }
            return;
        }
        String clientId = component.getClientId(context);
        assert (clientId != null);
        if (component instanceof UISelectMany) {
            Map requestParameterValuesMap = context.getExternalContext().getRequestParameterValuesMap();
            if (requestParameterValuesMap.containsKey(clientId)) {
                String[] newValues = (String[])requestParameterValuesMap.get(clientId);
                this.setSubmittedValue(component, newValues);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("submitted values for UISelectMany component " + component.getId() + " after decoding " + newValues);
                }
            } else {
                this.setSubmittedValue(component, new String[0]);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Set empty array for UISelectMany component " + component.getId() + " after decoding ");
                }
            }
        } else {
            Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
            if (requestParameterMap.containsKey(clientId)) {
                String newValue = (String)requestParameterMap.get(clientId);
                this.setSubmittedValue(component, newValue);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("submitted value for UISelectOne component " + component.getId() + " after decoding " + newValue);
                }
            } else {
                this.setSubmittedValue(component, RIConstants.NO_VALUE);
            }
        }
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (component instanceof UISelectMany) {
            return this.convertSelectManyValue(context, (UISelectMany)component, (String[])submittedValue);
        }
        return this.convertSelectOneValue(context, (UISelectOne)component, (String)submittedValue);
    }

    public Object convertSelectOneValue(FacesContext context, UISelectOne uiSelectOne, String newValue) throws ConverterException {
        Object convertedValue = null;
        if (newValue == RIConstants.NO_VALUE) {
            return null;
        }
        if (newValue == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("No conversion necessary for SelectOne Component  " + uiSelectOne.getId() + " since the new value is null ");
            }
            return null;
        }
        convertedValue = super.getConvertedValue(context, (UIComponent)uiSelectOne, newValue);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SelectOne Component  " + uiSelectOne.getId() + " convertedValue " + convertedValue);
        }
        return convertedValue;
    }

    public Object convertSelectManyValue(FacesContext context, UISelectMany uiSelectMany, String[] newValues) throws ConverterException {
        ValueExpression valueExpression = uiSelectMany.getValueExpression("value");
        Object result = newValues;
        Class modelType = null;
        boolean throwException = false;
        if (null != valueExpression) {
            modelType = valueExpression.getType(context.getELContext());
            if (null != modelType) {
                if (modelType.isArray()) {
                    result = this.handleArrayCase(context, uiSelectMany, modelType, newValues);
                } else if (List.class.isAssignableFrom(modelType)) {
                    result = this.handleListCase(context, newValues);
                } else {
                    throwException = true;
                }
            } else {
                throwException = true;
            }
        } else {
            Object[] convertedValues = new Object[1];
            result = this.handleArrayCase(context, uiSelectMany, convertedValues.getClass(), newValues);
        }
        if (throwException) {
            StringBuffer values = new StringBuffer();
            if (null != newValues) {
                for (int i = 0; i < newValues.length; ++i) {
                    if (i == 0) {
                        values.append(newValues[i]);
                        continue;
                    }
                    values.append(' ').append(newValues[i]);
                }
            }
            Object[] params = new Object[]{values.toString(), valueExpression.getExpressionString()};
            throw new ConverterException(MessageUtils.getExceptionMessage("com.sun.faces.TYPECONVERSION_ERROR", params));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SelectMany Component  " + uiSelectMany.getId() + " convertedValues " + result);
        }
        return result;
    }

    protected Object handleArrayCase(FacesContext context, UISelectMany uiSelectMany, Class arrayClass, String[] newValues) throws ConverterException {
        Object result = null;
        Class<?> elementType = null;
        Converter converter = null;
        int len = null != newValues ? newValues.length : 0;
        elementType = arrayClass.getComponentType();
        if (elementType.equals(String.class)) {
            return newValues;
        }
        try {
            result = Array.newInstance(elementType, len);
        }
        catch (Exception e) {
            throw new ConverterException((Throwable)e);
        }
        if (null == newValues) {
            return result;
        }
        converter = uiSelectMany.getConverter();
        if (null == converter && null == (converter = Util.getConverterForClass(elementType, context))) {
            if (elementType.equals(Object.class)) {
                return newValues;
            }
            StringBuffer valueStr = new StringBuffer();
            for (int i = 0; i < len; ++i) {
                if (i == 0) {
                    valueStr.append(newValues[i]);
                    continue;
                }
                valueStr.append(' ').append(newValues[i]);
            }
            Object[] params = new Object[]{valueStr.toString(), "null Converter"};
            throw new ConverterException(MessageUtils.getExceptionMessage("com.sun.faces.TYPECONVERSION_ERROR", params));
        }
        assert (null != result);
        if (elementType.isPrimitive()) {
            for (int i = 0; i < len; ++i) {
                if (elementType.equals(Boolean.TYPE)) {
                    Array.setBoolean(result, i, (Boolean)converter.getAsObject(context, (UIComponent)uiSelectMany, newValues[i]));
                    continue;
                }
                if (elementType.equals(Byte.TYPE)) {
                    Array.setByte(result, i, (Byte)converter.getAsObject(context, (UIComponent)uiSelectMany, newValues[i]));
                    continue;
                }
                if (elementType.equals(Double.TYPE)) {
                    Array.setDouble(result, i, (Double)converter.getAsObject(context, (UIComponent)uiSelectMany, newValues[i]));
                    continue;
                }
                if (elementType.equals(Float.TYPE)) {
                    Array.setFloat(result, i, ((Float)converter.getAsObject(context, (UIComponent)uiSelectMany, newValues[i])).floatValue());
                    continue;
                }
                if (elementType.equals(Integer.TYPE)) {
                    Array.setInt(result, i, (Integer)converter.getAsObject(context, (UIComponent)uiSelectMany, newValues[i]));
                    continue;
                }
                if (elementType.equals(Character.TYPE)) {
                    Array.setChar(result, i, ((Character)converter.getAsObject(context, (UIComponent)uiSelectMany, newValues[i])).charValue());
                    continue;
                }
                if (elementType.equals(Short.TYPE)) {
                    Array.setShort(result, i, (Short)converter.getAsObject(context, (UIComponent)uiSelectMany, newValues[i]));
                    continue;
                }
                if (!elementType.equals(Long.TYPE)) continue;
                Array.setLong(result, i, (Long)converter.getAsObject(context, (UIComponent)uiSelectMany, newValues[i]));
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (logger.isLoggable(Level.FINE)) {
                    Object converted = converter.getAsObject(context, (UIComponent)uiSelectMany, newValues[i]);
                    logger.fine("String value: " + newValues[i] + " converts to : " + converted.toString());
                }
                Array.set(result, i, converter.getAsObject(context, (UIComponent)uiSelectMany, newValues[i]));
            }
        }
        return result;
    }

    protected ArrayList<String> handleListCase(FacesContext context, String[] newValues) {
        int i = 0;
        int len = newValues.length;
        ArrayList<String> result = new ArrayList<String>(len);
        for (i = 0; i < len; ++i) {
            result.add(newValues[i]);
        }
        return result;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Begin encoding component " + component.getId());
        }
        if (!component.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End encoding component " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        this.renderSelect(context, component);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "End encoding component " + component.getId());
        }
    }

    void renderSelect(FacesContext context, UIComponent component) throws IOException {
        Object size;
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Rendering 'select'");
        }
        writer.startElement("select", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        writer.writeAttribute("name", (Object)component.getClientId(context), "clientId");
        String styleClass = null;
        styleClass = (String)component.getAttributes().get("styleClass");
        if (null != styleClass) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        if (!this.getMultipleText(component).equals("")) {
            writer.writeAttribute("multiple", (Object)true, "multiple");
        }
        int itemCount = this.getOptionNumber(context, component);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Rendering " + itemCount + " options");
        }
        if (null == (size = component.getAttributes().get("size")) || size instanceof Integer && (Integer)size == Integer.MIN_VALUE) {
            this.writeDefaultSize(writer, itemCount);
        }
        RenderKitUtils.renderPassThruAttributes(context, writer, component);
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component);
        this.renderOptions(context, component);
        writer.endElement("select");
    }

    int getOptionNumber(FacesContext context, UIComponent component) {
        Iterator<SelectItem> items = RenderKitUtils.getSelectItems(context, component);
        int itemCount = 0;
        while (items.hasNext()) {
            ++itemCount;
            SelectItem item = items.next();
            if (!(item instanceof SelectItemGroup)) continue;
            int optionsLength = ((SelectItemGroup)item).getSelectItems().length;
            itemCount += optionsLength;
        }
        return itemCount;
    }

    void renderOptions(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        Iterator<SelectItem> items = RenderKitUtils.getSelectItems(context, component);
        SelectItem curItem = null;
        while (items.hasNext()) {
            curItem = items.next();
            if (curItem instanceof SelectItemGroup) {
                writer.startElement("optgroup", component);
                writer.writeAttribute("label", (Object)curItem.getLabel(), "label");
                SelectItem[] itemsArray = ((SelectItemGroup)curItem).getSelectItems();
                for (int i = 0; i < itemsArray.length; ++i) {
                    this.renderOption(context, component, itemsArray[i]);
                }
                writer.endElement("optgroup");
                continue;
            }
            this.renderOption(context, component, curItem);
        }
    }

    protected void renderOption(FacesContext context, UIComponent component, SelectItem curItem) throws IOException {
        Object newValue;
        boolean isSelected;
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        writer.writeText((Object)"\t", null);
        writer.startElement("option", component);
        String valueString = this.getFormattedValue(context, component, curItem.getValue());
        writer.writeAttribute("value", (Object)valueString, "value");
        Object[] submittedValues = this.getSubmittedSelectedValues(context, component);
        Class type = String.class;
        Object valuesArray = null;
        Object itemValue = null;
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = valueString;
        } else {
            valuesArray = this.getCurrentSelectedValues(context, component);
            itemValue = curItem.getValue();
        }
        if (valuesArray != null) {
            type = valuesArray.getClass().getComponentType();
        }
        if (isSelected = this.isSelected(newValue = context.getApplication().getExpressionFactory().coerceToType(itemValue, type), valuesArray)) {
            writer.writeAttribute("selected", (Object)true, "selected");
        }
        String labelClass = null;
        Boolean disabledAttr = (Boolean)component.getAttributes().get("disabled");
        boolean componentDisabled = false;
        if (disabledAttr != null && disabledAttr.equals(Boolean.TRUE)) {
            componentDisabled = true;
        }
        if (!componentDisabled && curItem.isDisabled()) {
            writer.writeAttribute("disabled", (Object)true, "disabled");
        }
        if ((labelClass = componentDisabled || curItem.isDisabled() ? (String)component.getAttributes().get("disabledClass") : (String)component.getAttributes().get("enabledClass")) != null) {
            writer.writeAttribute("class", (Object)labelClass, "labelClass");
        }
        writer.writeText((Object)curItem.getLabel(), "label");
        writer.endElement("option");
        writer.writeText((Object)"\n", null);
    }

    boolean isSelected(Object itemValue, Object valueArray) {
        if (null != valueArray) {
            int len = Array.getLength(valueArray);
            for (int i = 0; i < len; ++i) {
                Object value = Array.get(valueArray, i);
                if (!(value == null ? itemValue == null : value.equals(itemValue))) continue;
                return true;
            }
        }
        return false;
    }

    boolean isSelected(String itemValue, Object[] values) {
        if (null != values) {
            int len = values.length;
            for (int i = 0; i < len; ++i) {
                if (!values[i].equals(itemValue)) continue;
                return true;
            }
        }
        return false;
    }

    protected void writeDefaultSize(ResponseWriter writer, int itemCount) throws IOException {
        writer.writeAttribute("size", (Object)"1", "size");
    }

    String getMultipleText(UIComponent component) {
        if (component instanceof UISelectMany) {
            return " multiple ";
        }
        return "";
    }

    Object[] getSubmittedSelectedValues(FacesContext context, UIComponent component) {
        if (component instanceof UISelectMany) {
            UISelectMany select = (UISelectMany)component;
            return (Object[])select.getSubmittedValue();
        }
        UISelectOne select = (UISelectOne)component;
        Object returnObject = select.getSubmittedValue();
        if (null != returnObject) {
            return new Object[]{returnObject};
        }
        return null;
    }

    Object getCurrentSelectedValues(FacesContext context, UIComponent component) {
        if (component instanceof UISelectMany) {
            UISelectMany select = (UISelectMany)component;
            Object value = select.getValue();
            if (value instanceof List) {
                return ((List)value).toArray();
            }
            return value;
        }
        UISelectOne select = (UISelectOne)component;
        Object returnObject = select.getValue();
        if (null != returnObject) {
            return new Object[]{returnObject};
        }
        return null;
    }
}

