/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.PathEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Vector;

public class ArchiveFinder {
    private static final String DIRECTORY_NAME = "com.sun.tdk.signaturetest.DirectoryEntry";
    private static final String ZIP_NAME = "com.sun.tdk.signaturetest.ZipFileEntry";
    private Vector errors;
    private int sizeIgnorables;
    private Vector entries = new Vector();
    private Enumeration elements;
    private PathEntry currentEntry;
    private static String pathSeparator;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Vector;

    public ArchiveFinder(String string) {
        String string2;
        this.errors = new Vector();
        String string3 = string2 = string == null ? "" : string;
        if (string2 != null && !string2.equals("") && pathSeparator == null) {
            throw new SecurityException("Can't define path separator");
        }
        Vector vector = new Vector();
        while (string2 != null && string2.length() > 0) {
            String string4;
            int n = string2.indexOf(pathSeparator);
            if (n < 0) {
                string4 = string2;
                string2 = null;
            } else {
                string4 = string2.substring(0, n);
                string2 = string2.substring(n + pathSeparator.length());
            }
            PathEntry pathEntry = this.createPathEntry(string4);
            if (pathEntry == null) continue;
            this.entries.addElement(pathEntry);
        }
        this.elements = this.entries.elements();
    }

    public static String getClasspath() {
        String string = System.getProperty("sun.boot.class.path");
        String string2 = System.getProperty("java.class.path");
        if (string == null || string.equals("") || pathSeparator == null) {
            return string2;
        }
        return string2 != null ? string + pathSeparator + string2 : string;
    }

    public void printErrors(PrintWriter printWriter) {
        if (printWriter != null) {
            int n = 0;
            while (n < this.errors.size()) {
                printWriter.println((String)this.errors.elementAt(n));
                ++n;
            }
        }
    }

    public int getNumErrors() {
        return this.errors.size() - this.sizeIgnorables;
    }

    public void setListToBegin() {
        this.elements = this.entries.elements();
        this.currentEntry = null;
    }

    public String nextClassName() {
        String string = null;
        while ((this.currentEntry == null || (string = this.currentEntry.nextClassName()) == null) && this.elements.hasMoreElements()) {
            this.currentEntry = (PathEntry)this.elements.nextElement();
            this.currentEntry.setListToBegin();
        }
        return string;
    }

    public InputStream getCurrentClass() throws IOException {
        if (this.currentEntry == null) {
            return null;
        }
        return this.currentEntry.getCurrentClass();
    }

    public InputStream findClass(String string) throws IOException, ClassNotFoundException {
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            try {
                return ((PathEntry)enumeration.nextElement()).findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(string);
    }

    protected PathEntry createPathEntry(String string) {
        Throwable throwable;
        try {
            Class<?> clazz = Class.forName(DIRECTORY_NAME);
            Constructor<?> constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = ArchiveFinder.class$("java.lang.String")) : class$java$lang$String, class$java$util$Vector == null ? (class$java$util$Vector = ArchiveFinder.class$("java.util.Vector")) : class$java$util$Vector);
            return (PathEntry)constructor.newInstance(string, this.errors);
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getTargetException();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        try {
            Class<?> clazz = Class.forName(ZIP_NAME);
            Constructor<?> constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = ArchiveFinder.class$("java.lang.String")) : class$java$lang$String);
            return (PathEntry)constructor.newInstance(string);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.errors.addElement("Ignoring " + string + ": " + throwable + " : " + invocationTargetException.getTargetException());
            ++this.sizeIgnorables;
        }
        catch (Throwable throwable3) {
            this.errors.addElement("Ignoring " + string + ": " + throwable + " : " + throwable3);
            ++this.sizeIgnorables;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("java.io.File");
            Field field = clazz.getField("pathSeparator");
            pathSeparator = (String)field.get(null);
        }
        catch (Throwable throwable) {
            try {
                pathSeparator = System.getProperty("path.separator");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }
}

