/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.ItemDescription;
import java.io.PrintWriter;

public class ErrorFormatter {
    String[] messages = new String[]{"Required class not found in implementation: ", "Definition required but not found in ", "Definition required but not found in ", "Definition required but not found in ", "Definition required but not found in ", "Definition required but not found in ", "Found class not permitted in implementation: ", "Definition found but not permitted in ", "Definition found but not permitted in ", "Definition found but not permitted in ", "Definition found but not permitted in ", "Definition found but not permitted in ", "Class modifiers are changed: ", "Definition is changed in ", "Definition is changed in ", "Definition is changed in ", "Definition is changed in ", "Definition is changed in ", "LinkageError does not allow to track definition in ", "Warning: The deprecated API is not deprecated in ", "Warning: The API is deprecated in "};
    PrintWriter out;
    int size;

    public ErrorFormatter(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public ErrorFormatter(PrintWriter printWriter, String[] stringArray) {
        this.out = printWriter;
        this.messages = stringArray;
    }

    public void addError(String string, String string2, String string3, String string4) {
        this.out.println(this.createError(string, string2, string3, string4));
        if (!"Deprecated".equals(string)) {
            ++this.size;
        }
    }

    public void setMessages(String[] stringArray) {
        this.messages = stringArray;
    }

    protected Message createError(String string, String string2, String string3, String string4) {
        int n = 0;
        if (string3 != null) {
            if (string3.startsWith("innr ") || string3.startsWith("CLSS ")) {
                n = 1;
            }
            if (string3.startsWith("supr ") || string3.startsWith("intf ")) {
                n = 2;
            }
            if (string3.startsWith("fld  ")) {
                n = 3;
            }
            if (string3.startsWith("cons ")) {
                n = 4;
            }
            if (string3.startsWith("meth ")) {
                n = 5;
            }
        }
        if (string.equals("LinkageError")) {
            n = 18;
        } else if (string.equals("Deprecated")) {
            n = string3 != null && string3.indexOf("<deprecated>") < 0 ? 19 : 20;
        } else if (string.equals("Changed")) {
            n += 12;
        } else if (!string.equals("Missing")) {
            n += 6;
        }
        Message message = new Message(n, string2, string3, string4);
        message.setMessages(this.messages);
        return message;
    }

    public void printErrors() {
    }

    public int getNumErrors() {
        return this.size;
    }

    public static String toString(String string) {
        int n = 0;
        while (n < ItemDescription.prefixes.length) {
            if (string.startsWith(ItemDescription.prefixes[n][0])) {
                return ItemDescription.prefixes[n][1] + string.substring(ItemDescription.prefixes[n][0].length());
            }
            ++n;
        }
        return string;
    }

    public class Message {
        public String[] messages;
        public String className;
        public String definition;
        public String tail;
        public int errorType;

        public Message(int n, String string, String string2, String string3) {
            this.errorType = n;
            this.className = string;
            this.definition = string2 == null ? "" : string2;
            this.tail = string3 == null ? "" : string3;
        }

        public void setMessages(String[] stringArray) {
            this.messages = stringArray;
        }

        public int compareTo(Message message) {
            if (message.errorType == this.errorType) {
                if (this.className.equals(message.className)) {
                    return this.getShortName(this.definition).compareTo(this.getShortName(message.definition));
                }
                return this.className.compareTo(message.className);
            }
            return this.errorType - message.errorType;
        }

        public String getShortName(String string) {
            int n = string.lastIndexOf(" throws ");
            String string2 = n >= 0 ? string.substring(0, n) : string;
            return string2.substring(string2.lastIndexOf(32) + 1);
        }

        public String toString() {
            String string = this.errorType < this.messages.length ? this.messages[this.errorType] : "Unknown error ";
            return string + this.className + "\n    " + ErrorFormatter.toString(this.definition) + this.tail;
        }
    }
}

