/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.staticsig;

import com.sun.tdk.signaturetest.ClassDescription;
import java.util.Hashtable;

class Cache {
    private Entry begin;
    private Entry end;
    private int size;
    private Hashtable classes;

    public Cache(int n) {
        this.size = n > 0 ? n : 100;
        this.classes = new Hashtable(this.size + 5);
        this.begin = new Entry(null);
        this.begin.next = this.end = new Entry(null);
        this.end.prev = this.begin;
    }

    ClassDescription getClass(String string) {
        Entry entry = (Entry)this.classes.get(string);
        if (entry != null) {
            this.remove(entry);
            this.toEnd(entry);
            return entry.classEntry;
        }
        return null;
    }

    void add(ClassDescription classDescription) {
        if (this.classes.size() >= this.size) {
            this.removeFirst();
        }
        Entry entry = new Entry(classDescription);
        this.toEnd(entry);
        this.classes.put(classDescription.getName(), entry);
    }

    private void removeFirst() {
        if (this.begin.next != this.end) {
            this.classes.remove(this.begin.next.classEntry.getName());
            this.remove(this.begin.next);
        }
    }

    private void remove(Entry entry) {
        if (entry.prev != null) {
            entry.prev.next = entry.next;
        }
        if (entry.next != null) {
            entry.next.prev = entry.prev;
        }
    }

    private void toEnd(Entry entry) {
        entry.next = this.end;
        entry.prev = this.end.prev;
        entry.prev.next = entry;
        this.end.prev = entry;
    }

    class Entry {
        public ClassDescription classEntry;
        public Entry next;
        public Entry prev;

        public Entry(ClassDescription classDescription) {
            this.classEntry = classDescription;
        }
    }
}

