/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.jsr94.tck;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.rules.Handle;
import javax.rules.ObjectFilter;
import javax.rules.StatefulRuleSession;
import junit.framework.TestCase;
import org.jcp.jsr94.tck.model.Customer;
import org.jcp.jsr94.tck.model.Invoice;
import org.jcp.jsr94.tck.util.TestCaseUtil;
import org.jcp.jsr94.tck.util.TestFactory;
import org.jcp.jsr94.tck.util.TestObjectFilter;

public class StatefulRuleSessionTest
extends TestCase {
    public StatefulRuleSessionTest(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testStatefulRuleSession() {
        try {
            StatefulRuleSession ruleSession = TestCaseUtil.getStatefulRuleSession("stateful", "tck_res_2.xml");
            StatefulRuleSessionTest.assertNotNull((String)"[StatefulRuleSessionTest] ", (Object)ruleSession);
            Customer inputCustomer = TestFactory.newInstance().createCustomer("test");
            inputCustomer.setCreditLimit(5000);
            Invoice inputInvoice = TestFactory.newInstance().createInvoice("test");
            inputInvoice.setAmount(2000);
            ArrayList<Object> input = new ArrayList<Object>();
            input.add(inputCustomer);
            input.add(inputInvoice);
            Handle customerHandle = ruleSession.addObject((Object)inputCustomer);
            StatefulRuleSessionTest.assertNotNull((String)"[StatefulRuleSessionTest] ", (Object)customerHandle);
            Handle invoiceHandle = ruleSession.addObject((Object)inputInvoice);
            StatefulRuleSessionTest.assertNotNull((String)"[StatefulRuleSessionTest] ", (Object)invoiceHandle);
            Object obj = null;
            obj = ruleSession.getObject(customerHandle);
            StatefulRuleSessionTest.assertNotNull((String)"[StatefulRuleSessionTest] ", (Object)obj);
            StatefulRuleSessionTest.assertTrue((String)"[StatefulRuleSessionTest] ", (boolean)(obj instanceof Customer));
            obj = ruleSession.getObject(invoiceHandle);
            StatefulRuleSessionTest.assertNotNull((String)"[StatefulRuleSessionTest] ", (Object)obj);
            StatefulRuleSessionTest.assertTrue((String)"[StatefulRuleSessionTest] ", (boolean)(obj instanceof Invoice));
            List list = ruleSession.getObjects();
            StatefulRuleSessionTest.assertNotNull((String)"[StatefulRuleSessionTest] ", (Object)list);
            StatefulRuleSessionTest.assertEquals((String)"[StatefulRuleSessionTest] ", (int)2, (int)list.size());
            Iterator itr = list.iterator();
            Customer resultCustomer = null;
            Invoice resultInvoice = null;
            while (itr.hasNext()) {
                obj = itr.next();
                if (obj instanceof Customer) {
                    resultCustomer = (Customer)obj;
                }
                if (!(obj instanceof Invoice)) continue;
                resultInvoice = (Invoice)obj;
            }
            StatefulRuleSessionTest.assertNotNull((String)"[StatefulRuleSessionTest] Customer not found in result set.", resultCustomer);
            StatefulRuleSessionTest.assertNotNull((String)"[StatefulRuleSessionTest] Invoice not found in result set.", resultInvoice);
            Customer updateCustomer = TestFactory.newInstance().createCustomer("update-test");
            updateCustomer.setCreditLimit(8000);
            ruleSession.updateObject(customerHandle, (Object)updateCustomer);
            obj = ruleSession.getObject(customerHandle);
            StatefulRuleSessionTest.assertNotNull((String)"[StatefulRuleSessionTest] ", (Object)obj);
            StatefulRuleSessionTest.assertTrue((String)"[StatefulRuleSessionTest] ", (boolean)(obj instanceof Customer));
            updateCustomer = (Customer)obj;
            StatefulRuleSessionTest.assertEquals((String)"[StatefulRuleSessionTest] verify updateObject ", (int)8000, (int)updateCustomer.getCreditLimit());
            List handles = ruleSession.getHandles();
            StatefulRuleSessionTest.assertNotNull((String)"[StatefulRuleSessionTest] getHandles ", (Object)handles);
            StatefulRuleSessionTest.assertEquals((String)"[StatefulRuleSessionTest] getHandles ", (int)2, (int)handles.size());
            itr = handles.iterator();
            resultCustomer = null;
            resultInvoice = null;
            while (itr.hasNext()) {
                obj = itr.next();
                if ((obj = ruleSession.getObject((Handle)obj)) instanceof Customer) {
                    resultCustomer = (Customer)obj;
                }
                if (!(obj instanceof Invoice)) continue;
                resultInvoice = (Invoice)obj;
            }
            StatefulRuleSessionTest.assertNotNull((String)"[StatefulRuleSessionTest][getHandles] Customer found in result set.", (Object)resultCustomer);
            StatefulRuleSessionTest.assertNotNull((String)"[StatefulRuleSessionTest][getHandles] Invoice not found in result set.", (Object)resultInvoice);
            ruleSession.removeObject(customerHandle);
            list = ruleSession.getObjects();
            StatefulRuleSessionTest.assertNotNull((String)"[StatefulRuleSessionTest] ", (Object)list);
            StatefulRuleSessionTest.assertEquals((String)"[StatefulRuleSessionTest] ", (int)1, (int)list.size());
            itr = list.iterator();
            resultCustomer = null;
            resultInvoice = null;
            while (itr.hasNext()) {
                obj = itr.next();
                if (obj instanceof Customer) {
                    resultCustomer = (Customer)obj;
                }
                if (!(obj instanceof Invoice)) continue;
                resultInvoice = (Invoice)obj;
            }
            StatefulRuleSessionTest.assertNull((String)"[StatefulRuleSessionTest] Customer found in result set.", (Object)resultCustomer);
            StatefulRuleSessionTest.assertNotNull((String)"[StatefulRuleSessionTest] Invoice not found in result set.", (Object)resultInvoice);
            ruleSession.reset();
            list = ruleSession.getObjects();
            StatefulRuleSessionTest.assertNotNull((String)"[StatefulRuleSessionTest] ", (Object)list);
            StatefulRuleSessionTest.assertEquals((String)"[StatefulRuleSessionTest] ", (int)0, (int)list.size());
            handles = ruleSession.addObjects(input);
            StatefulRuleSessionTest.assertNotNull((String)"[StatefulRuleSessionTest] ", (Object)handles);
            StatefulRuleSessionTest.assertEquals((String)"[StatefulRuleSessionTest] ", (int)2, (int)handles.size());
            ruleSession.executeRules();
            List results = ruleSession.getObjects();
            StatefulRuleSessionTest.assertNotNull((String)"[StatefulRuleSessionTest] No results found.", (Object)results);
            StatefulRuleSessionTest.assertEquals((String)"[StatefulRuleSessionTest] ", (int)2, (int)results.size());
            itr = results.iterator();
            resultCustomer = null;
            resultInvoice = null;
            while (itr.hasNext()) {
                obj = itr.next();
                if (obj instanceof Customer) {
                    resultCustomer = (Customer)obj;
                }
                if (!(obj instanceof Invoice)) continue;
                resultInvoice = (Invoice)obj;
            }
            StatefulRuleSessionTest.assertNotNull((String)"[StatefulRuleSessionTest] Customer not found in result set.", (Object)resultCustomer);
            StatefulRuleSessionTest.assertNotNull((String)"[StatefulRuleSessionTest] Invoice not found in result set.", (Object)resultInvoice);
            StatefulRuleSessionTest.assertEquals((String)"[StatefulRuleSessionTest] verify Customer ", (int)3000, (int)resultCustomer.getCreditLimit());
            StatefulRuleSessionTest.assertEquals((String)"[StatefulRuleSessionTest] verify Invoice ", (Object)"paid", (Object)resultInvoice.getStatus());
            Invoice secondInvoice = TestFactory.newInstance().createInvoice("invoice2");
            secondInvoice.setAmount(1500);
            Handle secondInvoiceHandle = ruleSession.addObject((Object)secondInvoice);
            ruleSession.executeRules();
            TestObjectFilter customerFilter = new TestObjectFilter(0);
            TestObjectFilter invoiceFilter = new TestObjectFilter(1);
            results = ruleSession.getObjects((ObjectFilter)customerFilter);
            StatefulRuleSessionTest.assertNotNull((String)"[StatefulRuleSessionTest] No results found.", (Object)results);
            StatefulRuleSessionTest.assertEquals((String)"[StatefulRuleSessionTest] ", (int)1, (int)results.size());
            itr = results.iterator();
            resultCustomer = null;
            resultInvoice = null;
            while (itr.hasNext()) {
                obj = itr.next();
                if (obj instanceof Customer) {
                    resultCustomer = (Customer)obj;
                }
                if (!(obj instanceof Invoice)) continue;
                resultInvoice = (Invoice)obj;
            }
            StatefulRuleSessionTest.assertNotNull((String)"[StatefulRuleSessionTest] Customer not found in result set.", (Object)resultCustomer);
            StatefulRuleSessionTest.assertNull((String)"[StatefulRuleSessionTest] Invoice found in result set.", (Object)resultInvoice);
            StatefulRuleSessionTest.assertEquals((String)"[StatefulRuleSessionTest] verify Customer(2) ", (int)1500, (int)resultCustomer.getCreditLimit());
            results = ruleSession.getObjects((ObjectFilter)invoiceFilter);
            StatefulRuleSessionTest.assertNotNull((String)"[StatefulRuleSessionTest] No results found.", (Object)results);
            StatefulRuleSessionTest.assertEquals((String)"[StatefulRuleSessionTest] ", (int)2, (int)results.size());
            itr = results.iterator();
            resultCustomer = null;
            resultInvoice = null;
            while (itr.hasNext()) {
                obj = itr.next();
                if (obj instanceof Customer) {
                    resultCustomer = (Customer)obj;
                }
                if (!(obj instanceof Invoice)) continue;
                resultInvoice = (Invoice)obj;
            }
            StatefulRuleSessionTest.assertNull((String)"[StatefulRuleSessionTest] Customer not found in result set.", (Object)resultCustomer);
            StatefulRuleSessionTest.assertNotNull((String)"[StatefulRuleSessionTest] Invoice found in result set.", (Object)resultInvoice);
            ruleSession.reset();
            ruleSession.release();
        }
        catch (Exception e) {
            StatefulRuleSessionTest.fail((String)e.getMessage());
        }
    }
}

