/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.jsr94.tck;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.rules.ObjectFilter;
import javax.rules.StatelessRuleSession;
import junit.framework.TestCase;
import org.jcp.jsr94.tck.model.Customer;
import org.jcp.jsr94.tck.model.Invoice;
import org.jcp.jsr94.tck.util.TestCaseUtil;
import org.jcp.jsr94.tck.util.TestFactory;
import org.jcp.jsr94.tck.util.TestObjectFilter;

public class StatelessRuleSessionTest
extends TestCase {
    public StatelessRuleSessionTest(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testStatelessRuleSession() {
        try {
            StatelessRuleSession ruleSession = TestCaseUtil.getStatelessRuleSession("stateless", "tck_res_1.xml");
            StatelessRuleSessionTest.assertNotNull((String)"[StatelessRuleSessionTest] ", (Object)ruleSession);
            Customer inputCustomer = TestFactory.newInstance().createCustomer("test");
            inputCustomer.setCreditLimit(5000);
            Invoice inputInvoice = TestFactory.newInstance().createInvoice("test");
            inputInvoice.setAmount(2000);
            ArrayList<Object> input = new ArrayList<Object>();
            input.add(inputCustomer);
            input.add(inputInvoice);
            List results = ruleSession.executeRules(input);
            StatelessRuleSessionTest.assertNotNull((String)"[StatelessRuleSessionTest] No results found.", (Object)results);
            StatelessRuleSessionTest.assertTrue((String)"[StatelessRuleSessionTest] ", (2 == results.size() ? 1 : 0) != 0);
            Iterator itr = results.iterator();
            Customer resultCustomer = null;
            Invoice resultInvoice = null;
            while (itr.hasNext()) {
                Object obj = itr.next();
                if (obj instanceof Customer) {
                    resultCustomer = (Customer)obj;
                }
                if (!(obj instanceof Invoice)) continue;
                resultInvoice = (Invoice)obj;
            }
            StatelessRuleSessionTest.assertNotNull((String)"[StatelessRuleSessionTest] Customer not found in result set.", resultCustomer);
            StatelessRuleSessionTest.assertNotNull((String)"[StatelessRuleSessionTest] Invoice not found in result set.", resultInvoice);
            StatelessRuleSessionTest.assertEquals((String)"[StatelessRuleSessionTest] ", (int)3000, (int)resultCustomer.getCreditLimit());
            StatelessRuleSessionTest.assertEquals((String)"[StatelessRuleSessionTest] ", (Object)"paid", (Object)resultInvoice.getStatus());
            inputCustomer = TestFactory.newInstance().createCustomer("test");
            inputCustomer.setCreditLimit(5000);
            inputInvoice = TestFactory.newInstance().createInvoice("test");
            inputInvoice.setAmount(2000);
            input = new ArrayList();
            input.add(inputCustomer);
            input.add(inputInvoice);
            TestObjectFilter customerFilter = new TestObjectFilter(0);
            results = ruleSession.executeRules(input, (ObjectFilter)customerFilter);
            StatelessRuleSessionTest.assertNotNull((String)"[StatelessRuleSessionTest] No results found.", (Object)results);
            StatelessRuleSessionTest.assertEquals((String)"[StatelessRuleSessionTest] ", (int)1, (int)results.size());
            itr = results.iterator();
            resultCustomer = null;
            resultInvoice = null;
            while (itr.hasNext()) {
                Object obj = itr.next();
                if (obj instanceof Customer) {
                    resultCustomer = (Customer)obj;
                }
                if (!(obj instanceof Invoice)) continue;
                resultInvoice = (Invoice)obj;
            }
            StatelessRuleSessionTest.assertNotNull((String)"[StatelessRuleSessionTest] Customer not found in result set.", (Object)resultCustomer);
            StatelessRuleSessionTest.assertNull((String)"[StatelessRuleSessionTest] Invoice found in result set.", (Object)resultInvoice);
            ruleSession.release();
        }
        catch (Exception e) {
            StatelessRuleSessionTest.fail((String)e.getMessage());
        }
    }
}

