/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.jsr94.tck.admin;

import java.util.List;
import javax.rules.RuleServiceProvider;
import javax.rules.admin.LocalRuleExecutionSetProvider;
import javax.rules.admin.Rule;
import javax.rules.admin.RuleAdministrator;
import javax.rules.admin.RuleExecutionSet;
import junit.framework.TestCase;
import org.jcp.jsr94.tck.util.TestCaseUtil;
import org.jcp.jsr94.tck.util.TestFactory;

public class RuleTest
extends TestCase {
    public RuleTest(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testRule() {
        try {
            RuleServiceProvider serviceProvider = TestCaseUtil.getRuleServiceProvider("RuleExecutionSetTest");
            RuleTest.assertNotNull((String)"[RuleTest] RuleServiceProvider not found.", (Object)serviceProvider);
            RuleAdministrator ruleAdministrator = serviceProvider.getRuleAdministrator();
            RuleTest.assertNotNull((String)"[RuleTest] RuleAdministrator not found.", (Object)ruleAdministrator);
            LocalRuleExecutionSetProvider localProvider = ruleAdministrator.getLocalRuleExecutionSetProvider(TestFactory.newInstance().createLocalRuleExecutionSetProviderMap());
            RuleExecutionSet res = TestFactory.newInstance().createRuleExecutionSet(serviceProvider, "tck_res_1.xml");
            List ruleList = res.getRules();
            RuleTest.assertNotNull((String)"[RuleTest] No rules found.", (Object)ruleList);
            RuleTest.assertTrue((String)"[RuleTest] ", (0 < ruleList.size() ? 1 : 0) != 0);
            Rule[] rules = ruleList.toArray(new Rule[0]);
            Rule rule = rules[0];
            RuleTest.assertNotNull((String)"[RuleTest] No rule name.", (Object)rule.getName());
            RuleTest.assertNotNull((String)"[RuleTest] No rule description", (Object)rule.getDescription());
            rule.setProperty((Object)"ruleProperty", (Object)ruleList);
            Object obj = rule.getProperty((Object)"ruleProperty");
            RuleTest.assertNotNull((String)"[RuleTest] Rule property could not be retrieved.", (Object)obj);
            RuleTest.assertEquals((String)"[RuleTest] ", (Object)obj, (Object)ruleList);
        }
        catch (Exception e) {
            RuleTest.fail((String)e.getMessage());
        }
    }
}

