/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.jsr94.tck.util;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Map;
import javax.rules.ConfigurationException;
import javax.rules.RuleServiceProvider;
import javax.rules.admin.LocalRuleExecutionSetProvider;
import javax.rules.admin.RuleExecutionSet;
import javax.rules.admin.RuleExecutionSetCreateException;
import javax.rules.admin.RuleExecutionSetProvider;
import junit.framework.TestCase;
import org.jcp.jsr94.tck.model.Customer;
import org.jcp.jsr94.tck.model.CustomerImpl;
import org.jcp.jsr94.tck.model.Invoice;
import org.jcp.jsr94.tck.model.InvoiceImpl;
import org.jcp.jsr94.tck.util.TestCaseUtil;
import org.w3c.dom.Element;

public class TestFactory {
    protected TestFactory() {
    }

    public static TestFactory newInstance() {
        String implClassName = TestCaseUtil.getTestFactory();
        if (implClassName == null) {
            throw new IllegalArgumentException("Since JSR-94 1.1 the <test-factory> must be specified in the lib/tck.conf file. The default value for this property is org.jcp.jsr94.tck.util.TestFactory.");
        }
        try {
            return (TestFactory)Class.forName(implClassName).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Could not create custom TestObjectFactory. Exception: " + e);
        }
    }

    public Map createRuleExecutionSetMap() {
        return null;
    }

    public Map createRegisterRuleExecutionSetMap() {
        return null;
    }

    public Map createDeregisterRuleExecutionSetMap() {
        return null;
    }

    public Map createLocalRuleExecutionSetProviderMap() {
        return null;
    }

    public Map createRuleExecutionSetProviderMap() {
        return null;
    }

    public RuleExecutionSet createRuleExecutionSet(RuleServiceProvider serviceProvider, String uri) throws ConfigurationException, RemoteException, RuleExecutionSetCreateException, IOException {
        RuleExecutionSet res = null;
        LocalRuleExecutionSetProvider localResProvider = serviceProvider.getRuleAdministrator().getLocalRuleExecutionSetProvider(this.createLocalRuleExecutionSetProviderMap());
        if (localResProvider != null) {
            InputStream inStream = TestCaseUtil.getRuleExecutionSetInputStream(uri);
            TestCase.assertNotNull((String)("[TestFactory] Input stream for " + uri + " could not be created."), (Object)inStream);
            res = localResProvider.createRuleExecutionSet(inStream, this.createRuleExecutionSetMap());
            inStream.close();
        } else {
            Element element = TestCaseUtil.getRuleExecutionSetDocumentElement(uri);
            RuleExecutionSetProvider resProvider = serviceProvider.getRuleAdministrator().getRuleExecutionSetProvider(this.createRuleExecutionSetProviderMap());
            res = resProvider.createRuleExecutionSet(element, this.createRuleExecutionSetMap());
        }
        TestCase.assertNotNull((String)("[TestFactory] RuleExecutionSet for " + uri + " could not be created."), (Object)res);
        return res;
    }

    public Map createRuleSessionMap(int type) {
        return null;
    }

    public Customer createCustomer(String name) {
        return new CustomerImpl(name);
    }

    public Invoice createInvoice(String description) {
        return new InvoiceImpl(description);
    }

    public Object createHandleTestObject(String name) {
        return name;
    }
}

