/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.el.ValueExpression;

public class Bindings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Method[] NO_FUNCTIONS = new Method[0];
    private static final ValueExpression[] NO_VARIABLES = new ValueExpression[0];
    private transient Method[] functions;
    private final ValueExpression[] variables;

    public Bindings(Method[] methodArray, ValueExpression[] valueExpressionArray) {
        this.functions = methodArray == null || methodArray.length == 0 ? NO_FUNCTIONS : methodArray;
        this.variables = valueExpressionArray == null || valueExpressionArray.length == 0 ? NO_VARIABLES : valueExpressionArray;
    }

    public Method getFunction(int n) {
        return this.functions[n];
    }

    public ValueExpression getVariable(int n) {
        return this.variables[n];
    }

    public boolean equals(Object object) {
        if (object instanceof Bindings) {
            Bindings bindings = (Bindings)object;
            return Arrays.equals(this.functions, bindings.functions) && Arrays.equals(this.variables, bindings.variables);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.functions) ^ Arrays.hashCode(this.variables);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        objectOutputStream.defaultWriteObject();
        MethodWrapper[] methodWrapperArray = new MethodWrapper[this.functions.length];
        for (int i = 0; i < methodWrapperArray.length; ++i) {
            methodWrapperArray[i] = new MethodWrapper(this.functions[i]);
        }
        objectOutputStream.writeObject(methodWrapperArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        MethodWrapper[] methodWrapperArray = (MethodWrapper[])objectInputStream.readObject();
        if (methodWrapperArray.length == 0) {
            this.functions = NO_FUNCTIONS;
        } else {
            this.functions = new Method[methodWrapperArray.length];
            for (int i = 0; i < this.functions.length; ++i) {
                this.functions[i] = methodWrapperArray[i].method;
            }
        }
    }

    private static class MethodWrapper
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient Method method;

        private MethodWrapper(Method method) {
            this.method = method;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeObject(this.method.getDeclaringClass());
            objectOutputStream.writeObject(this.method.getName());
            objectOutputStream.writeObject(this.method.getParameterTypes());
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            Class clazz = (Class)objectInputStream.readObject();
            String string = (String)objectInputStream.readObject();
            Class[] classArray = (Class[])objectInputStream.readObject();
            try {
                this.method = clazz.getDeclaredMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IOException(noSuchMethodException.getMessage());
            }
        }
    }
}

