/*
 * Decompiled with CFR 0.152.
 */
package org.junit;

import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;
import org.junit.matchers.Each;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assume {
    public static <T> void assumeThat(T value, Matcher<T> assumption) {
        if (!assumption.matches(value)) {
            throw new AssumptionViolatedException(value, assumption);
        }
    }

    public static void assumeNotNull(Object ... objects) {
        Assume.assumeThat(Arrays.asList(objects), Each.each(CoreMatchers.notNullValue()));
    }

    public static void assumeNoException(Throwable t) {
        Assume.assumeThat(t, CoreMatchers.nullValue());
    }

    public static void assumeTrue(boolean b) {
        Assume.assumeThat(b, CoreMatchers.is((Object)true));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AssumptionViolatedException
    extends RuntimeException
    implements SelfDescribing {
        private static final long serialVersionUID = 1L;
        private final Object fValue;
        private final Matcher<?> fMatcher;

        public AssumptionViolatedException(Object value, Matcher<?> matcher) {
            super(value instanceof Throwable ? (Throwable)value : null);
            this.fValue = value;
            this.fMatcher = matcher;
        }

        @Override
        public String getMessage() {
            return StringDescription.asString((SelfDescribing)this);
        }

        public void describeTo(Description description) {
            description.appendText("got: ");
            description.appendValue(this.fValue);
            description.appendText(", expected: ");
            description.appendDescriptionOf(this.fMatcher);
        }
    }
}

