/*
 * Decompiled with CFR 0.152.
 */
package kr.motd.maven.os;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import kr.motd.maven.os.DetectionException;
import kr.motd.maven.os.Detector;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="detect", defaultPhase=LifecyclePhase.VALIDATE)
public class DetectMojo
extends AbstractMojo {
    static final String CLASSIFIER_WITH_LIKES_PROPERTY = "os.detection.classifierWithLikes";
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="os.detection.classifierWithLikes", defaultValue="${os.detection.classifierWithLikes}")
    private String classifierWithLikes;
    private final Detector detector = new Detector(){

        @Override
        protected void log(String message) {
            DetectMojo.this.getLog().info((CharSequence)message);
        }

        @Override
        protected void logProperty(String name, String value) {
            Log log = DetectMojo.this.getLog();
            if (log.isInfoEnabled()) {
                log.info((CharSequence)(name + ": " + value));
            }
        }
    };

    public void execute() throws MojoExecutionException {
        try {
            this.detector.detect(this.project.getProperties(), DetectMojo.getClassifierWithLikes(this.classifierWithLikes));
        }
        catch (DetectionException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    public static List<String> getClassifierWithLikes(@Nullable String propertyValue) {
        if (propertyValue == null) {
            return Collections.emptyList();
        }
        String[] parts = propertyValue.split(",");
        ArrayList<String> likes = new ArrayList<String>(parts.length);
        for (String part : parts) {
            if ((part = part.trim()).isEmpty()) continue;
            likes.add(part);
        }
        return likes;
    }
}

