/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPSchema;
import com.novell.ldap.LDAPSchemaElement;
import com.novell.ldap.client.AttributeQualifier;
import com.novell.ldap.client.SchemaParser;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPAttributeSchema
extends LDAPSchemaElement {
    private String syntaxString;
    private boolean single = false;
    private String superior;
    private String equality;
    private String ordering;
    private String substring;
    private boolean collective = false;
    private boolean userMod = true;
    private int usage = 0;
    public static final int USER_APPLICATIONS = 0;
    public static final int DIRECTORY_OPERATION = 1;
    public static final int DISTRIBUTED_OPERATION = 2;
    public static final int DSA_OPERATION = 3;

    public LDAPAttributeSchema() {
        super(LDAPSchema.schemaTypeNames[0]);
    }

    public LDAPAttributeSchema(String[] stringArray, String string, String string2, String string3, boolean bl, String string4, boolean bl2, String string5, String string6, String string7, boolean bl3, boolean bl4, int n) {
        super(LDAPSchema.schemaTypeNames[0]);
        this.names = stringArray;
        this.oid = string;
        this.description = string2;
        this.obsolete = bl2;
        this.syntaxString = string3;
        this.single = bl;
        this.equality = string5;
        this.ordering = string6;
        this.substring = string7;
        this.collective = bl3;
        this.userMod = bl4;
        this.usage = n;
        super.setValue(this.formatString());
    }

    public LDAPAttributeSchema(String string) {
        super(LDAPSchema.schemaTypeNames[0]);
        try {
            SchemaParser schemaParser = new SchemaParser(string);
            if (schemaParser.getNames() != null) {
                this.names = schemaParser.getNames();
            }
            if (schemaParser.getID() != null) {
                this.oid = schemaParser.getID();
            }
            if (schemaParser.getDescription() != null) {
                this.description = schemaParser.getDescription();
            }
            if (schemaParser.getSyntax() != null) {
                this.syntaxString = schemaParser.getSyntax();
            }
            if (schemaParser.getSuperior() != null) {
                this.syntaxString = schemaParser.getSuperior();
            }
            this.single = schemaParser.getSingle();
            this.obsolete = schemaParser.getObsolete();
            Enumeration enumeration = schemaParser.getQualifiers();
            while (enumeration.hasMoreElements()) {
                AttributeQualifier attributeQualifier = (AttributeQualifier)enumeration.nextElement();
                this.setQualifier(attributeQualifier.getName(), attributeQualifier.getValues());
            }
            if (schemaParser.getEquality() != null) {
                this.equality = schemaParser.getEquality();
            }
            if (schemaParser.getOrdering() != null) {
                this.ordering = schemaParser.getOrdering();
            }
            if (schemaParser.getSubstring() != null) {
                this.substring = schemaParser.getSubstring();
            }
            super.setValue(this.formatString());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public String getSyntaxString() {
        return this.syntaxString;
    }

    public String getSuperior() {
        return this.superior;
    }

    public boolean isSingleValued() {
        return this.single;
    }

    public String getEqualityMatchingRule() {
        return this.equality;
    }

    public String getOrderingMatchingRule() {
        return this.ordering;
    }

    public String getSubstringMatchingRule() {
        return this.substring;
    }

    public boolean isCollective() {
        return this.collective;
    }

    public boolean isUserModifiable() {
        return this.userMod;
    }

    public int getUsage() {
        return this.usage;
    }

    protected String formatString() {
        int n;
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer("( ");
        String string = this.getID();
        if (string != null) {
            stringBuffer.append(string);
        }
        if ((stringArray = this.getNames()) != null) {
            stringBuffer.append(" NAME ");
            if (stringArray.length == 1) {
                stringBuffer.append("'" + stringArray[0] + "'");
            } else {
                stringBuffer.append("( ");
                for (n = 0; n < stringArray.length; ++n) {
                    stringBuffer.append(" '" + stringArray[n] + "'");
                }
                stringBuffer.append(" )");
            }
        }
        if ((string = this.getDescription()) != null) {
            stringBuffer.append(" DESC ");
            stringBuffer.append("'" + string + "'");
        }
        if (this.isObsolete()) {
            stringBuffer.append(" OBSOLETE");
        }
        if ((string = this.getSuperior()) != null) {
            stringBuffer.append(" SUP ");
            stringBuffer.append("'" + string + "'");
        }
        if ((string = this.getEqualityMatchingRule()) != null) {
            stringBuffer.append(" EQUALITY ");
            stringBuffer.append("'" + string + "'");
        }
        if ((string = this.getOrderingMatchingRule()) != null) {
            stringBuffer.append(" ORDERING ");
            stringBuffer.append("'" + string + "'");
        }
        if ((string = this.getSubstringMatchingRule()) != null) {
            stringBuffer.append(" SUBSTR ");
            stringBuffer.append("'" + string + "'");
        }
        if ((string = this.getSyntaxString()) != null) {
            stringBuffer.append(" SYNTAX ");
            stringBuffer.append(string);
        }
        if (this.isSingleValued()) {
            stringBuffer.append(" SINGLE-VALUE");
        }
        if (this.isCollective()) {
            stringBuffer.append(" COLLECTIVE");
        }
        if (!this.isUserModifiable()) {
            stringBuffer.append(" NO-USER-MODIFICATION");
        }
        if ((n = this.getUsage()) != 0) {
            switch (n) {
                case 1: {
                    stringBuffer.append(" USAGE directoryOperation");
                    break;
                }
                case 2: {
                    stringBuffer.append(" USAGE distributedOperation");
                    break;
                }
                case 3: {
                    stringBuffer.append(" USAGE dSAOperation");
                    break;
                }
            }
        }
        Enumeration enumeration = this.getQualifierNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string == null) continue;
            stringBuffer.append(" " + string);
            stringArray = this.getQualifier(string);
            if (stringArray == null) continue;
            if (stringArray.length > 1) {
                stringBuffer.append("(");
            }
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(" '" + stringArray[i] + "'");
            }
            if (stringArray.length <= 1) continue;
            stringBuffer.append(" )");
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    protected void setDeserializedValues(BufferedInputStream bufferedInputStream) throws IOException {
        LDAPAttributeSchema lDAPAttributeSchema = (LDAPAttributeSchema)LDAPAttributeSchema.readDSML(bufferedInputStream);
        this.oid = lDAPAttributeSchema.getID();
        this.names = lDAPAttributeSchema.getNames();
        this.description = lDAPAttributeSchema.getDescription();
        this.obsolete = lDAPAttributeSchema.isObsolete();
        Enumeration enumeration = lDAPAttributeSchema.getQualifierNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = lDAPAttributeSchema.getQualifier(string);
            this.setQualifier(string, stringArray);
        }
        this.collective = lDAPAttributeSchema.isCollective();
        this.equality = lDAPAttributeSchema.getEqualityMatchingRule();
        this.ordering = lDAPAttributeSchema.getOrderingMatchingRule();
        this.single = lDAPAttributeSchema.isSingleValued();
        this.substring = lDAPAttributeSchema.getSubstringMatchingRule();
        this.superior = lDAPAttributeSchema.getSuperior();
        this.syntaxString = lDAPAttributeSchema.getSyntaxString();
        this.usage = lDAPAttributeSchema.getUsage();
        this.userMod = lDAPAttributeSchema.isUserModifiable();
        super.setValue(this.formatString());
        lDAPAttributeSchema = null;
    }

    protected void writeValue(Writer writer) throws IOException {
        String string = this.formatString();
        writer.write(ValueXMLhandler.newLine(2));
        writer.write("<value>");
        writer.write(string);
        writer.write("</value>");
    }

    protected void writeValue(StringBuffer stringBuffer) {
        String string = this.formatString();
        stringBuffer.append(ValueXMLhandler.newLine(2));
        stringBuffer.append("<value>");
        stringBuffer.append(string);
        stringBuffer.append("</value>");
    }

    public static Object readDSML(InputStream inputStream) throws IOException {
        SAXEventMultiplexer sAXEventMultiplexer = new SAXEventMultiplexer();
        sAXEventMultiplexer.setLDAPXMLHandler(LDAPAttributeSchema.getTopXMLHandler("LDAPAttribute", null));
        return (LDAPAttributeSchema)sAXEventMultiplexer.parseXML(inputStream);
    }

    private static LDAPXMLHandler getTopXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPAttributeSchema.getXMLHandler("attr", this));
            }

            protected void endElement() {
                this.setObject((LDAPAttributeSchema)this.valuelist.get(0));
            }

            protected void addValue(String string, Object object) {
                if (string.equals("attr")) {
                    this.valuelist.add(object);
                }
            }
        };
    }

    static LDAPXMLHandler getXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            String attrName;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler(this));
            }

            protected void endElement() {
                Iterator iterator = this.valuelist.iterator();
                LDAPAttributeSchema lDAPAttributeSchema = new LDAPAttributeSchema(this.attrName);
                byte[] byArray = (byte[])iterator.next();
                StringBuffer stringBuffer = new StringBuffer(byArray.length);
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append((char)byArray[i]);
                }
                try {
                    SchemaParser schemaParser = new SchemaParser(stringBuffer.toString());
                    if (schemaParser.getNames() != null) {
                        lDAPAttributeSchema.names = schemaParser.getNames();
                    }
                    if (schemaParser.getID() != null) {
                        lDAPAttributeSchema.oid = schemaParser.getID();
                    }
                    if (schemaParser.getDescription() != null) {
                        lDAPAttributeSchema.description = schemaParser.getDescription();
                    }
                    if (schemaParser.getSyntax() != null) {
                        lDAPAttributeSchema.syntaxString = schemaParser.getSyntax();
                    }
                    if (schemaParser.getSuperior() != null) {
                        lDAPAttributeSchema.syntaxString = schemaParser.getSuperior();
                    }
                    lDAPAttributeSchema.single = schemaParser.getSingle();
                    lDAPAttributeSchema.obsolete = schemaParser.getObsolete();
                    Enumeration enumeration = schemaParser.getQualifiers();
                    while (enumeration.hasMoreElements()) {
                        AttributeQualifier attributeQualifier = (AttributeQualifier)enumeration.nextElement();
                        lDAPAttributeSchema.setQualifier(attributeQualifier.getName(), attributeQualifier.getValues());
                    }
                    if (schemaParser.getEquality() != null) {
                        lDAPAttributeSchema.equality = schemaParser.getEquality();
                    }
                    if (schemaParser.getOrdering() != null) {
                        lDAPAttributeSchema.ordering = schemaParser.getOrdering();
                    }
                    if (schemaParser.getSubstring() != null) {
                        lDAPAttributeSchema.substring = schemaParser.getSubstring();
                    }
                    lDAPAttributeSchema.setValue(lDAPAttributeSchema.formatString());
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.toString());
                }
                this.setObject(lDAPAttributeSchema);
                this.valuelist.clear();
            }

            protected void addValue(String string, Object object) {
                if (string.equals("value")) {
                    this.valuelist.add(object);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.attrName = attributes.getValue("name");
                if (this.attrName == null) {
                    throw new SAXException("invalid attr Tag, name is mandatory element: ");
                }
            }
        };
    }
}

