/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.impl.jmx.connection.support.providers;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.mc4j.ems.impl.jmx.connection.support.providers.AbstractConnectionProvider;
import org.mc4j.ems.impl.jmx.connection.support.providers.proxy.JMXRemotingMBeanServerProxy;

public class PramatiConnectionProvider
extends AbstractConnectionProvider {
    private JMXConnector jmxConnector;
    private MBeanServerConnection serverConnection;
    private MBeanServer mbeanServer;
    private static final String PROTOCOL_PROVIDER_PACKAGE = "jmx.remote.protocol.provider.pkgs";
    private static final String PRAMATI_PROTOCOL_PROVIDER_PACKAGE = "com.pramati.jmx.connector";

    protected void doConnect() throws Exception {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        JMXServiceURL url = new JMXServiceURL(this.connectionSettings.getServerUrl());
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("java.naming.security.principal", this.connectionSettings.getPrincipal());
        env.put("java.naming.security.credentials", this.connectionSettings.getCredentials());
        if (this.connectionSettings.getAdvancedProperties() != null) {
            Iterator<Map.Entry<Object, Object>> i$ = this.connectionSettings.getAdvancedProperties().entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry<Object, Object> entry = i$.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                env.put(key, value);
            }
        }
        env.put(PROTOCOL_PROVIDER_PACKAGE, PRAMATI_PROTOCOL_PROVIDER_PACKAGE);
        String[] credentials = new String[]{this.connectionSettings.getPrincipal(), this.connectionSettings.getCredentials()};
        env.put("jmx.remote.credentials", credentials);
        this.jmxConnector = JMXConnectorFactory.connect(url, env);
        this.serverConnection = this.jmxConnector.getMBeanServerConnection();
        JMXRemotingMBeanServerProxy proxy = new JMXRemotingMBeanServerProxy(this.serverConnection);
        this.setStatsProxy(proxy);
        this.mbeanServer = proxy.buildServerProxy();
        super.connect();
    }

    public void doDisconnect() {
        try {
            this.jmxConnector.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }
}

