/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.store;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mc4j.ems.store.Value;
import org.mc4j.ems.store.ValueHistory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteValueHistory
implements ValueHistory {
    protected List<Value> values = new LinkedList<Value>();
    protected int historySize;

    public CompleteValueHistory() {
        this(-1);
    }

    public CompleteValueHistory(int historySize) {
        this.historySize = historySize;
    }

    @Override
    public int getHistorySize() {
        return this.values.size();
    }

    public void setMaximumHistorySize(int historySize) {
        this.historySize = historySize;
    }

    @Override
    public List<Value> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    @Override
    public void addValue(Value value) {
        this.values.add(value);
        if (this.historySize > 0 && this.historySize < this.values.size()) {
            this.values.remove(0);
        }
    }
}

