/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.concatenation.validation;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import me.desair.tus.server.HttpMethod;
import me.desair.tus.server.RequestValidator;
import me.desair.tus.server.exception.TusException;
import me.desair.tus.server.exception.UploadLengthNotAllowedOnConcatenationException;
import me.desair.tus.server.upload.UploadStorageService;
import org.apache.commons.lang3.StringUtils;

public class NoUploadLengthOnFinalValidator
implements RequestValidator {
    @Override
    public void validate(HttpMethod method, HttpServletRequest request, UploadStorageService uploadStorageService, String ownerKey) throws IOException, TusException {
        String uploadConcatValue = request.getHeader("Upload-Concat");
        if (StringUtils.startsWithIgnoreCase((CharSequence)uploadConcatValue, (CharSequence)"final") && StringUtils.isNotBlank((CharSequence)request.getHeader("Upload-Length"))) {
            throw new UploadLengthNotAllowedOnConcatenationException("The upload length of a concatenated upload cannot be set");
        }
    }

    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.POST.equals((Object)method);
    }
}

