/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.concatenation.validation;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import me.desair.tus.server.HttpMethod;
import me.desair.tus.server.RequestValidator;
import me.desair.tus.server.exception.InvalidPartialUploadIdException;
import me.desair.tus.server.exception.TusException;
import me.desair.tus.server.upload.UploadInfo;
import me.desair.tus.server.upload.UploadStorageService;
import me.desair.tus.server.util.Utils;
import org.apache.commons.lang3.StringUtils;

public class PartialUploadsExistValidator
implements RequestValidator {
    @Override
    public void validate(HttpMethod method, HttpServletRequest request, UploadStorageService uploadStorageService, String ownerKey) throws IOException, TusException {
        String uploadConcatValue = request.getHeader("Upload-Concat");
        if (StringUtils.startsWithIgnoreCase((CharSequence)uploadConcatValue, (CharSequence)"final")) {
            for (String uploadUri : Utils.parseConcatenationIDsFromHeader(uploadConcatValue)) {
                UploadInfo uploadInfo = uploadStorageService.getUploadInfo(uploadUri, ownerKey);
                if (uploadInfo != null) continue;
                throw new InvalidPartialUploadIdException("The URI " + uploadUri + " in Upload-Concat header does not match an existing upload");
            }
        }
    }

    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.POST.equals((Object)method);
    }
}

