/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public enum Theme {
    ASCII("|  ", "+--", "'--", ".--", "---", " [OK] ", " [XX] ", " [??] ", "[*] "),
    UNICODE("\u2502  ", "\u251c\u2500 ", "\u2514\u2500 ", "\u252c\u2500 ", "\u2500\u2500 ", "\u2714 ", "\u2718 ", "\u21b7 ", "\u25cf ");

    private final String[] tiles;

    public static Theme valueOf(Charset charset) {
        if (StandardCharsets.UTF_8.equals(charset)) {
            return UNICODE;
        }
        return ASCII;
    }

    private Theme(String ... tiles) {
        this.tiles = tiles;
    }

    public final String blank() {
        return "   ";
    }

    public final String pipe() {
        return this.tiles[0];
    }

    public final String entry() {
        return this.tiles[1];
    }

    public final String end() {
        return this.tiles[2];
    }

    public final String down() {
        return this.tiles[3];
    }

    public final String dash() {
        return this.tiles[4];
    }

    public final String successful() {
        return this.tiles[5];
    }

    public final String failed() {
        return this.tiles[6];
    }

    public final String skipped() {
        return this.tiles[7];
    }

    public final String details() {
        return this.tiles[8];
    }

    public final String toString() {
        return this.name().toLowerCase();
    }
}

