/*
 * Decompiled with CFR 0.152.
 */
package me.saket.bytesize.internal;

import dev.erikchristensen.javamath2kmp.MathKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.PublishedApi;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.saket.bytesize.BitPrecision;
import me.saket.bytesize.BytePrecision;
import me.saket.bytesize.ByteSize;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u001a\u0015\u0010\u0006\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0081\b\u001a\u0015\u0010\u0006\u001a\u00020\u0001*\u00020\n2\u0006\u0010\b\u001a\u00020\tH\u0081\b\u001a\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0081\b\u001a\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\n2\u0006\u0010\b\u001a\u00020\tH\u0081\b\u001a\u0015\u0010\f\u001a\u00020\r*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0081\b\u001a\u0015\u0010\f\u001a\u00020\r*\u00020\n2\u0006\u0010\b\u001a\u00020\tH\u0081\b\u001a\u0015\u0010\f\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\b\u001a\u00020\u000eH\u0081\b\u001a\u0015\u0010\f\u001a\u00020\u0001*\u00020\n2\u0006\u0010\b\u001a\u00020\u000eH\u0081\b\u001a\u0015\u0010\u000f\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\b\u001a\u00020\u000eH\u0081\b\u001a\u0015\u0010\u000f\u001a\u00020\u0001*\u00020\n2\u0006\u0010\b\u001a\u00020\u000eH\u0081\b\u001a\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0081\b\u001a\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\n2\u0006\u0010\b\u001a\u00020\tH\u0081\b\u001a\r\u0010\u0012\u001a\u00020\u0001*\u00020\tH\u0081\b\u001a\u0014\u0010\u0013\u001a\u00020\r*\u00020\u00012\u0006\u0010\b\u001a\u00020\rH\u0001\u001a\f\u0010\u0014\u001a\u00020\u0001*\u00020\rH\u0001\u001a\f\u0010\u0015\u001a\u00020\u0016*\u00020\u000eH\u0001\"\u001b\u0010\u0000\u001a\u00020\u00018\u00c0\u0002X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0017"}, d2={"BitsPerByte", "", "getBitsPerByte$annotations", "()V", "getBitsPerByte", "()J", "commonPlus", "Lme/saket/bytesize/BytePrecision;", "other", "Lme/saket/bytesize/ByteSize;", "Lme/saket/bytesize/BitPrecision;", "commonMinus", "commonDiv", "", "", "commonTimes", "commonCompareTo", "", "inWholeBits", "timesExact", "toLongOrThrow", "hasFractionalPart", "", "library"})
@SourceDebugExtension(value={"SMAP\nmaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 maths.kt\nme/saket/bytesize/internal/MathsKt\n*L\n1#1,131:1\n97#1,3:132\n15#1:135\n97#1,3:136\n15#1:139\n97#1,3:140\n15#1:143\n97#1,3:144\n15#1:147\n15#1:148\n*S KotlinDebug\n*F\n+ 1 maths.kt\nme/saket/bytesize/internal/MathsKt\n*L\n24#1:132,3\n24#1:135\n34#1:136,3\n34#1:139\n44#1:140,3\n44#1:143\n92#1:144,3\n92#1:147\n99#1:148\n*E\n"})
public final class MathsKt {
    public static final long getBitsPerByte() {
        boolean $i$f$getBitsPerByte = false;
        return 8L;
    }

    @PublishedApi
    public static /* synthetic */ void getBitsPerByte$annotations() {
    }

    @PublishedApi
    public static final long commonPlus(@NotNull BytePrecision $this$commonPlus, @NotNull ByteSize other) {
        Intrinsics.checkNotNullParameter((Object)$this$commonPlus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$commonPlus = false;
        return MathKt.plusExact((long)$this$commonPlus.getInWholeBytes(), (long)other.inWholeBytes());
    }

    @PublishedApi
    public static final long commonPlus(@NotNull BitPrecision $this$commonPlus, @NotNull ByteSize other) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$commonPlus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$commonPlus = false;
        long l2 = $this$commonPlus.getInWholeBits();
        ByteSize $this$inWholeBits$iv = other;
        boolean $i$f$inWholeBits = false;
        ByteSize byteSize = $this$inWholeBits$iv;
        if (byteSize instanceof BitPrecision) {
            l = ((BitPrecision)((Object)$this$inWholeBits$iv)).getInWholeBits();
        } else if (byteSize instanceof BytePrecision) {
            boolean $i$f$getBitsPerByte = false;
            l = ((BytePrecision)((Object)$this$inWholeBits$iv)).getInWholeBytes() * 8L;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return MathKt.plusExact((long)l2, (long)l);
    }

    @PublishedApi
    public static final long commonMinus(@NotNull BytePrecision $this$commonMinus, @NotNull ByteSize other) {
        Intrinsics.checkNotNullParameter((Object)$this$commonMinus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$commonMinus = false;
        return MathKt.minusExact((long)$this$commonMinus.getInWholeBytes(), (long)other.inWholeBytes());
    }

    @PublishedApi
    public static final long commonMinus(@NotNull BitPrecision $this$commonMinus, @NotNull ByteSize other) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$commonMinus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$commonMinus = false;
        long l2 = $this$commonMinus.getInWholeBits();
        ByteSize $this$inWholeBits$iv = other;
        boolean $i$f$inWholeBits = false;
        ByteSize byteSize = $this$inWholeBits$iv;
        if (byteSize instanceof BitPrecision) {
            l = ((BitPrecision)((Object)$this$inWholeBits$iv)).getInWholeBits();
        } else if (byteSize instanceof BytePrecision) {
            boolean $i$f$getBitsPerByte = false;
            l = ((BytePrecision)((Object)$this$inWholeBits$iv)).getInWholeBytes() * 8L;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return MathKt.minusExact((long)l2, (long)l);
    }

    @PublishedApi
    public static final double commonDiv(@NotNull BytePrecision $this$commonDiv, @NotNull ByteSize other) {
        Intrinsics.checkNotNullParameter((Object)$this$commonDiv, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$commonDiv = false;
        return (double)$this$commonDiv.getInWholeBytes() / (double)other.inWholeBytes();
    }

    @PublishedApi
    public static final double commonDiv(@NotNull BitPrecision $this$commonDiv, @NotNull ByteSize other) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$commonDiv, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$commonDiv = false;
        double d = $this$commonDiv.getInWholeBits();
        ByteSize $this$inWholeBits$iv = other;
        boolean $i$f$inWholeBits = false;
        ByteSize byteSize = $this$inWholeBits$iv;
        if (byteSize instanceof BitPrecision) {
            l = ((BitPrecision)((Object)$this$inWholeBits$iv)).getInWholeBits();
        } else if (byteSize instanceof BytePrecision) {
            boolean $i$f$getBitsPerByte = false;
            l = ((BytePrecision)((Object)$this$inWholeBits$iv)).getInWholeBytes() * 8L;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return d / (double)l;
    }

    @PublishedApi
    public static final long commonDiv(@NotNull BytePrecision $this$commonDiv, @NotNull Number other) {
        Intrinsics.checkNotNullParameter((Object)$this$commonDiv, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$commonDiv = false;
        return MathsKt.hasFractionalPart(other) ? kotlin.math.MathKt.roundToLong((double)((double)$this$commonDiv.getInWholeBytes() / other.doubleValue())) : $this$commonDiv.getInWholeBytes() / other.longValue();
    }

    @PublishedApi
    public static final long commonDiv(@NotNull BitPrecision $this$commonDiv, @NotNull Number other) {
        Intrinsics.checkNotNullParameter((Object)$this$commonDiv, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$commonDiv = false;
        return MathsKt.hasFractionalPart(other) ? kotlin.math.MathKt.roundToLong((double)((double)$this$commonDiv.getInWholeBits() / other.doubleValue())) : $this$commonDiv.getInWholeBits() / other.longValue();
    }

    @PublishedApi
    public static final long commonTimes(@NotNull BytePrecision $this$commonTimes, @NotNull Number other) {
        Intrinsics.checkNotNullParameter((Object)$this$commonTimes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$commonTimes = false;
        return MathsKt.hasFractionalPart(other) ? MathsKt.toLongOrThrow(MathsKt.timesExact($this$commonTimes.getInWholeBytes(), other.doubleValue())) : MathKt.timesExact((long)$this$commonTimes.getInWholeBytes(), (long)other.longValue());
    }

    @PublishedApi
    public static final long commonTimes(@NotNull BitPrecision $this$commonTimes, @NotNull Number other) {
        Intrinsics.checkNotNullParameter((Object)$this$commonTimes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$commonTimes = false;
        return MathsKt.hasFractionalPart(other) ? MathsKt.toLongOrThrow(MathsKt.timesExact($this$commonTimes.getInWholeBits(), other.doubleValue())) : MathKt.timesExact((long)$this$commonTimes.getInWholeBits(), (long)other.longValue());
    }

    @PublishedApi
    public static final int commonCompareTo(@NotNull BytePrecision $this$commonCompareTo, @NotNull ByteSize other) {
        Intrinsics.checkNotNullParameter((Object)$this$commonCompareTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$commonCompareTo = false;
        return Intrinsics.compare((long)$this$commonCompareTo.getInWholeBytes(), (long)other.inWholeBytes());
    }

    @PublishedApi
    public static final int commonCompareTo(@NotNull BitPrecision $this$commonCompareTo, @NotNull ByteSize other) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$commonCompareTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$commonCompareTo = false;
        long l2 = $this$commonCompareTo.getInWholeBits();
        ByteSize $this$inWholeBits$iv = other;
        boolean $i$f$inWholeBits = false;
        ByteSize byteSize = $this$inWholeBits$iv;
        if (byteSize instanceof BitPrecision) {
            l = ((BitPrecision)((Object)$this$inWholeBits$iv)).getInWholeBits();
        } else if (byteSize instanceof BytePrecision) {
            boolean $i$f$getBitsPerByte = false;
            l = ((BytePrecision)((Object)$this$inWholeBits$iv)).getInWholeBytes() * 8L;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Intrinsics.compare((long)l2, (long)l);
    }

    @PublishedApi
    public static final long inWholeBits(@NotNull ByteSize $this$inWholeBits) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$inWholeBits, (String)"<this>");
        boolean $i$f$inWholeBits = false;
        ByteSize byteSize = $this$inWholeBits;
        if (byteSize instanceof BitPrecision) {
            l = ((BitPrecision)((Object)$this$inWholeBits)).getInWholeBits();
        } else if (byteSize instanceof BytePrecision) {
            boolean $i$f$getBitsPerByte = false;
            l = ((BytePrecision)((Object)$this$inWholeBits)).getInWholeBytes() * 8L;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return l;
    }

    @PublishedApi
    public static final double timesExact(long $this$timesExact, double other) {
        double d;
        double it = d = (double)$this$timesExact * other;
        boolean bl = false;
        if (Double.isInfinite(it)) {
            throw new ArithmeticException("Multiplication resulted in overflow");
        }
        return d;
    }

    @PublishedApi
    public static final long toLongOrThrow(double $this$toLongOrThrow) {
        if (Double.isNaN($this$toLongOrThrow) || Double.isInfinite($this$toLongOrThrow)) {
            throw new ArithmeticException("Cannot convert " + $this$toLongOrThrow + " to Long");
        }
        if ($this$toLongOrThrow < -9.223372036854776E18 || $this$toLongOrThrow > 9.223372036854776E18) {
            throw new ArithmeticException("Double value overflow: exceeds Long range: " + $this$toLongOrThrow);
        }
        return (long)$this$toLongOrThrow;
    }

    @PublishedApi
    public static final boolean hasFractionalPart(@NotNull Number $this$hasFractionalPart) {
        Intrinsics.checkNotNullParameter((Object)$this$hasFractionalPart, (String)"<this>");
        Number number = $this$hasFractionalPart;
        return number instanceof Double ? !($this$hasFractionalPart.doubleValue() == Math.floor($this$hasFractionalPart.doubleValue())) : (number instanceof Float ? !($this$hasFractionalPart.floatValue() == (float)Math.floor($this$hasFractionalPart.floatValue())) : false);
    }
}

