/*
  Copyright (c) 2015, 2017, Oracle and/or its affiliates. All rights reserved.

  The MySQL Connector/J is licensed under the terms of the GPLv2
  <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>, like most MySQL Connectors.
  There are special exceptions to the terms and conditions of the GPLv2 as it is applied to
  this software, see the FOSS License Exception
  <http://www.mysql.com/about/legal/licensing/foss-exception.html>.

  This program is free software; you can redistribute it and/or modify it under the terms
  of the GNU General Public License as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with this
  program; if not, write to the Free Software Foundation, Inc., 51 Franklin St, Fifth
  Floor, Boston, MA 02110-1301  USA

 */

package com.mysql.cj.x.protobuf;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: mysqlx_crud.proto

public final class MysqlxCrud {
  private MysqlxCrud() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
  }
  /**
   * Protobuf enum {@code Mysqlx.Crud.DataModel}
   *
   * <pre>
   * DataModel to use for filters, names, ...
   * </pre>
   */
  public enum DataModel
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>DOCUMENT = 1;</code>
     */
    DOCUMENT(0, 1),
    /**
     * <code>TABLE = 2;</code>
     */
    TABLE(1, 2),
    ;

    /**
     * <code>DOCUMENT = 1;</code>
     */
    public static final int DOCUMENT_VALUE = 1;
    /**
     * <code>TABLE = 2;</code>
     */
    public static final int TABLE_VALUE = 2;


    public final int getNumber() { return value; }

    public static DataModel valueOf(int value) {
      switch (value) {
        case 1: return DOCUMENT;
        case 2: return TABLE;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DataModel>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<DataModel>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<DataModel>() {
            public DataModel findValueByNumber(int number) {
              return DataModel.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.getDescriptor().getEnumTypes().get(0);
    }

    private static final DataModel[] VALUES = values();

    public static DataModel valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private DataModel(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:Mysqlx.Crud.DataModel)
  }

  /**
   * Protobuf enum {@code Mysqlx.Crud.ViewAlgorithm}
   *
   * <pre>
   * ViewAlgorithm defines how MySQL Server processes the view
   * </pre>
   */
  public enum ViewAlgorithm
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>UNDEFINED = 1;</code>
     *
     * <pre>
     * MySQL chooses which algorithm to use
     * </pre>
     */
    UNDEFINED(0, 1),
    /**
     * <code>MERGE = 2;</code>
     *
     * <pre>
     * the text of a statement that refers to the view and the view definition are merged
     * </pre>
     */
    MERGE(1, 2),
    /**
     * <code>TEMPTABLE = 3;</code>
     *
     * <pre>
     * the view are retrieved into a temporary table
     * </pre>
     */
    TEMPTABLE(2, 3),
    ;

    /**
     * <code>UNDEFINED = 1;</code>
     *
     * <pre>
     * MySQL chooses which algorithm to use
     * </pre>
     */
    public static final int UNDEFINED_VALUE = 1;
    /**
     * <code>MERGE = 2;</code>
     *
     * <pre>
     * the text of a statement that refers to the view and the view definition are merged
     * </pre>
     */
    public static final int MERGE_VALUE = 2;
    /**
     * <code>TEMPTABLE = 3;</code>
     *
     * <pre>
     * the view are retrieved into a temporary table
     * </pre>
     */
    public static final int TEMPTABLE_VALUE = 3;


    public final int getNumber() { return value; }

    public static ViewAlgorithm valueOf(int value) {
      switch (value) {
        case 1: return UNDEFINED;
        case 2: return MERGE;
        case 3: return TEMPTABLE;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ViewAlgorithm>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<ViewAlgorithm>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ViewAlgorithm>() {
            public ViewAlgorithm findValueByNumber(int number) {
              return ViewAlgorithm.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.getDescriptor().getEnumTypes().get(1);
    }

    private static final ViewAlgorithm[] VALUES = values();

    public static ViewAlgorithm valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private ViewAlgorithm(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:Mysqlx.Crud.ViewAlgorithm)
  }

  /**
   * Protobuf enum {@code Mysqlx.Crud.ViewSqlSecurity}
   *
   * <pre>
   * ViewSqlSecurity defines the security context in which the view is going to be
   * executed, this means that VIEW can be executed with current user permissions or
   * with permissions of the uses who defined the VIEW
   * </pre>
   */
  public enum ViewSqlSecurity
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>INVOKER = 1;</code>
     */
    INVOKER(0, 1),
    /**
     * <code>DEFINER = 2;</code>
     */
    DEFINER(1, 2),
    ;

    /**
     * <code>INVOKER = 1;</code>
     */
    public static final int INVOKER_VALUE = 1;
    /**
     * <code>DEFINER = 2;</code>
     */
    public static final int DEFINER_VALUE = 2;


    public final int getNumber() { return value; }

    public static ViewSqlSecurity valueOf(int value) {
      switch (value) {
        case 1: return INVOKER;
        case 2: return DEFINER;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ViewSqlSecurity>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<ViewSqlSecurity>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ViewSqlSecurity>() {
            public ViewSqlSecurity findValueByNumber(int number) {
              return ViewSqlSecurity.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.getDescriptor().getEnumTypes().get(2);
    }

    private static final ViewSqlSecurity[] VALUES = values();

    public static ViewSqlSecurity valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private ViewSqlSecurity(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:Mysqlx.Crud.ViewSqlSecurity)
  }

  /**
   * Protobuf enum {@code Mysqlx.Crud.ViewCheckOption}
   *
   * <pre>
   * ViewCheckOption limits the write operations done on a `VIEW`
   * (`INSERT`, `UPDATE`, `DELETE`) to rows in which the `WHERE` clause is `TRUE`
   * </pre>
   */
  public enum ViewCheckOption
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>LOCAL = 1;</code>
     *
     * <pre>
     * the view WHERE clause is checked, but no underlying views are checked
     * </pre>
     */
    LOCAL(0, 1),
    /**
     * <code>CASCADED = 2;</code>
     *
     * <pre>
     * the view WHERE clause is checked, then checking recurses to underlying views
     * </pre>
     */
    CASCADED(1, 2),
    ;

    /**
     * <code>LOCAL = 1;</code>
     *
     * <pre>
     * the view WHERE clause is checked, but no underlying views are checked
     * </pre>
     */
    public static final int LOCAL_VALUE = 1;
    /**
     * <code>CASCADED = 2;</code>
     *
     * <pre>
     * the view WHERE clause is checked, then checking recurses to underlying views
     * </pre>
     */
    public static final int CASCADED_VALUE = 2;


    public final int getNumber() { return value; }

    public static ViewCheckOption valueOf(int value) {
      switch (value) {
        case 1: return LOCAL;
        case 2: return CASCADED;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ViewCheckOption>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<ViewCheckOption>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ViewCheckOption>() {
            public ViewCheckOption findValueByNumber(int number) {
              return ViewCheckOption.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.getDescriptor().getEnumTypes().get(3);
    }

    private static final ViewCheckOption[] VALUES = values();

    public static ViewCheckOption valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private ViewCheckOption(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:Mysqlx.Crud.ViewCheckOption)
  }

  public interface ColumnOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Crud.Column)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional string name = 1;</code>
     */
    boolean hasName();
    /**
     * <code>optional string name = 1;</code>
     */
    java.lang.String getName();
    /**
     * <code>optional string name = 1;</code>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <code>optional string alias = 2;</code>
     */
    boolean hasAlias();
    /**
     * <code>optional string alias = 2;</code>
     */
    java.lang.String getAlias();
    /**
     * <code>optional string alias = 2;</code>
     */
    com.google.protobuf.ByteString
        getAliasBytes();

    /**
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem> 
        getDocumentPathList();
    /**
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem getDocumentPath(int index);
    /**
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
     */
    int getDocumentPathCount();
    /**
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder> 
        getDocumentPathOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder getDocumentPathOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code Mysqlx.Crud.Column}
   *
   * <pre>
   * column definition
   * </pre>
   */
  public static final class Column extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Crud.Column)
      ColumnOrBuilder {
    // Use Column.newBuilder() to construct.
    private Column(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Column(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Column defaultInstance;
    public static Column getDefaultInstance() {
      return defaultInstance;
    }

    public Column getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Column(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              name_ = bs;
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              alias_ = bs;
              break;
            }
            case 26: {
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                documentPath_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem>();
                mutable_bitField0_ |= 0x00000004;
              }
              documentPath_.add(input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
          documentPath_ = java.util.Collections.unmodifiableList(documentPath_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Column_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Column_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxCrud.Column.class, com.mysql.cj.x.protobuf.MysqlxCrud.Column.Builder.class);
    }

    public static com.google.protobuf.Parser<Column> PARSER =
        new com.google.protobuf.AbstractParser<Column>() {
      public Column parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Column(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Column> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private java.lang.Object name_;
    /**
     * <code>optional string name = 1;</code>
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional string name = 1;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string name = 1;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ALIAS_FIELD_NUMBER = 2;
    private java.lang.Object alias_;
    /**
     * <code>optional string alias = 2;</code>
     */
    public boolean hasAlias() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional string alias = 2;</code>
     */
    public java.lang.String getAlias() {
      java.lang.Object ref = alias_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          alias_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string alias = 2;</code>
     */
    public com.google.protobuf.ByteString
        getAliasBytes() {
      java.lang.Object ref = alias_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        alias_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DOCUMENT_PATH_FIELD_NUMBER = 3;
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem> documentPath_;
    /**
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
     */
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem> getDocumentPathList() {
      return documentPath_;
    }
    /**
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
     */
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder> 
        getDocumentPathOrBuilderList() {
      return documentPath_;
    }
    /**
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
     */
    public int getDocumentPathCount() {
      return documentPath_.size();
    }
    /**
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem getDocumentPath(int index) {
      return documentPath_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder getDocumentPathOrBuilder(
        int index) {
      return documentPath_.get(index);
    }

    private void initFields() {
      name_ = "";
      alias_ = "";
      documentPath_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getDocumentPathCount(); i++) {
        if (!getDocumentPath(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, getAliasBytes());
      }
      for (int i = 0; i < documentPath_.size(); i++) {
        output.writeMessage(3, documentPath_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, getAliasBytes());
      }
      for (int i = 0; i < documentPath_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, documentPath_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxCrud.Column parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Column parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Column parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Column parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Column parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Column parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Column parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Column parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Column parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Column parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxCrud.Column prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Crud.Column}
     *
     * <pre>
     * column definition
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Crud.Column)
        com.mysql.cj.x.protobuf.MysqlxCrud.ColumnOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Column_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Column_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxCrud.Column.class, com.mysql.cj.x.protobuf.MysqlxCrud.Column.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxCrud.Column.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getDocumentPathFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        name_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        alias_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        if (documentPathBuilder_ == null) {
          documentPath_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          documentPathBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Column_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Column getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.Column.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Column build() {
        com.mysql.cj.x.protobuf.MysqlxCrud.Column result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Column buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxCrud.Column result = new com.mysql.cj.x.protobuf.MysqlxCrud.Column(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.name_ = name_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.alias_ = alias_;
        if (documentPathBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)) {
            documentPath_ = java.util.Collections.unmodifiableList(documentPath_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.documentPath_ = documentPath_;
        } else {
          result.documentPath_ = documentPathBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxCrud.Column) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxCrud.Column)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxCrud.Column other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxCrud.Column.getDefaultInstance()) return this;
        if (other.hasName()) {
          bitField0_ |= 0x00000001;
          name_ = other.name_;
          onChanged();
        }
        if (other.hasAlias()) {
          bitField0_ |= 0x00000002;
          alias_ = other.alias_;
          onChanged();
        }
        if (documentPathBuilder_ == null) {
          if (!other.documentPath_.isEmpty()) {
            if (documentPath_.isEmpty()) {
              documentPath_ = other.documentPath_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureDocumentPathIsMutable();
              documentPath_.addAll(other.documentPath_);
            }
            onChanged();
          }
        } else {
          if (!other.documentPath_.isEmpty()) {
            if (documentPathBuilder_.isEmpty()) {
              documentPathBuilder_.dispose();
              documentPathBuilder_ = null;
              documentPath_ = other.documentPath_;
              bitField0_ = (bitField0_ & ~0x00000004);
              documentPathBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getDocumentPathFieldBuilder() : null;
            } else {
              documentPathBuilder_.addAllMessages(other.documentPath_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        for (int i = 0; i < getDocumentPathCount(); i++) {
          if (!getDocumentPath(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxCrud.Column parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxCrud.Column) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <code>optional string name = 1;</code>
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional string name = 1;</code>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            name_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string name = 1;</code>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string name = 1;</code>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string name = 1;</code>
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string name = 1;</code>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object alias_ = "";
      /**
       * <code>optional string alias = 2;</code>
       */
      public boolean hasAlias() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional string alias = 2;</code>
       */
      public java.lang.String getAlias() {
        java.lang.Object ref = alias_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            alias_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string alias = 2;</code>
       */
      public com.google.protobuf.ByteString
          getAliasBytes() {
        java.lang.Object ref = alias_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          alias_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string alias = 2;</code>
       */
      public Builder setAlias(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        alias_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string alias = 2;</code>
       */
      public Builder clearAlias() {
        bitField0_ = (bitField0_ & ~0x00000002);
        alias_ = getDefaultInstance().getAlias();
        onChanged();
        return this;
      }
      /**
       * <code>optional string alias = 2;</code>
       */
      public Builder setAliasBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        alias_ = value;
        onChanged();
        return this;
      }

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem> documentPath_ =
        java.util.Collections.emptyList();
      private void ensureDocumentPathIsMutable() {
        if (!((bitField0_ & 0x00000004) == 0x00000004)) {
          documentPath_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem>(documentPath_);
          bitField0_ |= 0x00000004;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder> documentPathBuilder_;

      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem> getDocumentPathList() {
        if (documentPathBuilder_ == null) {
          return java.util.Collections.unmodifiableList(documentPath_);
        } else {
          return documentPathBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
       */
      public int getDocumentPathCount() {
        if (documentPathBuilder_ == null) {
          return documentPath_.size();
        } else {
          return documentPathBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem getDocumentPath(int index) {
        if (documentPathBuilder_ == null) {
          return documentPath_.get(index);
        } else {
          return documentPathBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
       */
      public Builder setDocumentPath(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem value) {
        if (documentPathBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDocumentPathIsMutable();
          documentPath_.set(index, value);
          onChanged();
        } else {
          documentPathBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
       */
      public Builder setDocumentPath(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder builderForValue) {
        if (documentPathBuilder_ == null) {
          ensureDocumentPathIsMutable();
          documentPath_.set(index, builderForValue.build());
          onChanged();
        } else {
          documentPathBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
       */
      public Builder addDocumentPath(com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem value) {
        if (documentPathBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDocumentPathIsMutable();
          documentPath_.add(value);
          onChanged();
        } else {
          documentPathBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
       */
      public Builder addDocumentPath(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem value) {
        if (documentPathBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDocumentPathIsMutable();
          documentPath_.add(index, value);
          onChanged();
        } else {
          documentPathBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
       */
      public Builder addDocumentPath(
          com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder builderForValue) {
        if (documentPathBuilder_ == null) {
          ensureDocumentPathIsMutable();
          documentPath_.add(builderForValue.build());
          onChanged();
        } else {
          documentPathBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
       */
      public Builder addDocumentPath(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder builderForValue) {
        if (documentPathBuilder_ == null) {
          ensureDocumentPathIsMutable();
          documentPath_.add(index, builderForValue.build());
          onChanged();
        } else {
          documentPathBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
       */
      public Builder addAllDocumentPath(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem> values) {
        if (documentPathBuilder_ == null) {
          ensureDocumentPathIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, documentPath_);
          onChanged();
        } else {
          documentPathBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
       */
      public Builder clearDocumentPath() {
        if (documentPathBuilder_ == null) {
          documentPath_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          documentPathBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
       */
      public Builder removeDocumentPath(int index) {
        if (documentPathBuilder_ == null) {
          ensureDocumentPathIsMutable();
          documentPath_.remove(index);
          onChanged();
        } else {
          documentPathBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder getDocumentPathBuilder(
          int index) {
        return getDocumentPathFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder getDocumentPathOrBuilder(
          int index) {
        if (documentPathBuilder_ == null) {
          return documentPath_.get(index);  } else {
          return documentPathBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder> 
           getDocumentPathOrBuilderList() {
        if (documentPathBuilder_ != null) {
          return documentPathBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(documentPath_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder addDocumentPathBuilder() {
        return getDocumentPathFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder addDocumentPathBuilder(
          int index) {
        return getDocumentPathFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Expr.DocumentPathItem document_path = 3;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder> 
           getDocumentPathBuilderList() {
        return getDocumentPathFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder> 
          getDocumentPathFieldBuilder() {
        if (documentPathBuilder_ == null) {
          documentPathBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItem.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.DocumentPathItemOrBuilder>(
                  documentPath_,
                  ((bitField0_ & 0x00000004) == 0x00000004),
                  getParentForChildren(),
                  isClean());
          documentPath_ = null;
        }
        return documentPathBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Crud.Column)
    }

    static {
      defaultInstance = new Column(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Crud.Column)
  }

  public interface ProjectionOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Crud.Projection)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .Mysqlx.Expr.Expr source = 1;</code>
     */
    boolean hasSource();
    /**
     * <code>required .Mysqlx.Expr.Expr source = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Expr getSource();
    /**
     * <code>required .Mysqlx.Expr.Expr source = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getSourceOrBuilder();

    /**
     * <code>optional string alias = 2;</code>
     */
    boolean hasAlias();
    /**
     * <code>optional string alias = 2;</code>
     */
    java.lang.String getAlias();
    /**
     * <code>optional string alias = 2;</code>
     */
    com.google.protobuf.ByteString
        getAliasBytes();
  }
  /**
   * Protobuf type {@code Mysqlx.Crud.Projection}
   *
   * <pre>
   * a projection
   * :param source: the expression identifying an element from the source data
   *                which can include a column identifier or any expression
   * :param alias: optional alias. Required for DOCUMENTs (clients may use 
   *              the source string as default)
   * </pre>
   */
  public static final class Projection extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Crud.Projection)
      ProjectionOrBuilder {
    // Use Projection.newBuilder() to construct.
    private Projection(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Projection(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Projection defaultInstance;
    public static Projection getDefaultInstance() {
      return defaultInstance;
    }

    public Projection getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Projection(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = source_.toBuilder();
              }
              source_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpr.Expr.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(source_);
                source_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              alias_ = bs;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Projection_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Projection_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxCrud.Projection.class, com.mysql.cj.x.protobuf.MysqlxCrud.Projection.Builder.class);
    }

    public static com.google.protobuf.Parser<Projection> PARSER =
        new com.google.protobuf.AbstractParser<Projection>() {
      public Projection parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Projection(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Projection> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int SOURCE_FIELD_NUMBER = 1;
    private com.mysql.cj.x.protobuf.MysqlxExpr.Expr source_;
    /**
     * <code>required .Mysqlx.Expr.Expr source = 1;</code>
     */
    public boolean hasSource() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required .Mysqlx.Expr.Expr source = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getSource() {
      return source_;
    }
    /**
     * <code>required .Mysqlx.Expr.Expr source = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getSourceOrBuilder() {
      return source_;
    }

    public static final int ALIAS_FIELD_NUMBER = 2;
    private java.lang.Object alias_;
    /**
     * <code>optional string alias = 2;</code>
     */
    public boolean hasAlias() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional string alias = 2;</code>
     */
    public java.lang.String getAlias() {
      java.lang.Object ref = alias_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          alias_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string alias = 2;</code>
     */
    public com.google.protobuf.ByteString
        getAliasBytes() {
      java.lang.Object ref = alias_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        alias_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private void initFields() {
      source_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
      alias_ = "";
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasSource()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getSource().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, source_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, getAliasBytes());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, source_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, getAliasBytes());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxCrud.Projection parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Projection parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Projection parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Projection parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Projection parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Projection parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Projection parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Projection parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Projection parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Projection parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxCrud.Projection prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Crud.Projection}
     *
     * <pre>
     * a projection
     * :param source: the expression identifying an element from the source data
     *                which can include a column identifier or any expression
     * :param alias: optional alias. Required for DOCUMENTs (clients may use 
     *              the source string as default)
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Crud.Projection)
        com.mysql.cj.x.protobuf.MysqlxCrud.ProjectionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Projection_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Projection_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxCrud.Projection.class, com.mysql.cj.x.protobuf.MysqlxCrud.Projection.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxCrud.Projection.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getSourceFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (sourceBuilder_ == null) {
          source_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
        } else {
          sourceBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        alias_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Projection_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Projection getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.Projection.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Projection build() {
        com.mysql.cj.x.protobuf.MysqlxCrud.Projection result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Projection buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxCrud.Projection result = new com.mysql.cj.x.protobuf.MysqlxCrud.Projection(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (sourceBuilder_ == null) {
          result.source_ = source_;
        } else {
          result.source_ = sourceBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.alias_ = alias_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxCrud.Projection) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxCrud.Projection)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxCrud.Projection other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxCrud.Projection.getDefaultInstance()) return this;
        if (other.hasSource()) {
          mergeSource(other.getSource());
        }
        if (other.hasAlias()) {
          bitField0_ |= 0x00000002;
          alias_ = other.alias_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasSource()) {
          
          return false;
        }
        if (!getSource().isInitialized()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxCrud.Projection parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxCrud.Projection) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.mysql.cj.x.protobuf.MysqlxExpr.Expr source_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> sourceBuilder_;
      /**
       * <code>required .Mysqlx.Expr.Expr source = 1;</code>
       */
      public boolean hasSource() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required .Mysqlx.Expr.Expr source = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getSource() {
        if (sourceBuilder_ == null) {
          return source_;
        } else {
          return sourceBuilder_.getMessage();
        }
      }
      /**
       * <code>required .Mysqlx.Expr.Expr source = 1;</code>
       */
      public Builder setSource(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (sourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          source_ = value;
          onChanged();
        } else {
          sourceBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Expr.Expr source = 1;</code>
       */
      public Builder setSource(
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (sourceBuilder_ == null) {
          source_ = builderForValue.build();
          onChanged();
        } else {
          sourceBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Expr.Expr source = 1;</code>
       */
      public Builder mergeSource(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (sourceBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              source_ != com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance()) {
            source_ =
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr.newBuilder(source_).mergeFrom(value).buildPartial();
          } else {
            source_ = value;
          }
          onChanged();
        } else {
          sourceBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Expr.Expr source = 1;</code>
       */
      public Builder clearSource() {
        if (sourceBuilder_ == null) {
          source_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
          onChanged();
        } else {
          sourceBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>required .Mysqlx.Expr.Expr source = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder getSourceBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getSourceFieldBuilder().getBuilder();
      }
      /**
       * <code>required .Mysqlx.Expr.Expr source = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getSourceOrBuilder() {
        if (sourceBuilder_ != null) {
          return sourceBuilder_.getMessageOrBuilder();
        } else {
          return source_;
        }
      }
      /**
       * <code>required .Mysqlx.Expr.Expr source = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
          getSourceFieldBuilder() {
        if (sourceBuilder_ == null) {
          sourceBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder>(
                  getSource(),
                  getParentForChildren(),
                  isClean());
          source_ = null;
        }
        return sourceBuilder_;
      }

      private java.lang.Object alias_ = "";
      /**
       * <code>optional string alias = 2;</code>
       */
      public boolean hasAlias() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional string alias = 2;</code>
       */
      public java.lang.String getAlias() {
        java.lang.Object ref = alias_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            alias_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string alias = 2;</code>
       */
      public com.google.protobuf.ByteString
          getAliasBytes() {
        java.lang.Object ref = alias_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          alias_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string alias = 2;</code>
       */
      public Builder setAlias(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        alias_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string alias = 2;</code>
       */
      public Builder clearAlias() {
        bitField0_ = (bitField0_ & ~0x00000002);
        alias_ = getDefaultInstance().getAlias();
        onChanged();
        return this;
      }
      /**
       * <code>optional string alias = 2;</code>
       */
      public Builder setAliasBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        alias_ = value;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Crud.Projection)
    }

    static {
      defaultInstance = new Projection(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Crud.Projection)
  }

  public interface CollectionOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Crud.Collection)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required string name = 1;</code>
     */
    boolean hasName();
    /**
     * <code>required string name = 1;</code>
     */
    java.lang.String getName();
    /**
     * <code>required string name = 1;</code>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <code>optional string schema = 2;</code>
     */
    boolean hasSchema();
    /**
     * <code>optional string schema = 2;</code>
     */
    java.lang.String getSchema();
    /**
     * <code>optional string schema = 2;</code>
     */
    com.google.protobuf.ByteString
        getSchemaBytes();
  }
  /**
   * Protobuf type {@code Mysqlx.Crud.Collection}
   *
   * <pre>
   * collection
   * </pre>
   */
  public static final class Collection extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Crud.Collection)
      CollectionOrBuilder {
    // Use Collection.newBuilder() to construct.
    private Collection(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Collection(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Collection defaultInstance;
    public static Collection getDefaultInstance() {
      return defaultInstance;
    }

    public Collection getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Collection(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              name_ = bs;
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              schema_ = bs;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Collection_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Collection_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxCrud.Collection.class, com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder.class);
    }

    public static com.google.protobuf.Parser<Collection> PARSER =
        new com.google.protobuf.AbstractParser<Collection>() {
      public Collection parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Collection(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Collection> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private java.lang.Object name_;
    /**
     * <code>required string name = 1;</code>
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string name = 1;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string name = 1;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCHEMA_FIELD_NUMBER = 2;
    private java.lang.Object schema_;
    /**
     * <code>optional string schema = 2;</code>
     */
    public boolean hasSchema() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional string schema = 2;</code>
     */
    public java.lang.String getSchema() {
      java.lang.Object ref = schema_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          schema_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string schema = 2;</code>
     */
    public com.google.protobuf.ByteString
        getSchemaBytes() {
      java.lang.Object ref = schema_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        schema_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private void initFields() {
      name_ = "";
      schema_ = "";
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasName()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, getSchemaBytes());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, getSchemaBytes());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxCrud.Collection parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Collection parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Collection parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Collection parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Collection parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Collection parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Collection parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Collection parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Collection parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Collection parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxCrud.Collection prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Crud.Collection}
     *
     * <pre>
     * collection
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Crud.Collection)
        com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Collection_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Collection_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxCrud.Collection.class, com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxCrud.Collection.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        name_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        schema_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Collection_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Collection getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Collection build() {
        com.mysql.cj.x.protobuf.MysqlxCrud.Collection result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Collection buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxCrud.Collection result = new com.mysql.cj.x.protobuf.MysqlxCrud.Collection(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.name_ = name_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.schema_ = schema_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxCrud.Collection) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxCrud.Collection)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxCrud.Collection other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance()) return this;
        if (other.hasName()) {
          bitField0_ |= 0x00000001;
          name_ = other.name_;
          onChanged();
        }
        if (other.hasSchema()) {
          bitField0_ |= 0x00000002;
          schema_ = other.schema_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasName()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxCrud.Collection parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxCrud.Collection) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <code>required string name = 1;</code>
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string name = 1;</code>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            name_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object schema_ = "";
      /**
       * <code>optional string schema = 2;</code>
       */
      public boolean hasSchema() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional string schema = 2;</code>
       */
      public java.lang.String getSchema() {
        java.lang.Object ref = schema_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            schema_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string schema = 2;</code>
       */
      public com.google.protobuf.ByteString
          getSchemaBytes() {
        java.lang.Object ref = schema_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          schema_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string schema = 2;</code>
       */
      public Builder setSchema(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        schema_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema = 2;</code>
       */
      public Builder clearSchema() {
        bitField0_ = (bitField0_ & ~0x00000002);
        schema_ = getDefaultInstance().getSchema();
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema = 2;</code>
       */
      public Builder setSchemaBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        schema_ = value;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Crud.Collection)
    }

    static {
      defaultInstance = new Collection(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Crud.Collection)
  }

  public interface LimitOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Crud.Limit)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required uint64 row_count = 1;</code>
     */
    boolean hasRowCount();
    /**
     * <code>required uint64 row_count = 1;</code>
     */
    long getRowCount();

    /**
     * <code>optional uint64 offset = 2;</code>
     */
    boolean hasOffset();
    /**
     * <code>optional uint64 offset = 2;</code>
     */
    long getOffset();
  }
  /**
   * Protobuf type {@code Mysqlx.Crud.Limit}
   *
   * <pre>
   * limit
   * :param row_count: maximum rows to filter
   * :param offset: maximum rows to skip before applying the row_count
   * </pre>
   */
  public static final class Limit extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Crud.Limit)
      LimitOrBuilder {
    // Use Limit.newBuilder() to construct.
    private Limit(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Limit(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Limit defaultInstance;
    public static Limit getDefaultInstance() {
      return defaultInstance;
    }

    public Limit getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Limit(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              bitField0_ |= 0x00000001;
              rowCount_ = input.readUInt64();
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              offset_ = input.readUInt64();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Limit_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Limit_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxCrud.Limit.class, com.mysql.cj.x.protobuf.MysqlxCrud.Limit.Builder.class);
    }

    public static com.google.protobuf.Parser<Limit> PARSER =
        new com.google.protobuf.AbstractParser<Limit>() {
      public Limit parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Limit(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Limit> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int ROW_COUNT_FIELD_NUMBER = 1;
    private long rowCount_;
    /**
     * <code>required uint64 row_count = 1;</code>
     */
    public boolean hasRowCount() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required uint64 row_count = 1;</code>
     */
    public long getRowCount() {
      return rowCount_;
    }

    public static final int OFFSET_FIELD_NUMBER = 2;
    private long offset_;
    /**
     * <code>optional uint64 offset = 2;</code>
     */
    public boolean hasOffset() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional uint64 offset = 2;</code>
     */
    public long getOffset() {
      return offset_;
    }

    private void initFields() {
      rowCount_ = 0L;
      offset_ = 0L;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasRowCount()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeUInt64(1, rowCount_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt64(2, offset_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(1, rowCount_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(2, offset_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxCrud.Limit parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Limit parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Limit parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Limit parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Limit parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Limit parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Limit parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Limit parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Limit parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Limit parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxCrud.Limit prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Crud.Limit}
     *
     * <pre>
     * limit
     * :param row_count: maximum rows to filter
     * :param offset: maximum rows to skip before applying the row_count
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Crud.Limit)
        com.mysql.cj.x.protobuf.MysqlxCrud.LimitOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Limit_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Limit_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxCrud.Limit.class, com.mysql.cj.x.protobuf.MysqlxCrud.Limit.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxCrud.Limit.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        rowCount_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000001);
        offset_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Limit_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Limit getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.Limit.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Limit build() {
        com.mysql.cj.x.protobuf.MysqlxCrud.Limit result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Limit buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxCrud.Limit result = new com.mysql.cj.x.protobuf.MysqlxCrud.Limit(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.rowCount_ = rowCount_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.offset_ = offset_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxCrud.Limit) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxCrud.Limit)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxCrud.Limit other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxCrud.Limit.getDefaultInstance()) return this;
        if (other.hasRowCount()) {
          setRowCount(other.getRowCount());
        }
        if (other.hasOffset()) {
          setOffset(other.getOffset());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasRowCount()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxCrud.Limit parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxCrud.Limit) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private long rowCount_ ;
      /**
       * <code>required uint64 row_count = 1;</code>
       */
      public boolean hasRowCount() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required uint64 row_count = 1;</code>
       */
      public long getRowCount() {
        return rowCount_;
      }
      /**
       * <code>required uint64 row_count = 1;</code>
       */
      public Builder setRowCount(long value) {
        bitField0_ |= 0x00000001;
        rowCount_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint64 row_count = 1;</code>
       */
      public Builder clearRowCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        rowCount_ = 0L;
        onChanged();
        return this;
      }

      private long offset_ ;
      /**
       * <code>optional uint64 offset = 2;</code>
       */
      public boolean hasOffset() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional uint64 offset = 2;</code>
       */
      public long getOffset() {
        return offset_;
      }
      /**
       * <code>optional uint64 offset = 2;</code>
       */
      public Builder setOffset(long value) {
        bitField0_ |= 0x00000002;
        offset_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 offset = 2;</code>
       */
      public Builder clearOffset() {
        bitField0_ = (bitField0_ & ~0x00000002);
        offset_ = 0L;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Crud.Limit)
    }

    static {
      defaultInstance = new Limit(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Crud.Limit)
  }

  public interface OrderOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Crud.Order)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .Mysqlx.Expr.Expr expr = 1;</code>
     */
    boolean hasExpr();
    /**
     * <code>required .Mysqlx.Expr.Expr expr = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Expr getExpr();
    /**
     * <code>required .Mysqlx.Expr.Expr expr = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getExprOrBuilder();

    /**
     * <code>optional .Mysqlx.Crud.Order.Direction direction = 2 [default = ASC];</code>
     */
    boolean hasDirection();
    /**
     * <code>optional .Mysqlx.Crud.Order.Direction direction = 2 [default = ASC];</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.Order.Direction getDirection();
  }
  /**
   * Protobuf type {@code Mysqlx.Crud.Order}
   *
   * <pre>
   * sort order
   * </pre>
   */
  public static final class Order extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Crud.Order)
      OrderOrBuilder {
    // Use Order.newBuilder() to construct.
    private Order(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Order(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Order defaultInstance;
    public static Order getDefaultInstance() {
      return defaultInstance;
    }

    public Order getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Order(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = expr_.toBuilder();
              }
              expr_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpr.Expr.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(expr_);
                expr_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 16: {
              int rawValue = input.readEnum();
              com.mysql.cj.x.protobuf.MysqlxCrud.Order.Direction value = com.mysql.cj.x.protobuf.MysqlxCrud.Order.Direction.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(2, rawValue);
              } else {
                bitField0_ |= 0x00000002;
                direction_ = value;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Order_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Order_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxCrud.Order.class, com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder.class);
    }

    public static com.google.protobuf.Parser<Order> PARSER =
        new com.google.protobuf.AbstractParser<Order>() {
      public Order parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Order(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Order> getParserForType() {
      return PARSER;
    }

    /**
     * Protobuf enum {@code Mysqlx.Crud.Order.Direction}
     */
    public enum Direction
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>ASC = 1;</code>
       */
      ASC(0, 1),
      /**
       * <code>DESC = 2;</code>
       */
      DESC(1, 2),
      ;

      /**
       * <code>ASC = 1;</code>
       */
      public static final int ASC_VALUE = 1;
      /**
       * <code>DESC = 2;</code>
       */
      public static final int DESC_VALUE = 2;


      public final int getNumber() { return value; }

      public static Direction valueOf(int value) {
        switch (value) {
          case 1: return ASC;
          case 2: return DESC;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Direction>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static com.google.protobuf.Internal.EnumLiteMap<Direction>
          internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Direction>() {
              public Direction findValueByNumber(int number) {
                return Direction.valueOf(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(index);
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.Order.getDescriptor().getEnumTypes().get(0);
      }

      private static final Direction[] VALUES = values();

      public static Direction valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int index;
      private final int value;

      private Direction(int index, int value) {
        this.index = index;
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Crud.Order.Direction)
    }

    private int bitField0_;
    public static final int EXPR_FIELD_NUMBER = 1;
    private com.mysql.cj.x.protobuf.MysqlxExpr.Expr expr_;
    /**
     * <code>required .Mysqlx.Expr.Expr expr = 1;</code>
     */
    public boolean hasExpr() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required .Mysqlx.Expr.Expr expr = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getExpr() {
      return expr_;
    }
    /**
     * <code>required .Mysqlx.Expr.Expr expr = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getExprOrBuilder() {
      return expr_;
    }

    public static final int DIRECTION_FIELD_NUMBER = 2;
    private com.mysql.cj.x.protobuf.MysqlxCrud.Order.Direction direction_;
    /**
     * <code>optional .Mysqlx.Crud.Order.Direction direction = 2 [default = ASC];</code>
     */
    public boolean hasDirection() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .Mysqlx.Crud.Order.Direction direction = 2 [default = ASC];</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.Order.Direction getDirection() {
      return direction_;
    }

    private void initFields() {
      expr_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
      direction_ = com.mysql.cj.x.protobuf.MysqlxCrud.Order.Direction.ASC;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasExpr()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getExpr().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, expr_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeEnum(2, direction_.getNumber());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, expr_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, direction_.getNumber());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxCrud.Order parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Order parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Order parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Order parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Order parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Order parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Order parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Order parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Order parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Order parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxCrud.Order prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Crud.Order}
     *
     * <pre>
     * sort order
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Crud.Order)
        com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Order_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Order_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxCrud.Order.class, com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxCrud.Order.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getExprFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (exprBuilder_ == null) {
          expr_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
        } else {
          exprBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        direction_ = com.mysql.cj.x.protobuf.MysqlxCrud.Order.Direction.ASC;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Order_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Order getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.Order.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Order build() {
        com.mysql.cj.x.protobuf.MysqlxCrud.Order result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Order buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxCrud.Order result = new com.mysql.cj.x.protobuf.MysqlxCrud.Order(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (exprBuilder_ == null) {
          result.expr_ = expr_;
        } else {
          result.expr_ = exprBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.direction_ = direction_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxCrud.Order) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxCrud.Order)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxCrud.Order other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxCrud.Order.getDefaultInstance()) return this;
        if (other.hasExpr()) {
          mergeExpr(other.getExpr());
        }
        if (other.hasDirection()) {
          setDirection(other.getDirection());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasExpr()) {
          
          return false;
        }
        if (!getExpr().isInitialized()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxCrud.Order parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxCrud.Order) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.mysql.cj.x.protobuf.MysqlxExpr.Expr expr_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> exprBuilder_;
      /**
       * <code>required .Mysqlx.Expr.Expr expr = 1;</code>
       */
      public boolean hasExpr() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required .Mysqlx.Expr.Expr expr = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getExpr() {
        if (exprBuilder_ == null) {
          return expr_;
        } else {
          return exprBuilder_.getMessage();
        }
      }
      /**
       * <code>required .Mysqlx.Expr.Expr expr = 1;</code>
       */
      public Builder setExpr(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (exprBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          expr_ = value;
          onChanged();
        } else {
          exprBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Expr.Expr expr = 1;</code>
       */
      public Builder setExpr(
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (exprBuilder_ == null) {
          expr_ = builderForValue.build();
          onChanged();
        } else {
          exprBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Expr.Expr expr = 1;</code>
       */
      public Builder mergeExpr(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (exprBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              expr_ != com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance()) {
            expr_ =
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr.newBuilder(expr_).mergeFrom(value).buildPartial();
          } else {
            expr_ = value;
          }
          onChanged();
        } else {
          exprBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Expr.Expr expr = 1;</code>
       */
      public Builder clearExpr() {
        if (exprBuilder_ == null) {
          expr_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
          onChanged();
        } else {
          exprBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>required .Mysqlx.Expr.Expr expr = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder getExprBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getExprFieldBuilder().getBuilder();
      }
      /**
       * <code>required .Mysqlx.Expr.Expr expr = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getExprOrBuilder() {
        if (exprBuilder_ != null) {
          return exprBuilder_.getMessageOrBuilder();
        } else {
          return expr_;
        }
      }
      /**
       * <code>required .Mysqlx.Expr.Expr expr = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
          getExprFieldBuilder() {
        if (exprBuilder_ == null) {
          exprBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder>(
                  getExpr(),
                  getParentForChildren(),
                  isClean());
          expr_ = null;
        }
        return exprBuilder_;
      }

      private com.mysql.cj.x.protobuf.MysqlxCrud.Order.Direction direction_ = com.mysql.cj.x.protobuf.MysqlxCrud.Order.Direction.ASC;
      /**
       * <code>optional .Mysqlx.Crud.Order.Direction direction = 2 [default = ASC];</code>
       */
      public boolean hasDirection() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .Mysqlx.Crud.Order.Direction direction = 2 [default = ASC];</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Order.Direction getDirection() {
        return direction_;
      }
      /**
       * <code>optional .Mysqlx.Crud.Order.Direction direction = 2 [default = ASC];</code>
       */
      public Builder setDirection(com.mysql.cj.x.protobuf.MysqlxCrud.Order.Direction value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        direction_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.Order.Direction direction = 2 [default = ASC];</code>
       */
      public Builder clearDirection() {
        bitField0_ = (bitField0_ & ~0x00000002);
        direction_ = com.mysql.cj.x.protobuf.MysqlxCrud.Order.Direction.ASC;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Crud.Order)
    }

    static {
      defaultInstance = new Order(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Crud.Order)
  }

  public interface UpdateOperationOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Crud.UpdateOperation)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .Mysqlx.Expr.ColumnIdentifier source = 1;</code>
     */
    boolean hasSource();
    /**
     * <code>required .Mysqlx.Expr.ColumnIdentifier source = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier getSource();
    /**
     * <code>required .Mysqlx.Expr.ColumnIdentifier source = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifierOrBuilder getSourceOrBuilder();

    /**
     * <code>required .Mysqlx.Crud.UpdateOperation.UpdateType operation = 2;</code>
     */
    boolean hasOperation();
    /**
     * <code>required .Mysqlx.Crud.UpdateOperation.UpdateType operation = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.UpdateType getOperation();

    /**
     * <code>optional .Mysqlx.Expr.Expr value = 3;</code>
     */
    boolean hasValue();
    /**
     * <code>optional .Mysqlx.Expr.Expr value = 3;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Expr getValue();
    /**
     * <code>optional .Mysqlx.Expr.Expr value = 3;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getValueOrBuilder();
  }
  /**
   * Protobuf type {@code Mysqlx.Crud.UpdateOperation}
   *
   * <pre>
   * update operations
   * :param source: specification of the value to be updated
   *      if data_model is TABLE, a column name may be specified and also a document path, if the column has type JSON
   *      if data_model is DOCUMENT, only document paths are allowed
   *      in both cases, schema and table must be not set
   * :param operation: the type of operation to be performed
   * :param value: an expression to be computed as the new value for the operation
   * </pre>
   */
  public static final class UpdateOperation extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Crud.UpdateOperation)
      UpdateOperationOrBuilder {
    // Use UpdateOperation.newBuilder() to construct.
    private UpdateOperation(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private UpdateOperation(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final UpdateOperation defaultInstance;
    public static UpdateOperation getDefaultInstance() {
      return defaultInstance;
    }

    public UpdateOperation getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private UpdateOperation(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = source_.toBuilder();
              }
              source_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(source_);
                source_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 16: {
              int rawValue = input.readEnum();
              com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.UpdateType value = com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.UpdateType.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(2, rawValue);
              } else {
                bitField0_ |= 0x00000002;
                operation_ = value;
              }
              break;
            }
            case 26: {
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder subBuilder = null;
              if (((bitField0_ & 0x00000004) == 0x00000004)) {
                subBuilder = value_.toBuilder();
              }
              value_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpr.Expr.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(value_);
                value_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000004;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_UpdateOperation_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_UpdateOperation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.class, com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.Builder.class);
    }

    public static com.google.protobuf.Parser<UpdateOperation> PARSER =
        new com.google.protobuf.AbstractParser<UpdateOperation>() {
      public UpdateOperation parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new UpdateOperation(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<UpdateOperation> getParserForType() {
      return PARSER;
    }

    /**
     * Protobuf enum {@code Mysqlx.Crud.UpdateOperation.UpdateType}
     */
    public enum UpdateType
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>SET = 1;</code>
       *
       * <pre>
       * only allowed for TABLE
       * </pre>
       */
      SET(0, 1),
      /**
       * <code>ITEM_REMOVE = 2;</code>
       *
       * <pre>
       * no value (removes the identified path from a object or array)
       * </pre>
       */
      ITEM_REMOVE(1, 2),
      /**
       * <code>ITEM_SET = 3;</code>
       *
       * <pre>
       * sets the new value on the identified path
       * </pre>
       */
      ITEM_SET(2, 3),
      /**
       * <code>ITEM_REPLACE = 4;</code>
       *
       * <pre>
       * replaces a value if the path exists
       * </pre>
       */
      ITEM_REPLACE(3, 4),
      /**
       * <code>ITEM_MERGE = 5;</code>
       *
       * <pre>
       * source and value must be documents
       * </pre>
       */
      ITEM_MERGE(4, 5),
      /**
       * <code>ARRAY_INSERT = 6;</code>
       *
       * <pre>
       * insert the value in the array at the index identified in the source path
       * </pre>
       */
      ARRAY_INSERT(5, 6),
      /**
       * <code>ARRAY_APPEND = 7;</code>
       *
       * <pre>
       * append the value on the array at the identified path
       * </pre>
       */
      ARRAY_APPEND(6, 7),
      ;

      /**
       * <code>SET = 1;</code>
       *
       * <pre>
       * only allowed for TABLE
       * </pre>
       */
      public static final int SET_VALUE = 1;
      /**
       * <code>ITEM_REMOVE = 2;</code>
       *
       * <pre>
       * no value (removes the identified path from a object or array)
       * </pre>
       */
      public static final int ITEM_REMOVE_VALUE = 2;
      /**
       * <code>ITEM_SET = 3;</code>
       *
       * <pre>
       * sets the new value on the identified path
       * </pre>
       */
      public static final int ITEM_SET_VALUE = 3;
      /**
       * <code>ITEM_REPLACE = 4;</code>
       *
       * <pre>
       * replaces a value if the path exists
       * </pre>
       */
      public static final int ITEM_REPLACE_VALUE = 4;
      /**
       * <code>ITEM_MERGE = 5;</code>
       *
       * <pre>
       * source and value must be documents
       * </pre>
       */
      public static final int ITEM_MERGE_VALUE = 5;
      /**
       * <code>ARRAY_INSERT = 6;</code>
       *
       * <pre>
       * insert the value in the array at the index identified in the source path
       * </pre>
       */
      public static final int ARRAY_INSERT_VALUE = 6;
      /**
       * <code>ARRAY_APPEND = 7;</code>
       *
       * <pre>
       * append the value on the array at the identified path
       * </pre>
       */
      public static final int ARRAY_APPEND_VALUE = 7;


      public final int getNumber() { return value; }

      public static UpdateType valueOf(int value) {
        switch (value) {
          case 1: return SET;
          case 2: return ITEM_REMOVE;
          case 3: return ITEM_SET;
          case 4: return ITEM_REPLACE;
          case 5: return ITEM_MERGE;
          case 6: return ARRAY_INSERT;
          case 7: return ARRAY_APPEND;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<UpdateType>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static com.google.protobuf.Internal.EnumLiteMap<UpdateType>
          internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<UpdateType>() {
              public UpdateType findValueByNumber(int number) {
                return UpdateType.valueOf(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(index);
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.getDescriptor().getEnumTypes().get(0);
      }

      private static final UpdateType[] VALUES = values();

      public static UpdateType valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int index;
      private final int value;

      private UpdateType(int index, int value) {
        this.index = index;
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Crud.UpdateOperation.UpdateType)
    }

    private int bitField0_;
    public static final int SOURCE_FIELD_NUMBER = 1;
    private com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier source_;
    /**
     * <code>required .Mysqlx.Expr.ColumnIdentifier source = 1;</code>
     */
    public boolean hasSource() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required .Mysqlx.Expr.ColumnIdentifier source = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier getSource() {
      return source_;
    }
    /**
     * <code>required .Mysqlx.Expr.ColumnIdentifier source = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifierOrBuilder getSourceOrBuilder() {
      return source_;
    }

    public static final int OPERATION_FIELD_NUMBER = 2;
    private com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.UpdateType operation_;
    /**
     * <code>required .Mysqlx.Crud.UpdateOperation.UpdateType operation = 2;</code>
     */
    public boolean hasOperation() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>required .Mysqlx.Crud.UpdateOperation.UpdateType operation = 2;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.UpdateType getOperation() {
      return operation_;
    }

    public static final int VALUE_FIELD_NUMBER = 3;
    private com.mysql.cj.x.protobuf.MysqlxExpr.Expr value_;
    /**
     * <code>optional .Mysqlx.Expr.Expr value = 3;</code>
     */
    public boolean hasValue() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional .Mysqlx.Expr.Expr value = 3;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getValue() {
      return value_;
    }
    /**
     * <code>optional .Mysqlx.Expr.Expr value = 3;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getValueOrBuilder() {
      return value_;
    }

    private void initFields() {
      source_ = com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.getDefaultInstance();
      operation_ = com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.UpdateType.SET;
      value_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasSource()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasOperation()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getSource().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (hasValue()) {
        if (!getValue().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, source_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeEnum(2, operation_.getNumber());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(3, value_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, source_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, operation_.getNumber());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, value_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Crud.UpdateOperation}
     *
     * <pre>
     * update operations
     * :param source: specification of the value to be updated
     *      if data_model is TABLE, a column name may be specified and also a document path, if the column has type JSON
     *      if data_model is DOCUMENT, only document paths are allowed
     *      in both cases, schema and table must be not set
     * :param operation: the type of operation to be performed
     * :param value: an expression to be computed as the new value for the operation
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Crud.UpdateOperation)
        com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_UpdateOperation_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_UpdateOperation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.class, com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getSourceFieldBuilder();
          getValueFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (sourceBuilder_ == null) {
          source_ = com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.getDefaultInstance();
        } else {
          sourceBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        operation_ = com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.UpdateType.SET;
        bitField0_ = (bitField0_ & ~0x00000002);
        if (valueBuilder_ == null) {
          value_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
        } else {
          valueBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_UpdateOperation_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation build() {
        com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation result = new com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (sourceBuilder_ == null) {
          result.source_ = source_;
        } else {
          result.source_ = sourceBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.operation_ = operation_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (valueBuilder_ == null) {
          result.value_ = value_;
        } else {
          result.value_ = valueBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.getDefaultInstance()) return this;
        if (other.hasSource()) {
          mergeSource(other.getSource());
        }
        if (other.hasOperation()) {
          setOperation(other.getOperation());
        }
        if (other.hasValue()) {
          mergeValue(other.getValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasSource()) {
          
          return false;
        }
        if (!hasOperation()) {
          
          return false;
        }
        if (!getSource().isInitialized()) {
          
          return false;
        }
        if (hasValue()) {
          if (!getValue().isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier source_ = com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier, com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifierOrBuilder> sourceBuilder_;
      /**
       * <code>required .Mysqlx.Expr.ColumnIdentifier source = 1;</code>
       */
      public boolean hasSource() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required .Mysqlx.Expr.ColumnIdentifier source = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier getSource() {
        if (sourceBuilder_ == null) {
          return source_;
        } else {
          return sourceBuilder_.getMessage();
        }
      }
      /**
       * <code>required .Mysqlx.Expr.ColumnIdentifier source = 1;</code>
       */
      public Builder setSource(com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier value) {
        if (sourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          source_ = value;
          onChanged();
        } else {
          sourceBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Expr.ColumnIdentifier source = 1;</code>
       */
      public Builder setSource(
          com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.Builder builderForValue) {
        if (sourceBuilder_ == null) {
          source_ = builderForValue.build();
          onChanged();
        } else {
          sourceBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Expr.ColumnIdentifier source = 1;</code>
       */
      public Builder mergeSource(com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier value) {
        if (sourceBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              source_ != com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.getDefaultInstance()) {
            source_ =
              com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.newBuilder(source_).mergeFrom(value).buildPartial();
          } else {
            source_ = value;
          }
          onChanged();
        } else {
          sourceBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Expr.ColumnIdentifier source = 1;</code>
       */
      public Builder clearSource() {
        if (sourceBuilder_ == null) {
          source_ = com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.getDefaultInstance();
          onChanged();
        } else {
          sourceBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>required .Mysqlx.Expr.ColumnIdentifier source = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.Builder getSourceBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getSourceFieldBuilder().getBuilder();
      }
      /**
       * <code>required .Mysqlx.Expr.ColumnIdentifier source = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifierOrBuilder getSourceOrBuilder() {
        if (sourceBuilder_ != null) {
          return sourceBuilder_.getMessageOrBuilder();
        } else {
          return source_;
        }
      }
      /**
       * <code>required .Mysqlx.Expr.ColumnIdentifier source = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier, com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifierOrBuilder> 
          getSourceFieldBuilder() {
        if (sourceBuilder_ == null) {
          sourceBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier, com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifier.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ColumnIdentifierOrBuilder>(
                  getSource(),
                  getParentForChildren(),
                  isClean());
          source_ = null;
        }
        return sourceBuilder_;
      }

      private com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.UpdateType operation_ = com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.UpdateType.SET;
      /**
       * <code>required .Mysqlx.Crud.UpdateOperation.UpdateType operation = 2;</code>
       */
      public boolean hasOperation() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>required .Mysqlx.Crud.UpdateOperation.UpdateType operation = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.UpdateType getOperation() {
        return operation_;
      }
      /**
       * <code>required .Mysqlx.Crud.UpdateOperation.UpdateType operation = 2;</code>
       */
      public Builder setOperation(com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.UpdateType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        operation_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.UpdateOperation.UpdateType operation = 2;</code>
       */
      public Builder clearOperation() {
        bitField0_ = (bitField0_ & ~0x00000002);
        operation_ = com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.UpdateType.SET;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxExpr.Expr value_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> valueBuilder_;
      /**
       * <code>optional .Mysqlx.Expr.Expr value = 3;</code>
       */
      public boolean hasValue() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr value = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getValue() {
        if (valueBuilder_ == null) {
          return value_;
        } else {
          return valueBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr value = 3;</code>
       */
      public Builder setValue(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          value_ = value;
          onChanged();
        } else {
          valueBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr value = 3;</code>
       */
      public Builder setValue(
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (valueBuilder_ == null) {
          value_ = builderForValue.build();
          onChanged();
        } else {
          valueBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr value = 3;</code>
       */
      public Builder mergeValue(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (valueBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004) &&
              value_ != com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance()) {
            value_ =
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr.newBuilder(value_).mergeFrom(value).buildPartial();
          } else {
            value_ = value;
          }
          onChanged();
        } else {
          valueBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr value = 3;</code>
       */
      public Builder clearValue() {
        if (valueBuilder_ == null) {
          value_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
          onChanged();
        } else {
          valueBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr value = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder getValueBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getValueFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr value = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getValueOrBuilder() {
        if (valueBuilder_ != null) {
          return valueBuilder_.getMessageOrBuilder();
        } else {
          return value_;
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr value = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
          getValueFieldBuilder() {
        if (valueBuilder_ == null) {
          valueBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder>(
                  getValue(),
                  getParentForChildren(),
                  isClean());
          value_ = null;
        }
        return valueBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Crud.UpdateOperation)
    }

    static {
      defaultInstance = new UpdateOperation(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Crud.UpdateOperation)
  }

  public interface FindOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Crud.Find)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
     */
    boolean hasCollection();
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.Collection getCollection();
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder getCollectionOrBuilder();

    /**
     * <code>optional .Mysqlx.Crud.DataModel data_model = 3;</code>
     */
    boolean hasDataModel();
    /**
     * <code>optional .Mysqlx.Crud.DataModel data_model = 3;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.DataModel getDataModel();

    /**
     * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Projection> 
        getProjectionList();
    /**
     * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.Projection getProjection(int index);
    /**
     * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
     */
    int getProjectionCount();
    /**
     * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxCrud.ProjectionOrBuilder> 
        getProjectionOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.ProjectionOrBuilder getProjectionOrBuilder(
        int index);

    /**
     * <code>optional .Mysqlx.Expr.Expr criteria = 5;</code>
     */
    boolean hasCriteria();
    /**
     * <code>optional .Mysqlx.Expr.Expr criteria = 5;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Expr getCriteria();
    /**
     * <code>optional .Mysqlx.Expr.Expr criteria = 5;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getCriteriaOrBuilder();

    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> 
        getArgsList();
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getArgs(int index);
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
     */
    int getArgsCount();
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
        getArgsOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getArgsOrBuilder(
        int index);

    /**
     * <code>optional .Mysqlx.Crud.Limit limit = 6;</code>
     */
    boolean hasLimit();
    /**
     * <code>optional .Mysqlx.Crud.Limit limit = 6;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.Limit getLimit();
    /**
     * <code>optional .Mysqlx.Crud.Limit limit = 6;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.LimitOrBuilder getLimitOrBuilder();

    /**
     * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Order> 
        getOrderList();
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.Order getOrder(int index);
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
     */
    int getOrderCount();
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder> 
        getOrderOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder getOrderOrBuilder(
        int index);

    /**
     * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> 
        getGroupingList();
    /**
     * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Expr getGrouping(int index);
    /**
     * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
     */
    int getGroupingCount();
    /**
     * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
        getGroupingOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getGroupingOrBuilder(
        int index);

    /**
     * <code>optional .Mysqlx.Expr.Expr grouping_criteria = 9;</code>
     */
    boolean hasGroupingCriteria();
    /**
     * <code>optional .Mysqlx.Expr.Expr grouping_criteria = 9;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Expr getGroupingCriteria();
    /**
     * <code>optional .Mysqlx.Expr.Expr grouping_criteria = 9;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getGroupingCriteriaOrBuilder();

    /**
     * <code>optional .Mysqlx.Crud.Find.RowLock locking = 12;</code>
     */
    boolean hasLocking();
    /**
     * <code>optional .Mysqlx.Crud.Find.RowLock locking = 12;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.Find.RowLock getLocking();
  }
  /**
   * Protobuf type {@code Mysqlx.Crud.Find}
   *
   * <pre>
   * Find Documents/Rows in a Collection/Table
   * .. uml::
   *   client -&gt; server: Find
   *   ... one or more Resultset ...
   * :param collection: collection to insert into
   * :param data_model: datamodel that the operations refer to
   * :param projection: list of column projections that shall be returned
   * :param args: values for parameters used in filter expression
   * :param criteria: filter criteria
   * :param limit: numbers of rows that shall be skipped and returned
   * :param order: sort-order in which the rows/document shall be returned in
   * :param grouping: column expression list for aggregation (GROUP BY)
   * :param grouping_criteria: filter criteria for aggregated groups
   * :param locking: perform row locking on matches
   * :Returns: :protobuf:msg:`Mysqlx.Resultset::`
   * </pre>
   */
  public static final class Find extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Crud.Find)
      FindOrBuilder {
    // Use Find.newBuilder() to construct.
    private Find(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Find(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Find defaultInstance;
    public static Find getDefaultInstance() {
      return defaultInstance;
    }

    public Find getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Find(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 18: {
              com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = collection_.toBuilder();
              }
              collection_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxCrud.Collection.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(collection_);
                collection_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 24: {
              int rawValue = input.readEnum();
              com.mysql.cj.x.protobuf.MysqlxCrud.DataModel value = com.mysql.cj.x.protobuf.MysqlxCrud.DataModel.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(3, rawValue);
              } else {
                bitField0_ |= 0x00000002;
                dataModel_ = value;
              }
              break;
            }
            case 34: {
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                projection_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxCrud.Projection>();
                mutable_bitField0_ |= 0x00000004;
              }
              projection_.add(input.readMessage(com.mysql.cj.x.protobuf.MysqlxCrud.Projection.PARSER, extensionRegistry));
              break;
            }
            case 42: {
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder subBuilder = null;
              if (((bitField0_ & 0x00000004) == 0x00000004)) {
                subBuilder = criteria_.toBuilder();
              }
              criteria_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpr.Expr.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(criteria_);
                criteria_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000004;
              break;
            }
            case 50: {
              com.mysql.cj.x.protobuf.MysqlxCrud.Limit.Builder subBuilder = null;
              if (((bitField0_ & 0x00000008) == 0x00000008)) {
                subBuilder = limit_.toBuilder();
              }
              limit_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxCrud.Limit.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(limit_);
                limit_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000008;
              break;
            }
            case 58: {
              if (!((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
                order_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxCrud.Order>();
                mutable_bitField0_ |= 0x00000040;
              }
              order_.add(input.readMessage(com.mysql.cj.x.protobuf.MysqlxCrud.Order.PARSER, extensionRegistry));
              break;
            }
            case 66: {
              if (!((mutable_bitField0_ & 0x00000080) == 0x00000080)) {
                grouping_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxExpr.Expr>();
                mutable_bitField0_ |= 0x00000080;
              }
              grouping_.add(input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpr.Expr.PARSER, extensionRegistry));
              break;
            }
            case 74: {
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder subBuilder = null;
              if (((bitField0_ & 0x00000010) == 0x00000010)) {
                subBuilder = groupingCriteria_.toBuilder();
              }
              groupingCriteria_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpr.Expr.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(groupingCriteria_);
                groupingCriteria_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000010;
              break;
            }
            case 90: {
              if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
                args_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar>();
                mutable_bitField0_ |= 0x00000010;
              }
              args_.add(input.readMessage(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.PARSER, extensionRegistry));
              break;
            }
            case 96: {
              int rawValue = input.readEnum();
              com.mysql.cj.x.protobuf.MysqlxCrud.Find.RowLock value = com.mysql.cj.x.protobuf.MysqlxCrud.Find.RowLock.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(12, rawValue);
              } else {
                bitField0_ |= 0x00000020;
                locking_ = value;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
          projection_ = java.util.Collections.unmodifiableList(projection_);
        }
        if (((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
          order_ = java.util.Collections.unmodifiableList(order_);
        }
        if (((mutable_bitField0_ & 0x00000080) == 0x00000080)) {
          grouping_ = java.util.Collections.unmodifiableList(grouping_);
        }
        if (((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
          args_ = java.util.Collections.unmodifiableList(args_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Find_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Find_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxCrud.Find.class, com.mysql.cj.x.protobuf.MysqlxCrud.Find.Builder.class);
    }

    public static com.google.protobuf.Parser<Find> PARSER =
        new com.google.protobuf.AbstractParser<Find>() {
      public Find parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Find(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Find> getParserForType() {
      return PARSER;
    }

    /**
     * Protobuf enum {@code Mysqlx.Crud.Find.RowLock}
     */
    public enum RowLock
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>SHARED_LOCK = 1;</code>
       *
       * <pre>
       * Lock matching rows against updates
       * </pre>
       */
      SHARED_LOCK(0, 1),
      /**
       * <code>EXCLUSIVE_LOCK = 2;</code>
       *
       * <pre>
       * Lock matching rows so no other transaction can read or write to it
       * </pre>
       */
      EXCLUSIVE_LOCK(1, 2),
      ;

      /**
       * <code>SHARED_LOCK = 1;</code>
       *
       * <pre>
       * Lock matching rows against updates
       * </pre>
       */
      public static final int SHARED_LOCK_VALUE = 1;
      /**
       * <code>EXCLUSIVE_LOCK = 2;</code>
       *
       * <pre>
       * Lock matching rows so no other transaction can read or write to it
       * </pre>
       */
      public static final int EXCLUSIVE_LOCK_VALUE = 2;


      public final int getNumber() { return value; }

      public static RowLock valueOf(int value) {
        switch (value) {
          case 1: return SHARED_LOCK;
          case 2: return EXCLUSIVE_LOCK;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<RowLock>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static com.google.protobuf.Internal.EnumLiteMap<RowLock>
          internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<RowLock>() {
              public RowLock findValueByNumber(int number) {
                return RowLock.valueOf(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(index);
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.Find.getDescriptor().getEnumTypes().get(0);
      }

      private static final RowLock[] VALUES = values();

      public static RowLock valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int index;
      private final int value;

      private RowLock(int index, int value) {
        this.index = index;
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Crud.Find.RowLock)
    }

    private int bitField0_;
    public static final int COLLECTION_FIELD_NUMBER = 2;
    private com.mysql.cj.x.protobuf.MysqlxCrud.Collection collection_;
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
     */
    public boolean hasCollection() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.Collection getCollection() {
      return collection_;
    }
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder getCollectionOrBuilder() {
      return collection_;
    }

    public static final int DATA_MODEL_FIELD_NUMBER = 3;
    private com.mysql.cj.x.protobuf.MysqlxCrud.DataModel dataModel_;
    /**
     * <code>optional .Mysqlx.Crud.DataModel data_model = 3;</code>
     */
    public boolean hasDataModel() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .Mysqlx.Crud.DataModel data_model = 3;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.DataModel getDataModel() {
      return dataModel_;
    }

    public static final int PROJECTION_FIELD_NUMBER = 4;
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Projection> projection_;
    /**
     * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
     */
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Projection> getProjectionList() {
      return projection_;
    }
    /**
     * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
     */
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxCrud.ProjectionOrBuilder> 
        getProjectionOrBuilderList() {
      return projection_;
    }
    /**
     * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
     */
    public int getProjectionCount() {
      return projection_.size();
    }
    /**
     * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.Projection getProjection(int index) {
      return projection_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.ProjectionOrBuilder getProjectionOrBuilder(
        int index) {
      return projection_.get(index);
    }

    public static final int CRITERIA_FIELD_NUMBER = 5;
    private com.mysql.cj.x.protobuf.MysqlxExpr.Expr criteria_;
    /**
     * <code>optional .Mysqlx.Expr.Expr criteria = 5;</code>
     */
    public boolean hasCriteria() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional .Mysqlx.Expr.Expr criteria = 5;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getCriteria() {
      return criteria_;
    }
    /**
     * <code>optional .Mysqlx.Expr.Expr criteria = 5;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getCriteriaOrBuilder() {
      return criteria_;
    }

    public static final int ARGS_FIELD_NUMBER = 11;
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> args_;
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
     */
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> getArgsList() {
      return args_;
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
     */
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
        getArgsOrBuilderList() {
      return args_;
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
     */
    public int getArgsCount() {
      return args_.size();
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getArgs(int index) {
      return args_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getArgsOrBuilder(
        int index) {
      return args_.get(index);
    }

    public static final int LIMIT_FIELD_NUMBER = 6;
    private com.mysql.cj.x.protobuf.MysqlxCrud.Limit limit_;
    /**
     * <code>optional .Mysqlx.Crud.Limit limit = 6;</code>
     */
    public boolean hasLimit() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional .Mysqlx.Crud.Limit limit = 6;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.Limit getLimit() {
      return limit_;
    }
    /**
     * <code>optional .Mysqlx.Crud.Limit limit = 6;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.LimitOrBuilder getLimitOrBuilder() {
      return limit_;
    }

    public static final int ORDER_FIELD_NUMBER = 7;
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Order> order_;
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
     */
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Order> getOrderList() {
      return order_;
    }
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
     */
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder> 
        getOrderOrBuilderList() {
      return order_;
    }
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
     */
    public int getOrderCount() {
      return order_.size();
    }
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.Order getOrder(int index) {
      return order_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder getOrderOrBuilder(
        int index) {
      return order_.get(index);
    }

    public static final int GROUPING_FIELD_NUMBER = 8;
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> grouping_;
    /**
     * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
     */
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> getGroupingList() {
      return grouping_;
    }
    /**
     * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
     */
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
        getGroupingOrBuilderList() {
      return grouping_;
    }
    /**
     * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
     */
    public int getGroupingCount() {
      return grouping_.size();
    }
    /**
     * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getGrouping(int index) {
      return grouping_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getGroupingOrBuilder(
        int index) {
      return grouping_.get(index);
    }

    public static final int GROUPING_CRITERIA_FIELD_NUMBER = 9;
    private com.mysql.cj.x.protobuf.MysqlxExpr.Expr groupingCriteria_;
    /**
     * <code>optional .Mysqlx.Expr.Expr grouping_criteria = 9;</code>
     */
    public boolean hasGroupingCriteria() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional .Mysqlx.Expr.Expr grouping_criteria = 9;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getGroupingCriteria() {
      return groupingCriteria_;
    }
    /**
     * <code>optional .Mysqlx.Expr.Expr grouping_criteria = 9;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getGroupingCriteriaOrBuilder() {
      return groupingCriteria_;
    }

    public static final int LOCKING_FIELD_NUMBER = 12;
    private com.mysql.cj.x.protobuf.MysqlxCrud.Find.RowLock locking_;
    /**
     * <code>optional .Mysqlx.Crud.Find.RowLock locking = 12;</code>
     */
    public boolean hasLocking() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional .Mysqlx.Crud.Find.RowLock locking = 12;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.Find.RowLock getLocking() {
      return locking_;
    }

    private void initFields() {
      collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
      dataModel_ = com.mysql.cj.x.protobuf.MysqlxCrud.DataModel.DOCUMENT;
      projection_ = java.util.Collections.emptyList();
      criteria_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
      args_ = java.util.Collections.emptyList();
      limit_ = com.mysql.cj.x.protobuf.MysqlxCrud.Limit.getDefaultInstance();
      order_ = java.util.Collections.emptyList();
      grouping_ = java.util.Collections.emptyList();
      groupingCriteria_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
      locking_ = com.mysql.cj.x.protobuf.MysqlxCrud.Find.RowLock.SHARED_LOCK;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasCollection()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getCollection().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getProjectionCount(); i++) {
        if (!getProjection(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasCriteria()) {
        if (!getCriteria().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      for (int i = 0; i < getArgsCount(); i++) {
        if (!getArgs(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasLimit()) {
        if (!getLimit().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      for (int i = 0; i < getOrderCount(); i++) {
        if (!getOrder(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      for (int i = 0; i < getGroupingCount(); i++) {
        if (!getGrouping(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasGroupingCriteria()) {
        if (!getGroupingCriteria().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(2, collection_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeEnum(3, dataModel_.getNumber());
      }
      for (int i = 0; i < projection_.size(); i++) {
        output.writeMessage(4, projection_.get(i));
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(5, criteria_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeMessage(6, limit_);
      }
      for (int i = 0; i < order_.size(); i++) {
        output.writeMessage(7, order_.get(i));
      }
      for (int i = 0; i < grouping_.size(); i++) {
        output.writeMessage(8, grouping_.get(i));
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeMessage(9, groupingCriteria_);
      }
      for (int i = 0; i < args_.size(); i++) {
        output.writeMessage(11, args_.get(i));
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeEnum(12, locking_.getNumber());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, collection_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(3, dataModel_.getNumber());
      }
      for (int i = 0; i < projection_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, projection_.get(i));
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, criteria_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, limit_);
      }
      for (int i = 0; i < order_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, order_.get(i));
      }
      for (int i = 0; i < grouping_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(8, grouping_.get(i));
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(9, groupingCriteria_);
      }
      for (int i = 0; i < args_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(11, args_.get(i));
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(12, locking_.getNumber());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxCrud.Find parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Find parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Find parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Find parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Find parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Find parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Find parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Find parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Find parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Find parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxCrud.Find prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Crud.Find}
     *
     * <pre>
     * Find Documents/Rows in a Collection/Table
     * .. uml::
     *   client -&gt; server: Find
     *   ... one or more Resultset ...
     * :param collection: collection to insert into
     * :param data_model: datamodel that the operations refer to
     * :param projection: list of column projections that shall be returned
     * :param args: values for parameters used in filter expression
     * :param criteria: filter criteria
     * :param limit: numbers of rows that shall be skipped and returned
     * :param order: sort-order in which the rows/document shall be returned in
     * :param grouping: column expression list for aggregation (GROUP BY)
     * :param grouping_criteria: filter criteria for aggregated groups
     * :param locking: perform row locking on matches
     * :Returns: :protobuf:msg:`Mysqlx.Resultset::`
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Crud.Find)
        com.mysql.cj.x.protobuf.MysqlxCrud.FindOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Find_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Find_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxCrud.Find.class, com.mysql.cj.x.protobuf.MysqlxCrud.Find.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxCrud.Find.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getCollectionFieldBuilder();
          getProjectionFieldBuilder();
          getCriteriaFieldBuilder();
          getArgsFieldBuilder();
          getLimitFieldBuilder();
          getOrderFieldBuilder();
          getGroupingFieldBuilder();
          getGroupingCriteriaFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (collectionBuilder_ == null) {
          collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
        } else {
          collectionBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        dataModel_ = com.mysql.cj.x.protobuf.MysqlxCrud.DataModel.DOCUMENT;
        bitField0_ = (bitField0_ & ~0x00000002);
        if (projectionBuilder_ == null) {
          projection_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          projectionBuilder_.clear();
        }
        if (criteriaBuilder_ == null) {
          criteria_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
        } else {
          criteriaBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        if (argsBuilder_ == null) {
          args_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          argsBuilder_.clear();
        }
        if (limitBuilder_ == null) {
          limit_ = com.mysql.cj.x.protobuf.MysqlxCrud.Limit.getDefaultInstance();
        } else {
          limitBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000020);
        if (orderBuilder_ == null) {
          order_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000040);
        } else {
          orderBuilder_.clear();
        }
        if (groupingBuilder_ == null) {
          grouping_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000080);
        } else {
          groupingBuilder_.clear();
        }
        if (groupingCriteriaBuilder_ == null) {
          groupingCriteria_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
        } else {
          groupingCriteriaBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000100);
        locking_ = com.mysql.cj.x.protobuf.MysqlxCrud.Find.RowLock.SHARED_LOCK;
        bitField0_ = (bitField0_ & ~0x00000200);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Find_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Find getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.Find.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Find build() {
        com.mysql.cj.x.protobuf.MysqlxCrud.Find result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Find buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxCrud.Find result = new com.mysql.cj.x.protobuf.MysqlxCrud.Find(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (collectionBuilder_ == null) {
          result.collection_ = collection_;
        } else {
          result.collection_ = collectionBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.dataModel_ = dataModel_;
        if (projectionBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)) {
            projection_ = java.util.Collections.unmodifiableList(projection_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.projection_ = projection_;
        } else {
          result.projection_ = projectionBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000004;
        }
        if (criteriaBuilder_ == null) {
          result.criteria_ = criteria_;
        } else {
          result.criteria_ = criteriaBuilder_.build();
        }
        if (argsBuilder_ == null) {
          if (((bitField0_ & 0x00000010) == 0x00000010)) {
            args_ = java.util.Collections.unmodifiableList(args_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.args_ = args_;
        } else {
          result.args_ = argsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000008;
        }
        if (limitBuilder_ == null) {
          result.limit_ = limit_;
        } else {
          result.limit_ = limitBuilder_.build();
        }
        if (orderBuilder_ == null) {
          if (((bitField0_ & 0x00000040) == 0x00000040)) {
            order_ = java.util.Collections.unmodifiableList(order_);
            bitField0_ = (bitField0_ & ~0x00000040);
          }
          result.order_ = order_;
        } else {
          result.order_ = orderBuilder_.build();
        }
        if (groupingBuilder_ == null) {
          if (((bitField0_ & 0x00000080) == 0x00000080)) {
            grouping_ = java.util.Collections.unmodifiableList(grouping_);
            bitField0_ = (bitField0_ & ~0x00000080);
          }
          result.grouping_ = grouping_;
        } else {
          result.grouping_ = groupingBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000100) == 0x00000100)) {
          to_bitField0_ |= 0x00000010;
        }
        if (groupingCriteriaBuilder_ == null) {
          result.groupingCriteria_ = groupingCriteria_;
        } else {
          result.groupingCriteria_ = groupingCriteriaBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000200) == 0x00000200)) {
          to_bitField0_ |= 0x00000020;
        }
        result.locking_ = locking_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxCrud.Find) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxCrud.Find)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxCrud.Find other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxCrud.Find.getDefaultInstance()) return this;
        if (other.hasCollection()) {
          mergeCollection(other.getCollection());
        }
        if (other.hasDataModel()) {
          setDataModel(other.getDataModel());
        }
        if (projectionBuilder_ == null) {
          if (!other.projection_.isEmpty()) {
            if (projection_.isEmpty()) {
              projection_ = other.projection_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureProjectionIsMutable();
              projection_.addAll(other.projection_);
            }
            onChanged();
          }
        } else {
          if (!other.projection_.isEmpty()) {
            if (projectionBuilder_.isEmpty()) {
              projectionBuilder_.dispose();
              projectionBuilder_ = null;
              projection_ = other.projection_;
              bitField0_ = (bitField0_ & ~0x00000004);
              projectionBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getProjectionFieldBuilder() : null;
            } else {
              projectionBuilder_.addAllMessages(other.projection_);
            }
          }
        }
        if (other.hasCriteria()) {
          mergeCriteria(other.getCriteria());
        }
        if (argsBuilder_ == null) {
          if (!other.args_.isEmpty()) {
            if (args_.isEmpty()) {
              args_ = other.args_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensureArgsIsMutable();
              args_.addAll(other.args_);
            }
            onChanged();
          }
        } else {
          if (!other.args_.isEmpty()) {
            if (argsBuilder_.isEmpty()) {
              argsBuilder_.dispose();
              argsBuilder_ = null;
              args_ = other.args_;
              bitField0_ = (bitField0_ & ~0x00000010);
              argsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getArgsFieldBuilder() : null;
            } else {
              argsBuilder_.addAllMessages(other.args_);
            }
          }
        }
        if (other.hasLimit()) {
          mergeLimit(other.getLimit());
        }
        if (orderBuilder_ == null) {
          if (!other.order_.isEmpty()) {
            if (order_.isEmpty()) {
              order_ = other.order_;
              bitField0_ = (bitField0_ & ~0x00000040);
            } else {
              ensureOrderIsMutable();
              order_.addAll(other.order_);
            }
            onChanged();
          }
        } else {
          if (!other.order_.isEmpty()) {
            if (orderBuilder_.isEmpty()) {
              orderBuilder_.dispose();
              orderBuilder_ = null;
              order_ = other.order_;
              bitField0_ = (bitField0_ & ~0x00000040);
              orderBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getOrderFieldBuilder() : null;
            } else {
              orderBuilder_.addAllMessages(other.order_);
            }
          }
        }
        if (groupingBuilder_ == null) {
          if (!other.grouping_.isEmpty()) {
            if (grouping_.isEmpty()) {
              grouping_ = other.grouping_;
              bitField0_ = (bitField0_ & ~0x00000080);
            } else {
              ensureGroupingIsMutable();
              grouping_.addAll(other.grouping_);
            }
            onChanged();
          }
        } else {
          if (!other.grouping_.isEmpty()) {
            if (groupingBuilder_.isEmpty()) {
              groupingBuilder_.dispose();
              groupingBuilder_ = null;
              grouping_ = other.grouping_;
              bitField0_ = (bitField0_ & ~0x00000080);
              groupingBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getGroupingFieldBuilder() : null;
            } else {
              groupingBuilder_.addAllMessages(other.grouping_);
            }
          }
        }
        if (other.hasGroupingCriteria()) {
          mergeGroupingCriteria(other.getGroupingCriteria());
        }
        if (other.hasLocking()) {
          setLocking(other.getLocking());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasCollection()) {
          
          return false;
        }
        if (!getCollection().isInitialized()) {
          
          return false;
        }
        for (int i = 0; i < getProjectionCount(); i++) {
          if (!getProjection(i).isInitialized()) {
            
            return false;
          }
        }
        if (hasCriteria()) {
          if (!getCriteria().isInitialized()) {
            
            return false;
          }
        }
        for (int i = 0; i < getArgsCount(); i++) {
          if (!getArgs(i).isInitialized()) {
            
            return false;
          }
        }
        if (hasLimit()) {
          if (!getLimit().isInitialized()) {
            
            return false;
          }
        }
        for (int i = 0; i < getOrderCount(); i++) {
          if (!getOrder(i).isInitialized()) {
            
            return false;
          }
        }
        for (int i = 0; i < getGroupingCount(); i++) {
          if (!getGrouping(i).isInitialized()) {
            
            return false;
          }
        }
        if (hasGroupingCriteria()) {
          if (!getGroupingCriteria().isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxCrud.Find parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxCrud.Find) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.mysql.cj.x.protobuf.MysqlxCrud.Collection collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Collection, com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder> collectionBuilder_;
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
       */
      public boolean hasCollection() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Collection getCollection() {
        if (collectionBuilder_ == null) {
          return collection_;
        } else {
          return collectionBuilder_.getMessage();
        }
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
       */
      public Builder setCollection(com.mysql.cj.x.protobuf.MysqlxCrud.Collection value) {
        if (collectionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          collection_ = value;
          onChanged();
        } else {
          collectionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
       */
      public Builder setCollection(
          com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder builderForValue) {
        if (collectionBuilder_ == null) {
          collection_ = builderForValue.build();
          onChanged();
        } else {
          collectionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
       */
      public Builder mergeCollection(com.mysql.cj.x.protobuf.MysqlxCrud.Collection value) {
        if (collectionBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              collection_ != com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance()) {
            collection_ =
              com.mysql.cj.x.protobuf.MysqlxCrud.Collection.newBuilder(collection_).mergeFrom(value).buildPartial();
          } else {
            collection_ = value;
          }
          onChanged();
        } else {
          collectionBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
       */
      public Builder clearCollection() {
        if (collectionBuilder_ == null) {
          collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
          onChanged();
        } else {
          collectionBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder getCollectionBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getCollectionFieldBuilder().getBuilder();
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder getCollectionOrBuilder() {
        if (collectionBuilder_ != null) {
          return collectionBuilder_.getMessageOrBuilder();
        } else {
          return collection_;
        }
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Collection, com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder> 
          getCollectionFieldBuilder() {
        if (collectionBuilder_ == null) {
          collectionBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxCrud.Collection, com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder>(
                  getCollection(),
                  getParentForChildren(),
                  isClean());
          collection_ = null;
        }
        return collectionBuilder_;
      }

      private com.mysql.cj.x.protobuf.MysqlxCrud.DataModel dataModel_ = com.mysql.cj.x.protobuf.MysqlxCrud.DataModel.DOCUMENT;
      /**
       * <code>optional .Mysqlx.Crud.DataModel data_model = 3;</code>
       */
      public boolean hasDataModel() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .Mysqlx.Crud.DataModel data_model = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.DataModel getDataModel() {
        return dataModel_;
      }
      /**
       * <code>optional .Mysqlx.Crud.DataModel data_model = 3;</code>
       */
      public Builder setDataModel(com.mysql.cj.x.protobuf.MysqlxCrud.DataModel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        dataModel_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.DataModel data_model = 3;</code>
       */
      public Builder clearDataModel() {
        bitField0_ = (bitField0_ & ~0x00000002);
        dataModel_ = com.mysql.cj.x.protobuf.MysqlxCrud.DataModel.DOCUMENT;
        onChanged();
        return this;
      }

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Projection> projection_ =
        java.util.Collections.emptyList();
      private void ensureProjectionIsMutable() {
        if (!((bitField0_ & 0x00000004) == 0x00000004)) {
          projection_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxCrud.Projection>(projection_);
          bitField0_ |= 0x00000004;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Projection, com.mysql.cj.x.protobuf.MysqlxCrud.Projection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.ProjectionOrBuilder> projectionBuilder_;

      /**
       * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Projection> getProjectionList() {
        if (projectionBuilder_ == null) {
          return java.util.Collections.unmodifiableList(projection_);
        } else {
          return projectionBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
       */
      public int getProjectionCount() {
        if (projectionBuilder_ == null) {
          return projection_.size();
        } else {
          return projectionBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Projection getProjection(int index) {
        if (projectionBuilder_ == null) {
          return projection_.get(index);
        } else {
          return projectionBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
       */
      public Builder setProjection(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Projection value) {
        if (projectionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureProjectionIsMutable();
          projection_.set(index, value);
          onChanged();
        } else {
          projectionBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
       */
      public Builder setProjection(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Projection.Builder builderForValue) {
        if (projectionBuilder_ == null) {
          ensureProjectionIsMutable();
          projection_.set(index, builderForValue.build());
          onChanged();
        } else {
          projectionBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
       */
      public Builder addProjection(com.mysql.cj.x.protobuf.MysqlxCrud.Projection value) {
        if (projectionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureProjectionIsMutable();
          projection_.add(value);
          onChanged();
        } else {
          projectionBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
       */
      public Builder addProjection(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Projection value) {
        if (projectionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureProjectionIsMutable();
          projection_.add(index, value);
          onChanged();
        } else {
          projectionBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
       */
      public Builder addProjection(
          com.mysql.cj.x.protobuf.MysqlxCrud.Projection.Builder builderForValue) {
        if (projectionBuilder_ == null) {
          ensureProjectionIsMutable();
          projection_.add(builderForValue.build());
          onChanged();
        } else {
          projectionBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
       */
      public Builder addProjection(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Projection.Builder builderForValue) {
        if (projectionBuilder_ == null) {
          ensureProjectionIsMutable();
          projection_.add(index, builderForValue.build());
          onChanged();
        } else {
          projectionBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
       */
      public Builder addAllProjection(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxCrud.Projection> values) {
        if (projectionBuilder_ == null) {
          ensureProjectionIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, projection_);
          onChanged();
        } else {
          projectionBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
       */
      public Builder clearProjection() {
        if (projectionBuilder_ == null) {
          projection_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          projectionBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
       */
      public Builder removeProjection(int index) {
        if (projectionBuilder_ == null) {
          ensureProjectionIsMutable();
          projection_.remove(index);
          onChanged();
        } else {
          projectionBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Projection.Builder getProjectionBuilder(
          int index) {
        return getProjectionFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.ProjectionOrBuilder getProjectionOrBuilder(
          int index) {
        if (projectionBuilder_ == null) {
          return projection_.get(index);  } else {
          return projectionBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxCrud.ProjectionOrBuilder> 
           getProjectionOrBuilderList() {
        if (projectionBuilder_ != null) {
          return projectionBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(projection_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Projection.Builder addProjectionBuilder() {
        return getProjectionFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxCrud.Projection.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Projection.Builder addProjectionBuilder(
          int index) {
        return getProjectionFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxCrud.Projection.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Crud.Projection projection = 4;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Projection.Builder> 
           getProjectionBuilderList() {
        return getProjectionFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Projection, com.mysql.cj.x.protobuf.MysqlxCrud.Projection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.ProjectionOrBuilder> 
          getProjectionFieldBuilder() {
        if (projectionBuilder_ == null) {
          projectionBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxCrud.Projection, com.mysql.cj.x.protobuf.MysqlxCrud.Projection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.ProjectionOrBuilder>(
                  projection_,
                  ((bitField0_ & 0x00000004) == 0x00000004),
                  getParentForChildren(),
                  isClean());
          projection_ = null;
        }
        return projectionBuilder_;
      }

      private com.mysql.cj.x.protobuf.MysqlxExpr.Expr criteria_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> criteriaBuilder_;
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 5;</code>
       */
      public boolean hasCriteria() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getCriteria() {
        if (criteriaBuilder_ == null) {
          return criteria_;
        } else {
          return criteriaBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 5;</code>
       */
      public Builder setCriteria(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (criteriaBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          criteria_ = value;
          onChanged();
        } else {
          criteriaBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 5;</code>
       */
      public Builder setCriteria(
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (criteriaBuilder_ == null) {
          criteria_ = builderForValue.build();
          onChanged();
        } else {
          criteriaBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 5;</code>
       */
      public Builder mergeCriteria(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (criteriaBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008) &&
              criteria_ != com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance()) {
            criteria_ =
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr.newBuilder(criteria_).mergeFrom(value).buildPartial();
          } else {
            criteria_ = value;
          }
          onChanged();
        } else {
          criteriaBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 5;</code>
       */
      public Builder clearCriteria() {
        if (criteriaBuilder_ == null) {
          criteria_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
          onChanged();
        } else {
          criteriaBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder getCriteriaBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getCriteriaFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getCriteriaOrBuilder() {
        if (criteriaBuilder_ != null) {
          return criteriaBuilder_.getMessageOrBuilder();
        } else {
          return criteria_;
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
          getCriteriaFieldBuilder() {
        if (criteriaBuilder_ == null) {
          criteriaBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder>(
                  getCriteria(),
                  getParentForChildren(),
                  isClean());
          criteria_ = null;
        }
        return criteriaBuilder_;
      }

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> args_ =
        java.util.Collections.emptyList();
      private void ensureArgsIsMutable() {
        if (!((bitField0_ & 0x00000010) == 0x00000010)) {
          args_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar>(args_);
          bitField0_ |= 0x00000010;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> argsBuilder_;

      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> getArgsList() {
        if (argsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(args_);
        } else {
          return argsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
       */
      public int getArgsCount() {
        if (argsBuilder_ == null) {
          return args_.size();
        } else {
          return argsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getArgs(int index) {
        if (argsBuilder_ == null) {
          return args_.get(index);
        } else {
          return argsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
       */
      public Builder setArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.set(index, value);
          onChanged();
        } else {
          argsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
       */
      public Builder setArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.set(index, builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
       */
      public Builder addArgs(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.add(value);
          onChanged();
        } else {
          argsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
       */
      public Builder addArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.add(index, value);
          onChanged();
        } else {
          argsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
       */
      public Builder addArgs(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.add(builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
       */
      public Builder addArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.add(index, builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
       */
      public Builder addAllArgs(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> values) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, args_);
          onChanged();
        } else {
          argsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
       */
      public Builder clearArgs() {
        if (argsBuilder_ == null) {
          args_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          argsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
       */
      public Builder removeArgs(int index) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.remove(index);
          onChanged();
        } else {
          argsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder getArgsBuilder(
          int index) {
        return getArgsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getArgsOrBuilder(
          int index) {
        if (argsBuilder_ == null) {
          return args_.get(index);  } else {
          return argsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
           getArgsOrBuilderList() {
        if (argsBuilder_ != null) {
          return argsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(args_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder addArgsBuilder() {
        return getArgsFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder addArgsBuilder(
          int index) {
        return getArgsFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 11;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder> 
           getArgsBuilderList() {
        return getArgsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
          getArgsFieldBuilder() {
        if (argsBuilder_ == null) {
          argsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder>(
                  args_,
                  ((bitField0_ & 0x00000010) == 0x00000010),
                  getParentForChildren(),
                  isClean());
          args_ = null;
        }
        return argsBuilder_;
      }

      private com.mysql.cj.x.protobuf.MysqlxCrud.Limit limit_ = com.mysql.cj.x.protobuf.MysqlxCrud.Limit.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Limit, com.mysql.cj.x.protobuf.MysqlxCrud.Limit.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.LimitOrBuilder> limitBuilder_;
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 6;</code>
       */
      public boolean hasLimit() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 6;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Limit getLimit() {
        if (limitBuilder_ == null) {
          return limit_;
        } else {
          return limitBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 6;</code>
       */
      public Builder setLimit(com.mysql.cj.x.protobuf.MysqlxCrud.Limit value) {
        if (limitBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          limit_ = value;
          onChanged();
        } else {
          limitBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 6;</code>
       */
      public Builder setLimit(
          com.mysql.cj.x.protobuf.MysqlxCrud.Limit.Builder builderForValue) {
        if (limitBuilder_ == null) {
          limit_ = builderForValue.build();
          onChanged();
        } else {
          limitBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 6;</code>
       */
      public Builder mergeLimit(com.mysql.cj.x.protobuf.MysqlxCrud.Limit value) {
        if (limitBuilder_ == null) {
          if (((bitField0_ & 0x00000020) == 0x00000020) &&
              limit_ != com.mysql.cj.x.protobuf.MysqlxCrud.Limit.getDefaultInstance()) {
            limit_ =
              com.mysql.cj.x.protobuf.MysqlxCrud.Limit.newBuilder(limit_).mergeFrom(value).buildPartial();
          } else {
            limit_ = value;
          }
          onChanged();
        } else {
          limitBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 6;</code>
       */
      public Builder clearLimit() {
        if (limitBuilder_ == null) {
          limit_ = com.mysql.cj.x.protobuf.MysqlxCrud.Limit.getDefaultInstance();
          onChanged();
        } else {
          limitBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000020);
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 6;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Limit.Builder getLimitBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getLimitFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 6;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.LimitOrBuilder getLimitOrBuilder() {
        if (limitBuilder_ != null) {
          return limitBuilder_.getMessageOrBuilder();
        } else {
          return limit_;
        }
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Limit, com.mysql.cj.x.protobuf.MysqlxCrud.Limit.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.LimitOrBuilder> 
          getLimitFieldBuilder() {
        if (limitBuilder_ == null) {
          limitBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxCrud.Limit, com.mysql.cj.x.protobuf.MysqlxCrud.Limit.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.LimitOrBuilder>(
                  getLimit(),
                  getParentForChildren(),
                  isClean());
          limit_ = null;
        }
        return limitBuilder_;
      }

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Order> order_ =
        java.util.Collections.emptyList();
      private void ensureOrderIsMutable() {
        if (!((bitField0_ & 0x00000040) == 0x00000040)) {
          order_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxCrud.Order>(order_);
          bitField0_ |= 0x00000040;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Order, com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder> orderBuilder_;

      /**
       * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Order> getOrderList() {
        if (orderBuilder_ == null) {
          return java.util.Collections.unmodifiableList(order_);
        } else {
          return orderBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
       */
      public int getOrderCount() {
        if (orderBuilder_ == null) {
          return order_.size();
        } else {
          return orderBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Order getOrder(int index) {
        if (orderBuilder_ == null) {
          return order_.get(index);
        } else {
          return orderBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
       */
      public Builder setOrder(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Order value) {
        if (orderBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOrderIsMutable();
          order_.set(index, value);
          onChanged();
        } else {
          orderBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
       */
      public Builder setOrder(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder builderForValue) {
        if (orderBuilder_ == null) {
          ensureOrderIsMutable();
          order_.set(index, builderForValue.build());
          onChanged();
        } else {
          orderBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
       */
      public Builder addOrder(com.mysql.cj.x.protobuf.MysqlxCrud.Order value) {
        if (orderBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOrderIsMutable();
          order_.add(value);
          onChanged();
        } else {
          orderBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
       */
      public Builder addOrder(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Order value) {
        if (orderBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOrderIsMutable();
          order_.add(index, value);
          onChanged();
        } else {
          orderBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
       */
      public Builder addOrder(
          com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder builderForValue) {
        if (orderBuilder_ == null) {
          ensureOrderIsMutable();
          order_.add(builderForValue.build());
          onChanged();
        } else {
          orderBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
       */
      public Builder addOrder(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder builderForValue) {
        if (orderBuilder_ == null) {
          ensureOrderIsMutable();
          order_.add(index, builderForValue.build());
          onChanged();
        } else {
          orderBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
       */
      public Builder addAllOrder(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxCrud.Order> values) {
        if (orderBuilder_ == null) {
          ensureOrderIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, order_);
          onChanged();
        } else {
          orderBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
       */
      public Builder clearOrder() {
        if (orderBuilder_ == null) {
          order_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000040);
          onChanged();
        } else {
          orderBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
       */
      public Builder removeOrder(int index) {
        if (orderBuilder_ == null) {
          ensureOrderIsMutable();
          order_.remove(index);
          onChanged();
        } else {
          orderBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder getOrderBuilder(
          int index) {
        return getOrderFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder getOrderOrBuilder(
          int index) {
        if (orderBuilder_ == null) {
          return order_.get(index);  } else {
          return orderBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder> 
           getOrderOrBuilderList() {
        if (orderBuilder_ != null) {
          return orderBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(order_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder addOrderBuilder() {
        return getOrderFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxCrud.Order.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder addOrderBuilder(
          int index) {
        return getOrderFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxCrud.Order.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 7;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder> 
           getOrderBuilderList() {
        return getOrderFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Order, com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder> 
          getOrderFieldBuilder() {
        if (orderBuilder_ == null) {
          orderBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxCrud.Order, com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder>(
                  order_,
                  ((bitField0_ & 0x00000040) == 0x00000040),
                  getParentForChildren(),
                  isClean());
          order_ = null;
        }
        return orderBuilder_;
      }

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> grouping_ =
        java.util.Collections.emptyList();
      private void ensureGroupingIsMutable() {
        if (!((bitField0_ & 0x00000080) == 0x00000080)) {
          grouping_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxExpr.Expr>(grouping_);
          bitField0_ |= 0x00000080;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> groupingBuilder_;

      /**
       * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> getGroupingList() {
        if (groupingBuilder_ == null) {
          return java.util.Collections.unmodifiableList(grouping_);
        } else {
          return groupingBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
       */
      public int getGroupingCount() {
        if (groupingBuilder_ == null) {
          return grouping_.size();
        } else {
          return groupingBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getGrouping(int index) {
        if (groupingBuilder_ == null) {
          return grouping_.get(index);
        } else {
          return groupingBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
       */
      public Builder setGrouping(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (groupingBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureGroupingIsMutable();
          grouping_.set(index, value);
          onChanged();
        } else {
          groupingBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
       */
      public Builder setGrouping(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (groupingBuilder_ == null) {
          ensureGroupingIsMutable();
          grouping_.set(index, builderForValue.build());
          onChanged();
        } else {
          groupingBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
       */
      public Builder addGrouping(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (groupingBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureGroupingIsMutable();
          grouping_.add(value);
          onChanged();
        } else {
          groupingBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
       */
      public Builder addGrouping(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (groupingBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureGroupingIsMutable();
          grouping_.add(index, value);
          onChanged();
        } else {
          groupingBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
       */
      public Builder addGrouping(
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (groupingBuilder_ == null) {
          ensureGroupingIsMutable();
          grouping_.add(builderForValue.build());
          onChanged();
        } else {
          groupingBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
       */
      public Builder addGrouping(
          int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (groupingBuilder_ == null) {
          ensureGroupingIsMutable();
          grouping_.add(index, builderForValue.build());
          onChanged();
        } else {
          groupingBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
       */
      public Builder addAllGrouping(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxExpr.Expr> values) {
        if (groupingBuilder_ == null) {
          ensureGroupingIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, grouping_);
          onChanged();
        } else {
          groupingBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
       */
      public Builder clearGrouping() {
        if (groupingBuilder_ == null) {
          grouping_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000080);
          onChanged();
        } else {
          groupingBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
       */
      public Builder removeGrouping(int index) {
        if (groupingBuilder_ == null) {
          ensureGroupingIsMutable();
          grouping_.remove(index);
          onChanged();
        } else {
          groupingBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder getGroupingBuilder(
          int index) {
        return getGroupingFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getGroupingOrBuilder(
          int index) {
        if (groupingBuilder_ == null) {
          return grouping_.get(index);  } else {
          return groupingBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
           getGroupingOrBuilderList() {
        if (groupingBuilder_ != null) {
          return groupingBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(grouping_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder addGroupingBuilder() {
        return getGroupingFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder addGroupingBuilder(
          int index) {
        return getGroupingFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr grouping = 8;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder> 
           getGroupingBuilderList() {
        return getGroupingFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
          getGroupingFieldBuilder() {
        if (groupingBuilder_ == null) {
          groupingBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder>(
                  grouping_,
                  ((bitField0_ & 0x00000080) == 0x00000080),
                  getParentForChildren(),
                  isClean());
          grouping_ = null;
        }
        return groupingBuilder_;
      }

      private com.mysql.cj.x.protobuf.MysqlxExpr.Expr groupingCriteria_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> groupingCriteriaBuilder_;
      /**
       * <code>optional .Mysqlx.Expr.Expr grouping_criteria = 9;</code>
       */
      public boolean hasGroupingCriteria() {
        return ((bitField0_ & 0x00000100) == 0x00000100);
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr grouping_criteria = 9;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getGroupingCriteria() {
        if (groupingCriteriaBuilder_ == null) {
          return groupingCriteria_;
        } else {
          return groupingCriteriaBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr grouping_criteria = 9;</code>
       */
      public Builder setGroupingCriteria(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (groupingCriteriaBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          groupingCriteria_ = value;
          onChanged();
        } else {
          groupingCriteriaBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr grouping_criteria = 9;</code>
       */
      public Builder setGroupingCriteria(
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (groupingCriteriaBuilder_ == null) {
          groupingCriteria_ = builderForValue.build();
          onChanged();
        } else {
          groupingCriteriaBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr grouping_criteria = 9;</code>
       */
      public Builder mergeGroupingCriteria(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (groupingCriteriaBuilder_ == null) {
          if (((bitField0_ & 0x00000100) == 0x00000100) &&
              groupingCriteria_ != com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance()) {
            groupingCriteria_ =
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr.newBuilder(groupingCriteria_).mergeFrom(value).buildPartial();
          } else {
            groupingCriteria_ = value;
          }
          onChanged();
        } else {
          groupingCriteriaBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr grouping_criteria = 9;</code>
       */
      public Builder clearGroupingCriteria() {
        if (groupingCriteriaBuilder_ == null) {
          groupingCriteria_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
          onChanged();
        } else {
          groupingCriteriaBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000100);
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr grouping_criteria = 9;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder getGroupingCriteriaBuilder() {
        bitField0_ |= 0x00000100;
        onChanged();
        return getGroupingCriteriaFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr grouping_criteria = 9;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getGroupingCriteriaOrBuilder() {
        if (groupingCriteriaBuilder_ != null) {
          return groupingCriteriaBuilder_.getMessageOrBuilder();
        } else {
          return groupingCriteria_;
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr grouping_criteria = 9;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
          getGroupingCriteriaFieldBuilder() {
        if (groupingCriteriaBuilder_ == null) {
          groupingCriteriaBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder>(
                  getGroupingCriteria(),
                  getParentForChildren(),
                  isClean());
          groupingCriteria_ = null;
        }
        return groupingCriteriaBuilder_;
      }

      private com.mysql.cj.x.protobuf.MysqlxCrud.Find.RowLock locking_ = com.mysql.cj.x.protobuf.MysqlxCrud.Find.RowLock.SHARED_LOCK;
      /**
       * <code>optional .Mysqlx.Crud.Find.RowLock locking = 12;</code>
       */
      public boolean hasLocking() {
        return ((bitField0_ & 0x00000200) == 0x00000200);
      }
      /**
       * <code>optional .Mysqlx.Crud.Find.RowLock locking = 12;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Find.RowLock getLocking() {
        return locking_;
      }
      /**
       * <code>optional .Mysqlx.Crud.Find.RowLock locking = 12;</code>
       */
      public Builder setLocking(com.mysql.cj.x.protobuf.MysqlxCrud.Find.RowLock value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000200;
        locking_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.Find.RowLock locking = 12;</code>
       */
      public Builder clearLocking() {
        bitField0_ = (bitField0_ & ~0x00000200);
        locking_ = com.mysql.cj.x.protobuf.MysqlxCrud.Find.RowLock.SHARED_LOCK;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Crud.Find)
    }

    static {
      defaultInstance = new Find(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Crud.Find)
  }

  public interface InsertOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Crud.Insert)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    boolean hasCollection();
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.Collection getCollection();
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder getCollectionOrBuilder();

    /**
     * <code>optional .Mysqlx.Crud.DataModel data_model = 2;</code>
     */
    boolean hasDataModel();
    /**
     * <code>optional .Mysqlx.Crud.DataModel data_model = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.DataModel getDataModel();

    /**
     * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Column> 
        getProjectionList();
    /**
     * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.Column getProjection(int index);
    /**
     * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
     */
    int getProjectionCount();
    /**
     * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxCrud.ColumnOrBuilder> 
        getProjectionOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.ColumnOrBuilder getProjectionOrBuilder(
        int index);

    /**
     * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow> 
        getRowList();
    /**
     * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow getRow(int index);
    /**
     * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
     */
    int getRowCount();
    /**
     * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRowOrBuilder> 
        getRowOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRowOrBuilder getRowOrBuilder(
        int index);

    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> 
        getArgsList();
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getArgs(int index);
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
     */
    int getArgsCount();
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
        getArgsOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getArgsOrBuilder(
        int index);

    /**
     * <code>optional bool upsert = 6 [default = false];</code>
     */
    boolean hasUpsert();
    /**
     * <code>optional bool upsert = 6 [default = false];</code>
     */
    boolean getUpsert();
  }
  /**
   * Protobuf type {@code Mysqlx.Crud.Insert}
   *
   * <pre>
   * Insert documents/rows into a collection/table
   * :param collection: collection to insert into
   * :param data_model: datamodel that the operations refer to
   * :param projection: name of the columns to insert data into (empty if data_model is DOCUMENT)
   * :param row: set of rows to insert into the collection/table (a single expression with a JSON document literal or an OBJECT expression)
   * :param args: values for parameters used in row expressions
   * :param upsert: true if this should be treated as an Upsert (that is, update on duplicate key)
   * :Returns: :protobuf:msg:`Mysqlx.Resultset::`
   * </pre>
   */
  public static final class Insert extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Crud.Insert)
      InsertOrBuilder {
    // Use Insert.newBuilder() to construct.
    private Insert(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Insert(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Insert defaultInstance;
    public static Insert getDefaultInstance() {
      return defaultInstance;
    }

    public Insert getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Insert(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = collection_.toBuilder();
              }
              collection_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxCrud.Collection.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(collection_);
                collection_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 16: {
              int rawValue = input.readEnum();
              com.mysql.cj.x.protobuf.MysqlxCrud.DataModel value = com.mysql.cj.x.protobuf.MysqlxCrud.DataModel.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(2, rawValue);
              } else {
                bitField0_ |= 0x00000002;
                dataModel_ = value;
              }
              break;
            }
            case 26: {
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                projection_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxCrud.Column>();
                mutable_bitField0_ |= 0x00000004;
              }
              projection_.add(input.readMessage(com.mysql.cj.x.protobuf.MysqlxCrud.Column.PARSER, extensionRegistry));
              break;
            }
            case 34: {
              if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
                row_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow>();
                mutable_bitField0_ |= 0x00000008;
              }
              row_.add(input.readMessage(com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow.PARSER, extensionRegistry));
              break;
            }
            case 42: {
              if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
                args_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar>();
                mutable_bitField0_ |= 0x00000010;
              }
              args_.add(input.readMessage(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.PARSER, extensionRegistry));
              break;
            }
            case 48: {
              bitField0_ |= 0x00000004;
              upsert_ = input.readBool();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
          projection_ = java.util.Collections.unmodifiableList(projection_);
        }
        if (((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
          row_ = java.util.Collections.unmodifiableList(row_);
        }
        if (((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
          args_ = java.util.Collections.unmodifiableList(args_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Insert_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Insert_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxCrud.Insert.class, com.mysql.cj.x.protobuf.MysqlxCrud.Insert.Builder.class);
    }

    public static com.google.protobuf.Parser<Insert> PARSER =
        new com.google.protobuf.AbstractParser<Insert>() {
      public Insert parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Insert(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Insert> getParserForType() {
      return PARSER;
    }

    public interface TypedRowOrBuilder extends
        // @@protoc_insertion_point(interface_extends:Mysqlx.Crud.Insert.TypedRow)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
       */
      java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> 
          getFieldList();
      /**
       * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
       */
      com.mysql.cj.x.protobuf.MysqlxExpr.Expr getField(int index);
      /**
       * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
       */
      int getFieldCount();
      /**
       * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
       */
      java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
          getFieldOrBuilderList();
      /**
       * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
       */
      com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getFieldOrBuilder(
          int index);
    }
    /**
     * Protobuf type {@code Mysqlx.Crud.Insert.TypedRow}
     */
    public static final class TypedRow extends
        com.google.protobuf.GeneratedMessage implements
        // @@protoc_insertion_point(message_implements:Mysqlx.Crud.Insert.TypedRow)
        TypedRowOrBuilder {
      // Use TypedRow.newBuilder() to construct.
      private TypedRow(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
        this.unknownFields = builder.getUnknownFields();
      }
      private TypedRow(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

      private static final TypedRow defaultInstance;
      public static TypedRow getDefaultInstance() {
        return defaultInstance;
      }

      public TypedRow getDefaultInstanceForType() {
        return defaultInstance;
      }

      private final com.google.protobuf.UnknownFieldSet unknownFields;
      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
          getUnknownFields() {
        return this.unknownFields;
      }
      private TypedRow(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        initFields();
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!parseUnknownField(input, unknownFields,
                                       extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
              case 10: {
                if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                  field_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxExpr.Expr>();
                  mutable_bitField0_ |= 0x00000001;
                }
                field_.add(input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpr.Expr.PARSER, extensionRegistry));
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e.getMessage()).setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
            field_ = java.util.Collections.unmodifiableList(field_);
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Insert_TypedRow_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Insert_TypedRow_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow.class, com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow.Builder.class);
      }

      public static com.google.protobuf.Parser<TypedRow> PARSER =
          new com.google.protobuf.AbstractParser<TypedRow>() {
        public TypedRow parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new TypedRow(input, extensionRegistry);
        }
      };

      @java.lang.Override
      public com.google.protobuf.Parser<TypedRow> getParserForType() {
        return PARSER;
      }

      public static final int FIELD_FIELD_NUMBER = 1;
      private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> field_;
      /**
       * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> getFieldList() {
        return field_;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
          getFieldOrBuilderList() {
        return field_;
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
       */
      public int getFieldCount() {
        return field_.size();
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getField(int index) {
        return field_.get(index);
      }
      /**
       * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getFieldOrBuilder(
          int index) {
        return field_.get(index);
      }

      private void initFields() {
        field_ = java.util.Collections.emptyList();
      }
      private byte memoizedIsInitialized = -1;
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        for (int i = 0; i < getFieldCount(); i++) {
          if (!getField(i).isInitialized()) {
            memoizedIsInitialized = 0;
            return false;
          }
        }
        memoizedIsInitialized = 1;
        return true;
      }

      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        getSerializedSize();
        for (int i = 0; i < field_.size(); i++) {
          output.writeMessage(1, field_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      private int memoizedSerializedSize = -1;
      public int getSerializedSize() {
        int size = memoizedSerializedSize;
        if (size != -1) return size;

        size = 0;
        for (int i = 0; i < field_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(1, field_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSerializedSize = size;
        return size;
      }

      private static final long serialVersionUID = 0L;
      @java.lang.Override
      protected java.lang.Object writeReplace()
          throws java.io.ObjectStreamException {
        return super.writeReplace();
      }

      public static com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return PARSER.parseFrom(input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return PARSER.parseFrom(input, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return PARSER.parseDelimitedFrom(input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return PARSER.parseDelimitedFrom(input, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return PARSER.parseFrom(input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return PARSER.parseFrom(input, extensionRegistry);
      }

      public static Builder newBuilder() { return Builder.create(); }
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow prototype) {
        return newBuilder().mergeFrom(prototype);
      }
      public Builder toBuilder() { return newBuilder(this); }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code Mysqlx.Crud.Insert.TypedRow}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessage.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:Mysqlx.Crud.Insert.TypedRow)
          com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRowOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Insert_TypedRow_descriptor;
        }

        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Insert_TypedRow_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow.class, com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow.Builder.class);
        }

        // Construct using com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
            getFieldFieldBuilder();
          }
        }
        private static Builder create() {
          return new Builder();
        }

        public Builder clear() {
          super.clear();
          if (fieldBuilder_ == null) {
            field_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            fieldBuilder_.clear();
          }
          return this;
        }

        public Builder clone() {
          return create().mergeFrom(buildPartial());
        }

        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Insert_TypedRow_descriptor;
        }

        public com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow getDefaultInstanceForType() {
          return com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow.getDefaultInstance();
        }

        public com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow build() {
          com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        public com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow buildPartial() {
          com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow result = new com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow(this);
          int from_bitField0_ = bitField0_;
          if (fieldBuilder_ == null) {
            if (((bitField0_ & 0x00000001) == 0x00000001)) {
              field_ = java.util.Collections.unmodifiableList(field_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.field_ = field_;
          } else {
            result.field_ = fieldBuilder_.build();
          }
          onBuilt();
          return result;
        }

        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow) {
            return mergeFrom((com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow other) {
          if (other == com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow.getDefaultInstance()) return this;
          if (fieldBuilder_ == null) {
            if (!other.field_.isEmpty()) {
              if (field_.isEmpty()) {
                field_ = other.field_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureFieldIsMutable();
                field_.addAll(other.field_);
              }
              onChanged();
            }
          } else {
            if (!other.field_.isEmpty()) {
              if (fieldBuilder_.isEmpty()) {
                fieldBuilder_.dispose();
                fieldBuilder_ = null;
                field_ = other.field_;
                bitField0_ = (bitField0_ & ~0x00000001);
                fieldBuilder_ = 
                  com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                     getFieldFieldBuilder() : null;
              } else {
                fieldBuilder_.addAllMessages(other.field_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          return this;
        }

        public final boolean isInitialized() {
          for (int i = 0; i < getFieldCount(); i++) {
            if (!getField(i).isInitialized()) {
              
              return false;
            }
          }
          return true;
        }

        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow) e.getUnfinishedMessage();
            throw e;
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> field_ =
          java.util.Collections.emptyList();
        private void ensureFieldIsMutable() {
          if (!((bitField0_ & 0x00000001) == 0x00000001)) {
            field_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxExpr.Expr>(field_);
            bitField0_ |= 0x00000001;
           }
        }

        private com.google.protobuf.RepeatedFieldBuilder<
            com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> fieldBuilder_;

        /**
         * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
         */
        public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr> getFieldList() {
          if (fieldBuilder_ == null) {
            return java.util.Collections.unmodifiableList(field_);
          } else {
            return fieldBuilder_.getMessageList();
          }
        }
        /**
         * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
         */
        public int getFieldCount() {
          if (fieldBuilder_ == null) {
            return field_.size();
          } else {
            return fieldBuilder_.getCount();
          }
        }
        /**
         * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getField(int index) {
          if (fieldBuilder_ == null) {
            return field_.get(index);
          } else {
            return fieldBuilder_.getMessage(index);
          }
        }
        /**
         * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
         */
        public Builder setField(
            int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
          if (fieldBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureFieldIsMutable();
            field_.set(index, value);
            onChanged();
          } else {
            fieldBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
         */
        public Builder setField(
            int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
          if (fieldBuilder_ == null) {
            ensureFieldIsMutable();
            field_.set(index, builderForValue.build());
            onChanged();
          } else {
            fieldBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
         */
        public Builder addField(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
          if (fieldBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureFieldIsMutable();
            field_.add(value);
            onChanged();
          } else {
            fieldBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
         */
        public Builder addField(
            int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
          if (fieldBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureFieldIsMutable();
            field_.add(index, value);
            onChanged();
          } else {
            fieldBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
         */
        public Builder addField(
            com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
          if (fieldBuilder_ == null) {
            ensureFieldIsMutable();
            field_.add(builderForValue.build());
            onChanged();
          } else {
            fieldBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
         */
        public Builder addField(
            int index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
          if (fieldBuilder_ == null) {
            ensureFieldIsMutable();
            field_.add(index, builderForValue.build());
            onChanged();
          } else {
            fieldBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
         */
        public Builder addAllField(
            java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxExpr.Expr> values) {
          if (fieldBuilder_ == null) {
            ensureFieldIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(
                values, field_);
            onChanged();
          } else {
            fieldBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
         */
        public Builder clearField() {
          if (fieldBuilder_ == null) {
            field_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            fieldBuilder_.clear();
          }
          return this;
        }
        /**
         * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
         */
        public Builder removeField(int index) {
          if (fieldBuilder_ == null) {
            ensureFieldIsMutable();
            field_.remove(index);
            onChanged();
          } else {
            fieldBuilder_.remove(index);
          }
          return this;
        }
        /**
         * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder getFieldBuilder(
            int index) {
          return getFieldFieldBuilder().getBuilder(index);
        }
        /**
         * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getFieldOrBuilder(
            int index) {
          if (fieldBuilder_ == null) {
            return field_.get(index);  } else {
            return fieldBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
         */
        public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
             getFieldOrBuilderList() {
          if (fieldBuilder_ != null) {
            return fieldBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(field_);
          }
        }
        /**
         * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder addFieldBuilder() {
          return getFieldFieldBuilder().addBuilder(
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance());
        }
        /**
         * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder addFieldBuilder(
            int index) {
          return getFieldFieldBuilder().addBuilder(
              index, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance());
        }
        /**
         * <code>repeated .Mysqlx.Expr.Expr field = 1;</code>
         */
        public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder> 
             getFieldBuilderList() {
          return getFieldFieldBuilder().getBuilderList();
        }
        private com.google.protobuf.RepeatedFieldBuilder<
            com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
            getFieldFieldBuilder() {
          if (fieldBuilder_ == null) {
            fieldBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
                com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder>(
                    field_,
                    ((bitField0_ & 0x00000001) == 0x00000001),
                    getParentForChildren(),
                    isClean());
            field_ = null;
          }
          return fieldBuilder_;
        }

        // @@protoc_insertion_point(builder_scope:Mysqlx.Crud.Insert.TypedRow)
      }

      static {
        defaultInstance = new TypedRow(true);
        defaultInstance.initFields();
      }

      // @@protoc_insertion_point(class_scope:Mysqlx.Crud.Insert.TypedRow)
    }

    private int bitField0_;
    public static final int COLLECTION_FIELD_NUMBER = 1;
    private com.mysql.cj.x.protobuf.MysqlxCrud.Collection collection_;
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    public boolean hasCollection() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.Collection getCollection() {
      return collection_;
    }
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder getCollectionOrBuilder() {
      return collection_;
    }

    public static final int DATA_MODEL_FIELD_NUMBER = 2;
    private com.mysql.cj.x.protobuf.MysqlxCrud.DataModel dataModel_;
    /**
     * <code>optional .Mysqlx.Crud.DataModel data_model = 2;</code>
     */
    public boolean hasDataModel() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .Mysqlx.Crud.DataModel data_model = 2;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.DataModel getDataModel() {
      return dataModel_;
    }

    public static final int PROJECTION_FIELD_NUMBER = 3;
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Column> projection_;
    /**
     * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
     */
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Column> getProjectionList() {
      return projection_;
    }
    /**
     * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
     */
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxCrud.ColumnOrBuilder> 
        getProjectionOrBuilderList() {
      return projection_;
    }
    /**
     * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
     */
    public int getProjectionCount() {
      return projection_.size();
    }
    /**
     * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.Column getProjection(int index) {
      return projection_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.ColumnOrBuilder getProjectionOrBuilder(
        int index) {
      return projection_.get(index);
    }

    public static final int ROW_FIELD_NUMBER = 4;
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow> row_;
    /**
     * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
     */
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow> getRowList() {
      return row_;
    }
    /**
     * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
     */
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRowOrBuilder> 
        getRowOrBuilderList() {
      return row_;
    }
    /**
     * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
     */
    public int getRowCount() {
      return row_.size();
    }
    /**
     * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow getRow(int index) {
      return row_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRowOrBuilder getRowOrBuilder(
        int index) {
      return row_.get(index);
    }

    public static final int ARGS_FIELD_NUMBER = 5;
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> args_;
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
     */
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> getArgsList() {
      return args_;
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
     */
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
        getArgsOrBuilderList() {
      return args_;
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
     */
    public int getArgsCount() {
      return args_.size();
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getArgs(int index) {
      return args_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getArgsOrBuilder(
        int index) {
      return args_.get(index);
    }

    public static final int UPSERT_FIELD_NUMBER = 6;
    private boolean upsert_;
    /**
     * <code>optional bool upsert = 6 [default = false];</code>
     */
    public boolean hasUpsert() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional bool upsert = 6 [default = false];</code>
     */
    public boolean getUpsert() {
      return upsert_;
    }

    private void initFields() {
      collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
      dataModel_ = com.mysql.cj.x.protobuf.MysqlxCrud.DataModel.DOCUMENT;
      projection_ = java.util.Collections.emptyList();
      row_ = java.util.Collections.emptyList();
      args_ = java.util.Collections.emptyList();
      upsert_ = false;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasCollection()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getCollection().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getProjectionCount(); i++) {
        if (!getProjection(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      for (int i = 0; i < getRowCount(); i++) {
        if (!getRow(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      for (int i = 0; i < getArgsCount(); i++) {
        if (!getArgs(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, collection_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeEnum(2, dataModel_.getNumber());
      }
      for (int i = 0; i < projection_.size(); i++) {
        output.writeMessage(3, projection_.get(i));
      }
      for (int i = 0; i < row_.size(); i++) {
        output.writeMessage(4, row_.get(i));
      }
      for (int i = 0; i < args_.size(); i++) {
        output.writeMessage(5, args_.get(i));
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBool(6, upsert_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, collection_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, dataModel_.getNumber());
      }
      for (int i = 0; i < projection_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, projection_.get(i));
      }
      for (int i = 0; i < row_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, row_.get(i));
      }
      for (int i = 0; i < args_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, args_.get(i));
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(6, upsert_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxCrud.Insert parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Insert parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Insert parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Insert parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Insert parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Insert parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Insert parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Insert parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Insert parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Insert parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxCrud.Insert prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Crud.Insert}
     *
     * <pre>
     * Insert documents/rows into a collection/table
     * :param collection: collection to insert into
     * :param data_model: datamodel that the operations refer to
     * :param projection: name of the columns to insert data into (empty if data_model is DOCUMENT)
     * :param row: set of rows to insert into the collection/table (a single expression with a JSON document literal or an OBJECT expression)
     * :param args: values for parameters used in row expressions
     * :param upsert: true if this should be treated as an Upsert (that is, update on duplicate key)
     * :Returns: :protobuf:msg:`Mysqlx.Resultset::`
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Crud.Insert)
        com.mysql.cj.x.protobuf.MysqlxCrud.InsertOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Insert_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Insert_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxCrud.Insert.class, com.mysql.cj.x.protobuf.MysqlxCrud.Insert.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxCrud.Insert.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getCollectionFieldBuilder();
          getProjectionFieldBuilder();
          getRowFieldBuilder();
          getArgsFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (collectionBuilder_ == null) {
          collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
        } else {
          collectionBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        dataModel_ = com.mysql.cj.x.protobuf.MysqlxCrud.DataModel.DOCUMENT;
        bitField0_ = (bitField0_ & ~0x00000002);
        if (projectionBuilder_ == null) {
          projection_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          projectionBuilder_.clear();
        }
        if (rowBuilder_ == null) {
          row_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          rowBuilder_.clear();
        }
        if (argsBuilder_ == null) {
          args_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          argsBuilder_.clear();
        }
        upsert_ = false;
        bitField0_ = (bitField0_ & ~0x00000020);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Insert_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Insert getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.Insert.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Insert build() {
        com.mysql.cj.x.protobuf.MysqlxCrud.Insert result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Insert buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxCrud.Insert result = new com.mysql.cj.x.protobuf.MysqlxCrud.Insert(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (collectionBuilder_ == null) {
          result.collection_ = collection_;
        } else {
          result.collection_ = collectionBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.dataModel_ = dataModel_;
        if (projectionBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)) {
            projection_ = java.util.Collections.unmodifiableList(projection_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.projection_ = projection_;
        } else {
          result.projection_ = projectionBuilder_.build();
        }
        if (rowBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008)) {
            row_ = java.util.Collections.unmodifiableList(row_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.row_ = row_;
        } else {
          result.row_ = rowBuilder_.build();
        }
        if (argsBuilder_ == null) {
          if (((bitField0_ & 0x00000010) == 0x00000010)) {
            args_ = java.util.Collections.unmodifiableList(args_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.args_ = args_;
        } else {
          result.args_ = argsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000004;
        }
        result.upsert_ = upsert_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxCrud.Insert) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxCrud.Insert)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxCrud.Insert other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxCrud.Insert.getDefaultInstance()) return this;
        if (other.hasCollection()) {
          mergeCollection(other.getCollection());
        }
        if (other.hasDataModel()) {
          setDataModel(other.getDataModel());
        }
        if (projectionBuilder_ == null) {
          if (!other.projection_.isEmpty()) {
            if (projection_.isEmpty()) {
              projection_ = other.projection_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureProjectionIsMutable();
              projection_.addAll(other.projection_);
            }
            onChanged();
          }
        } else {
          if (!other.projection_.isEmpty()) {
            if (projectionBuilder_.isEmpty()) {
              projectionBuilder_.dispose();
              projectionBuilder_ = null;
              projection_ = other.projection_;
              bitField0_ = (bitField0_ & ~0x00000004);
              projectionBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getProjectionFieldBuilder() : null;
            } else {
              projectionBuilder_.addAllMessages(other.projection_);
            }
          }
        }
        if (rowBuilder_ == null) {
          if (!other.row_.isEmpty()) {
            if (row_.isEmpty()) {
              row_ = other.row_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureRowIsMutable();
              row_.addAll(other.row_);
            }
            onChanged();
          }
        } else {
          if (!other.row_.isEmpty()) {
            if (rowBuilder_.isEmpty()) {
              rowBuilder_.dispose();
              rowBuilder_ = null;
              row_ = other.row_;
              bitField0_ = (bitField0_ & ~0x00000008);
              rowBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getRowFieldBuilder() : null;
            } else {
              rowBuilder_.addAllMessages(other.row_);
            }
          }
        }
        if (argsBuilder_ == null) {
          if (!other.args_.isEmpty()) {
            if (args_.isEmpty()) {
              args_ = other.args_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensureArgsIsMutable();
              args_.addAll(other.args_);
            }
            onChanged();
          }
        } else {
          if (!other.args_.isEmpty()) {
            if (argsBuilder_.isEmpty()) {
              argsBuilder_.dispose();
              argsBuilder_ = null;
              args_ = other.args_;
              bitField0_ = (bitField0_ & ~0x00000010);
              argsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getArgsFieldBuilder() : null;
            } else {
              argsBuilder_.addAllMessages(other.args_);
            }
          }
        }
        if (other.hasUpsert()) {
          setUpsert(other.getUpsert());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasCollection()) {
          
          return false;
        }
        if (!getCollection().isInitialized()) {
          
          return false;
        }
        for (int i = 0; i < getProjectionCount(); i++) {
          if (!getProjection(i).isInitialized()) {
            
            return false;
          }
        }
        for (int i = 0; i < getRowCount(); i++) {
          if (!getRow(i).isInitialized()) {
            
            return false;
          }
        }
        for (int i = 0; i < getArgsCount(); i++) {
          if (!getArgs(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxCrud.Insert parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxCrud.Insert) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.mysql.cj.x.protobuf.MysqlxCrud.Collection collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Collection, com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder> collectionBuilder_;
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public boolean hasCollection() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Collection getCollection() {
        if (collectionBuilder_ == null) {
          return collection_;
        } else {
          return collectionBuilder_.getMessage();
        }
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public Builder setCollection(com.mysql.cj.x.protobuf.MysqlxCrud.Collection value) {
        if (collectionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          collection_ = value;
          onChanged();
        } else {
          collectionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public Builder setCollection(
          com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder builderForValue) {
        if (collectionBuilder_ == null) {
          collection_ = builderForValue.build();
          onChanged();
        } else {
          collectionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public Builder mergeCollection(com.mysql.cj.x.protobuf.MysqlxCrud.Collection value) {
        if (collectionBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              collection_ != com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance()) {
            collection_ =
              com.mysql.cj.x.protobuf.MysqlxCrud.Collection.newBuilder(collection_).mergeFrom(value).buildPartial();
          } else {
            collection_ = value;
          }
          onChanged();
        } else {
          collectionBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public Builder clearCollection() {
        if (collectionBuilder_ == null) {
          collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
          onChanged();
        } else {
          collectionBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder getCollectionBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getCollectionFieldBuilder().getBuilder();
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder getCollectionOrBuilder() {
        if (collectionBuilder_ != null) {
          return collectionBuilder_.getMessageOrBuilder();
        } else {
          return collection_;
        }
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Collection, com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder> 
          getCollectionFieldBuilder() {
        if (collectionBuilder_ == null) {
          collectionBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxCrud.Collection, com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder>(
                  getCollection(),
                  getParentForChildren(),
                  isClean());
          collection_ = null;
        }
        return collectionBuilder_;
      }

      private com.mysql.cj.x.protobuf.MysqlxCrud.DataModel dataModel_ = com.mysql.cj.x.protobuf.MysqlxCrud.DataModel.DOCUMENT;
      /**
       * <code>optional .Mysqlx.Crud.DataModel data_model = 2;</code>
       */
      public boolean hasDataModel() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .Mysqlx.Crud.DataModel data_model = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.DataModel getDataModel() {
        return dataModel_;
      }
      /**
       * <code>optional .Mysqlx.Crud.DataModel data_model = 2;</code>
       */
      public Builder setDataModel(com.mysql.cj.x.protobuf.MysqlxCrud.DataModel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        dataModel_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.DataModel data_model = 2;</code>
       */
      public Builder clearDataModel() {
        bitField0_ = (bitField0_ & ~0x00000002);
        dataModel_ = com.mysql.cj.x.protobuf.MysqlxCrud.DataModel.DOCUMENT;
        onChanged();
        return this;
      }

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Column> projection_ =
        java.util.Collections.emptyList();
      private void ensureProjectionIsMutable() {
        if (!((bitField0_ & 0x00000004) == 0x00000004)) {
          projection_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxCrud.Column>(projection_);
          bitField0_ |= 0x00000004;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Column, com.mysql.cj.x.protobuf.MysqlxCrud.Column.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.ColumnOrBuilder> projectionBuilder_;

      /**
       * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Column> getProjectionList() {
        if (projectionBuilder_ == null) {
          return java.util.Collections.unmodifiableList(projection_);
        } else {
          return projectionBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
       */
      public int getProjectionCount() {
        if (projectionBuilder_ == null) {
          return projection_.size();
        } else {
          return projectionBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Column getProjection(int index) {
        if (projectionBuilder_ == null) {
          return projection_.get(index);
        } else {
          return projectionBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
       */
      public Builder setProjection(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Column value) {
        if (projectionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureProjectionIsMutable();
          projection_.set(index, value);
          onChanged();
        } else {
          projectionBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
       */
      public Builder setProjection(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Column.Builder builderForValue) {
        if (projectionBuilder_ == null) {
          ensureProjectionIsMutable();
          projection_.set(index, builderForValue.build());
          onChanged();
        } else {
          projectionBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
       */
      public Builder addProjection(com.mysql.cj.x.protobuf.MysqlxCrud.Column value) {
        if (projectionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureProjectionIsMutable();
          projection_.add(value);
          onChanged();
        } else {
          projectionBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
       */
      public Builder addProjection(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Column value) {
        if (projectionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureProjectionIsMutable();
          projection_.add(index, value);
          onChanged();
        } else {
          projectionBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
       */
      public Builder addProjection(
          com.mysql.cj.x.protobuf.MysqlxCrud.Column.Builder builderForValue) {
        if (projectionBuilder_ == null) {
          ensureProjectionIsMutable();
          projection_.add(builderForValue.build());
          onChanged();
        } else {
          projectionBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
       */
      public Builder addProjection(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Column.Builder builderForValue) {
        if (projectionBuilder_ == null) {
          ensureProjectionIsMutable();
          projection_.add(index, builderForValue.build());
          onChanged();
        } else {
          projectionBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
       */
      public Builder addAllProjection(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxCrud.Column> values) {
        if (projectionBuilder_ == null) {
          ensureProjectionIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, projection_);
          onChanged();
        } else {
          projectionBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
       */
      public Builder clearProjection() {
        if (projectionBuilder_ == null) {
          projection_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          projectionBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
       */
      public Builder removeProjection(int index) {
        if (projectionBuilder_ == null) {
          ensureProjectionIsMutable();
          projection_.remove(index);
          onChanged();
        } else {
          projectionBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Column.Builder getProjectionBuilder(
          int index) {
        return getProjectionFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.ColumnOrBuilder getProjectionOrBuilder(
          int index) {
        if (projectionBuilder_ == null) {
          return projection_.get(index);  } else {
          return projectionBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxCrud.ColumnOrBuilder> 
           getProjectionOrBuilderList() {
        if (projectionBuilder_ != null) {
          return projectionBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(projection_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Column.Builder addProjectionBuilder() {
        return getProjectionFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxCrud.Column.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Column.Builder addProjectionBuilder(
          int index) {
        return getProjectionFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxCrud.Column.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Crud.Column projection = 3;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Column.Builder> 
           getProjectionBuilderList() {
        return getProjectionFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Column, com.mysql.cj.x.protobuf.MysqlxCrud.Column.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.ColumnOrBuilder> 
          getProjectionFieldBuilder() {
        if (projectionBuilder_ == null) {
          projectionBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxCrud.Column, com.mysql.cj.x.protobuf.MysqlxCrud.Column.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.ColumnOrBuilder>(
                  projection_,
                  ((bitField0_ & 0x00000004) == 0x00000004),
                  getParentForChildren(),
                  isClean());
          projection_ = null;
        }
        return projectionBuilder_;
      }

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow> row_ =
        java.util.Collections.emptyList();
      private void ensureRowIsMutable() {
        if (!((bitField0_ & 0x00000008) == 0x00000008)) {
          row_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow>(row_);
          bitField0_ |= 0x00000008;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow, com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRowOrBuilder> rowBuilder_;

      /**
       * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow> getRowList() {
        if (rowBuilder_ == null) {
          return java.util.Collections.unmodifiableList(row_);
        } else {
          return rowBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
       */
      public int getRowCount() {
        if (rowBuilder_ == null) {
          return row_.size();
        } else {
          return rowBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow getRow(int index) {
        if (rowBuilder_ == null) {
          return row_.get(index);
        } else {
          return rowBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
       */
      public Builder setRow(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow value) {
        if (rowBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRowIsMutable();
          row_.set(index, value);
          onChanged();
        } else {
          rowBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
       */
      public Builder setRow(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow.Builder builderForValue) {
        if (rowBuilder_ == null) {
          ensureRowIsMutable();
          row_.set(index, builderForValue.build());
          onChanged();
        } else {
          rowBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
       */
      public Builder addRow(com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow value) {
        if (rowBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRowIsMutable();
          row_.add(value);
          onChanged();
        } else {
          rowBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
       */
      public Builder addRow(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow value) {
        if (rowBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRowIsMutable();
          row_.add(index, value);
          onChanged();
        } else {
          rowBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
       */
      public Builder addRow(
          com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow.Builder builderForValue) {
        if (rowBuilder_ == null) {
          ensureRowIsMutable();
          row_.add(builderForValue.build());
          onChanged();
        } else {
          rowBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
       */
      public Builder addRow(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow.Builder builderForValue) {
        if (rowBuilder_ == null) {
          ensureRowIsMutable();
          row_.add(index, builderForValue.build());
          onChanged();
        } else {
          rowBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
       */
      public Builder addAllRow(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow> values) {
        if (rowBuilder_ == null) {
          ensureRowIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, row_);
          onChanged();
        } else {
          rowBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
       */
      public Builder clearRow() {
        if (rowBuilder_ == null) {
          row_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          rowBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
       */
      public Builder removeRow(int index) {
        if (rowBuilder_ == null) {
          ensureRowIsMutable();
          row_.remove(index);
          onChanged();
        } else {
          rowBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow.Builder getRowBuilder(
          int index) {
        return getRowFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRowOrBuilder getRowOrBuilder(
          int index) {
        if (rowBuilder_ == null) {
          return row_.get(index);  } else {
          return rowBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRowOrBuilder> 
           getRowOrBuilderList() {
        if (rowBuilder_ != null) {
          return rowBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(row_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow.Builder addRowBuilder() {
        return getRowFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow.Builder addRowBuilder(
          int index) {
        return getRowFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Crud.Insert.TypedRow row = 4;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow.Builder> 
           getRowBuilderList() {
        return getRowFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow, com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRowOrBuilder> 
          getRowFieldBuilder() {
        if (rowBuilder_ == null) {
          rowBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow, com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRow.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.Insert.TypedRowOrBuilder>(
                  row_,
                  ((bitField0_ & 0x00000008) == 0x00000008),
                  getParentForChildren(),
                  isClean());
          row_ = null;
        }
        return rowBuilder_;
      }

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> args_ =
        java.util.Collections.emptyList();
      private void ensureArgsIsMutable() {
        if (!((bitField0_ & 0x00000010) == 0x00000010)) {
          args_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar>(args_);
          bitField0_ |= 0x00000010;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> argsBuilder_;

      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> getArgsList() {
        if (argsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(args_);
        } else {
          return argsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
       */
      public int getArgsCount() {
        if (argsBuilder_ == null) {
          return args_.size();
        } else {
          return argsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getArgs(int index) {
        if (argsBuilder_ == null) {
          return args_.get(index);
        } else {
          return argsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
       */
      public Builder setArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.set(index, value);
          onChanged();
        } else {
          argsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
       */
      public Builder setArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.set(index, builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
       */
      public Builder addArgs(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.add(value);
          onChanged();
        } else {
          argsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
       */
      public Builder addArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.add(index, value);
          onChanged();
        } else {
          argsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
       */
      public Builder addArgs(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.add(builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
       */
      public Builder addArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.add(index, builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
       */
      public Builder addAllArgs(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> values) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, args_);
          onChanged();
        } else {
          argsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
       */
      public Builder clearArgs() {
        if (argsBuilder_ == null) {
          args_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          argsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
       */
      public Builder removeArgs(int index) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.remove(index);
          onChanged();
        } else {
          argsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder getArgsBuilder(
          int index) {
        return getArgsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getArgsOrBuilder(
          int index) {
        if (argsBuilder_ == null) {
          return args_.get(index);  } else {
          return argsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
           getArgsOrBuilderList() {
        if (argsBuilder_ != null) {
          return argsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(args_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder addArgsBuilder() {
        return getArgsFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder addArgsBuilder(
          int index) {
        return getArgsFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 5;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder> 
           getArgsBuilderList() {
        return getArgsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
          getArgsFieldBuilder() {
        if (argsBuilder_ == null) {
          argsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder>(
                  args_,
                  ((bitField0_ & 0x00000010) == 0x00000010),
                  getParentForChildren(),
                  isClean());
          args_ = null;
        }
        return argsBuilder_;
      }

      private boolean upsert_ ;
      /**
       * <code>optional bool upsert = 6 [default = false];</code>
       */
      public boolean hasUpsert() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>optional bool upsert = 6 [default = false];</code>
       */
      public boolean getUpsert() {
        return upsert_;
      }
      /**
       * <code>optional bool upsert = 6 [default = false];</code>
       */
      public Builder setUpsert(boolean value) {
        bitField0_ |= 0x00000020;
        upsert_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool upsert = 6 [default = false];</code>
       */
      public Builder clearUpsert() {
        bitField0_ = (bitField0_ & ~0x00000020);
        upsert_ = false;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Crud.Insert)
    }

    static {
      defaultInstance = new Insert(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Crud.Insert)
  }

  public interface UpdateOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Crud.Update)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
     */
    boolean hasCollection();
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.Collection getCollection();
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder getCollectionOrBuilder();

    /**
     * <code>optional .Mysqlx.Crud.DataModel data_model = 3;</code>
     */
    boolean hasDataModel();
    /**
     * <code>optional .Mysqlx.Crud.DataModel data_model = 3;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.DataModel getDataModel();

    /**
     * <code>optional .Mysqlx.Expr.Expr criteria = 4;</code>
     */
    boolean hasCriteria();
    /**
     * <code>optional .Mysqlx.Expr.Expr criteria = 4;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Expr getCriteria();
    /**
     * <code>optional .Mysqlx.Expr.Expr criteria = 4;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getCriteriaOrBuilder();

    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> 
        getArgsList();
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getArgs(int index);
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
     */
    int getArgsCount();
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
        getArgsOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getArgsOrBuilder(
        int index);

    /**
     * <code>optional .Mysqlx.Crud.Limit limit = 5;</code>
     */
    boolean hasLimit();
    /**
     * <code>optional .Mysqlx.Crud.Limit limit = 5;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.Limit getLimit();
    /**
     * <code>optional .Mysqlx.Crud.Limit limit = 5;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.LimitOrBuilder getLimitOrBuilder();

    /**
     * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Order> 
        getOrderList();
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.Order getOrder(int index);
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
     */
    int getOrderCount();
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder> 
        getOrderOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder getOrderOrBuilder(
        int index);

    /**
     * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation> 
        getOperationList();
    /**
     * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation getOperation(int index);
    /**
     * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
     */
    int getOperationCount();
    /**
     * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperationOrBuilder> 
        getOperationOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperationOrBuilder getOperationOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code Mysqlx.Crud.Update}
   *
   * <pre>
   * Update documents/rows in a collection/table
   * :param collection: collection to change
   * :param data_model: datamodel that the operations refer to
   * :param criteria: filter expression to match rows that the operations will apply on
   * :param args: values for parameters used in filter expression
   * :param limit: limits the number of rows to match
   * :param order: specifies order of matched rows
   * :param operation: list of operations to be applied. Valid operations will depend on the data_model.
   * :Returns: :protobuf:msg:`Mysqlx.Resultset::`
   * </pre>
   */
  public static final class Update extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Crud.Update)
      UpdateOrBuilder {
    // Use Update.newBuilder() to construct.
    private Update(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Update(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Update defaultInstance;
    public static Update getDefaultInstance() {
      return defaultInstance;
    }

    public Update getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Update(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 18: {
              com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = collection_.toBuilder();
              }
              collection_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxCrud.Collection.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(collection_);
                collection_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 24: {
              int rawValue = input.readEnum();
              com.mysql.cj.x.protobuf.MysqlxCrud.DataModel value = com.mysql.cj.x.protobuf.MysqlxCrud.DataModel.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(3, rawValue);
              } else {
                bitField0_ |= 0x00000002;
                dataModel_ = value;
              }
              break;
            }
            case 34: {
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder subBuilder = null;
              if (((bitField0_ & 0x00000004) == 0x00000004)) {
                subBuilder = criteria_.toBuilder();
              }
              criteria_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpr.Expr.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(criteria_);
                criteria_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000004;
              break;
            }
            case 42: {
              com.mysql.cj.x.protobuf.MysqlxCrud.Limit.Builder subBuilder = null;
              if (((bitField0_ & 0x00000008) == 0x00000008)) {
                subBuilder = limit_.toBuilder();
              }
              limit_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxCrud.Limit.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(limit_);
                limit_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000008;
              break;
            }
            case 50: {
              if (!((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
                order_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxCrud.Order>();
                mutable_bitField0_ |= 0x00000020;
              }
              order_.add(input.readMessage(com.mysql.cj.x.protobuf.MysqlxCrud.Order.PARSER, extensionRegistry));
              break;
            }
            case 58: {
              if (!((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
                operation_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation>();
                mutable_bitField0_ |= 0x00000040;
              }
              operation_.add(input.readMessage(com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.PARSER, extensionRegistry));
              break;
            }
            case 66: {
              if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
                args_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar>();
                mutable_bitField0_ |= 0x00000008;
              }
              args_.add(input.readMessage(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
          order_ = java.util.Collections.unmodifiableList(order_);
        }
        if (((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
          operation_ = java.util.Collections.unmodifiableList(operation_);
        }
        if (((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
          args_ = java.util.Collections.unmodifiableList(args_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Update_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Update_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxCrud.Update.class, com.mysql.cj.x.protobuf.MysqlxCrud.Update.Builder.class);
    }

    public static com.google.protobuf.Parser<Update> PARSER =
        new com.google.protobuf.AbstractParser<Update>() {
      public Update parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Update(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Update> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int COLLECTION_FIELD_NUMBER = 2;
    private com.mysql.cj.x.protobuf.MysqlxCrud.Collection collection_;
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
     */
    public boolean hasCollection() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.Collection getCollection() {
      return collection_;
    }
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder getCollectionOrBuilder() {
      return collection_;
    }

    public static final int DATA_MODEL_FIELD_NUMBER = 3;
    private com.mysql.cj.x.protobuf.MysqlxCrud.DataModel dataModel_;
    /**
     * <code>optional .Mysqlx.Crud.DataModel data_model = 3;</code>
     */
    public boolean hasDataModel() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .Mysqlx.Crud.DataModel data_model = 3;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.DataModel getDataModel() {
      return dataModel_;
    }

    public static final int CRITERIA_FIELD_NUMBER = 4;
    private com.mysql.cj.x.protobuf.MysqlxExpr.Expr criteria_;
    /**
     * <code>optional .Mysqlx.Expr.Expr criteria = 4;</code>
     */
    public boolean hasCriteria() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional .Mysqlx.Expr.Expr criteria = 4;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getCriteria() {
      return criteria_;
    }
    /**
     * <code>optional .Mysqlx.Expr.Expr criteria = 4;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getCriteriaOrBuilder() {
      return criteria_;
    }

    public static final int ARGS_FIELD_NUMBER = 8;
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> args_;
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
     */
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> getArgsList() {
      return args_;
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
     */
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
        getArgsOrBuilderList() {
      return args_;
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
     */
    public int getArgsCount() {
      return args_.size();
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getArgs(int index) {
      return args_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getArgsOrBuilder(
        int index) {
      return args_.get(index);
    }

    public static final int LIMIT_FIELD_NUMBER = 5;
    private com.mysql.cj.x.protobuf.MysqlxCrud.Limit limit_;
    /**
     * <code>optional .Mysqlx.Crud.Limit limit = 5;</code>
     */
    public boolean hasLimit() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional .Mysqlx.Crud.Limit limit = 5;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.Limit getLimit() {
      return limit_;
    }
    /**
     * <code>optional .Mysqlx.Crud.Limit limit = 5;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.LimitOrBuilder getLimitOrBuilder() {
      return limit_;
    }

    public static final int ORDER_FIELD_NUMBER = 6;
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Order> order_;
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
     */
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Order> getOrderList() {
      return order_;
    }
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
     */
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder> 
        getOrderOrBuilderList() {
      return order_;
    }
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
     */
    public int getOrderCount() {
      return order_.size();
    }
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.Order getOrder(int index) {
      return order_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder getOrderOrBuilder(
        int index) {
      return order_.get(index);
    }

    public static final int OPERATION_FIELD_NUMBER = 7;
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation> operation_;
    /**
     * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
     */
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation> getOperationList() {
      return operation_;
    }
    /**
     * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
     */
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperationOrBuilder> 
        getOperationOrBuilderList() {
      return operation_;
    }
    /**
     * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
     */
    public int getOperationCount() {
      return operation_.size();
    }
    /**
     * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation getOperation(int index) {
      return operation_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperationOrBuilder getOperationOrBuilder(
        int index) {
      return operation_.get(index);
    }

    private void initFields() {
      collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
      dataModel_ = com.mysql.cj.x.protobuf.MysqlxCrud.DataModel.DOCUMENT;
      criteria_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
      args_ = java.util.Collections.emptyList();
      limit_ = com.mysql.cj.x.protobuf.MysqlxCrud.Limit.getDefaultInstance();
      order_ = java.util.Collections.emptyList();
      operation_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasCollection()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getCollection().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (hasCriteria()) {
        if (!getCriteria().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      for (int i = 0; i < getArgsCount(); i++) {
        if (!getArgs(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasLimit()) {
        if (!getLimit().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      for (int i = 0; i < getOrderCount(); i++) {
        if (!getOrder(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      for (int i = 0; i < getOperationCount(); i++) {
        if (!getOperation(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(2, collection_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeEnum(3, dataModel_.getNumber());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(4, criteria_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeMessage(5, limit_);
      }
      for (int i = 0; i < order_.size(); i++) {
        output.writeMessage(6, order_.get(i));
      }
      for (int i = 0; i < operation_.size(); i++) {
        output.writeMessage(7, operation_.get(i));
      }
      for (int i = 0; i < args_.size(); i++) {
        output.writeMessage(8, args_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, collection_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(3, dataModel_.getNumber());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, criteria_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, limit_);
      }
      for (int i = 0; i < order_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, order_.get(i));
      }
      for (int i = 0; i < operation_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, operation_.get(i));
      }
      for (int i = 0; i < args_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(8, args_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxCrud.Update parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Update parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Update parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Update parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Update parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Update parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Update parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Update parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Update parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Update parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxCrud.Update prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Crud.Update}
     *
     * <pre>
     * Update documents/rows in a collection/table
     * :param collection: collection to change
     * :param data_model: datamodel that the operations refer to
     * :param criteria: filter expression to match rows that the operations will apply on
     * :param args: values for parameters used in filter expression
     * :param limit: limits the number of rows to match
     * :param order: specifies order of matched rows
     * :param operation: list of operations to be applied. Valid operations will depend on the data_model.
     * :Returns: :protobuf:msg:`Mysqlx.Resultset::`
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Crud.Update)
        com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Update_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Update_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxCrud.Update.class, com.mysql.cj.x.protobuf.MysqlxCrud.Update.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxCrud.Update.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getCollectionFieldBuilder();
          getCriteriaFieldBuilder();
          getArgsFieldBuilder();
          getLimitFieldBuilder();
          getOrderFieldBuilder();
          getOperationFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (collectionBuilder_ == null) {
          collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
        } else {
          collectionBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        dataModel_ = com.mysql.cj.x.protobuf.MysqlxCrud.DataModel.DOCUMENT;
        bitField0_ = (bitField0_ & ~0x00000002);
        if (criteriaBuilder_ == null) {
          criteria_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
        } else {
          criteriaBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        if (argsBuilder_ == null) {
          args_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          argsBuilder_.clear();
        }
        if (limitBuilder_ == null) {
          limit_ = com.mysql.cj.x.protobuf.MysqlxCrud.Limit.getDefaultInstance();
        } else {
          limitBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        if (orderBuilder_ == null) {
          order_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000020);
        } else {
          orderBuilder_.clear();
        }
        if (operationBuilder_ == null) {
          operation_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000040);
        } else {
          operationBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Update_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Update getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.Update.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Update build() {
        com.mysql.cj.x.protobuf.MysqlxCrud.Update result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Update buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxCrud.Update result = new com.mysql.cj.x.protobuf.MysqlxCrud.Update(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (collectionBuilder_ == null) {
          result.collection_ = collection_;
        } else {
          result.collection_ = collectionBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.dataModel_ = dataModel_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (criteriaBuilder_ == null) {
          result.criteria_ = criteria_;
        } else {
          result.criteria_ = criteriaBuilder_.build();
        }
        if (argsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008)) {
            args_ = java.util.Collections.unmodifiableList(args_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.args_ = args_;
        } else {
          result.args_ = argsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000008;
        }
        if (limitBuilder_ == null) {
          result.limit_ = limit_;
        } else {
          result.limit_ = limitBuilder_.build();
        }
        if (orderBuilder_ == null) {
          if (((bitField0_ & 0x00000020) == 0x00000020)) {
            order_ = java.util.Collections.unmodifiableList(order_);
            bitField0_ = (bitField0_ & ~0x00000020);
          }
          result.order_ = order_;
        } else {
          result.order_ = orderBuilder_.build();
        }
        if (operationBuilder_ == null) {
          if (((bitField0_ & 0x00000040) == 0x00000040)) {
            operation_ = java.util.Collections.unmodifiableList(operation_);
            bitField0_ = (bitField0_ & ~0x00000040);
          }
          result.operation_ = operation_;
        } else {
          result.operation_ = operationBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxCrud.Update) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxCrud.Update)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxCrud.Update other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxCrud.Update.getDefaultInstance()) return this;
        if (other.hasCollection()) {
          mergeCollection(other.getCollection());
        }
        if (other.hasDataModel()) {
          setDataModel(other.getDataModel());
        }
        if (other.hasCriteria()) {
          mergeCriteria(other.getCriteria());
        }
        if (argsBuilder_ == null) {
          if (!other.args_.isEmpty()) {
            if (args_.isEmpty()) {
              args_ = other.args_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureArgsIsMutable();
              args_.addAll(other.args_);
            }
            onChanged();
          }
        } else {
          if (!other.args_.isEmpty()) {
            if (argsBuilder_.isEmpty()) {
              argsBuilder_.dispose();
              argsBuilder_ = null;
              args_ = other.args_;
              bitField0_ = (bitField0_ & ~0x00000008);
              argsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getArgsFieldBuilder() : null;
            } else {
              argsBuilder_.addAllMessages(other.args_);
            }
          }
        }
        if (other.hasLimit()) {
          mergeLimit(other.getLimit());
        }
        if (orderBuilder_ == null) {
          if (!other.order_.isEmpty()) {
            if (order_.isEmpty()) {
              order_ = other.order_;
              bitField0_ = (bitField0_ & ~0x00000020);
            } else {
              ensureOrderIsMutable();
              order_.addAll(other.order_);
            }
            onChanged();
          }
        } else {
          if (!other.order_.isEmpty()) {
            if (orderBuilder_.isEmpty()) {
              orderBuilder_.dispose();
              orderBuilder_ = null;
              order_ = other.order_;
              bitField0_ = (bitField0_ & ~0x00000020);
              orderBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getOrderFieldBuilder() : null;
            } else {
              orderBuilder_.addAllMessages(other.order_);
            }
          }
        }
        if (operationBuilder_ == null) {
          if (!other.operation_.isEmpty()) {
            if (operation_.isEmpty()) {
              operation_ = other.operation_;
              bitField0_ = (bitField0_ & ~0x00000040);
            } else {
              ensureOperationIsMutable();
              operation_.addAll(other.operation_);
            }
            onChanged();
          }
        } else {
          if (!other.operation_.isEmpty()) {
            if (operationBuilder_.isEmpty()) {
              operationBuilder_.dispose();
              operationBuilder_ = null;
              operation_ = other.operation_;
              bitField0_ = (bitField0_ & ~0x00000040);
              operationBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getOperationFieldBuilder() : null;
            } else {
              operationBuilder_.addAllMessages(other.operation_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasCollection()) {
          
          return false;
        }
        if (!getCollection().isInitialized()) {
          
          return false;
        }
        if (hasCriteria()) {
          if (!getCriteria().isInitialized()) {
            
            return false;
          }
        }
        for (int i = 0; i < getArgsCount(); i++) {
          if (!getArgs(i).isInitialized()) {
            
            return false;
          }
        }
        if (hasLimit()) {
          if (!getLimit().isInitialized()) {
            
            return false;
          }
        }
        for (int i = 0; i < getOrderCount(); i++) {
          if (!getOrder(i).isInitialized()) {
            
            return false;
          }
        }
        for (int i = 0; i < getOperationCount(); i++) {
          if (!getOperation(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxCrud.Update parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxCrud.Update) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.mysql.cj.x.protobuf.MysqlxCrud.Collection collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Collection, com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder> collectionBuilder_;
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
       */
      public boolean hasCollection() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Collection getCollection() {
        if (collectionBuilder_ == null) {
          return collection_;
        } else {
          return collectionBuilder_.getMessage();
        }
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
       */
      public Builder setCollection(com.mysql.cj.x.protobuf.MysqlxCrud.Collection value) {
        if (collectionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          collection_ = value;
          onChanged();
        } else {
          collectionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
       */
      public Builder setCollection(
          com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder builderForValue) {
        if (collectionBuilder_ == null) {
          collection_ = builderForValue.build();
          onChanged();
        } else {
          collectionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
       */
      public Builder mergeCollection(com.mysql.cj.x.protobuf.MysqlxCrud.Collection value) {
        if (collectionBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              collection_ != com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance()) {
            collection_ =
              com.mysql.cj.x.protobuf.MysqlxCrud.Collection.newBuilder(collection_).mergeFrom(value).buildPartial();
          } else {
            collection_ = value;
          }
          onChanged();
        } else {
          collectionBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
       */
      public Builder clearCollection() {
        if (collectionBuilder_ == null) {
          collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
          onChanged();
        } else {
          collectionBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder getCollectionBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getCollectionFieldBuilder().getBuilder();
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder getCollectionOrBuilder() {
        if (collectionBuilder_ != null) {
          return collectionBuilder_.getMessageOrBuilder();
        } else {
          return collection_;
        }
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Collection, com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder> 
          getCollectionFieldBuilder() {
        if (collectionBuilder_ == null) {
          collectionBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxCrud.Collection, com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder>(
                  getCollection(),
                  getParentForChildren(),
                  isClean());
          collection_ = null;
        }
        return collectionBuilder_;
      }

      private com.mysql.cj.x.protobuf.MysqlxCrud.DataModel dataModel_ = com.mysql.cj.x.protobuf.MysqlxCrud.DataModel.DOCUMENT;
      /**
       * <code>optional .Mysqlx.Crud.DataModel data_model = 3;</code>
       */
      public boolean hasDataModel() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .Mysqlx.Crud.DataModel data_model = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.DataModel getDataModel() {
        return dataModel_;
      }
      /**
       * <code>optional .Mysqlx.Crud.DataModel data_model = 3;</code>
       */
      public Builder setDataModel(com.mysql.cj.x.protobuf.MysqlxCrud.DataModel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        dataModel_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.DataModel data_model = 3;</code>
       */
      public Builder clearDataModel() {
        bitField0_ = (bitField0_ & ~0x00000002);
        dataModel_ = com.mysql.cj.x.protobuf.MysqlxCrud.DataModel.DOCUMENT;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxExpr.Expr criteria_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> criteriaBuilder_;
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 4;</code>
       */
      public boolean hasCriteria() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getCriteria() {
        if (criteriaBuilder_ == null) {
          return criteria_;
        } else {
          return criteriaBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 4;</code>
       */
      public Builder setCriteria(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (criteriaBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          criteria_ = value;
          onChanged();
        } else {
          criteriaBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 4;</code>
       */
      public Builder setCriteria(
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (criteriaBuilder_ == null) {
          criteria_ = builderForValue.build();
          onChanged();
        } else {
          criteriaBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 4;</code>
       */
      public Builder mergeCriteria(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (criteriaBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004) &&
              criteria_ != com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance()) {
            criteria_ =
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr.newBuilder(criteria_).mergeFrom(value).buildPartial();
          } else {
            criteria_ = value;
          }
          onChanged();
        } else {
          criteriaBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 4;</code>
       */
      public Builder clearCriteria() {
        if (criteriaBuilder_ == null) {
          criteria_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
          onChanged();
        } else {
          criteriaBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder getCriteriaBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getCriteriaFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getCriteriaOrBuilder() {
        if (criteriaBuilder_ != null) {
          return criteriaBuilder_.getMessageOrBuilder();
        } else {
          return criteria_;
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
          getCriteriaFieldBuilder() {
        if (criteriaBuilder_ == null) {
          criteriaBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder>(
                  getCriteria(),
                  getParentForChildren(),
                  isClean());
          criteria_ = null;
        }
        return criteriaBuilder_;
      }

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> args_ =
        java.util.Collections.emptyList();
      private void ensureArgsIsMutable() {
        if (!((bitField0_ & 0x00000008) == 0x00000008)) {
          args_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar>(args_);
          bitField0_ |= 0x00000008;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> argsBuilder_;

      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> getArgsList() {
        if (argsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(args_);
        } else {
          return argsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
       */
      public int getArgsCount() {
        if (argsBuilder_ == null) {
          return args_.size();
        } else {
          return argsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getArgs(int index) {
        if (argsBuilder_ == null) {
          return args_.get(index);
        } else {
          return argsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
       */
      public Builder setArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.set(index, value);
          onChanged();
        } else {
          argsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
       */
      public Builder setArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.set(index, builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
       */
      public Builder addArgs(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.add(value);
          onChanged();
        } else {
          argsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
       */
      public Builder addArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.add(index, value);
          onChanged();
        } else {
          argsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
       */
      public Builder addArgs(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.add(builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
       */
      public Builder addArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.add(index, builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
       */
      public Builder addAllArgs(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> values) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, args_);
          onChanged();
        } else {
          argsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
       */
      public Builder clearArgs() {
        if (argsBuilder_ == null) {
          args_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          argsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
       */
      public Builder removeArgs(int index) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.remove(index);
          onChanged();
        } else {
          argsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder getArgsBuilder(
          int index) {
        return getArgsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getArgsOrBuilder(
          int index) {
        if (argsBuilder_ == null) {
          return args_.get(index);  } else {
          return argsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
           getArgsOrBuilderList() {
        if (argsBuilder_ != null) {
          return argsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(args_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder addArgsBuilder() {
        return getArgsFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder addArgsBuilder(
          int index) {
        return getArgsFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 8;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder> 
           getArgsBuilderList() {
        return getArgsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
          getArgsFieldBuilder() {
        if (argsBuilder_ == null) {
          argsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder>(
                  args_,
                  ((bitField0_ & 0x00000008) == 0x00000008),
                  getParentForChildren(),
                  isClean());
          args_ = null;
        }
        return argsBuilder_;
      }

      private com.mysql.cj.x.protobuf.MysqlxCrud.Limit limit_ = com.mysql.cj.x.protobuf.MysqlxCrud.Limit.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Limit, com.mysql.cj.x.protobuf.MysqlxCrud.Limit.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.LimitOrBuilder> limitBuilder_;
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 5;</code>
       */
      public boolean hasLimit() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Limit getLimit() {
        if (limitBuilder_ == null) {
          return limit_;
        } else {
          return limitBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 5;</code>
       */
      public Builder setLimit(com.mysql.cj.x.protobuf.MysqlxCrud.Limit value) {
        if (limitBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          limit_ = value;
          onChanged();
        } else {
          limitBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 5;</code>
       */
      public Builder setLimit(
          com.mysql.cj.x.protobuf.MysqlxCrud.Limit.Builder builderForValue) {
        if (limitBuilder_ == null) {
          limit_ = builderForValue.build();
          onChanged();
        } else {
          limitBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 5;</code>
       */
      public Builder mergeLimit(com.mysql.cj.x.protobuf.MysqlxCrud.Limit value) {
        if (limitBuilder_ == null) {
          if (((bitField0_ & 0x00000010) == 0x00000010) &&
              limit_ != com.mysql.cj.x.protobuf.MysqlxCrud.Limit.getDefaultInstance()) {
            limit_ =
              com.mysql.cj.x.protobuf.MysqlxCrud.Limit.newBuilder(limit_).mergeFrom(value).buildPartial();
          } else {
            limit_ = value;
          }
          onChanged();
        } else {
          limitBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 5;</code>
       */
      public Builder clearLimit() {
        if (limitBuilder_ == null) {
          limit_ = com.mysql.cj.x.protobuf.MysqlxCrud.Limit.getDefaultInstance();
          onChanged();
        } else {
          limitBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Limit.Builder getLimitBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getLimitFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.LimitOrBuilder getLimitOrBuilder() {
        if (limitBuilder_ != null) {
          return limitBuilder_.getMessageOrBuilder();
        } else {
          return limit_;
        }
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Limit, com.mysql.cj.x.protobuf.MysqlxCrud.Limit.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.LimitOrBuilder> 
          getLimitFieldBuilder() {
        if (limitBuilder_ == null) {
          limitBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxCrud.Limit, com.mysql.cj.x.protobuf.MysqlxCrud.Limit.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.LimitOrBuilder>(
                  getLimit(),
                  getParentForChildren(),
                  isClean());
          limit_ = null;
        }
        return limitBuilder_;
      }

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Order> order_ =
        java.util.Collections.emptyList();
      private void ensureOrderIsMutable() {
        if (!((bitField0_ & 0x00000020) == 0x00000020)) {
          order_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxCrud.Order>(order_);
          bitField0_ |= 0x00000020;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Order, com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder> orderBuilder_;

      /**
       * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Order> getOrderList() {
        if (orderBuilder_ == null) {
          return java.util.Collections.unmodifiableList(order_);
        } else {
          return orderBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
       */
      public int getOrderCount() {
        if (orderBuilder_ == null) {
          return order_.size();
        } else {
          return orderBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Order getOrder(int index) {
        if (orderBuilder_ == null) {
          return order_.get(index);
        } else {
          return orderBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
       */
      public Builder setOrder(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Order value) {
        if (orderBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOrderIsMutable();
          order_.set(index, value);
          onChanged();
        } else {
          orderBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
       */
      public Builder setOrder(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder builderForValue) {
        if (orderBuilder_ == null) {
          ensureOrderIsMutable();
          order_.set(index, builderForValue.build());
          onChanged();
        } else {
          orderBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
       */
      public Builder addOrder(com.mysql.cj.x.protobuf.MysqlxCrud.Order value) {
        if (orderBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOrderIsMutable();
          order_.add(value);
          onChanged();
        } else {
          orderBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
       */
      public Builder addOrder(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Order value) {
        if (orderBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOrderIsMutable();
          order_.add(index, value);
          onChanged();
        } else {
          orderBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
       */
      public Builder addOrder(
          com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder builderForValue) {
        if (orderBuilder_ == null) {
          ensureOrderIsMutable();
          order_.add(builderForValue.build());
          onChanged();
        } else {
          orderBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
       */
      public Builder addOrder(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder builderForValue) {
        if (orderBuilder_ == null) {
          ensureOrderIsMutable();
          order_.add(index, builderForValue.build());
          onChanged();
        } else {
          orderBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
       */
      public Builder addAllOrder(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxCrud.Order> values) {
        if (orderBuilder_ == null) {
          ensureOrderIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, order_);
          onChanged();
        } else {
          orderBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
       */
      public Builder clearOrder() {
        if (orderBuilder_ == null) {
          order_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000020);
          onChanged();
        } else {
          orderBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
       */
      public Builder removeOrder(int index) {
        if (orderBuilder_ == null) {
          ensureOrderIsMutable();
          order_.remove(index);
          onChanged();
        } else {
          orderBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder getOrderBuilder(
          int index) {
        return getOrderFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder getOrderOrBuilder(
          int index) {
        if (orderBuilder_ == null) {
          return order_.get(index);  } else {
          return orderBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder> 
           getOrderOrBuilderList() {
        if (orderBuilder_ != null) {
          return orderBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(order_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder addOrderBuilder() {
        return getOrderFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxCrud.Order.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder addOrderBuilder(
          int index) {
        return getOrderFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxCrud.Order.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 6;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder> 
           getOrderBuilderList() {
        return getOrderFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Order, com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder> 
          getOrderFieldBuilder() {
        if (orderBuilder_ == null) {
          orderBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxCrud.Order, com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder>(
                  order_,
                  ((bitField0_ & 0x00000020) == 0x00000020),
                  getParentForChildren(),
                  isClean());
          order_ = null;
        }
        return orderBuilder_;
      }

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation> operation_ =
        java.util.Collections.emptyList();
      private void ensureOperationIsMutable() {
        if (!((bitField0_ & 0x00000040) == 0x00000040)) {
          operation_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation>(operation_);
          bitField0_ |= 0x00000040;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation, com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperationOrBuilder> operationBuilder_;

      /**
       * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation> getOperationList() {
        if (operationBuilder_ == null) {
          return java.util.Collections.unmodifiableList(operation_);
        } else {
          return operationBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
       */
      public int getOperationCount() {
        if (operationBuilder_ == null) {
          return operation_.size();
        } else {
          return operationBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation getOperation(int index) {
        if (operationBuilder_ == null) {
          return operation_.get(index);
        } else {
          return operationBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
       */
      public Builder setOperation(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation value) {
        if (operationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOperationIsMutable();
          operation_.set(index, value);
          onChanged();
        } else {
          operationBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
       */
      public Builder setOperation(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.Builder builderForValue) {
        if (operationBuilder_ == null) {
          ensureOperationIsMutable();
          operation_.set(index, builderForValue.build());
          onChanged();
        } else {
          operationBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
       */
      public Builder addOperation(com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation value) {
        if (operationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOperationIsMutable();
          operation_.add(value);
          onChanged();
        } else {
          operationBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
       */
      public Builder addOperation(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation value) {
        if (operationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOperationIsMutable();
          operation_.add(index, value);
          onChanged();
        } else {
          operationBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
       */
      public Builder addOperation(
          com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.Builder builderForValue) {
        if (operationBuilder_ == null) {
          ensureOperationIsMutable();
          operation_.add(builderForValue.build());
          onChanged();
        } else {
          operationBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
       */
      public Builder addOperation(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.Builder builderForValue) {
        if (operationBuilder_ == null) {
          ensureOperationIsMutable();
          operation_.add(index, builderForValue.build());
          onChanged();
        } else {
          operationBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
       */
      public Builder addAllOperation(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation> values) {
        if (operationBuilder_ == null) {
          ensureOperationIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, operation_);
          onChanged();
        } else {
          operationBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
       */
      public Builder clearOperation() {
        if (operationBuilder_ == null) {
          operation_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000040);
          onChanged();
        } else {
          operationBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
       */
      public Builder removeOperation(int index) {
        if (operationBuilder_ == null) {
          ensureOperationIsMutable();
          operation_.remove(index);
          onChanged();
        } else {
          operationBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.Builder getOperationBuilder(
          int index) {
        return getOperationFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperationOrBuilder getOperationOrBuilder(
          int index) {
        if (operationBuilder_ == null) {
          return operation_.get(index);  } else {
          return operationBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperationOrBuilder> 
           getOperationOrBuilderList() {
        if (operationBuilder_ != null) {
          return operationBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(operation_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.Builder addOperationBuilder() {
        return getOperationFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.Builder addOperationBuilder(
          int index) {
        return getOperationFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Crud.UpdateOperation operation = 7;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.Builder> 
           getOperationBuilderList() {
        return getOperationFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation, com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperationOrBuilder> 
          getOperationFieldBuilder() {
        if (operationBuilder_ == null) {
          operationBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation, com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperation.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOperationOrBuilder>(
                  operation_,
                  ((bitField0_ & 0x00000040) == 0x00000040),
                  getParentForChildren(),
                  isClean());
          operation_ = null;
        }
        return operationBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Crud.Update)
    }

    static {
      defaultInstance = new Update(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Crud.Update)
  }

  public interface DeleteOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Crud.Delete)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    boolean hasCollection();
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.Collection getCollection();
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder getCollectionOrBuilder();

    /**
     * <code>optional .Mysqlx.Crud.DataModel data_model = 2;</code>
     */
    boolean hasDataModel();
    /**
     * <code>optional .Mysqlx.Crud.DataModel data_model = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.DataModel getDataModel();

    /**
     * <code>optional .Mysqlx.Expr.Expr criteria = 3;</code>
     */
    boolean hasCriteria();
    /**
     * <code>optional .Mysqlx.Expr.Expr criteria = 3;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.Expr getCriteria();
    /**
     * <code>optional .Mysqlx.Expr.Expr criteria = 3;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getCriteriaOrBuilder();

    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> 
        getArgsList();
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getArgs(int index);
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
     */
    int getArgsCount();
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
        getArgsOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getArgsOrBuilder(
        int index);

    /**
     * <code>optional .Mysqlx.Crud.Limit limit = 4;</code>
     */
    boolean hasLimit();
    /**
     * <code>optional .Mysqlx.Crud.Limit limit = 4;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.Limit getLimit();
    /**
     * <code>optional .Mysqlx.Crud.Limit limit = 4;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.LimitOrBuilder getLimitOrBuilder();

    /**
     * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Order> 
        getOrderList();
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.Order getOrder(int index);
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
     */
    int getOrderCount();
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder> 
        getOrderOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder getOrderOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code Mysqlx.Crud.Delete}
   *
   * <pre>
   * Delete documents/rows from a Collection/Table
   * :param collection: collection to change
   * :param data_model: datamodel that the operations refer to
   * :param criteria: filter expression to match rows that the operations will apply on
   * :param args: values for parameters used in filter expression
   * :param limit: limits the number of rows to match
   * :param order: specifies order of matched rows
   * :Returns: :protobuf:msg:`Mysqlx.Resultset::`
   * </pre>
   */
  public static final class Delete extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Crud.Delete)
      DeleteOrBuilder {
    // Use Delete.newBuilder() to construct.
    private Delete(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Delete(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Delete defaultInstance;
    public static Delete getDefaultInstance() {
      return defaultInstance;
    }

    public Delete getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Delete(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = collection_.toBuilder();
              }
              collection_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxCrud.Collection.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(collection_);
                collection_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 16: {
              int rawValue = input.readEnum();
              com.mysql.cj.x.protobuf.MysqlxCrud.DataModel value = com.mysql.cj.x.protobuf.MysqlxCrud.DataModel.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(2, rawValue);
              } else {
                bitField0_ |= 0x00000002;
                dataModel_ = value;
              }
              break;
            }
            case 26: {
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder subBuilder = null;
              if (((bitField0_ & 0x00000004) == 0x00000004)) {
                subBuilder = criteria_.toBuilder();
              }
              criteria_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpr.Expr.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(criteria_);
                criteria_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000004;
              break;
            }
            case 34: {
              com.mysql.cj.x.protobuf.MysqlxCrud.Limit.Builder subBuilder = null;
              if (((bitField0_ & 0x00000008) == 0x00000008)) {
                subBuilder = limit_.toBuilder();
              }
              limit_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxCrud.Limit.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(limit_);
                limit_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000008;
              break;
            }
            case 42: {
              if (!((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
                order_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxCrud.Order>();
                mutable_bitField0_ |= 0x00000020;
              }
              order_.add(input.readMessage(com.mysql.cj.x.protobuf.MysqlxCrud.Order.PARSER, extensionRegistry));
              break;
            }
            case 50: {
              if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
                args_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar>();
                mutable_bitField0_ |= 0x00000008;
              }
              args_.add(input.readMessage(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
          order_ = java.util.Collections.unmodifiableList(order_);
        }
        if (((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
          args_ = java.util.Collections.unmodifiableList(args_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Delete_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Delete_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxCrud.Delete.class, com.mysql.cj.x.protobuf.MysqlxCrud.Delete.Builder.class);
    }

    public static com.google.protobuf.Parser<Delete> PARSER =
        new com.google.protobuf.AbstractParser<Delete>() {
      public Delete parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Delete(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Delete> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int COLLECTION_FIELD_NUMBER = 1;
    private com.mysql.cj.x.protobuf.MysqlxCrud.Collection collection_;
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    public boolean hasCollection() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.Collection getCollection() {
      return collection_;
    }
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder getCollectionOrBuilder() {
      return collection_;
    }

    public static final int DATA_MODEL_FIELD_NUMBER = 2;
    private com.mysql.cj.x.protobuf.MysqlxCrud.DataModel dataModel_;
    /**
     * <code>optional .Mysqlx.Crud.DataModel data_model = 2;</code>
     */
    public boolean hasDataModel() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .Mysqlx.Crud.DataModel data_model = 2;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.DataModel getDataModel() {
      return dataModel_;
    }

    public static final int CRITERIA_FIELD_NUMBER = 3;
    private com.mysql.cj.x.protobuf.MysqlxExpr.Expr criteria_;
    /**
     * <code>optional .Mysqlx.Expr.Expr criteria = 3;</code>
     */
    public boolean hasCriteria() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional .Mysqlx.Expr.Expr criteria = 3;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getCriteria() {
      return criteria_;
    }
    /**
     * <code>optional .Mysqlx.Expr.Expr criteria = 3;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getCriteriaOrBuilder() {
      return criteria_;
    }

    public static final int ARGS_FIELD_NUMBER = 6;
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> args_;
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
     */
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> getArgsList() {
      return args_;
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
     */
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
        getArgsOrBuilderList() {
      return args_;
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
     */
    public int getArgsCount() {
      return args_.size();
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getArgs(int index) {
      return args_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getArgsOrBuilder(
        int index) {
      return args_.get(index);
    }

    public static final int LIMIT_FIELD_NUMBER = 4;
    private com.mysql.cj.x.protobuf.MysqlxCrud.Limit limit_;
    /**
     * <code>optional .Mysqlx.Crud.Limit limit = 4;</code>
     */
    public boolean hasLimit() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional .Mysqlx.Crud.Limit limit = 4;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.Limit getLimit() {
      return limit_;
    }
    /**
     * <code>optional .Mysqlx.Crud.Limit limit = 4;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.LimitOrBuilder getLimitOrBuilder() {
      return limit_;
    }

    public static final int ORDER_FIELD_NUMBER = 5;
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Order> order_;
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
     */
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Order> getOrderList() {
      return order_;
    }
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
     */
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder> 
        getOrderOrBuilderList() {
      return order_;
    }
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
     */
    public int getOrderCount() {
      return order_.size();
    }
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.Order getOrder(int index) {
      return order_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder getOrderOrBuilder(
        int index) {
      return order_.get(index);
    }

    private void initFields() {
      collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
      dataModel_ = com.mysql.cj.x.protobuf.MysqlxCrud.DataModel.DOCUMENT;
      criteria_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
      args_ = java.util.Collections.emptyList();
      limit_ = com.mysql.cj.x.protobuf.MysqlxCrud.Limit.getDefaultInstance();
      order_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasCollection()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getCollection().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (hasCriteria()) {
        if (!getCriteria().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      for (int i = 0; i < getArgsCount(); i++) {
        if (!getArgs(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasLimit()) {
        if (!getLimit().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      for (int i = 0; i < getOrderCount(); i++) {
        if (!getOrder(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, collection_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeEnum(2, dataModel_.getNumber());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(3, criteria_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeMessage(4, limit_);
      }
      for (int i = 0; i < order_.size(); i++) {
        output.writeMessage(5, order_.get(i));
      }
      for (int i = 0; i < args_.size(); i++) {
        output.writeMessage(6, args_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, collection_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, dataModel_.getNumber());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, criteria_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, limit_);
      }
      for (int i = 0; i < order_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, order_.get(i));
      }
      for (int i = 0; i < args_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, args_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxCrud.Delete parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Delete parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Delete parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Delete parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Delete parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Delete parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Delete parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Delete parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Delete parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.Delete parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxCrud.Delete prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Crud.Delete}
     *
     * <pre>
     * Delete documents/rows from a Collection/Table
     * :param collection: collection to change
     * :param data_model: datamodel that the operations refer to
     * :param criteria: filter expression to match rows that the operations will apply on
     * :param args: values for parameters used in filter expression
     * :param limit: limits the number of rows to match
     * :param order: specifies order of matched rows
     * :Returns: :protobuf:msg:`Mysqlx.Resultset::`
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Crud.Delete)
        com.mysql.cj.x.protobuf.MysqlxCrud.DeleteOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Delete_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Delete_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxCrud.Delete.class, com.mysql.cj.x.protobuf.MysqlxCrud.Delete.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxCrud.Delete.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getCollectionFieldBuilder();
          getCriteriaFieldBuilder();
          getArgsFieldBuilder();
          getLimitFieldBuilder();
          getOrderFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (collectionBuilder_ == null) {
          collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
        } else {
          collectionBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        dataModel_ = com.mysql.cj.x.protobuf.MysqlxCrud.DataModel.DOCUMENT;
        bitField0_ = (bitField0_ & ~0x00000002);
        if (criteriaBuilder_ == null) {
          criteria_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
        } else {
          criteriaBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        if (argsBuilder_ == null) {
          args_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          argsBuilder_.clear();
        }
        if (limitBuilder_ == null) {
          limit_ = com.mysql.cj.x.protobuf.MysqlxCrud.Limit.getDefaultInstance();
        } else {
          limitBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        if (orderBuilder_ == null) {
          order_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000020);
        } else {
          orderBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_Delete_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Delete getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.Delete.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Delete build() {
        com.mysql.cj.x.protobuf.MysqlxCrud.Delete result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.Delete buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxCrud.Delete result = new com.mysql.cj.x.protobuf.MysqlxCrud.Delete(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (collectionBuilder_ == null) {
          result.collection_ = collection_;
        } else {
          result.collection_ = collectionBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.dataModel_ = dataModel_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (criteriaBuilder_ == null) {
          result.criteria_ = criteria_;
        } else {
          result.criteria_ = criteriaBuilder_.build();
        }
        if (argsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008)) {
            args_ = java.util.Collections.unmodifiableList(args_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.args_ = args_;
        } else {
          result.args_ = argsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000008;
        }
        if (limitBuilder_ == null) {
          result.limit_ = limit_;
        } else {
          result.limit_ = limitBuilder_.build();
        }
        if (orderBuilder_ == null) {
          if (((bitField0_ & 0x00000020) == 0x00000020)) {
            order_ = java.util.Collections.unmodifiableList(order_);
            bitField0_ = (bitField0_ & ~0x00000020);
          }
          result.order_ = order_;
        } else {
          result.order_ = orderBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxCrud.Delete) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxCrud.Delete)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxCrud.Delete other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxCrud.Delete.getDefaultInstance()) return this;
        if (other.hasCollection()) {
          mergeCollection(other.getCollection());
        }
        if (other.hasDataModel()) {
          setDataModel(other.getDataModel());
        }
        if (other.hasCriteria()) {
          mergeCriteria(other.getCriteria());
        }
        if (argsBuilder_ == null) {
          if (!other.args_.isEmpty()) {
            if (args_.isEmpty()) {
              args_ = other.args_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureArgsIsMutable();
              args_.addAll(other.args_);
            }
            onChanged();
          }
        } else {
          if (!other.args_.isEmpty()) {
            if (argsBuilder_.isEmpty()) {
              argsBuilder_.dispose();
              argsBuilder_ = null;
              args_ = other.args_;
              bitField0_ = (bitField0_ & ~0x00000008);
              argsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getArgsFieldBuilder() : null;
            } else {
              argsBuilder_.addAllMessages(other.args_);
            }
          }
        }
        if (other.hasLimit()) {
          mergeLimit(other.getLimit());
        }
        if (orderBuilder_ == null) {
          if (!other.order_.isEmpty()) {
            if (order_.isEmpty()) {
              order_ = other.order_;
              bitField0_ = (bitField0_ & ~0x00000020);
            } else {
              ensureOrderIsMutable();
              order_.addAll(other.order_);
            }
            onChanged();
          }
        } else {
          if (!other.order_.isEmpty()) {
            if (orderBuilder_.isEmpty()) {
              orderBuilder_.dispose();
              orderBuilder_ = null;
              order_ = other.order_;
              bitField0_ = (bitField0_ & ~0x00000020);
              orderBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getOrderFieldBuilder() : null;
            } else {
              orderBuilder_.addAllMessages(other.order_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasCollection()) {
          
          return false;
        }
        if (!getCollection().isInitialized()) {
          
          return false;
        }
        if (hasCriteria()) {
          if (!getCriteria().isInitialized()) {
            
            return false;
          }
        }
        for (int i = 0; i < getArgsCount(); i++) {
          if (!getArgs(i).isInitialized()) {
            
            return false;
          }
        }
        if (hasLimit()) {
          if (!getLimit().isInitialized()) {
            
            return false;
          }
        }
        for (int i = 0; i < getOrderCount(); i++) {
          if (!getOrder(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxCrud.Delete parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxCrud.Delete) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.mysql.cj.x.protobuf.MysqlxCrud.Collection collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Collection, com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder> collectionBuilder_;
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public boolean hasCollection() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Collection getCollection() {
        if (collectionBuilder_ == null) {
          return collection_;
        } else {
          return collectionBuilder_.getMessage();
        }
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public Builder setCollection(com.mysql.cj.x.protobuf.MysqlxCrud.Collection value) {
        if (collectionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          collection_ = value;
          onChanged();
        } else {
          collectionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public Builder setCollection(
          com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder builderForValue) {
        if (collectionBuilder_ == null) {
          collection_ = builderForValue.build();
          onChanged();
        } else {
          collectionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public Builder mergeCollection(com.mysql.cj.x.protobuf.MysqlxCrud.Collection value) {
        if (collectionBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              collection_ != com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance()) {
            collection_ =
              com.mysql.cj.x.protobuf.MysqlxCrud.Collection.newBuilder(collection_).mergeFrom(value).buildPartial();
          } else {
            collection_ = value;
          }
          onChanged();
        } else {
          collectionBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public Builder clearCollection() {
        if (collectionBuilder_ == null) {
          collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
          onChanged();
        } else {
          collectionBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder getCollectionBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getCollectionFieldBuilder().getBuilder();
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder getCollectionOrBuilder() {
        if (collectionBuilder_ != null) {
          return collectionBuilder_.getMessageOrBuilder();
        } else {
          return collection_;
        }
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Collection, com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder> 
          getCollectionFieldBuilder() {
        if (collectionBuilder_ == null) {
          collectionBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxCrud.Collection, com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder>(
                  getCollection(),
                  getParentForChildren(),
                  isClean());
          collection_ = null;
        }
        return collectionBuilder_;
      }

      private com.mysql.cj.x.protobuf.MysqlxCrud.DataModel dataModel_ = com.mysql.cj.x.protobuf.MysqlxCrud.DataModel.DOCUMENT;
      /**
       * <code>optional .Mysqlx.Crud.DataModel data_model = 2;</code>
       */
      public boolean hasDataModel() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .Mysqlx.Crud.DataModel data_model = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.DataModel getDataModel() {
        return dataModel_;
      }
      /**
       * <code>optional .Mysqlx.Crud.DataModel data_model = 2;</code>
       */
      public Builder setDataModel(com.mysql.cj.x.protobuf.MysqlxCrud.DataModel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        dataModel_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.DataModel data_model = 2;</code>
       */
      public Builder clearDataModel() {
        bitField0_ = (bitField0_ & ~0x00000002);
        dataModel_ = com.mysql.cj.x.protobuf.MysqlxCrud.DataModel.DOCUMENT;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxExpr.Expr criteria_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> criteriaBuilder_;
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 3;</code>
       */
      public boolean hasCriteria() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr getCriteria() {
        if (criteriaBuilder_ == null) {
          return criteria_;
        } else {
          return criteriaBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 3;</code>
       */
      public Builder setCriteria(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (criteriaBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          criteria_ = value;
          onChanged();
        } else {
          criteriaBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 3;</code>
       */
      public Builder setCriteria(
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder builderForValue) {
        if (criteriaBuilder_ == null) {
          criteria_ = builderForValue.build();
          onChanged();
        } else {
          criteriaBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 3;</code>
       */
      public Builder mergeCriteria(com.mysql.cj.x.protobuf.MysqlxExpr.Expr value) {
        if (criteriaBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004) &&
              criteria_ != com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance()) {
            criteria_ =
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr.newBuilder(criteria_).mergeFrom(value).buildPartial();
          } else {
            criteria_ = value;
          }
          onChanged();
        } else {
          criteriaBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 3;</code>
       */
      public Builder clearCriteria() {
        if (criteriaBuilder_ == null) {
          criteria_ = com.mysql.cj.x.protobuf.MysqlxExpr.Expr.getDefaultInstance();
          onChanged();
        } else {
          criteriaBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder getCriteriaBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getCriteriaFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder getCriteriaOrBuilder() {
        if (criteriaBuilder_ != null) {
          return criteriaBuilder_.getMessageOrBuilder();
        } else {
          return criteria_;
        }
      }
      /**
       * <code>optional .Mysqlx.Expr.Expr criteria = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder> 
          getCriteriaFieldBuilder() {
        if (criteriaBuilder_ == null) {
          criteriaBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpr.Expr, com.mysql.cj.x.protobuf.MysqlxExpr.Expr.Builder, com.mysql.cj.x.protobuf.MysqlxExpr.ExprOrBuilder>(
                  getCriteria(),
                  getParentForChildren(),
                  isClean());
          criteria_ = null;
        }
        return criteriaBuilder_;
      }

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> args_ =
        java.util.Collections.emptyList();
      private void ensureArgsIsMutable() {
        if (!((bitField0_ & 0x00000008) == 0x00000008)) {
          args_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar>(args_);
          bitField0_ |= 0x00000008;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> argsBuilder_;

      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> getArgsList() {
        if (argsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(args_);
        } else {
          return argsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
       */
      public int getArgsCount() {
        if (argsBuilder_ == null) {
          return args_.size();
        } else {
          return argsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getArgs(int index) {
        if (argsBuilder_ == null) {
          return args_.get(index);
        } else {
          return argsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
       */
      public Builder setArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.set(index, value);
          onChanged();
        } else {
          argsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
       */
      public Builder setArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.set(index, builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
       */
      public Builder addArgs(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.add(value);
          onChanged();
        } else {
          argsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
       */
      public Builder addArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.add(index, value);
          onChanged();
        } else {
          argsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
       */
      public Builder addArgs(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.add(builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
       */
      public Builder addArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.add(index, builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
       */
      public Builder addAllArgs(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> values) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, args_);
          onChanged();
        } else {
          argsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
       */
      public Builder clearArgs() {
        if (argsBuilder_ == null) {
          args_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          argsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
       */
      public Builder removeArgs(int index) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.remove(index);
          onChanged();
        } else {
          argsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder getArgsBuilder(
          int index) {
        return getArgsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getArgsOrBuilder(
          int index) {
        if (argsBuilder_ == null) {
          return args_.get(index);  } else {
          return argsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
           getArgsOrBuilderList() {
        if (argsBuilder_ != null) {
          return argsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(args_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder addArgsBuilder() {
        return getArgsFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder addArgsBuilder(
          int index) {
        return getArgsFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Scalar args = 6;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder> 
           getArgsBuilderList() {
        return getArgsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
          getArgsFieldBuilder() {
        if (argsBuilder_ == null) {
          argsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder>(
                  args_,
                  ((bitField0_ & 0x00000008) == 0x00000008),
                  getParentForChildren(),
                  isClean());
          args_ = null;
        }
        return argsBuilder_;
      }

      private com.mysql.cj.x.protobuf.MysqlxCrud.Limit limit_ = com.mysql.cj.x.protobuf.MysqlxCrud.Limit.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Limit, com.mysql.cj.x.protobuf.MysqlxCrud.Limit.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.LimitOrBuilder> limitBuilder_;
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 4;</code>
       */
      public boolean hasLimit() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Limit getLimit() {
        if (limitBuilder_ == null) {
          return limit_;
        } else {
          return limitBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 4;</code>
       */
      public Builder setLimit(com.mysql.cj.x.protobuf.MysqlxCrud.Limit value) {
        if (limitBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          limit_ = value;
          onChanged();
        } else {
          limitBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 4;</code>
       */
      public Builder setLimit(
          com.mysql.cj.x.protobuf.MysqlxCrud.Limit.Builder builderForValue) {
        if (limitBuilder_ == null) {
          limit_ = builderForValue.build();
          onChanged();
        } else {
          limitBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 4;</code>
       */
      public Builder mergeLimit(com.mysql.cj.x.protobuf.MysqlxCrud.Limit value) {
        if (limitBuilder_ == null) {
          if (((bitField0_ & 0x00000010) == 0x00000010) &&
              limit_ != com.mysql.cj.x.protobuf.MysqlxCrud.Limit.getDefaultInstance()) {
            limit_ =
              com.mysql.cj.x.protobuf.MysqlxCrud.Limit.newBuilder(limit_).mergeFrom(value).buildPartial();
          } else {
            limit_ = value;
          }
          onChanged();
        } else {
          limitBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 4;</code>
       */
      public Builder clearLimit() {
        if (limitBuilder_ == null) {
          limit_ = com.mysql.cj.x.protobuf.MysqlxCrud.Limit.getDefaultInstance();
          onChanged();
        } else {
          limitBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Limit.Builder getLimitBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getLimitFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.LimitOrBuilder getLimitOrBuilder() {
        if (limitBuilder_ != null) {
          return limitBuilder_.getMessageOrBuilder();
        } else {
          return limit_;
        }
      }
      /**
       * <code>optional .Mysqlx.Crud.Limit limit = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Limit, com.mysql.cj.x.protobuf.MysqlxCrud.Limit.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.LimitOrBuilder> 
          getLimitFieldBuilder() {
        if (limitBuilder_ == null) {
          limitBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxCrud.Limit, com.mysql.cj.x.protobuf.MysqlxCrud.Limit.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.LimitOrBuilder>(
                  getLimit(),
                  getParentForChildren(),
                  isClean());
          limit_ = null;
        }
        return limitBuilder_;
      }

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Order> order_ =
        java.util.Collections.emptyList();
      private void ensureOrderIsMutable() {
        if (!((bitField0_ & 0x00000020) == 0x00000020)) {
          order_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxCrud.Order>(order_);
          bitField0_ |= 0x00000020;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Order, com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder> orderBuilder_;

      /**
       * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Order> getOrderList() {
        if (orderBuilder_ == null) {
          return java.util.Collections.unmodifiableList(order_);
        } else {
          return orderBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
       */
      public int getOrderCount() {
        if (orderBuilder_ == null) {
          return order_.size();
        } else {
          return orderBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Order getOrder(int index) {
        if (orderBuilder_ == null) {
          return order_.get(index);
        } else {
          return orderBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
       */
      public Builder setOrder(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Order value) {
        if (orderBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOrderIsMutable();
          order_.set(index, value);
          onChanged();
        } else {
          orderBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
       */
      public Builder setOrder(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder builderForValue) {
        if (orderBuilder_ == null) {
          ensureOrderIsMutable();
          order_.set(index, builderForValue.build());
          onChanged();
        } else {
          orderBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
       */
      public Builder addOrder(com.mysql.cj.x.protobuf.MysqlxCrud.Order value) {
        if (orderBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOrderIsMutable();
          order_.add(value);
          onChanged();
        } else {
          orderBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
       */
      public Builder addOrder(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Order value) {
        if (orderBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOrderIsMutable();
          order_.add(index, value);
          onChanged();
        } else {
          orderBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
       */
      public Builder addOrder(
          com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder builderForValue) {
        if (orderBuilder_ == null) {
          ensureOrderIsMutable();
          order_.add(builderForValue.build());
          onChanged();
        } else {
          orderBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
       */
      public Builder addOrder(
          int index, com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder builderForValue) {
        if (orderBuilder_ == null) {
          ensureOrderIsMutable();
          order_.add(index, builderForValue.build());
          onChanged();
        } else {
          orderBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
       */
      public Builder addAllOrder(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxCrud.Order> values) {
        if (orderBuilder_ == null) {
          ensureOrderIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, order_);
          onChanged();
        } else {
          orderBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
       */
      public Builder clearOrder() {
        if (orderBuilder_ == null) {
          order_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000020);
          onChanged();
        } else {
          orderBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
       */
      public Builder removeOrder(int index) {
        if (orderBuilder_ == null) {
          ensureOrderIsMutable();
          order_.remove(index);
          onChanged();
        } else {
          orderBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder getOrderBuilder(
          int index) {
        return getOrderFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder getOrderOrBuilder(
          int index) {
        if (orderBuilder_ == null) {
          return order_.get(index);  } else {
          return orderBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder> 
           getOrderOrBuilderList() {
        if (orderBuilder_ != null) {
          return orderBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(order_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder addOrderBuilder() {
        return getOrderFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxCrud.Order.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder addOrderBuilder(
          int index) {
        return getOrderFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxCrud.Order.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Crud.Order order = 5;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder> 
           getOrderBuilderList() {
        return getOrderFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Order, com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder> 
          getOrderFieldBuilder() {
        if (orderBuilder_ == null) {
          orderBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxCrud.Order, com.mysql.cj.x.protobuf.MysqlxCrud.Order.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.OrderOrBuilder>(
                  order_,
                  ((bitField0_ & 0x00000020) == 0x00000020),
                  getParentForChildren(),
                  isClean());
          order_ = null;
        }
        return orderBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Crud.Delete)
    }

    static {
      defaultInstance = new Delete(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Crud.Delete)
  }

  public interface CreateViewOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Crud.CreateView)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    boolean hasCollection();
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.Collection getCollection();
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder getCollectionOrBuilder();

    /**
     * <code>optional string definer = 2;</code>
     */
    boolean hasDefiner();
    /**
     * <code>optional string definer = 2;</code>
     */
    java.lang.String getDefiner();
    /**
     * <code>optional string definer = 2;</code>
     */
    com.google.protobuf.ByteString
        getDefinerBytes();

    /**
     * <code>optional .Mysqlx.Crud.ViewAlgorithm algorithm = 3 [default = UNDEFINED];</code>
     */
    boolean hasAlgorithm();
    /**
     * <code>optional .Mysqlx.Crud.ViewAlgorithm algorithm = 3 [default = UNDEFINED];</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm getAlgorithm();

    /**
     * <code>optional .Mysqlx.Crud.ViewSqlSecurity security = 4 [default = DEFINER];</code>
     */
    boolean hasSecurity();
    /**
     * <code>optional .Mysqlx.Crud.ViewSqlSecurity security = 4 [default = DEFINER];</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity getSecurity();

    /**
     * <code>optional .Mysqlx.Crud.ViewCheckOption check = 5;</code>
     */
    boolean hasCheck();
    /**
     * <code>optional .Mysqlx.Crud.ViewCheckOption check = 5;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption getCheck();

    /**
     * <code>repeated string column = 6;</code>
     */
    com.google.protobuf.ProtocolStringList
        getColumnList();
    /**
     * <code>repeated string column = 6;</code>
     */
    int getColumnCount();
    /**
     * <code>repeated string column = 6;</code>
     */
    java.lang.String getColumn(int index);
    /**
     * <code>repeated string column = 6;</code>
     */
    com.google.protobuf.ByteString
        getColumnBytes(int index);

    /**
     * <code>required .Mysqlx.Crud.Find stmt = 7;</code>
     */
    boolean hasStmt();
    /**
     * <code>required .Mysqlx.Crud.Find stmt = 7;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.Find getStmt();
    /**
     * <code>required .Mysqlx.Crud.Find stmt = 7;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.FindOrBuilder getStmtOrBuilder();

    /**
     * <code>optional bool replace_existing = 8 [default = false];</code>
     */
    boolean hasReplaceExisting();
    /**
     * <code>optional bool replace_existing = 8 [default = false];</code>
     */
    boolean getReplaceExisting();
  }
  /**
   * Protobuf type {@code Mysqlx.Crud.CreateView}
   */
  public static final class CreateView extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Crud.CreateView)
      CreateViewOrBuilder {
    // Use CreateView.newBuilder() to construct.
    private CreateView(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private CreateView(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final CreateView defaultInstance;
    public static CreateView getDefaultInstance() {
      return defaultInstance;
    }

    public CreateView getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private CreateView(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = collection_.toBuilder();
              }
              collection_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxCrud.Collection.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(collection_);
                collection_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              definer_ = bs;
              break;
            }
            case 24: {
              int rawValue = input.readEnum();
              com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm value = com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(3, rawValue);
              } else {
                bitField0_ |= 0x00000004;
                algorithm_ = value;
              }
              break;
            }
            case 32: {
              int rawValue = input.readEnum();
              com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity value = com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(4, rawValue);
              } else {
                bitField0_ |= 0x00000008;
                security_ = value;
              }
              break;
            }
            case 40: {
              int rawValue = input.readEnum();
              com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption value = com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(5, rawValue);
              } else {
                bitField0_ |= 0x00000010;
                check_ = value;
              }
              break;
            }
            case 50: {
              com.google.protobuf.ByteString bs = input.readBytes();
              if (!((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
                column_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000020;
              }
              column_.add(bs);
              break;
            }
            case 58: {
              com.mysql.cj.x.protobuf.MysqlxCrud.Find.Builder subBuilder = null;
              if (((bitField0_ & 0x00000020) == 0x00000020)) {
                subBuilder = stmt_.toBuilder();
              }
              stmt_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxCrud.Find.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(stmt_);
                stmt_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000020;
              break;
            }
            case 64: {
              bitField0_ |= 0x00000040;
              replaceExisting_ = input.readBool();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
          column_ = column_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_CreateView_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_CreateView_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxCrud.CreateView.class, com.mysql.cj.x.protobuf.MysqlxCrud.CreateView.Builder.class);
    }

    public static com.google.protobuf.Parser<CreateView> PARSER =
        new com.google.protobuf.AbstractParser<CreateView>() {
      public CreateView parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new CreateView(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<CreateView> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int COLLECTION_FIELD_NUMBER = 1;
    private com.mysql.cj.x.protobuf.MysqlxCrud.Collection collection_;
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    public boolean hasCollection() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.Collection getCollection() {
      return collection_;
    }
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder getCollectionOrBuilder() {
      return collection_;
    }

    public static final int DEFINER_FIELD_NUMBER = 2;
    private java.lang.Object definer_;
    /**
     * <code>optional string definer = 2;</code>
     */
    public boolean hasDefiner() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional string definer = 2;</code>
     */
    public java.lang.String getDefiner() {
      java.lang.Object ref = definer_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          definer_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string definer = 2;</code>
     */
    public com.google.protobuf.ByteString
        getDefinerBytes() {
      java.lang.Object ref = definer_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        definer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ALGORITHM_FIELD_NUMBER = 3;
    private com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm algorithm_;
    /**
     * <code>optional .Mysqlx.Crud.ViewAlgorithm algorithm = 3 [default = UNDEFINED];</code>
     */
    public boolean hasAlgorithm() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional .Mysqlx.Crud.ViewAlgorithm algorithm = 3 [default = UNDEFINED];</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm getAlgorithm() {
      return algorithm_;
    }

    public static final int SECURITY_FIELD_NUMBER = 4;
    private com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity security_;
    /**
     * <code>optional .Mysqlx.Crud.ViewSqlSecurity security = 4 [default = DEFINER];</code>
     */
    public boolean hasSecurity() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional .Mysqlx.Crud.ViewSqlSecurity security = 4 [default = DEFINER];</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity getSecurity() {
      return security_;
    }

    public static final int CHECK_FIELD_NUMBER = 5;
    private com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption check_;
    /**
     * <code>optional .Mysqlx.Crud.ViewCheckOption check = 5;</code>
     */
    public boolean hasCheck() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional .Mysqlx.Crud.ViewCheckOption check = 5;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption getCheck() {
      return check_;
    }

    public static final int COLUMN_FIELD_NUMBER = 6;
    private com.google.protobuf.LazyStringList column_;
    /**
     * <code>repeated string column = 6;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getColumnList() {
      return column_;
    }
    /**
     * <code>repeated string column = 6;</code>
     */
    public int getColumnCount() {
      return column_.size();
    }
    /**
     * <code>repeated string column = 6;</code>
     */
    public java.lang.String getColumn(int index) {
      return column_.get(index);
    }
    /**
     * <code>repeated string column = 6;</code>
     */
    public com.google.protobuf.ByteString
        getColumnBytes(int index) {
      return column_.getByteString(index);
    }

    public static final int STMT_FIELD_NUMBER = 7;
    private com.mysql.cj.x.protobuf.MysqlxCrud.Find stmt_;
    /**
     * <code>required .Mysqlx.Crud.Find stmt = 7;</code>
     */
    public boolean hasStmt() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>required .Mysqlx.Crud.Find stmt = 7;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.Find getStmt() {
      return stmt_;
    }
    /**
     * <code>required .Mysqlx.Crud.Find stmt = 7;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.FindOrBuilder getStmtOrBuilder() {
      return stmt_;
    }

    public static final int REPLACE_EXISTING_FIELD_NUMBER = 8;
    private boolean replaceExisting_;
    /**
     * <code>optional bool replace_existing = 8 [default = false];</code>
     */
    public boolean hasReplaceExisting() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <code>optional bool replace_existing = 8 [default = false];</code>
     */
    public boolean getReplaceExisting() {
      return replaceExisting_;
    }

    private void initFields() {
      collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
      definer_ = "";
      algorithm_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm.UNDEFINED;
      security_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity.DEFINER;
      check_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption.LOCAL;
      column_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      stmt_ = com.mysql.cj.x.protobuf.MysqlxCrud.Find.getDefaultInstance();
      replaceExisting_ = false;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasCollection()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasStmt()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getCollection().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getStmt().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, collection_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, getDefinerBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeEnum(3, algorithm_.getNumber());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeEnum(4, security_.getNumber());
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeEnum(5, check_.getNumber());
      }
      for (int i = 0; i < column_.size(); i++) {
        output.writeBytes(6, column_.getByteString(i));
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeMessage(7, stmt_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeBool(8, replaceExisting_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, collection_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, getDefinerBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(3, algorithm_.getNumber());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(4, security_.getNumber());
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(5, check_.getNumber());
      }
      {
        int dataSize = 0;
        for (int i = 0; i < column_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeBytesSizeNoTag(column_.getByteString(i));
        }
        size += dataSize;
        size += 1 * getColumnList().size();
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, stmt_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(8, replaceExisting_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxCrud.CreateView parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.CreateView parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.CreateView parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.CreateView parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.CreateView parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.CreateView parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.CreateView parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.CreateView parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.CreateView parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.CreateView parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxCrud.CreateView prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Crud.CreateView}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Crud.CreateView)
        com.mysql.cj.x.protobuf.MysqlxCrud.CreateViewOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_CreateView_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_CreateView_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxCrud.CreateView.class, com.mysql.cj.x.protobuf.MysqlxCrud.CreateView.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxCrud.CreateView.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getCollectionFieldBuilder();
          getStmtFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (collectionBuilder_ == null) {
          collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
        } else {
          collectionBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        definer_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        algorithm_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm.UNDEFINED;
        bitField0_ = (bitField0_ & ~0x00000004);
        security_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity.DEFINER;
        bitField0_ = (bitField0_ & ~0x00000008);
        check_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption.LOCAL;
        bitField0_ = (bitField0_ & ~0x00000010);
        column_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000020);
        if (stmtBuilder_ == null) {
          stmt_ = com.mysql.cj.x.protobuf.MysqlxCrud.Find.getDefaultInstance();
        } else {
          stmtBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000040);
        replaceExisting_ = false;
        bitField0_ = (bitField0_ & ~0x00000080);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_CreateView_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.CreateView getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.CreateView.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.CreateView build() {
        com.mysql.cj.x.protobuf.MysqlxCrud.CreateView result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.CreateView buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxCrud.CreateView result = new com.mysql.cj.x.protobuf.MysqlxCrud.CreateView(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (collectionBuilder_ == null) {
          result.collection_ = collection_;
        } else {
          result.collection_ = collectionBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.definer_ = definer_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.algorithm_ = algorithm_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.security_ = security_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.check_ = check_;
        if (((bitField0_ & 0x00000020) == 0x00000020)) {
          column_ = column_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.column_ = column_;
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000020;
        }
        if (stmtBuilder_ == null) {
          result.stmt_ = stmt_;
        } else {
          result.stmt_ = stmtBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000040;
        }
        result.replaceExisting_ = replaceExisting_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxCrud.CreateView) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxCrud.CreateView)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxCrud.CreateView other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxCrud.CreateView.getDefaultInstance()) return this;
        if (other.hasCollection()) {
          mergeCollection(other.getCollection());
        }
        if (other.hasDefiner()) {
          bitField0_ |= 0x00000002;
          definer_ = other.definer_;
          onChanged();
        }
        if (other.hasAlgorithm()) {
          setAlgorithm(other.getAlgorithm());
        }
        if (other.hasSecurity()) {
          setSecurity(other.getSecurity());
        }
        if (other.hasCheck()) {
          setCheck(other.getCheck());
        }
        if (!other.column_.isEmpty()) {
          if (column_.isEmpty()) {
            column_ = other.column_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureColumnIsMutable();
            column_.addAll(other.column_);
          }
          onChanged();
        }
        if (other.hasStmt()) {
          mergeStmt(other.getStmt());
        }
        if (other.hasReplaceExisting()) {
          setReplaceExisting(other.getReplaceExisting());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasCollection()) {
          
          return false;
        }
        if (!hasStmt()) {
          
          return false;
        }
        if (!getCollection().isInitialized()) {
          
          return false;
        }
        if (!getStmt().isInitialized()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxCrud.CreateView parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxCrud.CreateView) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.mysql.cj.x.protobuf.MysqlxCrud.Collection collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Collection, com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder> collectionBuilder_;
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public boolean hasCollection() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Collection getCollection() {
        if (collectionBuilder_ == null) {
          return collection_;
        } else {
          return collectionBuilder_.getMessage();
        }
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public Builder setCollection(com.mysql.cj.x.protobuf.MysqlxCrud.Collection value) {
        if (collectionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          collection_ = value;
          onChanged();
        } else {
          collectionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public Builder setCollection(
          com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder builderForValue) {
        if (collectionBuilder_ == null) {
          collection_ = builderForValue.build();
          onChanged();
        } else {
          collectionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public Builder mergeCollection(com.mysql.cj.x.protobuf.MysqlxCrud.Collection value) {
        if (collectionBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              collection_ != com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance()) {
            collection_ =
              com.mysql.cj.x.protobuf.MysqlxCrud.Collection.newBuilder(collection_).mergeFrom(value).buildPartial();
          } else {
            collection_ = value;
          }
          onChanged();
        } else {
          collectionBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public Builder clearCollection() {
        if (collectionBuilder_ == null) {
          collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
          onChanged();
        } else {
          collectionBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder getCollectionBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getCollectionFieldBuilder().getBuilder();
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder getCollectionOrBuilder() {
        if (collectionBuilder_ != null) {
          return collectionBuilder_.getMessageOrBuilder();
        } else {
          return collection_;
        }
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Collection, com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder> 
          getCollectionFieldBuilder() {
        if (collectionBuilder_ == null) {
          collectionBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxCrud.Collection, com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder>(
                  getCollection(),
                  getParentForChildren(),
                  isClean());
          collection_ = null;
        }
        return collectionBuilder_;
      }

      private java.lang.Object definer_ = "";
      /**
       * <code>optional string definer = 2;</code>
       */
      public boolean hasDefiner() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional string definer = 2;</code>
       */
      public java.lang.String getDefiner() {
        java.lang.Object ref = definer_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            definer_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string definer = 2;</code>
       */
      public com.google.protobuf.ByteString
          getDefinerBytes() {
        java.lang.Object ref = definer_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          definer_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string definer = 2;</code>
       */
      public Builder setDefiner(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        definer_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string definer = 2;</code>
       */
      public Builder clearDefiner() {
        bitField0_ = (bitField0_ & ~0x00000002);
        definer_ = getDefaultInstance().getDefiner();
        onChanged();
        return this;
      }
      /**
       * <code>optional string definer = 2;</code>
       */
      public Builder setDefinerBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        definer_ = value;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm algorithm_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm.UNDEFINED;
      /**
       * <code>optional .Mysqlx.Crud.ViewAlgorithm algorithm = 3 [default = UNDEFINED];</code>
       */
      public boolean hasAlgorithm() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional .Mysqlx.Crud.ViewAlgorithm algorithm = 3 [default = UNDEFINED];</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm getAlgorithm() {
        return algorithm_;
      }
      /**
       * <code>optional .Mysqlx.Crud.ViewAlgorithm algorithm = 3 [default = UNDEFINED];</code>
       */
      public Builder setAlgorithm(com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        algorithm_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.ViewAlgorithm algorithm = 3 [default = UNDEFINED];</code>
       */
      public Builder clearAlgorithm() {
        bitField0_ = (bitField0_ & ~0x00000004);
        algorithm_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm.UNDEFINED;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity security_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity.DEFINER;
      /**
       * <code>optional .Mysqlx.Crud.ViewSqlSecurity security = 4 [default = DEFINER];</code>
       */
      public boolean hasSecurity() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional .Mysqlx.Crud.ViewSqlSecurity security = 4 [default = DEFINER];</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity getSecurity() {
        return security_;
      }
      /**
       * <code>optional .Mysqlx.Crud.ViewSqlSecurity security = 4 [default = DEFINER];</code>
       */
      public Builder setSecurity(com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000008;
        security_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.ViewSqlSecurity security = 4 [default = DEFINER];</code>
       */
      public Builder clearSecurity() {
        bitField0_ = (bitField0_ & ~0x00000008);
        security_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity.DEFINER;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption check_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption.LOCAL;
      /**
       * <code>optional .Mysqlx.Crud.ViewCheckOption check = 5;</code>
       */
      public boolean hasCheck() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional .Mysqlx.Crud.ViewCheckOption check = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption getCheck() {
        return check_;
      }
      /**
       * <code>optional .Mysqlx.Crud.ViewCheckOption check = 5;</code>
       */
      public Builder setCheck(com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        check_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.ViewCheckOption check = 5;</code>
       */
      public Builder clearCheck() {
        bitField0_ = (bitField0_ & ~0x00000010);
        check_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption.LOCAL;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList column_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureColumnIsMutable() {
        if (!((bitField0_ & 0x00000020) == 0x00000020)) {
          column_ = new com.google.protobuf.LazyStringArrayList(column_);
          bitField0_ |= 0x00000020;
         }
      }
      /**
       * <code>repeated string column = 6;</code>
       */
      public com.google.protobuf.ProtocolStringList
          getColumnList() {
        return column_.getUnmodifiableView();
      }
      /**
       * <code>repeated string column = 6;</code>
       */
      public int getColumnCount() {
        return column_.size();
      }
      /**
       * <code>repeated string column = 6;</code>
       */
      public java.lang.String getColumn(int index) {
        return column_.get(index);
      }
      /**
       * <code>repeated string column = 6;</code>
       */
      public com.google.protobuf.ByteString
          getColumnBytes(int index) {
        return column_.getByteString(index);
      }
      /**
       * <code>repeated string column = 6;</code>
       */
      public Builder setColumn(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureColumnIsMutable();
        column_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string column = 6;</code>
       */
      public Builder addColumn(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureColumnIsMutable();
        column_.add(value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string column = 6;</code>
       */
      public Builder addAllColumn(
          java.lang.Iterable<java.lang.String> values) {
        ensureColumnIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, column_);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string column = 6;</code>
       */
      public Builder clearColumn() {
        column_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string column = 6;</code>
       */
      public Builder addColumnBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureColumnIsMutable();
        column_.add(value);
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxCrud.Find stmt_ = com.mysql.cj.x.protobuf.MysqlxCrud.Find.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Find, com.mysql.cj.x.protobuf.MysqlxCrud.Find.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.FindOrBuilder> stmtBuilder_;
      /**
       * <code>required .Mysqlx.Crud.Find stmt = 7;</code>
       */
      public boolean hasStmt() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <code>required .Mysqlx.Crud.Find stmt = 7;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Find getStmt() {
        if (stmtBuilder_ == null) {
          return stmt_;
        } else {
          return stmtBuilder_.getMessage();
        }
      }
      /**
       * <code>required .Mysqlx.Crud.Find stmt = 7;</code>
       */
      public Builder setStmt(com.mysql.cj.x.protobuf.MysqlxCrud.Find value) {
        if (stmtBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          stmt_ = value;
          onChanged();
        } else {
          stmtBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Find stmt = 7;</code>
       */
      public Builder setStmt(
          com.mysql.cj.x.protobuf.MysqlxCrud.Find.Builder builderForValue) {
        if (stmtBuilder_ == null) {
          stmt_ = builderForValue.build();
          onChanged();
        } else {
          stmtBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Find stmt = 7;</code>
       */
      public Builder mergeStmt(com.mysql.cj.x.protobuf.MysqlxCrud.Find value) {
        if (stmtBuilder_ == null) {
          if (((bitField0_ & 0x00000040) == 0x00000040) &&
              stmt_ != com.mysql.cj.x.protobuf.MysqlxCrud.Find.getDefaultInstance()) {
            stmt_ =
              com.mysql.cj.x.protobuf.MysqlxCrud.Find.newBuilder(stmt_).mergeFrom(value).buildPartial();
          } else {
            stmt_ = value;
          }
          onChanged();
        } else {
          stmtBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000040;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Find stmt = 7;</code>
       */
      public Builder clearStmt() {
        if (stmtBuilder_ == null) {
          stmt_ = com.mysql.cj.x.protobuf.MysqlxCrud.Find.getDefaultInstance();
          onChanged();
        } else {
          stmtBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000040);
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Find stmt = 7;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Find.Builder getStmtBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getStmtFieldBuilder().getBuilder();
      }
      /**
       * <code>required .Mysqlx.Crud.Find stmt = 7;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.FindOrBuilder getStmtOrBuilder() {
        if (stmtBuilder_ != null) {
          return stmtBuilder_.getMessageOrBuilder();
        } else {
          return stmt_;
        }
      }
      /**
       * <code>required .Mysqlx.Crud.Find stmt = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Find, com.mysql.cj.x.protobuf.MysqlxCrud.Find.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.FindOrBuilder> 
          getStmtFieldBuilder() {
        if (stmtBuilder_ == null) {
          stmtBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxCrud.Find, com.mysql.cj.x.protobuf.MysqlxCrud.Find.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.FindOrBuilder>(
                  getStmt(),
                  getParentForChildren(),
                  isClean());
          stmt_ = null;
        }
        return stmtBuilder_;
      }

      private boolean replaceExisting_ ;
      /**
       * <code>optional bool replace_existing = 8 [default = false];</code>
       */
      public boolean hasReplaceExisting() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       * <code>optional bool replace_existing = 8 [default = false];</code>
       */
      public boolean getReplaceExisting() {
        return replaceExisting_;
      }
      /**
       * <code>optional bool replace_existing = 8 [default = false];</code>
       */
      public Builder setReplaceExisting(boolean value) {
        bitField0_ |= 0x00000080;
        replaceExisting_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool replace_existing = 8 [default = false];</code>
       */
      public Builder clearReplaceExisting() {
        bitField0_ = (bitField0_ & ~0x00000080);
        replaceExisting_ = false;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Crud.CreateView)
    }

    static {
      defaultInstance = new CreateView(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Crud.CreateView)
  }

  public interface ModifyViewOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Crud.ModifyView)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    boolean hasCollection();
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.Collection getCollection();
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder getCollectionOrBuilder();

    /**
     * <code>optional string definer = 2;</code>
     */
    boolean hasDefiner();
    /**
     * <code>optional string definer = 2;</code>
     */
    java.lang.String getDefiner();
    /**
     * <code>optional string definer = 2;</code>
     */
    com.google.protobuf.ByteString
        getDefinerBytes();

    /**
     * <code>optional .Mysqlx.Crud.ViewAlgorithm algorithm = 3;</code>
     */
    boolean hasAlgorithm();
    /**
     * <code>optional .Mysqlx.Crud.ViewAlgorithm algorithm = 3;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm getAlgorithm();

    /**
     * <code>optional .Mysqlx.Crud.ViewSqlSecurity security = 4;</code>
     */
    boolean hasSecurity();
    /**
     * <code>optional .Mysqlx.Crud.ViewSqlSecurity security = 4;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity getSecurity();

    /**
     * <code>optional .Mysqlx.Crud.ViewCheckOption check = 5;</code>
     */
    boolean hasCheck();
    /**
     * <code>optional .Mysqlx.Crud.ViewCheckOption check = 5;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption getCheck();

    /**
     * <code>repeated string column = 6;</code>
     */
    com.google.protobuf.ProtocolStringList
        getColumnList();
    /**
     * <code>repeated string column = 6;</code>
     */
    int getColumnCount();
    /**
     * <code>repeated string column = 6;</code>
     */
    java.lang.String getColumn(int index);
    /**
     * <code>repeated string column = 6;</code>
     */
    com.google.protobuf.ByteString
        getColumnBytes(int index);

    /**
     * <code>optional .Mysqlx.Crud.Find stmt = 7;</code>
     */
    boolean hasStmt();
    /**
     * <code>optional .Mysqlx.Crud.Find stmt = 7;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.Find getStmt();
    /**
     * <code>optional .Mysqlx.Crud.Find stmt = 7;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.FindOrBuilder getStmtOrBuilder();
  }
  /**
   * Protobuf type {@code Mysqlx.Crud.ModifyView}
   */
  public static final class ModifyView extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Crud.ModifyView)
      ModifyViewOrBuilder {
    // Use ModifyView.newBuilder() to construct.
    private ModifyView(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private ModifyView(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final ModifyView defaultInstance;
    public static ModifyView getDefaultInstance() {
      return defaultInstance;
    }

    public ModifyView getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private ModifyView(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = collection_.toBuilder();
              }
              collection_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxCrud.Collection.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(collection_);
                collection_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              definer_ = bs;
              break;
            }
            case 24: {
              int rawValue = input.readEnum();
              com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm value = com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(3, rawValue);
              } else {
                bitField0_ |= 0x00000004;
                algorithm_ = value;
              }
              break;
            }
            case 32: {
              int rawValue = input.readEnum();
              com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity value = com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(4, rawValue);
              } else {
                bitField0_ |= 0x00000008;
                security_ = value;
              }
              break;
            }
            case 40: {
              int rawValue = input.readEnum();
              com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption value = com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(5, rawValue);
              } else {
                bitField0_ |= 0x00000010;
                check_ = value;
              }
              break;
            }
            case 50: {
              com.google.protobuf.ByteString bs = input.readBytes();
              if (!((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
                column_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000020;
              }
              column_.add(bs);
              break;
            }
            case 58: {
              com.mysql.cj.x.protobuf.MysqlxCrud.Find.Builder subBuilder = null;
              if (((bitField0_ & 0x00000020) == 0x00000020)) {
                subBuilder = stmt_.toBuilder();
              }
              stmt_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxCrud.Find.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(stmt_);
                stmt_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000020;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
          column_ = column_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_ModifyView_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_ModifyView_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView.class, com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView.Builder.class);
    }

    public static com.google.protobuf.Parser<ModifyView> PARSER =
        new com.google.protobuf.AbstractParser<ModifyView>() {
      public ModifyView parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new ModifyView(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<ModifyView> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int COLLECTION_FIELD_NUMBER = 1;
    private com.mysql.cj.x.protobuf.MysqlxCrud.Collection collection_;
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    public boolean hasCollection() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.Collection getCollection() {
      return collection_;
    }
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder getCollectionOrBuilder() {
      return collection_;
    }

    public static final int DEFINER_FIELD_NUMBER = 2;
    private java.lang.Object definer_;
    /**
     * <code>optional string definer = 2;</code>
     */
    public boolean hasDefiner() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional string definer = 2;</code>
     */
    public java.lang.String getDefiner() {
      java.lang.Object ref = definer_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          definer_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string definer = 2;</code>
     */
    public com.google.protobuf.ByteString
        getDefinerBytes() {
      java.lang.Object ref = definer_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        definer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ALGORITHM_FIELD_NUMBER = 3;
    private com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm algorithm_;
    /**
     * <code>optional .Mysqlx.Crud.ViewAlgorithm algorithm = 3;</code>
     */
    public boolean hasAlgorithm() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional .Mysqlx.Crud.ViewAlgorithm algorithm = 3;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm getAlgorithm() {
      return algorithm_;
    }

    public static final int SECURITY_FIELD_NUMBER = 4;
    private com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity security_;
    /**
     * <code>optional .Mysqlx.Crud.ViewSqlSecurity security = 4;</code>
     */
    public boolean hasSecurity() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional .Mysqlx.Crud.ViewSqlSecurity security = 4;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity getSecurity() {
      return security_;
    }

    public static final int CHECK_FIELD_NUMBER = 5;
    private com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption check_;
    /**
     * <code>optional .Mysqlx.Crud.ViewCheckOption check = 5;</code>
     */
    public boolean hasCheck() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional .Mysqlx.Crud.ViewCheckOption check = 5;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption getCheck() {
      return check_;
    }

    public static final int COLUMN_FIELD_NUMBER = 6;
    private com.google.protobuf.LazyStringList column_;
    /**
     * <code>repeated string column = 6;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getColumnList() {
      return column_;
    }
    /**
     * <code>repeated string column = 6;</code>
     */
    public int getColumnCount() {
      return column_.size();
    }
    /**
     * <code>repeated string column = 6;</code>
     */
    public java.lang.String getColumn(int index) {
      return column_.get(index);
    }
    /**
     * <code>repeated string column = 6;</code>
     */
    public com.google.protobuf.ByteString
        getColumnBytes(int index) {
      return column_.getByteString(index);
    }

    public static final int STMT_FIELD_NUMBER = 7;
    private com.mysql.cj.x.protobuf.MysqlxCrud.Find stmt_;
    /**
     * <code>optional .Mysqlx.Crud.Find stmt = 7;</code>
     */
    public boolean hasStmt() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional .Mysqlx.Crud.Find stmt = 7;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.Find getStmt() {
      return stmt_;
    }
    /**
     * <code>optional .Mysqlx.Crud.Find stmt = 7;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.FindOrBuilder getStmtOrBuilder() {
      return stmt_;
    }

    private void initFields() {
      collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
      definer_ = "";
      algorithm_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm.UNDEFINED;
      security_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity.INVOKER;
      check_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption.LOCAL;
      column_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      stmt_ = com.mysql.cj.x.protobuf.MysqlxCrud.Find.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasCollection()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getCollection().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (hasStmt()) {
        if (!getStmt().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, collection_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, getDefinerBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeEnum(3, algorithm_.getNumber());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeEnum(4, security_.getNumber());
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeEnum(5, check_.getNumber());
      }
      for (int i = 0; i < column_.size(); i++) {
        output.writeBytes(6, column_.getByteString(i));
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeMessage(7, stmt_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, collection_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, getDefinerBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(3, algorithm_.getNumber());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(4, security_.getNumber());
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(5, check_.getNumber());
      }
      {
        int dataSize = 0;
        for (int i = 0; i < column_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeBytesSizeNoTag(column_.getByteString(i));
        }
        size += dataSize;
        size += 1 * getColumnList().size();
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, stmt_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Crud.ModifyView}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Crud.ModifyView)
        com.mysql.cj.x.protobuf.MysqlxCrud.ModifyViewOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_ModifyView_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_ModifyView_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView.class, com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getCollectionFieldBuilder();
          getStmtFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (collectionBuilder_ == null) {
          collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
        } else {
          collectionBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        definer_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        algorithm_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm.UNDEFINED;
        bitField0_ = (bitField0_ & ~0x00000004);
        security_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity.INVOKER;
        bitField0_ = (bitField0_ & ~0x00000008);
        check_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption.LOCAL;
        bitField0_ = (bitField0_ & ~0x00000010);
        column_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000020);
        if (stmtBuilder_ == null) {
          stmt_ = com.mysql.cj.x.protobuf.MysqlxCrud.Find.getDefaultInstance();
        } else {
          stmtBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000040);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_ModifyView_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView build() {
        com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView result = new com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (collectionBuilder_ == null) {
          result.collection_ = collection_;
        } else {
          result.collection_ = collectionBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.definer_ = definer_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.algorithm_ = algorithm_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.security_ = security_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.check_ = check_;
        if (((bitField0_ & 0x00000020) == 0x00000020)) {
          column_ = column_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.column_ = column_;
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000020;
        }
        if (stmtBuilder_ == null) {
          result.stmt_ = stmt_;
        } else {
          result.stmt_ = stmtBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView.getDefaultInstance()) return this;
        if (other.hasCollection()) {
          mergeCollection(other.getCollection());
        }
        if (other.hasDefiner()) {
          bitField0_ |= 0x00000002;
          definer_ = other.definer_;
          onChanged();
        }
        if (other.hasAlgorithm()) {
          setAlgorithm(other.getAlgorithm());
        }
        if (other.hasSecurity()) {
          setSecurity(other.getSecurity());
        }
        if (other.hasCheck()) {
          setCheck(other.getCheck());
        }
        if (!other.column_.isEmpty()) {
          if (column_.isEmpty()) {
            column_ = other.column_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureColumnIsMutable();
            column_.addAll(other.column_);
          }
          onChanged();
        }
        if (other.hasStmt()) {
          mergeStmt(other.getStmt());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasCollection()) {
          
          return false;
        }
        if (!getCollection().isInitialized()) {
          
          return false;
        }
        if (hasStmt()) {
          if (!getStmt().isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxCrud.ModifyView) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.mysql.cj.x.protobuf.MysqlxCrud.Collection collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Collection, com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder> collectionBuilder_;
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public boolean hasCollection() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Collection getCollection() {
        if (collectionBuilder_ == null) {
          return collection_;
        } else {
          return collectionBuilder_.getMessage();
        }
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public Builder setCollection(com.mysql.cj.x.protobuf.MysqlxCrud.Collection value) {
        if (collectionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          collection_ = value;
          onChanged();
        } else {
          collectionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public Builder setCollection(
          com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder builderForValue) {
        if (collectionBuilder_ == null) {
          collection_ = builderForValue.build();
          onChanged();
        } else {
          collectionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public Builder mergeCollection(com.mysql.cj.x.protobuf.MysqlxCrud.Collection value) {
        if (collectionBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              collection_ != com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance()) {
            collection_ =
              com.mysql.cj.x.protobuf.MysqlxCrud.Collection.newBuilder(collection_).mergeFrom(value).buildPartial();
          } else {
            collection_ = value;
          }
          onChanged();
        } else {
          collectionBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public Builder clearCollection() {
        if (collectionBuilder_ == null) {
          collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
          onChanged();
        } else {
          collectionBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder getCollectionBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getCollectionFieldBuilder().getBuilder();
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder getCollectionOrBuilder() {
        if (collectionBuilder_ != null) {
          return collectionBuilder_.getMessageOrBuilder();
        } else {
          return collection_;
        }
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Collection, com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder> 
          getCollectionFieldBuilder() {
        if (collectionBuilder_ == null) {
          collectionBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxCrud.Collection, com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder>(
                  getCollection(),
                  getParentForChildren(),
                  isClean());
          collection_ = null;
        }
        return collectionBuilder_;
      }

      private java.lang.Object definer_ = "";
      /**
       * <code>optional string definer = 2;</code>
       */
      public boolean hasDefiner() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional string definer = 2;</code>
       */
      public java.lang.String getDefiner() {
        java.lang.Object ref = definer_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            definer_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string definer = 2;</code>
       */
      public com.google.protobuf.ByteString
          getDefinerBytes() {
        java.lang.Object ref = definer_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          definer_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string definer = 2;</code>
       */
      public Builder setDefiner(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        definer_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string definer = 2;</code>
       */
      public Builder clearDefiner() {
        bitField0_ = (bitField0_ & ~0x00000002);
        definer_ = getDefaultInstance().getDefiner();
        onChanged();
        return this;
      }
      /**
       * <code>optional string definer = 2;</code>
       */
      public Builder setDefinerBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        definer_ = value;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm algorithm_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm.UNDEFINED;
      /**
       * <code>optional .Mysqlx.Crud.ViewAlgorithm algorithm = 3;</code>
       */
      public boolean hasAlgorithm() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional .Mysqlx.Crud.ViewAlgorithm algorithm = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm getAlgorithm() {
        return algorithm_;
      }
      /**
       * <code>optional .Mysqlx.Crud.ViewAlgorithm algorithm = 3;</code>
       */
      public Builder setAlgorithm(com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        algorithm_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.ViewAlgorithm algorithm = 3;</code>
       */
      public Builder clearAlgorithm() {
        bitField0_ = (bitField0_ & ~0x00000004);
        algorithm_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewAlgorithm.UNDEFINED;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity security_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity.INVOKER;
      /**
       * <code>optional .Mysqlx.Crud.ViewSqlSecurity security = 4;</code>
       */
      public boolean hasSecurity() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional .Mysqlx.Crud.ViewSqlSecurity security = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity getSecurity() {
        return security_;
      }
      /**
       * <code>optional .Mysqlx.Crud.ViewSqlSecurity security = 4;</code>
       */
      public Builder setSecurity(com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000008;
        security_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.ViewSqlSecurity security = 4;</code>
       */
      public Builder clearSecurity() {
        bitField0_ = (bitField0_ & ~0x00000008);
        security_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewSqlSecurity.INVOKER;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption check_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption.LOCAL;
      /**
       * <code>optional .Mysqlx.Crud.ViewCheckOption check = 5;</code>
       */
      public boolean hasCheck() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional .Mysqlx.Crud.ViewCheckOption check = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption getCheck() {
        return check_;
      }
      /**
       * <code>optional .Mysqlx.Crud.ViewCheckOption check = 5;</code>
       */
      public Builder setCheck(com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        check_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.ViewCheckOption check = 5;</code>
       */
      public Builder clearCheck() {
        bitField0_ = (bitField0_ & ~0x00000010);
        check_ = com.mysql.cj.x.protobuf.MysqlxCrud.ViewCheckOption.LOCAL;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList column_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureColumnIsMutable() {
        if (!((bitField0_ & 0x00000020) == 0x00000020)) {
          column_ = new com.google.protobuf.LazyStringArrayList(column_);
          bitField0_ |= 0x00000020;
         }
      }
      /**
       * <code>repeated string column = 6;</code>
       */
      public com.google.protobuf.ProtocolStringList
          getColumnList() {
        return column_.getUnmodifiableView();
      }
      /**
       * <code>repeated string column = 6;</code>
       */
      public int getColumnCount() {
        return column_.size();
      }
      /**
       * <code>repeated string column = 6;</code>
       */
      public java.lang.String getColumn(int index) {
        return column_.get(index);
      }
      /**
       * <code>repeated string column = 6;</code>
       */
      public com.google.protobuf.ByteString
          getColumnBytes(int index) {
        return column_.getByteString(index);
      }
      /**
       * <code>repeated string column = 6;</code>
       */
      public Builder setColumn(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureColumnIsMutable();
        column_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string column = 6;</code>
       */
      public Builder addColumn(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureColumnIsMutable();
        column_.add(value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string column = 6;</code>
       */
      public Builder addAllColumn(
          java.lang.Iterable<java.lang.String> values) {
        ensureColumnIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, column_);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string column = 6;</code>
       */
      public Builder clearColumn() {
        column_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string column = 6;</code>
       */
      public Builder addColumnBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureColumnIsMutable();
        column_.add(value);
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxCrud.Find stmt_ = com.mysql.cj.x.protobuf.MysqlxCrud.Find.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Find, com.mysql.cj.x.protobuf.MysqlxCrud.Find.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.FindOrBuilder> stmtBuilder_;
      /**
       * <code>optional .Mysqlx.Crud.Find stmt = 7;</code>
       */
      public boolean hasStmt() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <code>optional .Mysqlx.Crud.Find stmt = 7;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Find getStmt() {
        if (stmtBuilder_ == null) {
          return stmt_;
        } else {
          return stmtBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Crud.Find stmt = 7;</code>
       */
      public Builder setStmt(com.mysql.cj.x.protobuf.MysqlxCrud.Find value) {
        if (stmtBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          stmt_ = value;
          onChanged();
        } else {
          stmtBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.Find stmt = 7;</code>
       */
      public Builder setStmt(
          com.mysql.cj.x.protobuf.MysqlxCrud.Find.Builder builderForValue) {
        if (stmtBuilder_ == null) {
          stmt_ = builderForValue.build();
          onChanged();
        } else {
          stmtBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.Find stmt = 7;</code>
       */
      public Builder mergeStmt(com.mysql.cj.x.protobuf.MysqlxCrud.Find value) {
        if (stmtBuilder_ == null) {
          if (((bitField0_ & 0x00000040) == 0x00000040) &&
              stmt_ != com.mysql.cj.x.protobuf.MysqlxCrud.Find.getDefaultInstance()) {
            stmt_ =
              com.mysql.cj.x.protobuf.MysqlxCrud.Find.newBuilder(stmt_).mergeFrom(value).buildPartial();
          } else {
            stmt_ = value;
          }
          onChanged();
        } else {
          stmtBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000040;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.Find stmt = 7;</code>
       */
      public Builder clearStmt() {
        if (stmtBuilder_ == null) {
          stmt_ = com.mysql.cj.x.protobuf.MysqlxCrud.Find.getDefaultInstance();
          onChanged();
        } else {
          stmtBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000040);
        return this;
      }
      /**
       * <code>optional .Mysqlx.Crud.Find stmt = 7;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Find.Builder getStmtBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getStmtFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Crud.Find stmt = 7;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.FindOrBuilder getStmtOrBuilder() {
        if (stmtBuilder_ != null) {
          return stmtBuilder_.getMessageOrBuilder();
        } else {
          return stmt_;
        }
      }
      /**
       * <code>optional .Mysqlx.Crud.Find stmt = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Find, com.mysql.cj.x.protobuf.MysqlxCrud.Find.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.FindOrBuilder> 
          getStmtFieldBuilder() {
        if (stmtBuilder_ == null) {
          stmtBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxCrud.Find, com.mysql.cj.x.protobuf.MysqlxCrud.Find.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.FindOrBuilder>(
                  getStmt(),
                  getParentForChildren(),
                  isClean());
          stmt_ = null;
        }
        return stmtBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Crud.ModifyView)
    }

    static {
      defaultInstance = new ModifyView(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Crud.ModifyView)
  }

  public interface DropViewOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Crud.DropView)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    boolean hasCollection();
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.Collection getCollection();
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder getCollectionOrBuilder();

    /**
     * <code>optional bool if_exists = 2 [default = false];</code>
     */
    boolean hasIfExists();
    /**
     * <code>optional bool if_exists = 2 [default = false];</code>
     */
    boolean getIfExists();
  }
  /**
   * Protobuf type {@code Mysqlx.Crud.DropView}
   */
  public static final class DropView extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Crud.DropView)
      DropViewOrBuilder {
    // Use DropView.newBuilder() to construct.
    private DropView(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private DropView(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final DropView defaultInstance;
    public static DropView getDefaultInstance() {
      return defaultInstance;
    }

    public DropView getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private DropView(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = collection_.toBuilder();
              }
              collection_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxCrud.Collection.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(collection_);
                collection_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              ifExists_ = input.readBool();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_DropView_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_DropView_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxCrud.DropView.class, com.mysql.cj.x.protobuf.MysqlxCrud.DropView.Builder.class);
    }

    public static com.google.protobuf.Parser<DropView> PARSER =
        new com.google.protobuf.AbstractParser<DropView>() {
      public DropView parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new DropView(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<DropView> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int COLLECTION_FIELD_NUMBER = 1;
    private com.mysql.cj.x.protobuf.MysqlxCrud.Collection collection_;
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    public boolean hasCollection() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.Collection getCollection() {
      return collection_;
    }
    /**
     * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder getCollectionOrBuilder() {
      return collection_;
    }

    public static final int IF_EXISTS_FIELD_NUMBER = 2;
    private boolean ifExists_;
    /**
     * <code>optional bool if_exists = 2 [default = false];</code>
     */
    public boolean hasIfExists() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional bool if_exists = 2 [default = false];</code>
     */
    public boolean getIfExists() {
      return ifExists_;
    }

    private void initFields() {
      collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
      ifExists_ = false;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasCollection()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getCollection().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, collection_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBool(2, ifExists_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, collection_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, ifExists_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxCrud.DropView parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.DropView parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.DropView parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.DropView parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.DropView parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.DropView parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.DropView parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.DropView parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.DropView parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCrud.DropView parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxCrud.DropView prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Crud.DropView}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Crud.DropView)
        com.mysql.cj.x.protobuf.MysqlxCrud.DropViewOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_DropView_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_DropView_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxCrud.DropView.class, com.mysql.cj.x.protobuf.MysqlxCrud.DropView.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxCrud.DropView.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getCollectionFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (collectionBuilder_ == null) {
          collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
        } else {
          collectionBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        ifExists_ = false;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.internal_static_Mysqlx_Crud_DropView_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.DropView getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxCrud.DropView.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.DropView build() {
        com.mysql.cj.x.protobuf.MysqlxCrud.DropView result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxCrud.DropView buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxCrud.DropView result = new com.mysql.cj.x.protobuf.MysqlxCrud.DropView(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (collectionBuilder_ == null) {
          result.collection_ = collection_;
        } else {
          result.collection_ = collectionBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.ifExists_ = ifExists_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxCrud.DropView) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxCrud.DropView)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxCrud.DropView other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxCrud.DropView.getDefaultInstance()) return this;
        if (other.hasCollection()) {
          mergeCollection(other.getCollection());
        }
        if (other.hasIfExists()) {
          setIfExists(other.getIfExists());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasCollection()) {
          
          return false;
        }
        if (!getCollection().isInitialized()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxCrud.DropView parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxCrud.DropView) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.mysql.cj.x.protobuf.MysqlxCrud.Collection collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Collection, com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder> collectionBuilder_;
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public boolean hasCollection() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Collection getCollection() {
        if (collectionBuilder_ == null) {
          return collection_;
        } else {
          return collectionBuilder_.getMessage();
        }
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public Builder setCollection(com.mysql.cj.x.protobuf.MysqlxCrud.Collection value) {
        if (collectionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          collection_ = value;
          onChanged();
        } else {
          collectionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public Builder setCollection(
          com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder builderForValue) {
        if (collectionBuilder_ == null) {
          collection_ = builderForValue.build();
          onChanged();
        } else {
          collectionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public Builder mergeCollection(com.mysql.cj.x.protobuf.MysqlxCrud.Collection value) {
        if (collectionBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              collection_ != com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance()) {
            collection_ =
              com.mysql.cj.x.protobuf.MysqlxCrud.Collection.newBuilder(collection_).mergeFrom(value).buildPartial();
          } else {
            collection_ = value;
          }
          onChanged();
        } else {
          collectionBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public Builder clearCollection() {
        if (collectionBuilder_ == null) {
          collection_ = com.mysql.cj.x.protobuf.MysqlxCrud.Collection.getDefaultInstance();
          onChanged();
        } else {
          collectionBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder getCollectionBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getCollectionFieldBuilder().getBuilder();
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder getCollectionOrBuilder() {
        if (collectionBuilder_ != null) {
          return collectionBuilder_.getMessageOrBuilder();
        } else {
          return collection_;
        }
      }
      /**
       * <code>required .Mysqlx.Crud.Collection collection = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCrud.Collection, com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder> 
          getCollectionFieldBuilder() {
        if (collectionBuilder_ == null) {
          collectionBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxCrud.Collection, com.mysql.cj.x.protobuf.MysqlxCrud.Collection.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.CollectionOrBuilder>(
                  getCollection(),
                  getParentForChildren(),
                  isClean());
          collection_ = null;
        }
        return collectionBuilder_;
      }

      private boolean ifExists_ ;
      /**
       * <code>optional bool if_exists = 2 [default = false];</code>
       */
      public boolean hasIfExists() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional bool if_exists = 2 [default = false];</code>
       */
      public boolean getIfExists() {
        return ifExists_;
      }
      /**
       * <code>optional bool if_exists = 2 [default = false];</code>
       */
      public Builder setIfExists(boolean value) {
        bitField0_ |= 0x00000002;
        ifExists_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool if_exists = 2 [default = false];</code>
       */
      public Builder clearIfExists() {
        bitField0_ = (bitField0_ & ~0x00000002);
        ifExists_ = false;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Crud.DropView)
    }

    static {
      defaultInstance = new DropView(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Crud.DropView)
  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Crud_Column_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Crud_Column_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Crud_Projection_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Crud_Projection_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Crud_Collection_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Crud_Collection_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Crud_Limit_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Crud_Limit_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Crud_Order_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Crud_Order_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Crud_UpdateOperation_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Crud_UpdateOperation_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Crud_Find_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Crud_Find_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Crud_Insert_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Crud_Insert_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Crud_Insert_TypedRow_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Crud_Insert_TypedRow_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Crud_Update_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Crud_Update_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Crud_Delete_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Crud_Delete_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Crud_CreateView_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Crud_CreateView_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Crud_ModifyView_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Crud_ModifyView_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Crud_DropView_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Crud_DropView_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\021mysqlx_crud.proto\022\013Mysqlx.Crud\032\021mysqlx" +
      "_expr.proto\032\026mysqlx_datatypes.proto\"[\n\006C" +
      "olumn\022\014\n\004name\030\001 \001(\t\022\r\n\005alias\030\002 \001(\t\0224\n\rdo" +
      "cument_path\030\003 \003(\0132\035.Mysqlx.Expr.Document" +
      "PathItem\">\n\nProjection\022!\n\006source\030\001 \002(\0132\021" +
      ".Mysqlx.Expr.Expr\022\r\n\005alias\030\002 \001(\t\"*\n\nColl" +
      "ection\022\014\n\004name\030\001 \002(\t\022\016\n\006schema\030\002 \001(\t\"*\n\005" +
      "Limit\022\021\n\trow_count\030\001 \002(\004\022\016\n\006offset\030\002 \001(\004" +
      "\"~\n\005Order\022\037\n\004expr\030\001 \002(\0132\021.Mysqlx.Expr.Ex" +
      "pr\0224\n\tdirection\030\002 \001(\0162\034.Mysqlx.Crud.Orde",
      "r.Direction:\003ASC\"\036\n\tDirection\022\007\n\003ASC\020\001\022\010" +
      "\n\004DESC\020\002\"\232\002\n\017UpdateOperation\022-\n\006source\030\001" +
      " \002(\0132\035.Mysqlx.Expr.ColumnIdentifier\022:\n\to" +
      "peration\030\002 \002(\0162\'.Mysqlx.Crud.UpdateOpera" +
      "tion.UpdateType\022 \n\005value\030\003 \001(\0132\021.Mysqlx." +
      "Expr.Expr\"z\n\nUpdateType\022\007\n\003SET\020\001\022\017\n\013ITEM" +
      "_REMOVE\020\002\022\014\n\010ITEM_SET\020\003\022\020\n\014ITEM_REPLACE\020" +
      "\004\022\016\n\nITEM_MERGE\020\005\022\020\n\014ARRAY_INSERT\020\006\022\020\n\014A" +
      "RRAY_APPEND\020\007\"\316\003\n\004Find\022+\n\ncollection\030\002 \002" +
      "(\0132\027.Mysqlx.Crud.Collection\022*\n\ndata_mode",
      "l\030\003 \001(\0162\026.Mysqlx.Crud.DataModel\022+\n\nproje" +
      "ction\030\004 \003(\0132\027.Mysqlx.Crud.Projection\022#\n\010" +
      "criteria\030\005 \001(\0132\021.Mysqlx.Expr.Expr\022&\n\004arg" +
      "s\030\013 \003(\0132\030.Mysqlx.Datatypes.Scalar\022!\n\005lim" +
      "it\030\006 \001(\0132\022.Mysqlx.Crud.Limit\022!\n\005order\030\007 " +
      "\003(\0132\022.Mysqlx.Crud.Order\022#\n\010grouping\030\010 \003(" +
      "\0132\021.Mysqlx.Expr.Expr\022,\n\021grouping_criteri" +
      "a\030\t \001(\0132\021.Mysqlx.Expr.Expr\022*\n\007locking\030\014 " +
      "\001(\0162\031.Mysqlx.Crud.Find.RowLock\".\n\007RowLoc" +
      "k\022\017\n\013SHARED_LOCK\020\001\022\022\n\016EXCLUSIVE_LOCK\020\002\"\242",
      "\002\n\006Insert\022+\n\ncollection\030\001 \002(\0132\027.Mysqlx.C" +
      "rud.Collection\022*\n\ndata_model\030\002 \001(\0162\026.Mys" +
      "qlx.Crud.DataModel\022\'\n\nprojection\030\003 \003(\0132\023" +
      ".Mysqlx.Crud.Column\022)\n\003row\030\004 \003(\0132\034.Mysql" +
      "x.Crud.Insert.TypedRow\022&\n\004args\030\005 \003(\0132\030.M" +
      "ysqlx.Datatypes.Scalar\022\025\n\006upsert\030\006 \001(\010:\005" +
      "false\032,\n\010TypedRow\022 \n\005field\030\001 \003(\0132\021.Mysql" +
      "x.Expr.Expr\"\245\002\n\006Update\022+\n\ncollection\030\002 \002" +
      "(\0132\027.Mysqlx.Crud.Collection\022*\n\ndata_mode" +
      "l\030\003 \001(\0162\026.Mysqlx.Crud.DataModel\022#\n\010crite",
      "ria\030\004 \001(\0132\021.Mysqlx.Expr.Expr\022&\n\004args\030\010 \003" +
      "(\0132\030.Mysqlx.Datatypes.Scalar\022!\n\005limit\030\005 " +
      "\001(\0132\022.Mysqlx.Crud.Limit\022!\n\005order\030\006 \003(\0132\022" +
      ".Mysqlx.Crud.Order\022/\n\toperation\030\007 \003(\0132\034." +
      "Mysqlx.Crud.UpdateOperation\"\364\001\n\006Delete\022+" +
      "\n\ncollection\030\001 \002(\0132\027.Mysqlx.Crud.Collect" +
      "ion\022*\n\ndata_model\030\002 \001(\0162\026.Mysqlx.Crud.Da" +
      "taModel\022#\n\010criteria\030\003 \001(\0132\021.Mysqlx.Expr." +
      "Expr\022&\n\004args\030\006 \003(\0132\030.Mysqlx.Datatypes.Sc" +
      "alar\022!\n\005limit\030\004 \001(\0132\022.Mysqlx.Crud.Limit\022",
      "!\n\005order\030\005 \003(\0132\022.Mysqlx.Crud.Order\"\274\002\n\nC" +
      "reateView\022+\n\ncollection\030\001 \002(\0132\027.Mysqlx.C" +
      "rud.Collection\022\017\n\007definer\030\002 \001(\t\0228\n\talgor" +
      "ithm\030\003 \001(\0162\032.Mysqlx.Crud.ViewAlgorithm:\t" +
      "UNDEFINED\0227\n\010security\030\004 \001(\0162\034.Mysqlx.Cru" +
      "d.ViewSqlSecurity:\007DEFINER\022+\n\005check\030\005 \001(" +
      "\0162\034.Mysqlx.Crud.ViewCheckOption\022\016\n\006colum" +
      "n\030\006 \003(\t\022\037\n\004stmt\030\007 \002(\0132\021.Mysqlx.Crud.Find" +
      "\022\037\n\020replace_existing\030\010 \001(\010:\005false\"\207\002\n\nMo" +
      "difyView\022+\n\ncollection\030\001 \002(\0132\027.Mysqlx.Cr",
      "ud.Collection\022\017\n\007definer\030\002 \001(\t\022-\n\talgori" +
      "thm\030\003 \001(\0162\032.Mysqlx.Crud.ViewAlgorithm\022.\n" +
      "\010security\030\004 \001(\0162\034.Mysqlx.Crud.ViewSqlSec" +
      "urity\022+\n\005check\030\005 \001(\0162\034.Mysqlx.Crud.ViewC" +
      "heckOption\022\016\n\006column\030\006 \003(\t\022\037\n\004stmt\030\007 \001(\013" +
      "2\021.Mysqlx.Crud.Find\"Q\n\010DropView\022+\n\ncolle" +
      "ction\030\001 \002(\0132\027.Mysqlx.Crud.Collection\022\030\n\t" +
      "if_exists\030\002 \001(\010:\005false*$\n\tDataModel\022\014\n\010D" +
      "OCUMENT\020\001\022\t\n\005TABLE\020\002*8\n\rViewAlgorithm\022\r\n" +
      "\tUNDEFINED\020\001\022\t\n\005MERGE\020\002\022\r\n\tTEMPTABLE\020\003*+",
      "\n\017ViewSqlSecurity\022\013\n\007INVOKER\020\001\022\013\n\007DEFINE" +
      "R\020\002**\n\017ViewCheckOption\022\t\n\005LOCAL\020\001\022\014\n\010CAS" +
      "CADED\020\002B\031\n\027com.mysql.cj.x.protobuf"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          com.mysql.cj.x.protobuf.MysqlxExpr.getDescriptor(),
          com.mysql.cj.x.protobuf.MysqlxDatatypes.getDescriptor(),
        }, assigner);
    internal_static_Mysqlx_Crud_Column_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_Mysqlx_Crud_Column_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Crud_Column_descriptor,
        new java.lang.String[] { "Name", "Alias", "DocumentPath", });
    internal_static_Mysqlx_Crud_Projection_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_Mysqlx_Crud_Projection_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Crud_Projection_descriptor,
        new java.lang.String[] { "Source", "Alias", });
    internal_static_Mysqlx_Crud_Collection_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_Mysqlx_Crud_Collection_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Crud_Collection_descriptor,
        new java.lang.String[] { "Name", "Schema", });
    internal_static_Mysqlx_Crud_Limit_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_Mysqlx_Crud_Limit_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Crud_Limit_descriptor,
        new java.lang.String[] { "RowCount", "Offset", });
    internal_static_Mysqlx_Crud_Order_descriptor =
      getDescriptor().getMessageTypes().get(4);
    internal_static_Mysqlx_Crud_Order_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Crud_Order_descriptor,
        new java.lang.String[] { "Expr", "Direction", });
    internal_static_Mysqlx_Crud_UpdateOperation_descriptor =
      getDescriptor().getMessageTypes().get(5);
    internal_static_Mysqlx_Crud_UpdateOperation_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Crud_UpdateOperation_descriptor,
        new java.lang.String[] { "Source", "Operation", "Value", });
    internal_static_Mysqlx_Crud_Find_descriptor =
      getDescriptor().getMessageTypes().get(6);
    internal_static_Mysqlx_Crud_Find_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Crud_Find_descriptor,
        new java.lang.String[] { "Collection", "DataModel", "Projection", "Criteria", "Args", "Limit", "Order", "Grouping", "GroupingCriteria", "Locking", });
    internal_static_Mysqlx_Crud_Insert_descriptor =
      getDescriptor().getMessageTypes().get(7);
    internal_static_Mysqlx_Crud_Insert_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Crud_Insert_descriptor,
        new java.lang.String[] { "Collection", "DataModel", "Projection", "Row", "Args", "Upsert", });
    internal_static_Mysqlx_Crud_Insert_TypedRow_descriptor =
      internal_static_Mysqlx_Crud_Insert_descriptor.getNestedTypes().get(0);
    internal_static_Mysqlx_Crud_Insert_TypedRow_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Crud_Insert_TypedRow_descriptor,
        new java.lang.String[] { "Field", });
    internal_static_Mysqlx_Crud_Update_descriptor =
      getDescriptor().getMessageTypes().get(8);
    internal_static_Mysqlx_Crud_Update_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Crud_Update_descriptor,
        new java.lang.String[] { "Collection", "DataModel", "Criteria", "Args", "Limit", "Order", "Operation", });
    internal_static_Mysqlx_Crud_Delete_descriptor =
      getDescriptor().getMessageTypes().get(9);
    internal_static_Mysqlx_Crud_Delete_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Crud_Delete_descriptor,
        new java.lang.String[] { "Collection", "DataModel", "Criteria", "Args", "Limit", "Order", });
    internal_static_Mysqlx_Crud_CreateView_descriptor =
      getDescriptor().getMessageTypes().get(10);
    internal_static_Mysqlx_Crud_CreateView_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Crud_CreateView_descriptor,
        new java.lang.String[] { "Collection", "Definer", "Algorithm", "Security", "Check", "Column", "Stmt", "ReplaceExisting", });
    internal_static_Mysqlx_Crud_ModifyView_descriptor =
      getDescriptor().getMessageTypes().get(11);
    internal_static_Mysqlx_Crud_ModifyView_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Crud_ModifyView_descriptor,
        new java.lang.String[] { "Collection", "Definer", "Algorithm", "Security", "Check", "Column", "Stmt", });
    internal_static_Mysqlx_Crud_DropView_descriptor =
      getDescriptor().getMessageTypes().get(12);
    internal_static_Mysqlx_Crud_DropView_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Crud_DropView_descriptor,
        new java.lang.String[] { "Collection", "IfExists", });
    com.mysql.cj.x.protobuf.MysqlxExpr.getDescriptor();
    com.mysql.cj.x.protobuf.MysqlxDatatypes.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
