/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.util.List;
import scala_maven.FileUtils;
import scala_maven.ScalaCompilerSupport;
import scala_maven_executions.JavaMainCaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalaContinuousCompileMojo
extends ScalaCompilerSupport {
    protected File mainOutputDir;
    protected File mainSourceDir;
    protected File testOutputDir;
    protected File testSourceDir;
    protected boolean useFsc = true;
    protected boolean once = false;
    protected boolean verbose = false;

    @Override
    protected List<String> getClasspathElements() throws Exception {
        throw new UnsupportedOperationException("USELESS");
    }

    @Override
    protected File getOutputDir() throws Exception {
        throw new UnsupportedOperationException("USELESS");
    }

    @Override
    protected List<File> getSourceDirectories() throws Exception {
        throw new UnsupportedOperationException("USELESS");
    }

    @Override
    protected JavaMainCaller getScalaCommand() throws Exception {
        JavaMainCaller jcmd = super.getScalaCommand();
        if (this.useFsc && this.verbose) {
            jcmd.addOption("-verbose", this.verbose);
        }
        return jcmd;
    }

    @Override
    protected final void doExecute() throws Exception {
        this.mainOutputDir = FileUtils.fileOf(this.mainOutputDir, this.useCanonicalPath);
        if (!this.mainOutputDir.exists()) {
            this.mainOutputDir.mkdirs();
        }
        this.mainSourceDir = FileUtils.fileOf(this.mainSourceDir, this.useCanonicalPath);
        this.testOutputDir = FileUtils.fileOf(this.testOutputDir, this.useCanonicalPath);
        if (!this.testOutputDir.exists()) {
            this.testOutputDir.mkdirs();
        }
        this.testSourceDir = FileUtils.fileOf(this.testSourceDir, this.useCanonicalPath);
        if (this.useFsc) {
            this.getLog().info((CharSequence)"use fsc for compilation");
            this.scalaClassName = "scala.tools.nsc.CompileClient";
            if (!this.once) {
                StopServer stopServer = new StopServer();
                stopServer.run();
                this.startNewCompileServer();
                Runtime.getRuntime().addShutdownHook(stopServer);
            } else {
                this.startNewCompileServer();
            }
        }
        this.getLog().info((CharSequence)"wait for files to compile...");
        do {
            this.clearCompileErrors();
            int nbFile = 0;
            if (this.mainSourceDir.exists() && (nbFile = this.compile(this.mainSourceDir, this.mainOutputDir, (List<String>)this.project.getCompileClasspathElements(), true)) == -1) {
                nbFile = 0;
            }
            if (this.testSourceDir.exists()) {
                nbFile += this.compile(this.testSourceDir, this.testOutputDir, (List<String>)this.project.getTestClasspathElements(), true);
            }
            if (nbFile > 0) {
                if (!this.hasCompileErrors()) {
                    this.postCompileActions();
                } else {
                    this.getLog().info((CharSequence)"Not running test cases due to compile error");
                }
            }
            if (this.once) continue;
            if (nbFile > 0) {
                this.getLog().info((CharSequence)"wait for files to compile...");
                Thread.sleep(5000L);
                continue;
            }
            Thread.sleep(3000L);
        } while (!this.once);
    }

    protected void postCompileActions() throws Exception {
    }

    private void startNewCompileServer() throws Exception {
        File serverTagFile = new File(this.mainOutputDir + ".server");
        if (serverTagFile.exists()) {
            return;
        }
        this.getLog().info((CharSequence)"start server...");
        JavaMainCaller jcmd = this.getEmptyScalaCommand("scala.tools.nsc.MainGenericRunner");
        jcmd.addArgs("scala.tools.nsc.CompileServer");
        jcmd.addJvmArgs(this.jvmArgs);
        jcmd.addArgs(this.args);
        jcmd.spawn(this.displayCmd);
        FileUtils.fileWrite((String)serverTagFile.getAbsolutePath(), (String)".");
        Thread.sleep(1000L);
    }

    private class StopServer
    extends Thread {
        private StopServer() {
        }

        public void run() {
            try {
                ScalaContinuousCompileMojo.this.getLog().info((CharSequence)"stop server(s)...");
                JavaMainCaller jcmd = ScalaContinuousCompileMojo.this.getScalaCommand();
                jcmd.addArgs("-shutdown");
                jcmd.run(ScalaContinuousCompileMojo.this.displayCmd, false);
                File serverTagFile = new File(ScalaContinuousCompileMojo.this.mainOutputDir + ".server");
                if (serverTagFile.exists()) {
                    serverTagFile.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

