/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import javax.imageio.ImageIO;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.CounterRequest;
import net.bull.javamelody.internal.model.Range;
import net.bull.javamelody.internal.model.RrdNioBackend;
import net.bull.javamelody.internal.model.RrdNioBackendFactory;
import org.jrobin.core.RrdBackendFactory;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDbPool;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.Sample;
import org.jrobin.core.Util;
import org.jrobin.data.DataProcessor;
import org.jrobin.data.Plottable;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;

public final class JRobin {
    public static final int SMALL_HEIGHT = 50;
    private static final Color PERCENTILE_COLOR = new Color(200, 50, 50);
    private static final Color LIGHT_RED = Color.RED.brighter().brighter();
    private static final Paint SMALL_GRADIENT = new GradientPaint(0.0f, 0.0f, LIGHT_RED, 0.0f, 50.0f, Color.GREEN, false);
    private static final int HOUR = 3600;
    private static final int DAY = 86400;
    private static final int DEFAULT_OBSOLETE_GRAPHS_DAYS = 90;
    private final RrdDbPool rrdPool = JRobin.getRrdDbPool();
    private final String application;
    private final String name;
    private final String rrdFileName;
    private final int step;
    private final String requestName;

    private JRobin(String application, String name, File rrdFile, int step, String requestName) throws RrdException, IOException {
        assert (application != null);
        assert (name != null);
        assert (rrdFile != null);
        assert (step > 0);
        this.application = application;
        this.name = name;
        this.rrdFileName = rrdFile.getPath();
        this.step = step;
        this.requestName = requestName;
        this.init();
    }

    public static void stop() {
        if (RrdNioBackend.getFileSyncTimer() != null) {
            RrdNioBackend.getFileSyncTimer().cancel();
        }
    }

    public static void initBackendFactory(Timer timer) throws IOException {
        RrdNioBackend.setFileSyncTimer(timer);
        try {
            if (!RrdBackendFactory.getDefaultFactory().getFactoryName().equals("NIO-JavaMelody")) {
                RrdBackendFactory.registerAndSetAsDefaultFactory((RrdBackendFactory)new RrdNioBackendFactory());
            }
        }
        catch (RrdException e) {
            throw JRobin.createIOException((Exception)((Object)e));
        }
    }

    static JRobin createInstance(String application, String name, String requestName) throws IOException {
        File rrdFile = JRobin.getRrdFile(application, name);
        int step = Parameters.getResolutionSeconds();
        try {
            return new JRobin(application, name, rrdFile, step, requestName);
        }
        catch (RrdException e) {
            throw JRobin.createIOException((Exception)((Object)e));
        }
    }

    static JRobin createInstanceIfFileExists(String application, String name, String requestName) throws IOException {
        File rrdFile = JRobin.getRrdFile(application, name);
        if (rrdFile.exists()) {
            int step = Parameters.getResolutionSeconds();
            try {
                return new JRobin(application, name, rrdFile, step, requestName);
            }
            catch (RrdException e) {
                throw JRobin.createIOException((Exception)((Object)e));
            }
        }
        return null;
    }

    private static File getRrdFile(String application, String name) {
        File dir = Parameters.getStorageDirectory(application);
        return new File(dir, name + ".rrd");
    }

    private void init() throws IOException, RrdException {
        File rrdFile = new File(this.rrdFileName);
        File rrdDirectory = rrdFile.getParentFile();
        if (!rrdDirectory.mkdirs() && !rrdDirectory.exists()) {
            throw new IOException("JavaMelody directory can't be created: " + rrdDirectory.getPath());
        }
        if (!rrdFile.exists() || rrdFile.length() == 0L) {
            RrdDef rrdDef = new RrdDef(this.rrdFileName, (long)this.step);
            rrdDef.setStartTime(Util.getTime() - (long)this.step);
            String dsType = "GAUGE";
            int heartbeat = this.step * 2;
            rrdDef.addDatasource(this.getDataSourceName(), "GAUGE", (long)heartbeat, 0.0, Double.NaN);
            String average = "AVERAGE";
            String max = "MAX";
            rrdDef.addArchive("AVERAGE", 0.25, 1, 86400 / this.step);
            rrdDef.addArchive("MAX", 0.25, 1, 86400 / this.step);
            rrdDef.addArchive("AVERAGE", 0.25, 3600 / this.step, 168);
            rrdDef.addArchive("MAX", 0.25, 3600 / this.step, 168);
            rrdDef.addArchive("AVERAGE", 0.25, 21600 / this.step, 124);
            rrdDef.addArchive("MAX", 0.25, 21600 / this.step, 124);
            rrdDef.addArchive("AVERAGE", 0.25, 172800 / this.step, 360);
            rrdDef.addArchive("MAX", 0.25, 172800 / this.step, 360);
            RrdDb rrdDb = this.rrdPool.requestRrdDb(rrdDef);
            this.rrdPool.release(rrdDb);
        }
    }

    private void resetFile() throws IOException {
        this.deleteFile();
        try {
            this.init();
        }
        catch (RrdException e) {
            throw JRobin.createIOException((Exception)((Object)e));
        }
    }

    public byte[] graph(Range range, int width, int height) throws IOException {
        return this.graph(range, width, height, false);
    }

    public byte[] graph(Range range, int width, int height, boolean maxHidden) throws IOException {
        AppContextClassLoaderLeakPrevention.dummy();
        try {
            RrdGraphDef graphDef = new RrdGraphDef();
            if (Locale.CHINESE.getLanguage().equals(I18N.getResourceBundle().getLocale().getLanguage())) {
                graphDef.setSmallFont(new Font("Monospaced", 0, 10));
                graphDef.setLargeFont(new Font("Monospaced", 1, 12));
            }
            this.initGraphSource(graphDef, height, maxHidden, range);
            this.initGraphPeriodAndSize(range, width, height, graphDef);
            graphDef.setImageFormat("png");
            graphDef.setFilename("-");
            graphDef.setPoolUsed(true);
            return new RrdGraph(graphDef).getRrdGraphInfo().getBytes();
        }
        catch (RrdException e) {
            throw JRobin.createIOException((Exception)((Object)e));
        }
    }

    private void initGraphPeriodAndSize(Range range, int width, int height, RrdGraphDef graphDef) {
        String titleEnd;
        long endTime = range.getJRobinEndTime();
        long startTime = range.getJRobinStartTime();
        String label = this.getLabel();
        String titleStart = label.length() > 31 && width <= 200 ? label : label + " - " + range.getLabel();
        if (width > 400) {
            titleEnd = range.getPeriod() == null ? " - " + I18N.getFormattedString("sur", this.getApplication()) : " - " + I18N.getCurrentDate() + ' ' + I18N.getFormattedString("sur", this.getApplication());
        } else {
            titleEnd = "";
            if (range.getPeriod() == null) {
                graphDef.setLargeFont(graphDef.getLargeFont().deriveFont(graphDef.getLargeFont().getSize2D() - 2.0f));
            }
        }
        graphDef.setStartTime(startTime);
        graphDef.setEndTime(endTime);
        graphDef.setTitle(titleStart + titleEnd);
        graphDef.setFirstDayOfWeek(Calendar.getInstance(I18N.getCurrentLocale()).getFirstDayOfWeek());
        graphDef.setWidth(width);
        graphDef.setHeight(height);
        if (width <= 100) {
            graphDef.setNoLegend(true);
            graphDef.setUnitsLength(0);
            graphDef.setShowSignature(false);
            graphDef.setTitle(null);
        }
    }

    private void initGraphSource(RrdGraphDef graphDef, int height, boolean maxHidden, Range range) throws IOException {
        String dataSourceName = this.getDataSourceName();
        String average = "average";
        graphDef.datasource("average", this.rrdFileName, dataSourceName, "AVERAGE");
        graphDef.setMinValue(0.0);
        String moyenneLabel = I18N.getString("Moyenne");
        graphDef.area("average", JRobin.getPaint(height), moyenneLabel);
        graphDef.gprint("average", "AVERAGE", moyenneLabel + ": %9.0f %S\\r");
        if (!maxHidden) {
            String max = "max";
            graphDef.datasource("max", this.rrdFileName, dataSourceName, "MAX");
            String maximumLabel = I18N.getString("Maximum");
            graphDef.line("max", (Paint)Color.BLUE, maximumLabel);
            graphDef.gprint("max", "MAX", maximumLabel + ": %9.0f %S\\r");
        }
        if (height > 200) {
            final double percentileValue = this.get95PercentileValue(range);
            Plottable constantDataSource = new Plottable(){

                public double getValue(long timestamp) {
                    return percentileValue;
                }
            };
            String percentile = "percentile";
            graphDef.datasource("percentile", constantDataSource);
            String percentileLabel = I18N.getString("95percentile");
            graphDef.line("percentile", (Paint)PERCENTILE_COLOR, percentileLabel);
            graphDef.gprint("percentile", "MAX", ":%9.0f %S\\r");
        }
    }

    private static Paint getPaint(int height) {
        if (height == 50) {
            return SMALL_GRADIENT;
        }
        return new GradientPaint(0.0f, 0.0f, LIGHT_RED, 0.0f, height, Color.GREEN, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addValue(double value) throws IOException {
        try {
            RrdDb rrdDb;
            RrdDb rrdDb2 = rrdDb = this.rrdPool.requestRrdDb(this.rrdFileName);
            synchronized (rrdDb2) {
                try {
                    Sample sample = rrdDb.createSample();
                    if (sample.getTime() > rrdDb.getLastUpdateTime()) {
                        sample.setValue(this.getDataSourceName(), value);
                        sample.update();
                    }
                }
                finally {
                    this.rrdPool.release(rrdDb);
                }
            }
        }
        catch (FileNotFoundException e) {
            if (e.getMessage() != null && e.getMessage().endsWith("[non existent]")) {
                LOG.debug("A JRobin file was deleted and created again: " + new File(this.rrdFileName).getPath());
                this.resetFile();
                this.addValue(value);
            }
        }
        catch (RrdException e) {
            if (e.getMessage() != null && e.getMessage().startsWith("Invalid file header")) {
                LOG.debug("A JRobin file was found corrupted and was reset: " + new File(this.rrdFileName).getPath());
                this.resetFile();
                this.addValue(value);
            }
            throw JRobin.createIOException((Exception)((Object)e));
        }
        catch (IllegalArgumentException e) {
            LOG.debug("A JRobin file was found corrupted and was reset: " + new File(this.rrdFileName).getPath());
            this.resetFile();
            this.addValue(value);
            throw JRobin.createIOException(e);
        }
        catch (ArithmeticException e) {
            LOG.debug("A JRobin file was found corrupted and was reset: " + new File(this.rrdFileName).getPath());
            this.resetFile();
            this.addValue(value);
            throw JRobin.createIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getLastValue() throws IOException {
        double d;
        RrdDb rrdDb = this.rrdPool.requestRrdDb(this.rrdFileName);
        try {
            d = rrdDb.getLastDatasourceValue(this.getDataSourceName());
        }
        catch (Throwable throwable) {
            try {
                this.rrdPool.release(rrdDb);
                throw throwable;
            }
            catch (RrdException e) {
                throw JRobin.createIOException((Exception)((Object)e));
            }
        }
        this.rrdPool.release(rrdDb);
        return d;
    }

    double getMeanValue(Range range) throws IOException {
        assert (range.getPeriod() == null);
        try {
            DataProcessor dproc = this.processData(range);
            return dproc.getAggregate("average", "AVERAGE");
        }
        catch (RrdException e) {
            throw JRobin.createIOException((Exception)((Object)e));
        }
    }

    private double get95PercentileValue(Range range) throws IOException {
        try {
            DataProcessor dproc = this.processData(range);
            return dproc.get95Percentile("average");
        }
        catch (RrdException e) {
            throw JRobin.createIOException((Exception)((Object)e));
        }
    }

    private DataProcessor processData(Range range) throws IOException, RrdException {
        String dataSourceName = this.getDataSourceName();
        long endTime = range.getJRobinEndTime();
        long startTime = range.getJRobinStartTime();
        DataProcessor dproc = new DataProcessor(startTime, endTime);
        dproc.addDatasource("average", this.rrdFileName, dataSourceName, "AVERAGE");
        dproc.setPoolUsed(true);
        dproc.processData();
        return dproc;
    }

    boolean deleteFile() {
        return new File(this.rrdFileName).delete();
    }

    private String getApplication() {
        return this.application;
    }

    public String getName() {
        return this.name;
    }

    private String getDataSourceName() {
        return this.name.substring(0, Math.min(20, this.name.length()));
    }

    public String getLabel() {
        if (this.requestName == null) {
            return I18N.getString(this.getName());
        }
        String shortRequestName = this.requestName.substring(0, Math.min(30, this.requestName.length()));
        return I18N.getFormattedString("Temps_moyens_de", shortRequestName);
    }

    private static IOException createIOException(Exception e) {
        return new IOException(e.getMessage(), e);
    }

    static long deleteObsoleteJRobinFiles(String application) throws IOException {
        Calendar nowMinusThreeMonthsAndADay = Calendar.getInstance();
        nowMinusThreeMonthsAndADay.add(6, -JRobin.getObsoleteGraphsDays());
        nowMinusThreeMonthsAndADay.add(6, -1);
        long timestamp = Util.getTimestamp((Calendar)nowMinusThreeMonthsAndADay);
        RrdDbPool rrdPool = JRobin.getRrdDbPool();
        int counterRequestIdLength = new CounterRequest("", "").getId().length();
        long diskUsage = 0L;
        for (File file : JRobin.listRrdFiles(application)) {
            if (file.getName().length() > counterRequestIdLength && file.lastModified() < nowMinusThreeMonthsAndADay.getTimeInMillis()) {
                try {
                    RrdDb rrdDb = rrdPool.requestRrdDb(file.getPath());
                    boolean obsolete = rrdDb.getLastUpdateTime() < timestamp;
                    rrdPool.release(rrdDb);
                    boolean deleted = false;
                    if (obsolete) {
                        deleted = file.delete();
                    }
                    if (deleted) continue;
                    diskUsage += file.length();
                }
                catch (IOException e) {
                }
                catch (RrdException e) {}
                continue;
            }
            diskUsage += file.length();
        }
        return diskUsage;
    }

    private static int getObsoleteGraphsDays() {
        String param = Parameter.OBSOLETE_GRAPHS_DAYS.getValue();
        if (param != null) {
            int result = Integer.parseInt(param);
            if (result <= 0) {
                throw new IllegalStateException("The parameter obsolete-graphs-days should be > 0 (90 recommended)");
            }
            return result;
        }
        return 90;
    }

    private static List<File> listRrdFiles(String application) {
        FilenameFilter filenameFilter;
        File storageDir = Parameters.getStorageDirectory(application);
        File[] files = storageDir.listFiles(filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fileName) {
                return fileName.endsWith(".rrd");
            }
        });
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(files);
    }

    private static RrdDbPool getRrdDbPool() throws IOException {
        try {
            return RrdDbPool.getInstance();
        }
        catch (RrdException e) {
            throw JRobin.createIOException((Exception)((Object)e));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[application=" + this.getApplication() + ", name=" + this.getName() + ']';
    }

    private static final class AppContextClassLoaderLeakPrevention {
        private AppContextClassLoaderLeakPrevention() {
        }

        static void dummy() {
        }

        static {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                ImageIO.getCacheDirectory();
            }
            catch (Throwable t) {
                LOG.info("prevention of AppContext ClassLoader leak failed, skipping");
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
        }
    }
}

