/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.mongodb.client.MongoDatabase;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.MongoWrapper;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.PriorityOrdered;
import org.springframework.data.mongodb.MongoDbFactory;

public class SpringMongoDbFactoryBeanPostProcessor
implements BeanPostProcessor,
PriorityOrdered {
    private static final boolean MONGO_DB_FACTORY_AVAILABLE = SpringMongoDbFactoryBeanPostProcessor.isMongoDbFactoryAvailable();
    private int order = Integer.MAX_VALUE;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (MONGO_DB_FACTORY_AVAILABLE && bean instanceof MongoDbFactory) {
            final MongoDbFactory mongoDbFactory = (MongoDbFactory)bean;
            InvocationHandler invocationHandler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Object result = method.invoke((Object)mongoDbFactory, args);
                    if (result instanceof MongoDatabase) {
                        result = MongoWrapper.createDatabaseProxy((MongoDatabase)result);
                    }
                    return result;
                }
            };
            return JdbcWrapper.createProxy(mongoDbFactory, invocationHandler);
        }
        return bean;
    }

    private static boolean isMongoDbFactoryAvailable() {
        try {
            Class.forName("org.springframework.data.mongodb.MongoDbFactory");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

