/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import net.bull.javamelody.MonitoringProxy;
import net.bull.javamelody.internal.model.Counter;

public class Stopwatch
implements AutoCloseable {
    private static final Counter SERVICES_COUNTER = MonitoringProxy.getServicesCounter();
    private final String name;
    private final long startTime;
    private long duration;
    private boolean closed;

    public Stopwatch(String stopwatchName) {
        SERVICES_COUNTER.bindContextIncludingCpu(stopwatchName);
        this.startTime = System.currentTimeMillis();
        this.name = stopwatchName;
    }

    public String getName() {
        return this.name;
    }

    public long getDuration() {
        if (this.closed) {
            return this.duration;
        }
        return System.currentTimeMillis() - this.startTime;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (this.closed) {
            throw new IllegalStateException("Stopwatch already closed");
        }
        SERVICES_COUNTER.addRequestForCurrentContext(false);
        this.duration = this.getDuration();
        this.closed = true;
    }
}

