/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Properties;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.common.InputOutput;
import net.bull.javamelody.internal.common.Parameters;

enum PdfFonts {
    NORMAL(PdfFonts.getFont(8.0f, 0)),
    BOLD(PdfFonts.getFont(8.0f, 1)),
    PARAGRAPH_TITLE(PdfFonts.getFont(10.0f, 1)),
    TABLE_CELL(PdfFonts.getFont(5.5f, 0)),
    BOLD_CELL(PdfFonts.getFont(5.5f, 1)),
    BLUE(PdfFonts.getFont(5.5f, 0)),
    INFO_CELL(PdfFonts.getFont(5.5f, 0)),
    WARNING_CELL(PdfFonts.getFont(5.5f, 1)),
    SEVERE_CELL(PdfFonts.getFont(5.5f, 1)),
    TABLE_HEADER(PdfFonts.getFont(5.5f, 1));

    private static final String UKRAINIAN_LANGUAGE = "uk";
    private static final String CZECH_LANGUAGE = "cs";
    private static BaseFont chineseBaseFont;
    private static BaseFont dejaVuSansBaseFont;
    private final transient Font font;
    private transient Font chineseFont;
    private transient Font dejaVuSansFont;

    private PdfFonts(Font font) {
        this.font = font;
    }

    Font getFont() {
        String language = I18N.getResourceBundle().getLocale().getLanguage();
        if (Locale.CHINESE.getLanguage().equals(language)) {
            return this.getChineseFont();
        }
        if (UKRAINIAN_LANGUAGE.equals(language) || CZECH_LANGUAGE.equals(language)) {
            return this.getDejaVuSansFont();
        }
        return this.font;
    }

    private static Font getFont(float size, int style) {
        return FontFactory.getFont((String)"Helvetica", (float)size, (int)style);
    }

    private Font getChineseFont() {
        if (this.chineseFont == null) {
            BaseFont bfChinese = PdfFonts.getChineseBaseFont();
            this.chineseFont = new Font(bfChinese, this.font.getSize(), this.font.getStyle());
        }
        return this.chineseFont;
    }

    private static synchronized BaseFont getChineseBaseFont() {
        if (chineseBaseFont == null) {
            try {
                try {
                    chineseBaseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
                }
                catch (DocumentException e) {
                    PdfFonts.loadCJKFonts();
                    chineseBaseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
                }
            }
            catch (DocumentException e) {
                throw new IllegalStateException(e);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return chineseBaseFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadCJKFonts() {
        block10: {
            try {
                InputStream is;
                Class<?> cjkFontClass = Class.forName("com.lowagie.text.pdf.CJKFont");
                Field cjkFontsField = cjkFontClass.getDeclaredField("cjkFonts");
                Field cjkEncodingsField = cjkFontClass.getDeclaredField("cjkEncodings");
                cjkFontsField.setAccessible(true);
                cjkEncodingsField.setAccessible(true);
                Properties cjkFonts = (Properties)cjkFontsField.get(null);
                Properties cjkEncodings = (Properties)cjkEncodingsField.get(null);
                if (cjkFonts.isEmpty()) {
                    is = BaseFont.getResourceStream((String)"com/lowagie/text/pdf/fonts/cjkfonts.properties.renamedForIssue258");
                    try {
                        cjkFonts.load(is);
                    }
                    finally {
                        is.close();
                    }
                }
                if (!cjkEncodings.isEmpty()) break block10;
                is = BaseFont.getResourceStream((String)"com/lowagie/text/pdf/fonts/cjkencodings.properties.renamedForIssue258");
                try {
                    cjkEncodings.load(is);
                }
                finally {
                    is.close();
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private Font getDejaVuSansFont() {
        if (this.dejaVuSansFont == null) {
            BaseFont bfDejaVuSans = PdfFonts.getDejaVuSansBaseFont();
            this.dejaVuSansFont = new Font(bfDejaVuSans, this.font.getSize(), this.font.getStyle());
        }
        return this.dejaVuSansFont;
    }

    private static synchronized BaseFont getDejaVuSansBaseFont() {
        InputStream input;
        if (dejaVuSansBaseFont == null && (input = PdfFonts.class.getResourceAsStream("/DejaVuSans-Bold.ttf")) != null) {
            try {
                try {
                    File file = new File(Parameters.TEMPORARY_DIRECTORY, "javamelody-ukrainian.ttf");
                    InputOutput.pumpToFile(input, file);
                    dejaVuSansBaseFont = BaseFont.createFont((String)file.getPath(), (String)"Identity-H", (boolean)true);
                }
                finally {
                    input.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            catch (DocumentException e) {
                throw new IllegalStateException(e);
            }
        }
        return dejaVuSansBaseFont;
    }

    static boolean shouldUseEnglishInsteadOfUkrainian() {
        return UKRAINIAN_LANGUAGE.equals(I18N.getResourceBundle().getLocale().getLanguage()) && PdfFonts.getDejaVuSansBaseFont() == null;
    }

    static {
        PdfFonts.BLUE.font.setColor(Color.BLUE);
        PdfFonts.INFO_CELL.font.setColor(Color.GREEN);
        PdfFonts.WARNING_CELL.font.setColor(Color.ORANGE);
        PdfFonts.SEVERE_CELL.font.setColor(Color.RED);
    }
}

