/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.html;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import net.bull.javamelody.internal.model.MBeanNode;
import net.bull.javamelody.internal.model.PID;
import net.bull.javamelody.internal.web.html.HtmlAbstractReport;

class HtmlMBeansReport
extends HtmlAbstractReport {
    private static final String BR = "<br/>";
    private final List<MBeanNode> mbeans;
    private final String pid = PID.getPID();
    private int sequence;

    HtmlMBeansReport(List<MBeanNode> mbeans, Writer writer) {
        super(writer);
        assert (mbeans != null);
        this.mbeans = mbeans;
    }

    @Override
    void toHtml() throws IOException {
        this.writeLinks();
        this.writeln(BR);
        this.writeTitle("mbeans.png", HtmlMBeansReport.getString("MBeans"));
        this.writeTree();
    }

    void writeTree() throws IOException {
        if (this.mbeans.isEmpty()) {
            return;
        }
        String endDiv = "</div>";
        MBeanNode platformNode = this.mbeans.get(0);
        this.writeln("<div class='mbeanNode'>");
        this.writeTree(platformNode.getChildren());
        this.writeln("</div>");
        for (MBeanNode node : this.mbeans) {
            if (node == platformNode) continue;
            this.writeDirectly("<br/><b>" + HtmlMBeansReport.htmlEncodeButNotSpace(node.getName()) + "</b>");
            this.writeln("<div class='mbeanNode'><br/>");
            this.writeTree(node.getChildren());
            this.writeln("</div>");
        }
    }

    private void writeTree(List<MBeanNode> nodes) throws IOException {
        boolean first = true;
        for (MBeanNode node : nodes) {
            String name = node.getName();
            if (first) {
                first = false;
            } else {
                this.write(BR);
            }
            List<MBeanNode> children = node.getChildren();
            if (children != null) {
                String id = this.getNextId();
                this.writePrintedShowHideLink(id, HtmlMBeansReport.htmlEncodeButNotSpace(name));
                this.writeln("<div id='" + id + "' class='displayNone mbeanNode'><div>");
                this.writeTree(children);
                this.writeln("</div></div>");
                continue;
            }
            this.writeMBeanNode(node);
        }
    }

    private void writeMBeanNode(MBeanNode mbean) throws IOException {
        String mbeanName = mbean.getName();
        String mbeanId = this.getNextId();
        int indexOfComma = mbeanName.indexOf(44);
        if (indexOfComma != -1) {
            mbeanName = mbeanName.substring(indexOfComma + 1);
            this.writePrintedShowHideLink(mbeanId, HtmlMBeansReport.htmlEncodeButNotSpace(mbeanName));
            this.writeln("<div id='" + mbeanId + "' class='displayNone mbeanNode'>");
            this.writeAttributes(mbean);
            this.writeln("</div>");
        } else {
            this.writeAttributes(mbean);
        }
    }

    private void writeAttributes(MBeanNode mbean) throws IOException {
        String description = mbean.getDescription();
        List<MBeanNode.MBeanAttribute> attributes = mbean.getAttributes();
        if (description != null || !attributes.isEmpty()) {
            this.writeln("<table border='0' summary=''>");
            if (description != null) {
                this.write("<tr><td colspan='3' class='mbeanAttributes'>(");
                this.writeDirectly(HtmlMBeansReport.htmlEncodeButNotSpace(description));
                this.write(")</td></tr>");
            }
            for (MBeanNode.MBeanAttribute attribute : attributes) {
                this.writeAttribute(mbean, attribute);
            }
            this.writeln("</table>");
        }
    }

    private void writeAttribute(MBeanNode mbean, MBeanNode.MBeanAttribute attribute) throws IOException {
        String attributeName = attribute.getName();
        String formattedValue = attribute.getFormattedValue();
        String description = attribute.getDescription();
        this.write("<tr valign='top'><td>");
        if (mbean.getName().indexOf(124) == -1 && attributeName.indexOf(124) == -1) {
            this.writeDirectly("<a href='?jmxValue=" + mbean.getName().replace(" ", "%20").replace("'", "%27") + '.' + attributeName + "' ");
            this.writeln("title=\"#Lien_valeur_mbeans#\">-</a>&nbsp;");
        } else {
            this.writeln("-&nbsp;");
        }
        this.writeDirectly(HtmlMBeansReport.htmlEncodeButNotSpace(attributeName));
        this.write("</td><td>");
        this.writeDirectly(HtmlMBeansReport.htmlEncodeButNotSpace(formattedValue));
        this.write("</td><td>");
        if (description != null) {
            this.write("(");
            this.writeDirectly(HtmlMBeansReport.htmlEncodeButNotSpace(description));
            this.write(")");
        } else {
            this.write("&nbsp;");
        }
        this.write("</td></tr>");
    }

    private String getNextId() {
        return 'x' + this.pid + '_' + this.sequence++;
    }

    void writeLinks() throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a class='back' href=''><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=mbeans'><img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        if (HtmlMBeansReport.isPdfEnabled()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=mbeans&amp;format=pdf' title='#afficher_PDF#'>");
            this.write("<img src='?resource=pdf.png' alt='#PDF#'/> #PDF#</a>");
        }
        this.writeln("</div>");
    }

    private void writePrintedShowHideLink(String idToShow, String label) throws IOException {
        this.writeDirectly("<a class='showHide' href='' id='" + idToShow + "A' data-show-hide-id='" + idToShow + "'><img id='" + idToShow + "Img' src='?resource=bullets/plus.png' alt=''/> " + label + "</a>");
    }
}

