/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.pdf;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.bull.javamelody.internal.common.Parameters;

public final class Bar {
    private static final double MIN_VALUE = 0.0;
    private static final double MAX_VALUE = 100.0;
    private static final int PARTIAL_BLOCKS = 5;
    private static final int FULL_BLOCKS = 10;
    private static final double UNIT_SIZE = 2.0;
    private final double percentValue;
    private final BufferedImage image;
    private final Graphics graphics;
    private int x;
    private final boolean alertOnHighUsage;

    private Bar(double percentValue, boolean alertOnHighUsage) {
        this.percentValue = percentValue;
        this.alertOnHighUsage = alertOnHighUsage;
        this.image = alertOnHighUsage ? new BufferedImage(130, 14, 2) : new BufferedImage(106, 10, 2);
        this.graphics = this.image.getGraphics();
    }

    public static BufferedImage toBar(double percentValue) throws IOException {
        Bar bar = new Bar(percentValue, false);
        bar.draw();
        bar.graphics.dispose();
        return bar.image;
    }

    public static BufferedImage toBarWithAlert(double percentValue) throws IOException {
        Bar bar = new Bar(percentValue, percentValue >= 95.0);
        bar.draw();
        bar.graphics.dispose();
        return bar.image;
    }

    private void draw() throws IOException {
        assert (this.x == 0);
        double myPercent = Math.max(Math.min(this.percentValue, 100.0), 0.0);
        int fullBlockCount = (int)Math.floor(myPercent / 10.0);
        int partialBlockIndex = (int)Math.floor((myPercent - (double)fullBlockCount * 2.0 * 5.0) / 2.0);
        this.addImage(Bar.getBarImage(fullBlockCount > 0 || partialBlockIndex > 0 ? "a" : "a0"));
        BufferedImage fullBody = Bar.getBarImage(String.valueOf(5));
        for (int i = 0; i < fullBlockCount; ++i) {
            this.addImage(fullBody);
        }
        if (partialBlockIndex > 0) {
            BufferedImage partialBody = Bar.getBarImage(String.valueOf(partialBlockIndex));
            this.addImage(partialBody);
        }
        int emptyBlocks = 10 - fullBlockCount - (partialBlockIndex > 0 ? 1 : 0);
        BufferedImage emptyBody = Bar.getBarImage(String.valueOf(0));
        for (int i = 0; i < emptyBlocks; ++i) {
            this.addImage(emptyBody);
        }
        this.addImage(Bar.getBarImage(fullBlockCount == 10 ? "b" : "b0"));
        if (this.alertOnHighUsage) {
            this.x += 8;
            this.graphics.drawImage(Bar.getImage("alert.png"), this.x, 0, null);
        }
    }

    private void addImage(BufferedImage img) {
        this.graphics.drawImage(img, this.x, this.alertOnHighUsage ? 4 : 0, null);
        this.x += img.getWidth();
    }

    private static BufferedImage getBarImage(String key) throws IOException {
        return Bar.getImage("bar/rb_" + key + ".gif");
    }

    private static BufferedImage getImage(String fileName) throws IOException {
        return ImageIO.read(Bar.class.getResource(Parameters.getResourcePath(fileName)));
    }
}

