/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.utils;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import net.dongliu.apk.parser.exception.ParserException;
import net.dongliu.apk.parser.parser.StringPoolEntry;
import net.dongliu.apk.parser.struct.ResourceValue;
import net.dongliu.apk.parser.struct.StringPool;
import net.dongliu.apk.parser.struct.StringPoolHeader;
import net.dongliu.apk.parser.utils.Buffers;
import net.dongliu.apk.parser.utils.Unsigned;

public class ParseUtils {
    public static Charset charsetUTF8 = Charset.forName("UTF-8");

    public static String readString(ByteBuffer buffer, boolean utf8) {
        if (utf8) {
            int strLen = ParseUtils.readLen(buffer);
            int bytesLen = ParseUtils.readLen(buffer);
            byte[] bytes = Buffers.readBytes(buffer, bytesLen);
            String str = new String(bytes, charsetUTF8);
            short trailling = Buffers.readUByte(buffer);
            return str;
        }
        int strLen = ParseUtils.readLen16(buffer);
        String str = Buffers.readString(buffer, strLen);
        int trailling = Buffers.readUShort(buffer);
        return str;
    }

    public static String readStringUTF16(ByteBuffer buffer, int strLen) {
        String str = Buffers.readString(buffer, strLen);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c != '\u0000') continue;
            return str.substring(0, i);
        }
        return str;
    }

    private static int readLen(ByteBuffer buffer) {
        int len = 0;
        int i = Buffers.readUByte(buffer);
        if ((i & 0x80) != 0) {
            len |= (i & 0x7F) << 8;
            len += Buffers.readUByte(buffer);
        } else {
            len = i;
        }
        return len;
    }

    private static int readLen16(ByteBuffer buffer) {
        int len = 0;
        int i = Buffers.readUShort(buffer);
        if ((i & 0x8000) != 0) {
            len |= (i & Short.MAX_VALUE) << 16;
            len += Buffers.readUShort(buffer);
        } else {
            len = i;
        }
        return len;
    }

    public static StringPool readStringPool(ByteBuffer buffer, StringPoolHeader stringPoolHeader) {
        long beginPos = buffer.position();
        int[] offsets = new int[stringPoolHeader.getStringCount()];
        if (stringPoolHeader.getStringCount() > 0) {
            for (int idx = 0; idx < stringPoolHeader.getStringCount(); ++idx) {
                offsets[idx] = Unsigned.toUInt(Buffers.readUInt(buffer));
            }
        }
        boolean sorted = (stringPoolHeader.getFlags() & 1L) != 0L;
        boolean utf8 = (stringPoolHeader.getFlags() & 0x100L) != 0L;
        long stringPos = beginPos + stringPoolHeader.getStringsStart() - (long)stringPoolHeader.getHeaderSize();
        Buffers.position(buffer, stringPos);
        StringPoolEntry[] entries = new StringPoolEntry[offsets.length];
        for (int i = 0; i < offsets.length; ++i) {
            entries[i] = new StringPoolEntry(i, stringPos + Unsigned.toLong(offsets[i]));
        }
        String lastStr = null;
        long lastOffset = -1L;
        StringPool stringPool = new StringPool(stringPoolHeader.getStringCount());
        for (StringPoolEntry entry : entries) {
            String str;
            if (entry.getOffset() == lastOffset) {
                stringPool.set(entry.getIdx(), lastStr);
                continue;
            }
            Buffers.position(buffer, entry.getOffset());
            lastOffset = entry.getOffset();
            lastStr = str = ParseUtils.readString(buffer, utf8);
            stringPool.set(entry.getIdx(), str);
        }
        if (stringPoolHeader.getStyleCount() > 0) {
            // empty if block
        }
        Buffers.position(buffer, beginPos + (long)stringPoolHeader.getBodySize());
        return stringPool;
    }

    @Nullable
    public static ResourceValue readResValue(ByteBuffer buffer, StringPool stringPool) {
        int size = Buffers.readUShort(buffer);
        short res0 = Buffers.readUByte(buffer);
        short dataType = Buffers.readUByte(buffer);
        switch (dataType) {
            case 16: {
                return ResourceValue.decimal(buffer.getInt());
            }
            case 17: {
                return ResourceValue.hexadecimal(buffer.getInt());
            }
            case 3: {
                int strRef = buffer.getInt();
                if (strRef >= 0) {
                    return ResourceValue.string(strRef, stringPool);
                }
                return null;
            }
            case 1: {
                return ResourceValue.reference(buffer.getInt());
            }
            case 18: {
                return ResourceValue.bool(buffer.getInt());
            }
            case 0: {
                return ResourceValue.nullValue();
            }
            case 29: 
            case 31: {
                return ResourceValue.rgb(buffer.getInt(), 6);
            }
            case 28: 
            case 30: {
                return ResourceValue.rgb(buffer.getInt(), 8);
            }
            case 5: {
                return ResourceValue.dimension(buffer.getInt());
            }
            case 6: {
                return ResourceValue.fraction(buffer.getInt());
            }
        }
        return ResourceValue.raw(buffer.getInt(), dataType);
    }

    public static void checkChunkType(int expected, int real) {
        if (expected != real) {
            throw new ParserException("Expect chunk type:" + Integer.toHexString(expected) + ", but got:" + Integer.toHexString(real));
        }
    }
}

