/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities.channel.concrete;

import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.annotations.Incubating;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.channel.ChannelFlag;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.entities.channel.attribute.IAgeRestrictedChannel;
import net.dv8tion.jda.api.entities.channel.attribute.ISlowmodeChannel;
import net.dv8tion.jda.api.entities.channel.attribute.IThreadContainer;
import net.dv8tion.jda.api.entities.channel.attribute.IWebhookContainer;
import net.dv8tion.jda.api.entities.channel.forums.ForumTag;
import net.dv8tion.jda.api.entities.channel.middleman.StandardGuildChannel;
import net.dv8tion.jda.api.entities.emoji.EmojiUnion;
import net.dv8tion.jda.api.managers.channel.concrete.ForumChannelManager;
import net.dv8tion.jda.api.requests.restaction.ChannelAction;
import net.dv8tion.jda.api.requests.restaction.ForumPostAction;
import net.dv8tion.jda.api.utils.cache.SortedSnowflakeCacheView;
import net.dv8tion.jda.api.utils.messages.MessageCreateData;

public interface ForumChannel
extends StandardGuildChannel,
IThreadContainer,
IWebhookContainer,
IAgeRestrictedChannel,
ISlowmodeChannel {
    public static final int MAX_FORUM_TOPIC_LENGTH = 4096;
    public static final int MAX_POST_TAGS = 5;

    @Override
    @Nonnull
    default public ChannelType getType() {
        return ChannelType.FORUM;
    }

    @Override
    @Nonnull
    public ForumChannelManager getManager();

    @Nonnull
    public ChannelAction<ForumChannel> createCopy(@Nonnull Guild var1);

    @Nonnull
    default public ChannelAction<ForumChannel> createCopy() {
        return this.createCopy(this.getGuild());
    }

    @Nonnull
    public SortedSnowflakeCacheView<ForumTag> getAvailableTagCache();

    @Nonnull
    default public List<ForumTag> getAvailableTags() {
        return this.getAvailableTagCache().asList();
    }

    @Nonnull
    default public List<ForumTag> getAvailableTagsByName(@Nonnull String name, boolean ignoreCase) {
        return this.getAvailableTagCache().getElementsByName(name, ignoreCase);
    }

    @Nullable
    default public ForumTag getAvailableTagById(long id) {
        return (ForumTag)this.getAvailableTagCache().getElementById(id);
    }

    @Nullable
    default public ForumTag getAvailableTagById(@Nonnull String id) {
        return (ForumTag)this.getAvailableTagCache().getElementById(id);
    }

    @Nullable
    public String getTopic();

    default public boolean isTagRequired() {
        return this.getFlags().contains((Object)ChannelFlag.REQUIRE_TAG);
    }

    @Nullable
    public EmojiUnion getDefaultReaction();

    @Nonnull
    public Layout getDefaultLayout();

    @Nonnull
    @Incubating
    @CheckReturnValue
    public ForumPostAction createForumPost(@Nonnull String var1, @Nonnull MessageCreateData var2);

    public static enum Layout {
        DEFAULT_VIEW(0),
        LIST_VIEW(1),
        GALLERY_VIEW(2),
        UNKNOWN(-1);

        private final int key;

        private Layout(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        @Nonnull
        public static Layout fromKey(int key) {
            for (Layout layout : Layout.values()) {
                if (layout.key != key) continue;
                return layout;
            }
            return UNKNOWN;
        }
    }
}

