/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.handle;

import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.entities.channel.attribute.IAgeRestrictedChannel;
import net.dv8tion.jda.api.entities.channel.concrete.Category;
import net.dv8tion.jda.api.entities.channel.concrete.ForumChannel;
import net.dv8tion.jda.api.entities.channel.concrete.NewsChannel;
import net.dv8tion.jda.api.entities.channel.concrete.PrivateChannel;
import net.dv8tion.jda.api.entities.channel.concrete.StageChannel;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.channel.concrete.VoiceChannel;
import net.dv8tion.jda.api.events.channel.ChannelDeleteEvent;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.GuildImpl;
import net.dv8tion.jda.internal.handle.EventCache;
import net.dv8tion.jda.internal.handle.SocketHandler;
import net.dv8tion.jda.internal.requests.WebSocketClient;
import net.dv8tion.jda.internal.utils.cache.SnowflakeCacheViewImpl;

public class ChannelDeleteHandler
extends SocketHandler {
    public ChannelDeleteHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        ChannelType type = ChannelType.fromId(content.getInt("type"));
        long guildId = 0L;
        if (type.isGuild()) {
            guildId = content.getLong("guild_id");
            if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
                return guildId;
            }
        }
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildById(guildId);
        long channelId = content.getLong("id");
        switch (type) {
            case TEXT: {
                IAgeRestrictedChannel channel = (TextChannel)this.getJDA().getTextChannelsView().remove(channelId);
                if (channel == null || guild == null) {
                    WebSocketClient.LOG.debug("CHANNEL_DELETE attempted to delete a text channel that is not yet cached. JSON: {}", (Object)content);
                    return null;
                }
                guild.getTextChannelsView().remove(channel.getIdLong());
                this.getJDA().handleEvent(new ChannelDeleteEvent(this.getJDA(), this.responseNumber, channel));
                break;
            }
            case NEWS: {
                IAgeRestrictedChannel channel = (NewsChannel)this.getJDA().getNewsChannelView().remove(channelId);
                if (channel == null || guild == null) {
                    WebSocketClient.LOG.debug("CHANNEL_DELETE attempted to delete a news channel that is not yet cached. JSON: {}", (Object)content);
                    return null;
                }
                guild.getNewsChannelView().remove(channel.getIdLong());
                this.getJDA().handleEvent(new ChannelDeleteEvent(this.getJDA(), this.responseNumber, channel));
                break;
            }
            case VOICE: {
                IAgeRestrictedChannel channel = (VoiceChannel)this.getJDA().getVoiceChannelsView().remove(channelId);
                if (channel == null || guild == null) {
                    WebSocketClient.LOG.debug("CHANNEL_DELETE attempted to delete a voice channel that is not yet cached. JSON: {}", (Object)content);
                    return null;
                }
                guild.getVoiceChannelsView().remove(channel.getIdLong());
                this.getJDA().handleEvent(new ChannelDeleteEvent(this.getJDA(), this.responseNumber, channel));
                break;
            }
            case STAGE: {
                IAgeRestrictedChannel channel = (StageChannel)this.getJDA().getStageChannelView().remove(channelId);
                if (channel == null || guild == null) {
                    WebSocketClient.LOG.debug("CHANNEL_DELETE attempted to delete a stage channel that is not yet cached. JSON: {}", (Object)content);
                    return null;
                }
                guild.getStageChannelsView().remove(channel.getIdLong());
                this.getJDA().handleEvent(new ChannelDeleteEvent(this.getJDA(), this.responseNumber, channel));
                break;
            }
            case CATEGORY: {
                Category category = (Category)this.getJDA().getCategoriesView().remove(channelId);
                if (category == null || guild == null) {
                    WebSocketClient.LOG.debug("CHANNEL_DELETE attempted to delete a category channel that is not yet cached. JSON: {}", (Object)content);
                    return null;
                }
                guild.getCategoriesView().remove(channelId);
                this.getJDA().handleEvent(new ChannelDeleteEvent(this.getJDA(), this.responseNumber, category));
                break;
            }
            case FORUM: {
                IAgeRestrictedChannel channel = (ForumChannel)this.getJDA().getForumChannelsView().remove(channelId);
                if (channel == null || guild == null) {
                    WebSocketClient.LOG.debug("CHANNEL_DELETE attempted to delete a forum channel that is not yet cached. JSON: {}", (Object)content);
                    return null;
                }
                guild.getForumChannelsView().remove(channel.getIdLong());
                this.getJDA().handleEvent(new ChannelDeleteEvent(this.getJDA(), this.responseNumber, channel));
                break;
            }
            case PRIVATE: {
                SnowflakeCacheViewImpl<PrivateChannel> privateView = this.getJDA().getPrivateChannelsView();
                PrivateChannel channel = (PrivateChannel)privateView.remove(channelId);
                if (channel != null) break;
                WebSocketClient.LOG.debug("CHANNEL_DELETE attempted to delete a private channel that is not yet cached. JSON: {}", (Object)content);
                return null;
            }
            case GROUP: {
                WebSocketClient.LOG.warn("Received a CHANNEL_DELETE for a channel of type GROUP which is not supported!");
                return null;
            }
            default: {
                WebSocketClient.LOG.debug("CHANNEL_DELETE provided an unknown channel type. JSON: {}", (Object)content);
            }
        }
        if (guild != null) {
            String channelId1 = Long.toUnsignedString(channelId);
            guild.getScheduledEventsView().stream().filter(scheduledEvent -> scheduledEvent.getType().isChannel() && scheduledEvent.getLocation().equals(channelId1)).forEach(scheduledEvent -> guild.getScheduledEventsView().remove(scheduledEvent.getIdLong()));
        }
        this.getJDA().getEventCache().clear(EventCache.Type.CHANNEL, channelId);
        return null;
    }
}

