/*
 * Decompiled with CFR 0.152.
 */
package net.erdfelt.android.apk.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import net.erdfelt.android.apk.io.LEInputStream;
import net.erdfelt.android.apk.xml.Namespace;

public class BinaryXmlInputStream
extends LEInputStream {
    private String[] stringtable = new String[0];
    private Map<String, Namespace> namespaceMap = new HashMap<String, Namespace>();

    public BinaryXmlInputStream(InputStream in) {
        super(in);
    }

    private int copyShort(byte[] buf, int offset) {
        int value = 0;
        value += buf[offset + 1] << 8 & 0xFF00;
        return value |= buf[offset] & 0xFF;
    }

    private String copyUTF16(byte[] buf, int offset) throws UnsupportedEncodingException {
        if (offset < 0) {
            return null;
        }
        int len = this.copyShort(buf, offset);
        byte[] chars = new byte[len * 2];
        for (int i = 0; i < len; ++i) {
            chars[i * 2 + 1] = buf[offset + 2 + i * 2];
            chars[i * 2] = buf[offset + 2 + i * 2 + 1];
        }
        return new String(chars, "UTF-16");
    }

    public String getString(int index) {
        if (index < 0) {
            return null;
        }
        return this.stringtable[index];
    }

    public int readChunkId() throws IOException {
        int id = this.readInt();
        return id;
    }

    public int readChunkSize() throws IOException {
        int size = this.readInt();
        return size;
    }

    public void readNamespaceDef(boolean addDef) throws IOException {
        int chunkSize = this.readChunkSize();
        int lineNumber = this.readInt();
        this.skipInt();
        String prefix = this.readStringRef();
        String uri = this.readStringRef();
        if (addDef) {
            Namespace namespace = new Namespace(prefix, uri);
            this.namespaceMap.put(uri, namespace);
        } else {
            this.namespaceMap.remove(uri);
        }
    }

    public Namespace readNamespaceRef() throws IOException {
        String uri = this.readStringRef();
        if (uri == null) {
            return Namespace.EMPTY;
        }
        return this.namespaceMap.get(uri);
    }

    public String readStringRef() throws IOException {
        int index = this.readInt();
        return this.getString(index);
    }

    public void readStringTableDef() throws IOException {
        int chunkSize = this.readInt();
        int stringCount = this.readInt();
        int styleCount = this.readInt();
        this.skipInt();
        int offsetStrings = this.readInt();
        int offsetStyles = this.readInt();
        int[] stringOffsets = this.readIntArray(stringCount);
        int[] styleOffsets = this.readIntArray(styleCount);
        int bufsize = chunkSize - offsetStrings;
        if (offsetStyles > 0) {
            bufsize = offsetStyles - offsetStrings;
        }
        byte[] rawstrings = this.readByteArray(bufsize);
        this.stringtable = new String[stringCount];
        for (int i = 0; i < stringCount; ++i) {
            this.stringtable[i] = this.copyUTF16(rawstrings, stringOffsets[i]);
        }
    }
}

