/*
 * Decompiled with CFR 0.152.
 */
package net.jadler.matchers;

import java.util.List;
import net.jadler.Request;
import net.jadler.matchers.RequestMatcher;
import org.apache.commons.lang.Validate;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public class ParameterRequestMatcher
extends RequestMatcher<List<String>> {
    private final String paramName;
    private final String desc;

    public ParameterRequestMatcher(Matcher<? super List<String>> pred, String paramName) {
        super(pred);
        Validate.notEmpty((String)paramName, (String)"paramName cannot be empty");
        this.paramName = paramName;
        this.desc = "parameter \"" + paramName + "\" is";
    }

    @Override
    protected List<String> retrieveValue(Request req) {
        return req.getParameters().getValues(this.paramName);
    }

    @Override
    protected String provideDescription() {
        return this.desc;
    }

    @Factory
    public static ParameterRequestMatcher requestParameter(String paramName, Matcher<? super List<String>> pred) {
        return new ParameterRequestMatcher(pred, paramName);
    }
}

