/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import net.javacrumbs.jsonunit.core.internal.Context;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.listener.Difference;

class DifferenceImpl
implements Difference {
    private final Context context;
    private final Difference.Type type;

    DifferenceImpl(Context context, Difference.Type type) {
        this.context = context;
        this.type = type;
    }

    @Override
    public String getActualPath() {
        return this.context.actualPath() != null ? this.context.actualPath().getFullPath() : null;
    }

    @Override
    public String getExpectedPath() {
        return this.context.expectedPath() != null ? this.context.expectedPath().getFullPath() : null;
    }

    @Override
    public Object getActual() {
        Node actualNode = this.context.actualNode();
        return actualNode != null && !actualNode.isMissingNode() ? actualNode.getValue() : null;
    }

    @Override
    public Object getExpected() {
        Node expectedNode = this.context.expectedNode();
        return expectedNode != null && !expectedNode.isMissingNode() ? expectedNode.getValue() : null;
    }

    public String toString() {
        return String.valueOf((Object)this.getType()) + " Expected " + String.valueOf(this.getExpected()) + " in " + this.getExpectedPath() + " got " + String.valueOf(this.getActual()) + " in " + this.getActualPath();
    }

    @Override
    public Difference.Type getType() {
        return this.type;
    }

    static Difference missing(Context context) {
        return new MissingDifference(context.clearActual());
    }

    static Difference extra(Context context) {
        return new ExtraDifference(context.clearExpected());
    }

    static Difference different(Context context) {
        return new DifferenceImpl(context, Difference.Type.DIFFERENT);
    }

    private static class MissingDifference
    extends DifferenceImpl {
        MissingDifference(Context context) {
            super(context, Difference.Type.MISSING);
        }

        @Override
        public String toString() {
            return String.valueOf((Object)this.getType()) + " " + String.valueOf(this.getExpected()) + " in " + this.getExpectedPath();
        }
    }

    private static class ExtraDifference
    extends DifferenceImpl {
        ExtraDifference(Context context) {
            super(context, Difference.Type.EXTRA);
        }

        @Override
        public String toString() {
            return String.valueOf((Object)this.getType()) + " " + String.valueOf(this.getActual()) + " in " + this.getActualPath();
        }
    }
}

