/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.io.Reader;
import java.math.BigDecimal;
import net.javacrumbs.jsonunit.core.internal.GenericNodeBuilder;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.NodeFactory;
import net.javacrumbs.jsonunit.core.internal.Utils;
import org.jspecify.annotations.Nullable;

abstract class AbstractNodeFactory
implements NodeFactory {
    AbstractNodeFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node convertToNode(@Nullable Object source, String label, boolean lenient) {
        String sourceString;
        if (source == null) {
            return this.nullNode();
        }
        if (source instanceof Node) {
            Node node = (Node)source;
            return node;
        }
        if (source instanceof String && !(sourceString = (String)source).trim().isEmpty()) {
            return this.readValue(sourceString, label, lenient);
        }
        if (source instanceof Reader) {
            Reader reader = (Reader)source;
            try {
                Node node = this.readValue(reader, label, lenient);
                return node;
            }
            finally {
                Utils.closeQuietly(reader);
            }
        }
        return this.convertValue(source);
    }

    final Node convertValue(Object source) {
        if (source instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)source;
            return new GenericNodeBuilder.NumberNode(bigDecimal);
        }
        return this.doConvertValue(source);
    }

    protected IllegalArgumentException newParseException(String label, Reader value, Exception e) {
        if (value instanceof Utils.JsonStringReader) {
            Utils.JsonStringReader reader = (Utils.JsonStringReader)value;
            return new IllegalArgumentException("Can not parse " + label + " value: '" + reader.getString() + "'", e);
        }
        return new IllegalArgumentException("Can not parse " + label + " value.", e);
    }

    protected abstract Node doConvertValue(Object var1);

    protected abstract Node readValue(Reader var1, String var2, boolean var3);

    Node readValue(String source, String label, boolean lenient) {
        return this.readValue(Utils.toReader(source), label, lenient);
    }

    protected abstract Node nullNode();
}

