/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.core;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.annotation.NonNull;

public abstract class AbstractSimpleLock
implements SimpleLock {
    private boolean valid = true;
    protected final LockConfiguration lockConfiguration;

    protected AbstractSimpleLock(LockConfiguration lockConfiguration) {
        this.lockConfiguration = lockConfiguration;
    }

    @Override
    public final void unlock() {
        this.checkValidity();
        this.doUnlock();
        this.valid = false;
    }

    protected abstract void doUnlock();

    @Override
    @NonNull
    @Deprecated
    public final Optional<SimpleLock> extend(@NonNull Instant lockAtMostUntil, @NonNull Instant lockAtLeastUntil) {
        Instant now = Instant.now();
        return this.extend(Duration.between(now, lockAtMostUntil), Duration.between(now, lockAtLeastUntil));
    }

    @Override
    @NonNull
    public Optional<SimpleLock> extend(@NonNull Duration lockAtMostFor, @NonNull Duration lockAtLeastFor) {
        this.checkValidity();
        Optional<SimpleLock> result = this.doExtend(new LockConfiguration(this.lockConfiguration.getName(), lockAtMostFor, lockAtLeastFor));
        this.valid = false;
        return result;
    }

    protected Optional<SimpleLock> doExtend(LockConfiguration newConfiguration) {
        throw new UnsupportedOperationException();
    }

    private void checkValidity() {
        if (!this.valid) {
            throw new IllegalStateException("Lock is not valid, it has already been unlocked or extended");
        }
    }
}

