/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.core;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.support.annotation.NonNull;

public class LockConfiguration {
    private final Instant createdAt;
    private final String name;
    private final Duration lockAtMostFor;
    private final Duration lockAtLeastFor;

    public LockConfiguration(@NonNull String name, @NonNull Duration lockAtMostFor, @NonNull Duration lockAtLeastFor) {
        this(ClockProvider.now(), name, lockAtMostFor, lockAtLeastFor);
    }

    @Deprecated
    public LockConfiguration(@NonNull String name, @NonNull Instant lockAtMostUntil) {
        this(name, lockAtMostUntil, ClockProvider.now());
    }

    @Deprecated
    public LockConfiguration(@NonNull String name, @NonNull Instant lockAtMostUntil, @NonNull Instant lockAtLeastUntil) {
        this(ClockProvider.now(), name, lockAtMostUntil, lockAtLeastUntil);
    }

    @Deprecated
    private LockConfiguration(@NonNull Instant createdAt, @NonNull String name, @NonNull Instant lockAtMostUntil, @NonNull Instant lockAtLeastUntil) {
        this(createdAt, name, Duration.between(createdAt, lockAtMostUntil), Duration.between(createdAt, lockAtLeastUntil));
    }

    private LockConfiguration(@NonNull Instant createdAt, @NonNull String name, @NonNull Duration lockAtMostFor, @NonNull Duration lockAtLeastFor) {
        this.createdAt = Objects.requireNonNull(createdAt);
        this.name = Objects.requireNonNull(name);
        this.lockAtMostFor = Objects.requireNonNull(lockAtMostFor);
        this.lockAtLeastFor = Objects.requireNonNull(lockAtLeastFor);
        if (lockAtLeastFor.compareTo(lockAtMostFor) > 0) {
            throw new IllegalArgumentException("lockAtLeastFor is longer than lockAtMostFor for lock '" + name + "'.");
        }
        if (lockAtMostFor.isNegative()) {
            throw new IllegalArgumentException("lockAtMostFor is negative '" + name + "'.");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("lock name can not be empty");
        }
    }

    public String getName() {
        return this.name;
    }

    public Instant getLockAtMostUntil() {
        return this.createdAt.plus(this.lockAtMostFor);
    }

    public Instant getLockAtLeastUntil() {
        return this.createdAt.plus(this.lockAtLeastFor);
    }

    public Instant getUnlockTime() {
        Instant now = ClockProvider.now();
        Instant lockAtLeastUntil = this.getLockAtLeastUntil();
        return lockAtLeastUntil.isAfter(now) ? lockAtLeastUntil : now;
    }

    public Duration getLockAtLeastFor() {
        return this.lockAtLeastFor;
    }

    public Duration getLockAtMostFor() {
        return this.lockAtMostFor;
    }

    public String toString() {
        return "LockConfiguration{name='" + this.name + '\'' + ", lockAtMostFor=" + this.lockAtMostFor + ", lockAtLeastFor=" + this.lockAtLeastFor + '}';
    }
}

