/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.ExecutionResult;
import net.jodah.failsafe.FailsafeExecutor;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.PolicyExecutor;
import net.jodah.failsafe.internal.util.Assert;

public abstract class AbstractExecution
extends ExecutionContext {
    final FailsafeExecutor<Object> executor;
    final List<PolicyExecutor<Policy<Object>>> policyExecutors;
    volatile Object lastResult;
    volatile Throwable lastFailure;
    private volatile long waitNanos;
    volatile boolean completed;

    AbstractExecution(FailsafeExecutor<Object> executor) {
        super(Duration.ofNanos(System.nanoTime()));
        this.executor = executor;
        this.policyExecutors = new ArrayList<PolicyExecutor<Policy<Object>>>(executor.policies.size());
        ListIterator policyIterator = executor.policies.listIterator(executor.policies.size());
        while (policyIterator.hasPrevious()) {
            this.buildPolicyExecutor(policyIterator.previous());
        }
    }

    private void buildPolicyExecutor(Policy policy) {
        PolicyExecutor policyExecutor = policy.toExecutor();
        policyExecutor.execution = this;
        this.policyExecutors.add(policyExecutor);
    }

    void record(ExecutionResult result) {
        Assert.state(!this.completed, "Execution has already been completed", new Object[0]);
        ++this.attempts;
        this.lastResult = result.getResult();
        this.lastFailure = result.getFailure();
    }

    void preExecute() {
    }

    synchronized boolean postExecute(ExecutionResult result) {
        this.record(result);
        for (PolicyExecutor<Policy<Object>> policyExecutor : this.policyExecutors) {
            result = policyExecutor.postExecute(result);
        }
        this.waitNanos = result.getWaitNanos();
        this.completed = result.isComplete();
        return this.completed;
    }

    public <T extends Throwable> T getLastFailure() {
        return (T)this.lastFailure;
    }

    public <T> T getLastResult() {
        return (T)this.lastResult;
    }

    public Duration getWaitTime() {
        return Duration.ofNanos(this.waitNanos);
    }

    public boolean isComplete() {
        return this.completed;
    }
}

