/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe.internal;

import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.internal.CircuitBreakerStats;
import net.jodah.failsafe.internal.CircuitState;

public class OpenState
extends CircuitState {
    private final CircuitBreaker circuit;
    private final long startTime = System.nanoTime();

    public OpenState(CircuitBreaker circuit, CircuitState previousState) {
        this.circuit = circuit;
        this.bitSet = previousState.bitSet;
    }

    @Override
    public boolean allowsExecution(CircuitBreakerStats stats) {
        if (System.nanoTime() - this.startTime >= this.circuit.getDelay().toNanos()) {
            this.circuit.halfOpen();
            return true;
        }
        return false;
    }

    @Override
    public CircuitBreaker.State getState() {
        return CircuitBreaker.State.OPEN;
    }
}

