/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.io.IOException;
import java.io.InputStream;
import java.security.AuthProvider;
import java.security.Key;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import net.jsign.jca.AbstractKeyStoreSpi;

public class AutoLoginProvider
extends Provider {
    private final AuthProvider provider;
    private char[] storepass;

    public AutoLoginProvider(AuthProvider provider) {
        super(provider.getName(), provider.getVersion(), provider.getInfo() + " with auto login");
        this.provider = provider;
    }

    @Override
    public Provider.Service getService(String type, String algorithm) {
        if ("KeyStore".equals(type)) {
            return new PasswordInterceptorService(this.provider.getService(type, algorithm));
        }
        if ("Signature".equals(type) && this.storepass != null) {
            this.login();
        }
        return this.provider.getService(type, algorithm);
    }

    private void login() {
        try {
            this.provider.logout();
            this.provider.login(null, callbacks -> {
                for (Callback callback : callbacks) {
                    if (!(callback instanceof PasswordCallback)) continue;
                    ((PasswordCallback)callback).setPassword(this.storepass);
                }
            });
        }
        catch (LoginException loginException) {
            // empty catch block
        }
    }

    static /* synthetic */ char[] access$002(AutoLoginProvider x0, char[] x1) {
        x0.storepass = x1;
        return x1;
    }

    class PasswordInterceptorKeyStoreSpi
    extends AbstractKeyStoreSpi {
        private final KeyStoreSpi instance;

        public PasswordInterceptorKeyStoreSpi(KeyStoreSpi instance) {
            this.instance = instance;
        }

        @Override
        public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
            AutoLoginProvider.access$002(AutoLoginProvider.this, password);
            this.instance.engineLoad(stream, password);
        }

        @Override
        public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
            return this.instance.engineGetKey(alias, password);
        }

        @Override
        public Certificate[] engineGetCertificateChain(String alias) {
            return this.instance.engineGetCertificateChain(alias);
        }

        @Override
        public Enumeration<String> engineAliases() {
            return this.instance.engineAliases();
        }
    }

    class PasswordInterceptorService
    extends Provider.Service {
        private final Provider.Service service;

        public PasswordInterceptorService(Provider.Service service) {
            super(AutoLoginProvider.this, service.getType(), service.getAlgorithm(), service.getClassName(), null, null);
            this.service = service;
        }

        @Override
        public Object newInstance(Object constructorParameter) throws NoSuchAlgorithmException {
            return new PasswordInterceptorKeyStoreSpi((KeyStoreSpi)this.service.newInstance(constructorParameter));
        }
    }
}

