/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import net.jsign.jca.SmartCard;
import net.jsign.jca.TLV;

public class CryptoCertumCard
extends SmartCard {
    static final byte[] ESIGN_COMMON_PROFILE_AID = new byte[]{-96, 0, 0, 1, 103, 69, 83, 73, 71, 79};

    private CryptoCertumCard(CardChannel channel) throws CardException {
        super(channel);
        this.select();
    }

    private void select() throws CardException {
        this.select("Certum", ESIGN_COMMON_PROFILE_AID);
    }

    public void verify(int p1, int p2, String pin) throws CardException {
        if (pin == null) {
            pin = "";
        }
        byte[] mask = new byte[16];
        System.arraycopy(pin.getBytes(), 0, mask, 0, pin.length());
        ResponseAPDU response = this.transmit(new CommandAPDU(0, 32, p1, p2, pin.isEmpty() ? null : mask));
        this.handleError(response);
    }

    public byte[] getChallenge(int length) throws CardException {
        ResponseAPDU response = this.transmit(new CommandAPDU(0, 132, 0, 0, length));
        this.handleError(response);
        return response.getData();
    }

    public byte[] getFile(int fid) throws CardException {
        return this.getFile(fid, false);
    }

    public byte[] getFile(int fid, boolean partial) throws CardException {
        int cacheId;
        int n = cacheId = partial ? fid | Integer.MIN_VALUE : fid;
        if (this.dataObjectCache.containsKey(cacheId)) {
            return (byte[])this.dataObjectCache.get(cacheId);
        }
        ResponseAPDU response = this.transmit(new CommandAPDU(0, 164, 2, 12, new byte[]{(byte)((fid & 0xFF00) >> 8), (byte)(fid & 0xFF)}));
        this.handleError(response);
        byte[] data = this.readBinary(partial);
        this.dataObjectCache.put(cacheId, data);
        return data;
    }

    private byte[] readBinary(boolean partial) throws CardException {
        int offset = 0;
        int length = 256;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while (true) {
            ResponseAPDU response = this.transmit(new CommandAPDU(0, 176, offset & 0xFF, (offset & 0xFF00) >> 8, length));
            this.handleError(response);
            byte[] data = response.getData();
            bout.write(data, 0, data.length);
            if (data.length < length || partial) break;
            ++offset;
        }
        return bout.toByteArray();
    }

    public byte[] getKeyData(int keyref) throws CardException {
        byte[] template = new byte[]{-74, 3, -125, 1, (byte)keyref, 127, 73, 2, -127, 0};
        ResponseAPDU response = this.transmit(new CommandAPDU(0, 203, 0, 255, template));
        this.handleError(response);
        TLV tlv = TLV.parse(ByteBuffer.wrap(response.getData()));
        return tlv.children().get(1).children().get(0).value();
    }

    public List<Entry> getEntries() throws CardException {
        byte[] data = this.getFile(20530);
        ArrayList<Entry> objects = new ArrayList<Entry>();
        for (int i = 36; i < data.length - 2; i += 2) {
            int type = (data[i] & 0xF0) >> 4;
            int index = data[i] & 0xF;
            Entry entry = null;
            if (index != 0) {
                if (type == 2) {
                    Certificate certificate = new Certificate();
                    certificate.index = index;
                    entry = certificate;
                } else {
                    Key key = new Key();
                    key.index = index;
                    key.type = type;
                    byte algorithm = data[i + 1];
                    block0 : switch (type) {
                        case 0: {
                            switch (algorithm) {
                                case 65: {
                                    key.size = 2048;
                                    break;
                                }
                                case 66: {
                                    key.size = 3072;
                                    break;
                                }
                                case 67: {
                                    key.size = 4096;
                                    break;
                                }
                                case 68: {
                                    key.size = 1024;
                                }
                            }
                            break;
                        }
                        case 1: {
                            switch (algorithm) {
                                case 65: {
                                    key.size = 256;
                                    break block0;
                                }
                                case 66: {
                                    key.size = 384;
                                    break block0;
                                }
                                case 67: {
                                    key.size = 521;
                                }
                            }
                        }
                    }
                    entry = key;
                }
            }
            if (entry == null) continue;
            objects.add(entry);
        }
        return objects;
    }

    public Key getKey(String name) throws CardException {
        for (Entry entry : this.getEntries()) {
            if (!(entry instanceof Key) || !entry.name().equals(name)) continue;
            return (Key)entry;
        }
        return null;
    }

    public Certificate getCertificate(String name) throws CardException {
        for (Entry entry : this.getEntries()) {
            if (!(entry instanceof Certificate) || !entry.name().equals(name)) continue;
            return (Certificate)entry;
        }
        return null;
    }

    public List<String> aliases() throws CardException {
        ArrayList<String> aliases = new ArrayList<String>();
        for (Entry entry : this.getEntries()) {
            if (!(entry instanceof Key)) continue;
            aliases.add(entry.name());
        }
        return aliases;
    }

    public byte[] sign(Key key, byte[] hash) throws CardException {
        if (this.pin != null) {
            this.verify(0, 131, this.pin);
        }
        this.manageSecurityEnvironment(key);
        this.hash(hash);
        return this.computeDigitalSignature();
    }

    private void manageSecurityEnvironment(Key key) throws CardException {
        byte[] template = new byte[]{-128, 1, (byte)(key.type == 0 ? 66 : 68), -124, 1, key.ref()};
        ResponseAPDU response = this.transmit(new CommandAPDU(0, 34, 129, 182, template));
        this.handleError(response);
    }

    private void hash(byte[] hash) throws CardException {
        TLV template = new TLV("90", hash);
        ResponseAPDU response = this.transmit(new CommandAPDU(0, 42, 144, 160, template.getEncoded()));
        this.handleError(response);
    }

    private byte[] computeDigitalSignature() throws CardException {
        ResponseAPDU response = this.transmit(new CommandAPDU(0, 42, 158, 154, 128));
        if (response.getSW() == 27272) {
            throw new CardException("Signature key not found");
        }
        this.handleError(response);
        return response.getData();
    }

    public static CryptoCertumCard getCard() throws CardException {
        CardChannel channel = CryptoCertumCard.openChannel(ESIGN_COMMON_PROFILE_AID);
        return channel != null ? new CryptoCertumCard(channel) : null;
    }

    public class Certificate
    extends Entry {
        @Override
        public int fid() {
            return 8192 + this.index;
        }

        public X509Certificate getCertificate() throws CardException {
            ByteBuffer buffer = ByteBuffer.wrap(this.data()).order(ByteOrder.BIG_ENDIAN);
            buffer.position(132);
            int length = buffer.getShort() & 0xFFFF;
            byte[] data = new byte[length];
            buffer.get(data);
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(data);
                return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(in);
            }
            catch (CertificateException e) {
                throw new CardException("Invalid data for certificate #" + this.index, e);
            }
        }
    }

    public class Key
    extends Entry {
        public int type;
        public int size;

        public byte ref() {
            return (byte)((this.type == 0 ? 32 : 48) + this.index);
        }

        @Override
        public int fid() {
            return 4096 + this.ref();
        }
    }

    public abstract class Entry {
        public int index;

        public abstract int fid();

        public byte[] data() throws CardException {
            return CryptoCertumCard.this.getFile(this.fid());
        }

        public String name() throws CardException {
            byte[] data = CryptoCertumCard.this.getFile(this.fid(), true);
            byte length = data[2];
            return new String(data, 3, (int)length, StandardCharsets.UTF_8);
        }
    }
}

