/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import net.jsign.KeyStoreBuilder;
import net.jsign.jca.RESTClient;

public class GaraSignCredentials {
    public String username;
    public String password;
    public KeyStore.Builder keystore;
    public String sessionToken;

    public GaraSignCredentials(String username, String password, String keystore, String storepass) {
        this(username, password, new KeyStoreBuilder().keystore(keystore).storepass(storepass).builder());
    }

    public GaraSignCredentials(String username, String password, KeyStore.Builder keystore) {
        this.username = username;
        this.password = password;
        this.keystore = keystore;
    }

    public String getSessionToken(String endpoint) throws IOException {
        if (this.sessionToken == null) {
            Map<String, ?> response;
            String status;
            RESTClient client = new RESTClient(endpoint).authentication((conn, data) -> {
                if (conn instanceof HttpsURLConnection && this.keystore != null) {
                    try {
                        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        kmf.init(this.keystore.getKeyStore(), ((KeyStore.PasswordProtection)this.keystore.getProtectionParameter("")).getPassword());
                        SSLContext context = SSLContext.getInstance("TLS");
                        context.init(kmf.getKeyManagers(), null, new SecureRandom());
                        ((HttpsURLConnection)conn).setSSLSocketFactory(context.getSocketFactory());
                    }
                    catch (GeneralSecurityException e) {
                        throw new RuntimeException("Unable to load the GaraSign client certificate", e);
                    }
                }
            });
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            params.put("api_version", "1.0");
            if (this.username != null && this.password != null) {
                params.put("username", this.username);
                params.put("password", this.password);
            }
            if (!"SUCCESS".equals(status = (String)(response = client.post("/authenticate", params)).get("status"))) {
                throw new IOException("Failed to authenticate with GaraSign: " + response.get("message"));
            }
            this.sessionToken = (String)response.get("sessionToken");
        }
        return this.sessionToken;
    }
}

