/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.execution;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import net.nicoulaj.maven.plugins.checksum.execution.Execution;
import net.nicoulaj.maven.plugins.checksum.execution.ExecutionException;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTarget;

public abstract class AbstractExecution
implements Execution {
    protected List<File> files;
    protected List<String> algorithms;
    protected List<ExecutionTarget> targets;

    @Override
    public List<File> getFiles() {
        return this.files;
    }

    @Override
    public void setFiles(List<File> files) {
        this.files = files;
    }

    @Override
    public void addFile(File file) {
        if (this.files == null) {
            this.files = new LinkedList<File>();
        }
        this.files.add(file);
    }

    @Override
    public void removeFile(File file) {
        if (this.files != null) {
            this.files.remove(file);
        }
    }

    @Override
    public List<String> getAlgorithms() {
        return this.algorithms;
    }

    @Override
    public void setAlgorithms(List<String> algorithms) {
        this.algorithms = algorithms;
    }

    @Override
    public void addAlgorithm(String algorithm) {
        if (this.algorithms == null) {
            this.algorithms = new LinkedList<String>();
        }
        this.algorithms.add(algorithm);
    }

    @Override
    public void removeAlgorithm(String algorithm) {
        if (this.algorithms != null) {
            this.algorithms.remove(algorithm);
        }
    }

    @Override
    public List<ExecutionTarget> getTargets() {
        return this.targets;
    }

    @Override
    public void addTarget(ExecutionTarget target) {
        if (this.targets == null) {
            this.targets = new LinkedList<ExecutionTarget>();
        }
        this.targets.add(target);
    }

    @Override
    public void removeTarget(ExecutionTarget target) {
        if (this.targets != null) {
            this.targets.remove(target);
        }
    }

    @Override
    public void setTargets(List<ExecutionTarget> targets) {
        this.targets = targets;
    }

    @Override
    public void checkParameters() throws ExecutionException {
        if (this.files == null || this.files.isEmpty()) {
            throw new ExecutionException("No file to process.");
        }
        if (this.algorithms == null || this.algorithms.isEmpty()) {
            throw new ExecutionException("No checksum algorithm defined.");
        }
        if (this.targets == null || this.targets.isEmpty()) {
            throw new ExecutionException("No output target defined.");
        }
    }
}

