/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.execution.target;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import net.nicoulaj.maven.plugins.checksum.digest.DigesterFactory;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTarget;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTargetInitializationException;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTargetWriteException;
import org.codehaus.plexus.util.FileUtils;

public class OneHashPerFileTarget
implements ExecutionTarget {
    protected String encoding;
    protected File outputDirectory;

    public OneHashPerFileTarget(String encoding, File outputDirectory) {
        this.encoding = encoding;
        this.outputDirectory = outputDirectory;
    }

    public OneHashPerFileTarget(String encoding) {
        this(encoding, null);
    }

    @Override
    public void init() throws ExecutionTargetInitializationException {
        if (this.outputDirectory != null) {
            if (this.outputDirectory.exists() && !this.outputDirectory.isDirectory()) {
                throw new ExecutionTargetInitializationException("'" + this.outputDirectory.getPath() + "' already exists and is not a directory.");
            }
            this.outputDirectory.mkdirs();
        }
    }

    @Override
    public void write(String digest, File file, String algorithm) throws ExecutionTargetWriteException {
        try {
            File outputFileDirectory = this.outputDirectory != null ? this.outputDirectory : file.getParentFile();
            String outputFileName = file.getName() + DigesterFactory.getInstance().getFileDigester(algorithm).getFileExtension();
            FileUtils.fileWrite((String)(outputFileDirectory.getPath() + File.separator + outputFileName), (String)digest);
        }
        catch (IOException e) {
            throw new ExecutionTargetWriteException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ExecutionTargetWriteException(e.getMessage());
        }
    }

    @Override
    public void close() {
    }
}

