/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.filters;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import net.lightbody.bmp.filters.HttpsAwareFiltersAdapter;
import net.lightbody.bmp.filters.RequestFilter;
import net.lightbody.bmp.util.HttpMessageContents;
import net.lightbody.bmp.util.HttpMessageInfo;
import org.littleshoot.proxy.HttpFilters;
import org.littleshoot.proxy.HttpFiltersSourceAdapter;

public class RequestFilterAdapter
extends HttpsAwareFiltersAdapter {
    private final RequestFilter requestFilter;

    public RequestFilterAdapter(HttpRequest originalRequest, ChannelHandlerContext ctx, RequestFilter requestFilter) {
        super(originalRequest, ctx);
        this.requestFilter = requestFilter;
    }

    public HttpResponse clientToProxyRequest(HttpObject httpObject) {
        if (httpObject instanceof HttpRequest) {
            HttpMessageContents contents;
            HttpRequest httpRequest = (HttpRequest)httpObject;
            if (httpObject instanceof FullHttpMessage) {
                FullHttpMessage httpContent = (FullHttpMessage)httpObject;
                contents = new HttpMessageContents(httpContent);
            } else {
                contents = null;
            }
            HttpMessageInfo messageInfo = new HttpMessageInfo(this.originalRequest, this.ctx, this.isHttps(), this.getFullUrl(httpRequest), this.getOriginalUrl());
            HttpResponse response = this.requestFilter.filterRequest(httpRequest, contents, messageInfo);
            if (response != null) {
                return response;
            }
        }
        return null;
    }

    public static class FilterSource
    extends HttpFiltersSourceAdapter {
        private static final int DEFAULT_MAXIMUM_REQUEST_BUFFER_SIZE = 0x200000;
        private final RequestFilter filter;
        private final int maximumRequestBufferSizeInBytes;

        public FilterSource(RequestFilter filter) {
            this.filter = filter;
            this.maximumRequestBufferSizeInBytes = 0x200000;
        }

        public FilterSource(RequestFilter filter, int maximumRequestBufferSizeInBytes) {
            this.filter = filter;
            this.maximumRequestBufferSizeInBytes = maximumRequestBufferSizeInBytes;
        }

        public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
            return new RequestFilterAdapter(originalRequest, ctx, this.filter);
        }

        public int getMaximumRequestBufferSizeInBytes() {
            return this.maximumRequestBufferSizeInBytes;
        }
    }
}

