/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.util;

import com.google.common.net.HostAndPort;
import com.google.common.net.MediaType;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.xml.bind.DatatypeConverter;
import net.lightbody.bmp.exception.DecompressionException;
import net.lightbody.bmp.util.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserMobHttpUtil {
    private static final Logger log = LoggerFactory.getLogger(BrowserMobHttpUtil.class);
    public static final String UNKNOWN_CONTENT_TYPE = "application/octet-stream";
    public static final Charset DEFAULT_HTTP_CHARSET = StandardCharsets.ISO_8859_1;
    public static final int DECOMPRESS_BUFFER_SIZE = 16192;

    public static long getHeaderSize(HttpHeaders headers) {
        long headersSize = 0L;
        for (Map.Entry header : headers.entries()) {
            headersSize += (long)(((String)header.getKey()).length() + ((String)header.getValue()).length() + 4);
        }
        return headersSize;
    }

    public static byte[] decompressContents(byte[] fullMessage) throws DecompressionException {
        InflaterInputStream gzipReader = null;
        try {
            try {
                int bytesRead;
                gzipReader = new GZIPInputStream(new ByteArrayInputStream(fullMessage));
                ByteArrayOutputStream uncompressed = new ByteArrayOutputStream(fullMessage.length);
                byte[] decompressBuffer = new byte[16192];
                while ((bytesRead = gzipReader.read(decompressBuffer)) > -1) {
                    uncompressed.write(decompressBuffer, 0, bytesRead);
                }
                fullMessage = uncompressed.toByteArray();
            }
            catch (IOException e) {
                throw new DecompressionException("Unable to decompress response", e);
            }
        }
        finally {
            try {
                if (gzipReader != null) {
                    gzipReader.close();
                }
            }
            catch (IOException e) {
                log.warn("Unable to close gzip stream", (Throwable)e);
            }
        }
        return fullMessage;
    }

    public static boolean hasTextualContent(String contentType) {
        return contentType != null && (contentType.startsWith("text/") || contentType.startsWith("application/x-javascript") || contentType.startsWith("application/javascript") || contentType.startsWith("application/json") || contentType.startsWith("application/xml") || contentType.startsWith("application/xhtml+xml"));
    }

    public static byte[] extractReadableBytes(ByteBuf content) {
        byte[] binaryContent = new byte[content.readableBytes()];
        content.markReaderIndex();
        content.readBytes(binaryContent);
        content.resetReaderIndex();
        return binaryContent;
    }

    public static String getContentAsString(byte[] content, Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("Charset cannot be null");
        }
        return new String(content, charset);
    }

    public static Charset readCharsetInContentTypeHeader(String contentTypeHeader) throws net.lightbody.bmp.exception.UnsupportedCharsetException {
        MediaType mediaType;
        if (contentTypeHeader == null || contentTypeHeader.isEmpty()) {
            return null;
        }
        try {
            mediaType = MediaType.parse((String)contentTypeHeader);
        }
        catch (IllegalArgumentException e) {
            log.info("Unable to parse Content-Type header: {}. Content-Type header will be ignored.", (Object)contentTypeHeader, (Object)e);
            return null;
        }
        try {
            return (Charset)mediaType.charset().orNull();
        }
        catch (UnsupportedCharsetException e) {
            throw new net.lightbody.bmp.exception.UnsupportedCharsetException(e);
        }
    }

    public static String getRawPathAndParamsFromRequest(HttpRequest httpRequest) throws URISyntaxException {
        if (HttpUtil.startsWithHttpOrHttps((String)httpRequest.getUri())) {
            return BrowserMobHttpUtil.getRawPathAndParamsFromUri(httpRequest.getUri());
        }
        new URI(httpRequest.getUri());
        return httpRequest.getUri();
    }

    public static String getRawPathAndParamsFromUri(String uriString) throws URISyntaxException {
        URI uri = new URI(uriString);
        String path = uri.getRawPath();
        String query = uri.getRawQuery();
        if (query != null) {
            return String.valueOf(path) + '?' + query;
        }
        return path;
    }

    public static boolean isRedirect(HttpResponse httpResponse) {
        switch (httpResponse.getStatus().code()) {
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                return true;
            }
        }
        return false;
    }

    public static String removeMatchingPort(String hostWithPort, int portNumber) {
        HostAndPort parsedHostAndPort = HostAndPort.fromString((String)hostWithPort);
        if (parsedHostAndPort.hasPort() && parsedHostAndPort.getPort() == portNumber) {
            return HostAndPort.fromHost((String)parsedHostAndPort.getHostText()).toString();
        }
        return hostWithPort;
    }

    public static String base64EncodeBasicCredentials(String username, String password) {
        String credentialsToEncode = String.valueOf(username) + ':' + password;
        byte[] credentialsAsUtf8Bytes = credentialsToEncode.getBytes(StandardCharsets.UTF_8);
        return DatatypeConverter.printBase64Binary((byte[])credentialsAsUtf8Bytes);
    }
}

