/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ReusableByteBuffer
extends OutputStream {
    static final int DEFAULT_INITIAL_CAPACITY = 1024;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final List<byte[]> buffers = new ArrayList<byte[]>();
    private int alreadyBufferedSize = 0;
    private int tailWriteIndex = 0;
    private boolean closed = false;

    public ReusableByteBuffer() {
        this(1024);
    }

    public ReusableByteBuffer(int initialCapacity) {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("initialCapacity must be greater than 0");
        }
        this.buffers.add(new byte[initialCapacity]);
    }

    @Override
    public void write(int datum) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        this.growIfNeeded();
        this.getTailBuffer()[this.tailWriteIndex++] = (byte)datum;
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        Objects.requireNonNull(data, "data must not be null");
        if (offset < 0 || offset + length > data.length || length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        while (length > 0) {
            byte[] buffer = this.getTailBuffer();
            int freeSpace = buffer.length - this.tailWriteIndex;
            if (freeSpace > 0) {
                int toCopy = Math.min(freeSpace, length);
                System.arraycopy(data, offset, buffer, this.tailWriteIndex, toCopy);
                offset += toCopy;
                this.tailWriteIndex += toCopy;
                length -= toCopy;
            }
            if (length <= 0) continue;
            this.growIfNeeded();
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public int size() {
        return this.alreadyBufferedSize + this.tailWriteIndex;
    }

    public void reset() {
        if (this.buffers.size() > 1) {
            byte[] initialBuffer = this.buffers.get(0);
            this.buffers.clear();
            this.buffers.add(initialBuffer);
        }
        this.closed = false;
        this.tailWriteIndex = 0;
        this.alreadyBufferedSize = 0;
    }

    public void writeTo(OutputStream out) throws IOException {
        Iterator<byte[]> it = this.buffers.iterator();
        while (it.hasNext()) {
            byte[] buffer = it.next();
            if (it.hasNext()) {
                out.write(buffer, 0, buffer.length);
                continue;
            }
            out.write(buffer, 0, this.tailWriteIndex);
        }
    }

    public byte[] toByteArray() {
        int totalSize = this.size();
        if (totalSize == 0) {
            return EMPTY_BYTES;
        }
        byte[] result = new byte[totalSize];
        int offset = 0;
        Iterator<byte[]> it = this.buffers.iterator();
        while (it.hasNext()) {
            byte[] buffer = it.next();
            if (it.hasNext()) {
                System.arraycopy(buffer, 0, result, offset, buffer.length);
                offset += buffer.length;
                continue;
            }
            System.arraycopy(buffer, 0, result, offset, this.tailWriteIndex);
        }
        return result;
    }

    private void growIfNeeded() {
        if (this.getTailBuffer().length == this.tailWriteIndex) {
            this.alreadyBufferedSize += this.tailWriteIndex;
            this.buffers.add(new byte[this.tailWriteIndex * 2]);
            this.tailWriteIndex = 0;
        }
    }

    private byte[] getTailBuffer() {
        return this.buffers.get(this.buffers.size() - 1);
    }
}

