/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype.TtfInstructions;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mabb.fontverter.io.FontDataInputStream;
import org.mabb.fontverter.opentype.TtfInstructions.instructions.TtfInstruction;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TtfInstructionParser {
    private static ConcurrentHashMap<Integer, Class> instructionTypes = new ConcurrentHashMap();
    private static Logger log = LoggerFactory.getLogger(TtfInstructionParser.class);

    public List<TtfInstruction> parse(byte[] data) throws IOException, InstantiationException, IllegalAccessException {
        LinkedList<TtfInstruction> instructions = new LinkedList<TtfInstruction>();
        FontDataInputStream in = new FontDataInputStream(data);
        while (in.available() > 0) {
            int code = in.readByte() & 0xFF;
            TtfInstruction instruction = TtfInstructionParser.createFromCode(code);
            if (instruction == null) {
                log.error("No instruction found for code: 0x" + Integer.toHexString(code) + "/" + code);
                log.error("Position: " + in.getPosition() + " Length: " + data.length);
                break;
            }
            instruction.read(in);
            instructions.add(instruction);
            log.info("Parsed instruction: " + instruction.getClass().getSimpleName() + " code: 0x" + Integer.toHexString(code) + "/" + code);
        }
        return instructions;
    }

    public static TtfInstruction createFromCode(int code) throws IllegalAccessException, InstantiationException, IOException {
        TtfInstructionParser.initInstructionTypes();
        Class type = instructionTypes.get(code);
        if (type == null) {
            return null;
        }
        TtfInstruction instruction = (TtfInstruction)type.newInstance();
        instruction.code = code;
        return instruction;
    }

    private static void initInstructionTypes() throws IllegalAccessException, InstantiationException {
        if (instructionTypes.isEmpty()) {
            Reflections reflections = new Reflections("org.mabb.fontverter", new Scanner[0]);
            Set adapterClasses = reflections.getSubTypesOf(TtfInstruction.class);
            List<Class> instructionClasses = Arrays.asList(adapterClasses.toArray(new Class[adapterClasses.size()]));
            for (Class typeOn : instructionClasses) {
                TtfInstruction instructOn = (TtfInstruction)typeOn.newInstance();
                int[] range = instructOn.getCodeRanges();
                if (range.length == 1) {
                    instructionTypes.put(range[0], typeOn);
                    continue;
                }
                for (int i = range[0]; i <= range[1]; ++i) {
                    instructionTypes.put(i, typeOn);
                }
            }
        }
    }
}

