/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.amazon.s3;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.noderunner.amazon.s3.Bucket;
import net.noderunner.amazon.s3.ISO801DateFormat;
import net.noderunner.amazon.s3.Response;
import org.apache.commons.httpclient.HttpMethod;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListAllBucketsResponse
extends Response {
    private List<Bucket> entries;

    ListAllBucketsResponse(HttpMethod method) throws IOException {
        super(method);
        if (this.isOk()) {
            this.entries = new ArrayList<Bucket>();
            this.parse(new ListAllMyBucketsHandler());
        }
    }

    public List<Bucket> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    @Override
    public String toString() {
        return super.toString() + " entries=" + this.entries;
    }

    class ListAllMyBucketsHandler
    extends DefaultHandler {
        private Bucket currBucket = null;
        private StringBuilder currText = null;
        private SimpleDateFormat iso8601Parser = new ISO801DateFormat();

        public ListAllMyBucketsHandler() {
            this.currText = new StringBuilder();
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("Bucket")) {
                this.currBucket = new Bucket();
            }
        }

        public void endElement(String uri, String name, String qName) {
            if (name.equals("Bucket")) {
                ListAllBucketsResponse.this.entries.add(this.currBucket);
            } else if (name.equals("Name")) {
                if (this.currBucket == null) {
                    throw new IllegalStateException();
                }
                this.currBucket.setName(this.currText.toString());
            } else if (name.equals("CreationDate")) {
                try {
                    this.currBucket.setCreationDate(this.iso8601Parser.parse(this.currText.toString()));
                }
                catch (ParseException e) {
                    throw new RuntimeException("Unexpected date format in list bucket output", e);
                }
            }
            this.currText = new StringBuilder();
        }

        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }
}

