/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.http;

import java.io.IOException;
import java.io.OutputStream;
import net.noderunner.http.DataPoster;

public class ByteArrayDataPoster
implements DataPoster {
    private final byte[] data;
    private final int len;
    private final int off;

    public ByteArrayDataPoster(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Null byte[]");
        }
        this.data = data;
        this.off = 0;
        this.len = data.length;
    }

    public ByteArrayDataPoster(byte[] data, int off, int len) {
        if (data == null) {
            throw new IllegalArgumentException("Null byte[]");
        }
        this.data = data;
        this.off = off;
        this.len = len;
    }

    public void sendData(OutputStream os) throws IOException {
        if (os == null) {
            throw new IllegalArgumentException("OutputStream is null");
        }
        os.write(this.data, this.off, this.len);
        os.flush();
    }

    public String toString() {
        return "ByteArrayDataPoster data=" + this.data.length + " off=" + this.off + " len=" + this.len;
    }
}

